/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.options;

import java.util.List;
import org.eclipse.escet.common.app.framework.options.Option;
import org.eclipse.escet.common.app.framework.options.OptionGroup;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class CifSpecOption
extends Option<List<String>> {
    public CifSpecOption() {
        super("CIF specification", "The absolute or relative local file system path to the CIF specification (\".cif\" file) or compiled code file (\".cifcode\" file) to simulate.", null, "*", "CIFSPEC", true);
    }

    public static String getCifSpecPath() {
        List files = (List)Options.get(CifSpecOption.class);
        return (String)Lists.first((List)files);
    }

    public static String getDerivedPath(String replaceExt) {
        Object rslt = CifSpecOption.getCifSpecPath();
        if (((String)rslt).endsWith(".cif")) {
            rslt = Strings.slice((String)rslt, (Integer)0, (Integer)(-".cif".length()));
        } else if (((String)rslt).endsWith(".cifcode")) {
            rslt = Strings.slice((String)rslt, (Integer)0, (Integer)(-".cifcode".length()));
        }
        rslt = (String)rslt + replaceExt;
        return rslt;
    }

    public List<String> getDefault() {
        return Lists.list();
    }

    public List<String> parseValue(String optName, String value) {
        return Lists.list((Object)value);
    }

    public void verifyValue(List<String> value) {
        if (value.size() == 0) {
            String msg = "The CIF simulator expects exactly one CIF specification file (\".cif\" file) or compiled code file (\".cifcode\" file) to simulate, but no such file was provided.";
            throw new InvalidOptionException(msg);
        }
        if (value.size() != 1) {
            List inputs = Lists.copy(value);
            int i = 0;
            while (i < inputs.size()) {
                inputs.set(i, "\"" + (String)inputs.get(i) + "\"");
                ++i;
            }
            String msg = Strings.fmt((String)"The CIF simulator expects exactly one CIF specification file (\".cif\" file) or compiled code file (\".cifcode\" file) to simulate, but %d files were provided: %s.", (Object[])new Object[]{value.size(), String.join((CharSequence)", ", inputs)});
            throw new InvalidOptionException(msg);
        }
    }

    public String[] getCmdLine(Object value) {
        List files = (List)value;
        return files.toArray(new String[0]);
    }

    public OptionGroup<List<String>> createOptionGroup(Composite page) {
        return new OptionGroup<List<String>>(page, Options.getInstance(CifSpecOption.class)){
            Label specPathLabel;
            Text specPathText;

            protected void addComponents(Group group) {
                this.specPathLabel = new Label((Composite)group, 0);
                this.specPathLabel.setText("Path:");
                this.specPathText = new Text((Composite)group, 2052);
                this.layoutGeneric(new Object[]{new Control[]{this.specPathLabel, this.specPathText}}, 0);
            }

            public String getDescription() {
                return "The absolute or relative local file system path to the CIF specification (\".cif\" file) or compiled code file (\".cifcode\" file) to simulate.";
            }

            public void setToValue(List<String> value) {
                if (value.size() > 1) {
                    CifSpecOption.this.verifyValue(value);
                }
                this.specPathText.setText(value.isEmpty() ? "" : (String)Lists.first(value));
            }

            public String[] getCmdLine() {
                String[] stringArray;
                String path = this.specPathText.getText();
                if (path.isEmpty()) {
                    stringArray = new String[]{};
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = path;
                }
                return stringArray;
            }
        };
    }
}

