/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.typechecker;

import java.util.Locale;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.TextPosition;
import org.eclipse.escet.common.typechecker.SemanticProblemSeverity;

public class SemanticProblem
implements Comparable<SemanticProblem> {
    public final String message;
    public final SemanticProblemSeverity severity;
    public final TextPosition position;

    public SemanticProblem(String message, SemanticProblemSeverity severity, TextPosition position) {
        Assert.notNull((Object)message);
        Assert.notNull((Object)position);
        this.message = message;
        this.severity = severity;
        this.position = position;
    }

    public boolean equals(Object obj) {
        SemanticProblem other = (SemanticProblem)obj;
        return this.severity == other.severity && this.position.equals((Object)other.position) && this.message.equals(other.message);
    }

    public int hashCode() {
        return this.severity.hashCode() ^ this.position.hashCode() ^ this.message.hashCode();
    }

    @Override
    public int compareTo(SemanticProblem other) {
        int result = this.severity.compareTo(other.severity);
        if (result != 0) {
            return result;
        }
        result = this.position.compareTo(other.position);
        if (result != 0) {
            return result;
        }
        return this.message.compareTo(other.message);
    }

    public String toString() {
        String src = this.position.source;
        if (src == null) {
            src = "";
        }
        return Strings.fmt((String)"%sSemantic %s at line %d, column %d: %s", (Object[])new Object[]{src, this.severity.name().toLowerCase(Locale.US), this.position.startLine, this.position.startColumn, this.message});
    }
}

