/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.metamodel.cif.expressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BinaryOperator implements Enumerator
{
    DISJUNCTION(0, "Disjunction", "Disjunction"),
    IMPLICATION(1, "Implication", "Implication"),
    BI_CONDITIONAL(2, "BiConditional", "BiConditional"),
    CONJUNCTION(3, "Conjunction", "Conjunction"),
    LESS_THAN(4, "LessThan", "LessThan"),
    LESS_EQUAL(5, "LessEqual", "LessEqual"),
    GREATER_THAN(6, "GreaterThan", "GreaterThan"),
    GREATER_EQUAL(7, "GreaterEqual", "GreaterEqual"),
    EQUAL(8, "Equal", "Equal"),
    UNEQUAL(9, "Unequal", "Unequal"),
    MODULUS(11, "Modulus", "Modulus"),
    INTEGER_DIVISION(12, "IntegerDivision", "IntegerDivision"),
    MULTIPLICATION(14, "Multiplication", "Multiplication"),
    SUBTRACTION(15, "Subtraction", "Subtraction"),
    ADDITION(16, "Addition", "Addition"),
    SUBSET(10, "Subset", "Subset"),
    ELEMENT_OF(13, "ElementOf", "ElementOf"),
    DIVISION(17, "Division", "Division");

    public static final int DISJUNCTION_VALUE = 0;
    public static final int IMPLICATION_VALUE = 1;
    public static final int BI_CONDITIONAL_VALUE = 2;
    public static final int CONJUNCTION_VALUE = 3;
    public static final int LESS_THAN_VALUE = 4;
    public static final int LESS_EQUAL_VALUE = 5;
    public static final int GREATER_THAN_VALUE = 6;
    public static final int GREATER_EQUAL_VALUE = 7;
    public static final int EQUAL_VALUE = 8;
    public static final int UNEQUAL_VALUE = 9;
    public static final int MODULUS_VALUE = 11;
    public static final int INTEGER_DIVISION_VALUE = 12;
    public static final int MULTIPLICATION_VALUE = 14;
    public static final int SUBTRACTION_VALUE = 15;
    public static final int ADDITION_VALUE = 16;
    public static final int SUBSET_VALUE = 10;
    public static final int ELEMENT_OF_VALUE = 13;
    public static final int DIVISION_VALUE = 17;
    private static final BinaryOperator[] VALUES_ARRAY;
    public static final List<BinaryOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BinaryOperator[]{DISJUNCTION, IMPLICATION, BI_CONDITIONAL, CONJUNCTION, LESS_THAN, LESS_EQUAL, GREATER_THAN, GREATER_EQUAL, EQUAL, UNEQUAL, MODULUS, INTEGER_DIVISION, MULTIPLICATION, SUBTRACTION, ADDITION, SUBSET, ELEMENT_OF, DIVISION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BinaryOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BinaryOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BinaryOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BinaryOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BinaryOperator get(int value) {
        switch (value) {
            case 0: {
                return DISJUNCTION;
            }
            case 1: {
                return IMPLICATION;
            }
            case 2: {
                return BI_CONDITIONAL;
            }
            case 3: {
                return CONJUNCTION;
            }
            case 4: {
                return LESS_THAN;
            }
            case 5: {
                return LESS_EQUAL;
            }
            case 6: {
                return GREATER_THAN;
            }
            case 7: {
                return GREATER_EQUAL;
            }
            case 8: {
                return EQUAL;
            }
            case 9: {
                return UNEQUAL;
            }
            case 11: {
                return MODULUS;
            }
            case 12: {
                return INTEGER_DIVISION;
            }
            case 14: {
                return MULTIPLICATION;
            }
            case 15: {
                return SUBTRACTION;
            }
            case 16: {
                return ADDITION;
            }
            case 10: {
                return SUBSET;
            }
            case 13: {
                return ELEMENT_OF;
            }
            case 17: {
                return DIVISION;
            }
        }
        return null;
    }

    private BinaryOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

