/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.IoDecl;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgFile;
import org.eclipse.escet.cif.metamodel.cif.print.PrintFile;
import org.eclipse.escet.cif.parser.ast.iodecls.AIoDecl;
import org.eclipse.escet.cif.parser.ast.iodecls.print.APrint;
import org.eclipse.escet.cif.parser.ast.iodecls.print.APrintFile;
import org.eclipse.escet.cif.parser.ast.iodecls.svg.ASvgCopy;
import org.eclipse.escet.cif.parser.ast.iodecls.svg.ASvgFile;
import org.eclipse.escet.cif.parser.ast.iodecls.svg.ASvgIn;
import org.eclipse.escet.cif.parser.ast.iodecls.svg.ASvgMove;
import org.eclipse.escet.cif.parser.ast.iodecls.svg.ASvgOut;
import org.eclipse.escet.cif.typechecker.CifPrintTypeChecker;
import org.eclipse.escet.cif.typechecker.CifSvgTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.scopes.ParentScope;
import org.eclipse.escet.common.java.TextPosition;
import org.eclipse.escet.common.typechecker.SemanticException;

public class IoDeclTypeChecker {
    private final CifTypeChecker tchecker;
    private final CifSvgTypeChecker cifSvgChecker;
    private final CifPrintTypeChecker cifPrintChecker;

    public IoDeclTypeChecker(CifTypeChecker tchecker) {
        this.tchecker = tchecker;
        this.cifSvgChecker = new CifSvgTypeChecker(tchecker);
        this.cifPrintChecker = new CifPrintTypeChecker(tchecker);
    }

    public void check(List<AIoDecl> astIoDecls, ParentScope<?> scope, ComplexComponent comp) {
        TextPosition svgFilePos = null;
        TextPosition printFilePos = null;
        EList ioDecls = comp.getIoDecls();
        for (AIoDecl astIoDecl : astIoDecls) {
            IoDecl ioDecl;
            try {
                ioDecl = this.check(astIoDecl, scope);
            }
            catch (SemanticException ex) {
                continue;
            }
            ioDecls.add(ioDecl);
            if (ioDecl instanceof SvgFile) {
                if (svgFilePos == null) {
                    svgFilePos = astIoDecl.position;
                } else {
                    this.tchecker.addProblem(ErrMsg.SVG_DUPL_FILE, svgFilePos, scope.getAbsText());
                    this.tchecker.addProblem(ErrMsg.SVG_DUPL_FILE, astIoDecl.position, scope.getAbsText());
                    throw new SemanticException();
                }
            }
            if (!(ioDecl instanceof PrintFile)) continue;
            if (printFilePos == null) {
                printFilePos = astIoDecl.position;
                continue;
            }
            this.tchecker.addProblem(ErrMsg.PRINT_DUPL_FILE, printFilePos, scope.getAbsText());
            this.tchecker.addProblem(ErrMsg.PRINT_DUPL_FILE, astIoDecl.position, scope.getAbsText());
            throw new SemanticException();
        }
    }

    public IoDecl check(AIoDecl ioDecl, ParentScope<?> scope) {
        if (ioDecl instanceof ASvgFile) {
            return this.cifSvgChecker.checkSvgFile((ASvgFile)ioDecl, scope);
        }
        if (ioDecl instanceof ASvgCopy) {
            return this.cifSvgChecker.checkSvgCopy((ASvgCopy)ioDecl, scope);
        }
        if (ioDecl instanceof ASvgMove) {
            return this.cifSvgChecker.checkSvgMove((ASvgMove)ioDecl, scope);
        }
        if (ioDecl instanceof ASvgOut) {
            return this.cifSvgChecker.checkSvgOut((ASvgOut)ioDecl, scope);
        }
        if (ioDecl instanceof ASvgIn) {
            return this.cifSvgChecker.checkSvgIn((ASvgIn)ioDecl, scope);
        }
        if (ioDecl instanceof APrintFile) {
            return this.cifPrintChecker.checkPrintFile((APrintFile)ioDecl);
        }
        if (ioDecl instanceof APrint) {
            return this.cifPrintChecker.checkPrint((APrint)ioDecl, scope);
        }
        throw new RuntimeException("Unknown I/O decl: " + String.valueOf(ioDecl));
    }
}

