/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.discovery.wizards;

import org.eclipse.equinox.internal.p2.discovery.AbstractCatalogSource;
import org.eclipse.equinox.internal.p2.discovery.model.Overview;
import org.eclipse.equinox.internal.p2.ui.discovery.util.ControlListItem;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.DiscoveryResources;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.OverviewToolTip;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractDiscoveryItem<T>
extends ControlListItem<T> {
    protected final DiscoveryResources resources;

    public AbstractDiscoveryItem(Composite parent, int style, DiscoveryResources resources, T element) {
        super(parent, style, element);
        this.resources = resources;
    }

    private void hookRecursively(Control control, Listener listener) {
        control.addListener(12, listener);
        control.addListener(32, listener);
        control.addListener(5, listener);
        control.addListener(7, listener);
        control.addListener(3, listener);
        control.addListener(37, listener);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.hookRecursively(child, listener);
                ++n2;
            }
        }
    }

    protected void hookTooltip(Control parent, Widget tipActivator, Control exitControl, Control titleControl, AbstractCatalogSource source, Overview overview, Image image) {
        OverviewToolTip toolTip = new OverviewToolTip(parent, source, overview, image);
        Listener listener = event -> {
            switch (event.type) {
                case 32: {
                    toolTip.show(titleControl);
                    break;
                }
                case 12: 
                case 37: {
                    toolTip.hide();
                }
            }
        };
        tipActivator.addListener(12, listener);
        tipActivator.addListener(37, listener);
        if (image != null) {
            tipActivator.addListener(32, listener);
        }
        Listener selectionListener = event -> toolTip.show(titleControl);
        tipActivator.addListener(13, selectionListener);
        Listener exitListener = event -> {
            switch (event.type) {
                case 37: {
                    toolTip.hide();
                    break;
                }
                case 7: {
                    Rectangle containerBounds = exitControl.getBounds();
                    Point displayLocation = exitControl.getParent().toDisplay(containerBounds.x, containerBounds.y);
                    containerBounds.x = displayLocation.x;
                    containerBounds.y = displayLocation.y;
                    if (containerBounds.contains(Display.getCurrent().getCursorLocation())) break;
                    toolTip.hide();
                }
            }
        };
        this.hookRecursively(exitControl, exitListener);
    }

    @Override
    public void updateColors(int index) {
    }
}

