/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.url.connection;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.soda.dk.connection.StreamConnection;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.dk.url.connection.service.UrlConnectionService;

public class UrlConnection
extends StreamConnection
implements ConnectionService,
UrlConnectionService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.url.connection.UrlConnection";
    protected static final char[] TOSTRING_NAME = "UrlConnection[".toCharArray();
    private URLConnection urlConnection;
    private String name = null;

    public UrlConnection(ConfigurationService configuration) {
        super(configuration);
    }

    public UrlConnection(Dictionary properties) {
        this((ConfigurationService)new EscConfiguration(properties));
    }

    public UrlConnection(String url) throws IllegalArgumentException {
        Hashtable<String, String> table = new Hashtable<String, String>(23);
        table.put("url", url);
        this.setConfigurationService((ConfigurationService)new EscConfiguration(table));
    }

    public synchronized void close() throws IOException {
        super.close();
        if (this.urlConnection != null) {
            this.urlConnection = null;
            this.handleError(null, 1002, this.toString());
        }
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getString("url", "http://localhost");
        }
        return this.name;
    }

    public synchronized void open() throws IOException {
        URL theUrl = new URL(this.getName());
        this.urlConnection = theUrl.openConnection();
        this.setInputStream(this.urlConnection.getInputStream());
        super.open();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(TOSTRING_NAME);
        if (this.urlConnection == null) {
            buffer.append(this.getName());
        } else {
            buffer.append(this.urlConnection);
        }
        buffer.append(']');
        return buffer.toString();
    }
}

