/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transport;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.dk.interest.InterestMasks;
import org.eclipse.soda.dk.interest.service.InterestService;
import org.eclipse.soda.dk.message.Message;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.multiplex.connection.service.MultiplexConnectionListener;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.transport.Controller;
import org.eclipse.soda.dk.transport.HistoryQueue;
import org.eclipse.soda.dk.transport.TransportListeners;
import org.eclipse.soda.dk.transport.TransportResourceBundle;
import org.eclipse.soda.dk.transport.service.ChannelStateService;
import org.eclipse.soda.dk.transport.service.ControllerService;
import org.eclipse.soda.dk.transport.service.ResponseListener;
import org.eclipse.soda.dk.transport.service.TransportListener;
import org.eclipse.soda.dk.transport.service.TransportService;

public class Transport
extends EscObject
implements TransportService,
ConfigurationService,
MultiplexConnectionListener {
    public static final int NO_ACTIVITY_STATUS_UNKNOWN = 0;
    public static final int TRANSPORT_ERROR_RESOURCE = 2016;
    public static final int MESSAGE_RECEIVED_EXCEPTION_RESOURCE = 2019;
    protected static final int TRANSPORT_STARTED_STATE_RESOURCE = 2005;
    public static final long DEFAULT_NO_ACTIVITY_TIMEOUT = 10000L;
    public static final int TRANSPORT_STARTUP_EXCEPTION_RESOURCE = 2009;
    public static final int MESSAGE_RECEIVED_RESOURCE = 2023;
    protected static final int BAD_CHECKSUM_RESOURCE = 2007;
    public static final int UNABLE_TO_CONNECTION_TO_BUS_RESOURCE = 2021;
    public static final int MESSAGE_SENT_RESOURCE = 2024;
    protected static final int UNKNOWN_ERROR = 0;
    public static final long DEFAULT_RETRY_TIME = 1000L;
    protected static final int WRITE_EXCEPTION_RESOURCE = 2030;
    protected static final int NACK_RECEIVED_RESOURCE = 2036;
    protected static final int WRITE_INTERRUPT_PENDING_RESOURCE = 2032;
    public static final int NO_ACTIVITY_STATUS_MESSAGE_SENT = 1;
    protected static final int WRITE_INTERRUPT_RESOURCE = 2031;
    protected static final int NO_ACTIVITY_RESOURCE = 2037;
    public static final int TRANSMIT_RETRIES_DEFAULT = 0;
    private static final int ECHO_MASK = 0x100000;
    protected static final int PROCESS_INPUT_EXCEPTION_RESOURCE = 2015;
    protected static final int CLONE_EXCEPTION_RESOURCE = 3;
    protected static final int QUEUE_TOO_BIG_RESOURCE = 2034;
    private static final int ECHO_RESET = -1048577;
    private static final int RECEIVING_DATA = 262144;
    public static final int NO_ACTIVITY_STATUS_ERROR = 2;
    private static final int RECEIVING_DATA_RESET = -262145;
    private static final int ECHO_SET = 0x100000;
    private static final int RECEIVING_DATA_SET = 458752;
    protected static final int CLOSE_EXCEPTION_RESOURCE = 2017;
    private static final int RECEIVING_GOOD_DATA = 524288;
    public static final int ERROR_OCCURRED_EXCEPTION_RESOURCE = 2022;
    private static final int RECEIVING_GOOD_DATA_RESET = -524289;
    private static final int ACTIVE_MASK = 65536;
    private static final int RECEIVING_GOOD_DATA_SET = 983040;
    public static final int ERROR_ON_BUS_RESOURCE = 2020;
    private static final int RECEIVING_INPUT = 131072;
    protected static final int CONFIGURATION_ERROR_RESOURCE = 2038;
    private static final int RECEIVING_INPUT_RESET = -131073;
    protected static final int EXCEPTION_NO_RESPONSE_RESOURCE = 2039;
    private static final int RECEIVING_INPUT_SET = 196608;
    private static final int ACTIVE_RESET = -65537;
    public static final int RECONNECT_RESOURCE = 2028;
    protected static final int INTERRUPT_BEFORE_WRITE_RESOURCE = 2035;
    protected static final int RUN_EXCEPTION_RESOURCE = 2013;
    public static final int CONFIGURATION_MISMATCH_RESOURCE = 2027;
    protected static final int SEND_EXCEPTION_RESOURCE = 2012;
    protected static final int INVALID_MESSAGE_RESOURCE = 2006;
    protected static final int SEND_NOT_STARTED_EXCEPTION_RESOURCE = 2014;
    private static final int ACTIVE_SET = 65536;
    protected static final int SHUTDOWN_EXCEPTION_RESOURCE = 2011;
    protected static final int INVALID_SEQUENCE_RESOURCE = 2033;
    protected static final int STARTUP_EXCEPTION_RESOURCE = 2010;
    protected static final int CONNECTION_IN_USE_EXCEPTION_RESOURCE = 2029;
    public static final int STARTUP_MESSAGE_RECEIVED_RESOURCE = 2025;
    public static final long NO_ACTIVITY_TIMEOUT_DEFAULT = 10000L;
    public static final String[] STATE_STRINGS = new String[]{"DEAD", "CREATED", "ALIVE", "CONNECTED", "ACTIVE", "STARTED"};
    public static final char CR = '\r';
    protected static final int TRANSPORT_ACTIVE_STATE_RESOURCE = 2004;
    public static final long RETRY_TIME_DEFAULT = 1000L;
    protected static final int TRANSPORT_ALIVE_STATE_RESOURCE = 2002;
    public static final char LF = '\n';
    protected static final int TRANSPORT_CHANGED_EXCEPTION_RESOURCE = 2018;
    public static final int MESSAGE_FILTERED_RESOURCE = 2026;
    protected static final int TRANSPORT_CONNECTED_STATE_RESOURCE = 2003;
    protected static final int TRANSPORT_CREATED_STATE_RESOURCE = 2001;
    protected static final int TRANSPORT_DEAD_STATE_RESOURCE = 2000;
    protected static final int[] TRANSPORT_STATE_RESOURCE_TABLE = new int[]{2000, 2001, 2002, 2003, 2004, 2005};
    protected static final long NoActivityTimeoutDefault = Transport.getStaticLong((String)"transport.noactivitytimeout", (long)10000L);
    protected static final long RetryTimeDefault = Transport.getStaticLong((String)"transport.retrytime", (long)1000L);
    protected static final int PriorityDefault = Transport.getStaticInt((String)"transport.priority", (int)7);
    protected static final int TransmitRetriesDefault = Transport.getStaticInt((String)"transport.transmitretries", (int)0);
    protected static final int NotificationPriorityDefault = Transport.getStaticInt((String)"transport.notificationpriority", (int)5);
    private static ResourceBundle DefaultResourceBundle;
    private ConfigurationService configurationService = null;
    private ControllerService controller;
    protected int errorCount = 0;
    protected HistoryQueue history = new HistoryQueue();
    private int information;
    protected int inputMessageCount = 0;
    private InterestMasks interestMask = new InterestMasks();
    protected long noActivityTimeout = NoActivityTimeoutDefault;
    protected NotificationService notificationService = null;
    protected String prefixMetrics = "Transport/Metrics";
    protected String prefixStatus = "Transport/Status";
    protected long retryTime = RetryTimeDefault;
    private int priority = PriorityDefault;
    protected int sentMessageCount = 0;
    private int state = 1;
    protected final Object stateChanaged = new Object();
    protected long stateChangeCount = 0L;
    private TransportListener transportListener;
    private final Object transportListenerSync = new Object();
    protected int logLevel = 0;
    private boolean multiplexing = false;
    private int transmitRetries = TransmitRetriesDefault;
    private int notificationPriority = NotificationPriorityDefault;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.transport.TransportResourceBundle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DefaultResourceBundle = Nls.getResourceBundle((Class)clazz);
    }

    public Transport() {
        this(0);
    }

    public Transport(short style) {
        this.setTransportListener(null);
        this.setStyle(style);
    }

    public void addHistory(Object timestamp, Object object) {
        if (this.history != null) {
            this.history.enqueue(timestamp, object);
        }
    }

    public void addInterest(InterestService interest) {
        this.getInterestMask().add(interest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransportListener(TransportListener transportListener) {
        Object object = this.transportListenerSync;
        synchronized (object) {
            this.setTransportListener(TransportListeners.add(this.transportListener, transportListener));
        }
        Map channels = this.getChannels();
        if (channels != null) {
            Object currentTimestamp = Transport.getCurrentTimestamp();
            Map map = channels;
            synchronized (map) {
                Iterator iterator = channels.values().iterator();
                while (iterator.hasNext()) {
                    ChannelService channel = (ChannelService)iterator.next();
                    this.getController().channelChanged((TransportService)this, currentTimestamp, channel, channel.getState(), channel.getState());
                }
            }
        }
    }

    protected boolean attemptRecoveryFromError(int errorNumber, Throwable error) {
        switch (errorNumber) {
            case 2006: {
                return true;
            }
            case 2007: {
                return true;
            }
            case 2015: {
                return true;
            }
            case 2017: {
                return true;
            }
            case 2018: {
                return true;
            }
        }
        return super.attemptRecoveryFromError(errorNumber, error);
    }

    public void broadcastMetrics(ChannelService channel, TransportService source, Object timestamp) {
        NotificationService notificationService = this.getNotificationService();
        if (notificationService != null) {
            Hashtable<String, Object> map = new Hashtable<String, Object>();
            map.put("timestamp", timestamp);
            map.put("source", source.toString());
            map.put("inputMessageCount", Transport.createNumber((long)this.getInputMessageCount()));
            map.put("errorCount", Transport.createNumber((long)this.getErrorCount()));
            if (channel != null) {
                map.put("channel_id", channel.getId());
                String externalId = channel.getExternalId();
                if (externalId != null) {
                    map.put("channel_external_id", externalId);
                }
            }
            notificationService.broadcast(this.prefixMetrics, map);
        }
    }

    public void broadcastMetrics(TransportService source, Object timestamp) {
        this.broadcastMetrics(null, source, timestamp);
    }

    public void broadcastStatus(TransportService source, Object timestamp, int newState, int oldState) {
        NotificationService notificationService = this.getNotificationService();
        if (notificationService != null) {
            Hashtable<String, Object> map = new Hashtable<String, Object>();
            map.put("state", Transport.createInteger((int)newState));
            if (oldState != Integer.MIN_VALUE) {
                map.put("stateOld", Transport.createInteger((int)oldState));
            }
            map.put("timestamp", timestamp);
            map.put("source", source.toString());
            Dictionary configuration = this.getConfigurationInformation();
            if (configuration != null) {
                map.put("configuration", configuration);
            }
            notificationService.broadcast(this.prefixStatus, map);
        }
    }

    public void channelChanged(ChannelService channel, int newState, int oldState) {
        Object currentTimestamp = Transport.getCurrentTimestamp();
        this.getController().channelChanged((TransportService)this, currentTimestamp, channel, newState, oldState);
    }

    public void close() {
        this.closeChannels();
    }

    public void closeChannel(ChannelService channel) {
        ControllerService controller = this.getController();
        ChannelStateService channelState = controller.getChannelState(channel);
        controller.closeTransportChannel(channelState, false);
    }

    protected void closeChannels() {
        this.getController().closeTransportChannels();
    }

    public void configure() throws Exception {
    }

    public void connect() throws Exception {
        this.setState(3);
    }

    protected ChannelStateService createChannelState(ChannelService channel) {
        return null;
    }

    public ControllerService createController() {
        return new Controller(this, this.getNotificationPriority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() {
        if (this.getState() > 0) {
            Transport transport = this;
            synchronized (transport) {
                this.stop();
                this.setState(0);
                this.setNotificationService(null);
                ControllerService controller = this.getController();
                if (controller != null) {
                    controller.stop();
                    this.setController(null);
                    this.setTransportListener(null);
                    this.setConfigurationInformation(null);
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.getState() > 0) {
            this.exit();
        }
    }

    public void fireErrorOccurred(ChannelService channel, Object timestamp, Object data) {
        this.updateErrorCount(channel);
        this.getController().errorOccurred((Object)this, timestamp, data);
    }

    public void fireErrorOccurred(Object timestamp, Object data) {
        this.fireErrorOccurred(null, timestamp, data);
    }

    public void fireMessageReceived(ChannelService channel, Object timestamp, MessageService message) {
        this.updateInputMessageCount(channel);
        Object currentTimestamp = timestamp != null ? timestamp : Transport.getCurrentTimestamp();
        this.getController().messageReceived((TransportService)this, currentTimestamp, channel, message);
        this.addHistory(currentTimestamp, message);
    }

    public void fireMessageReceived(Object timestamp, MessageService message) {
        this.fireMessageReceived(null, timestamp, message);
    }

    public void fireTransportChanged(TransportService source, Object timestamp, int newState, int oldState) {
        ControllerService controllerService = this.getController();
        if (controllerService != null) {
            controllerService.transportChanged((TransportService)this, timestamp, newState, oldState);
        }
        this.broadcastStatus(source, timestamp, newState, oldState);
        if (oldState == 5) {
            this.broadcastMetrics(source, timestamp);
        }
    }

    public Map getChannels() {
        return null;
    }

    public Dictionary getConfigurationInformation() {
        if (this.configurationService == null) {
            return null;
        }
        return this.configurationService.getProperties();
    }

    public Object getConfigurationInformation(String propertyName) {
        if (this.configurationService == null) {
            return null;
        }
        return this.getConfigurationInformation().get(propertyName);
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public ConnectionService getConnection() {
        return null;
    }

    public ControllerService getController() {
        return this.controller;
    }

    public int getDefaultTransmitRetries() {
        return 0;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getErrorCount(ChannelService channel) {
        ChannelStateService channelState = this.getController().getChannelState(channel);
        return channelState.getErrorCount();
    }

    protected int getErrorSeverity(int errorNumber, Throwable error) {
        switch (errorNumber) {
            case 2005: {
                return 3;
            }
            case 2027: 
            case 2028: 
            case 2029: 
            case 2031: 
            case 2032: 
            case 2035: {
                return 2;
            }
            case 0: 
            case 3: 
            case 2006: 
            case 2007: 
            case 2009: 
            case 2010: 
            case 2011: 
            case 2012: 
            case 2013: 
            case 2015: 
            case 2017: 
            case 2018: 
            case 2019: 
            case 2030: 
            case 2034: {
                return 1;
            }
            case 2: 
            case 2037: {
                return 3;
            }
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2014: 
            case 2025: 
            case 2026: {
                return 4;
            }
            case 2023: 
            case 2024: {
                return 5;
            }
        }
        return super.getErrorSeverity(errorNumber, error);
    }

    public HistoryQueue getHistory() {
        return this.history;
    }

    protected int getInformation() {
        return this.information;
    }

    public int getInputMessageCount() {
        return this.inputMessageCount;
    }

    public int getInputMessageCount(ChannelService channel) {
        ChannelStateService channelState = this.getController().getChannelState(channel);
        return channelState.getInputMessageCount();
    }

    public InterestMasks getInterestMask() {
        return this.interestMask;
    }

    public String getKey() {
        String outputName = ((Object)((Object)this)).getClass().getName();
        int index = outputName.lastIndexOf(46);
        if (index > 0) {
            return outputName.substring(index + 1);
        }
        return outputName;
    }

    public Object getLogDetails4() {
        return String.valueOf(this.getConnection());
    }

    public Object getLogDetails5() {
        return String.valueOf((Object)this);
    }

    public int getLogLevel() {
        if (this.logLevel == 0) {
            return super.getLogLevel();
        }
        return this.logLevel;
    }

    public long getNoActivityTimeout() {
        return this.noActivityTimeout;
    }

    public int getNotificationPriority() {
        return this.notificationPriority;
    }

    public NotificationService getNotificationService() {
        return this.notificationService;
    }

    public String getPrefix() {
        return this.getString("prefix", "");
    }

    public int getPriority() {
        int priority = this.getInformation() & 0xF;
        if (priority == 0) {
            priority = this.priority;
        }
        if (priority == 0) {
            return 7;
        }
        return priority;
    }

    public Dictionary getProperties() {
        if (this.configurationService == null) {
            return EscConfiguration.getConfiguration().getProperties();
        }
        return this.configurationService.getProperties();
    }

    public String getQualifiedKey() {
        return this.getKey();
    }

    public String getResource(int resourceId) {
        try {
            return DefaultResourceBundle.getString(TransportResourceBundle.getKey(resourceId));
        }
        catch (RuntimeException runtimeException) {
            return super.getResource(resourceId);
        }
    }

    public long getResponseTimeout() {
        return 0L;
    }

    public long getRetryTime() {
        return this.retryTime;
    }

    public int getSentMessageCount() {
        return this.sentMessageCount;
    }

    public int getSentMessageCount(ChannelService channel) {
        ChannelStateService channelState = this.getController().getChannelState(channel);
        return channelState.getSentMessageCount();
    }

    public int getState() {
        return this.state;
    }

    public long getStateChangeCount() {
        return this.stateChangeCount;
    }

    public String getString(String key, String defaultString) {
        if (this.configurationService != null) {
            return this.configurationService.getString(key, super.getString(key, defaultString));
        }
        return super.getString(key, defaultString);
    }

    public short getStyle() {
        return (short)this.getInformation();
    }

    public int getTransmitRetries() {
        return this.transmitRetries;
    }

    protected TransportListener getTransportListener() {
        return this.transportListener;
    }

    protected void handleError(ChannelService channel, Throwable error, int resourceId, Object[] objects) {
        if (this.hasListeners()) {
            if (error != null) {
                this.fireErrorOccurred(channel, Transport.getCurrentTimestamp(), error);
            } else {
                this.fireErrorOccurred(channel, Transport.getCurrentTimestamp(), this.createException(resourceId, objects));
            }
        }
        super.handleError(error, resourceId, objects);
    }

    protected void handleError(Throwable error, int resourceId, Object[] objects) {
        this.handleError(null, error, resourceId, objects);
    }

    public boolean hasListeners() {
        return this.getTransportListener() != null;
    }

    public boolean isActive() {
        return this.getState() >= 4;
    }

    public boolean isEcho() {
        return (this.getInformation() & 0x100000) != 0;
    }

    public boolean isMultiplexing() {
        return this.multiplexing;
    }

    public boolean isReceivingData() {
        return (this.getInformation() & 0x40000) != 0;
    }

    public boolean isReceivingGoodData() {
        return (this.getInformation() & 0x80000) != 0;
    }

    public boolean isReceivingInput() {
        return (this.getInformation() & 0x20000) != 0;
    }

    public boolean isStarted() {
        return this.getState() >= 5;
    }

    public void log(int severity, String message, Throwable exception) {
        if (Transport.shouldLog((int)severity)) {
            ControllerService controllerService;
            if (severity == 5 && (controllerService = this.getController()) != null) {
                controllerService.trace(message);
                return;
            }
            super.log(severity, message, exception);
        }
    }

    public int noActivityProcessing() {
        return this.noActivityProcessing(null);
    }

    public int noActivityProcessing(ChannelService channel) {
        boolean isStarted;
        boolean bl = channel == null ? this.getState() == 5 : (isStarted = channel.getState() == 5);
        if (isStarted) {
            MessageService message;
            block4: {
                try {
                    message = this.noActivityProcessingMessage();
                    if (message != null) break block4;
                    this.broadcastMetrics(channel, this, EscObject.getCurrentTimestamp());
                    return 0;
                }
                catch (Exception exception) {
                    return 2;
                }
            }
            this.write(channel, message);
            this.broadcastMetrics(channel, this, EscObject.getCurrentTimestamp());
            return 1;
        }
        return 0;
    }

    public MessageService noActivityProcessingMessage() {
        return null;
    }

    public int noResponseProcessing(ChannelService channel) {
        return 0;
    }

    public ChannelService openChannel(Map parameters) throws IOException {
        return null;
    }

    public String prependPrefix(String topic) {
        return this.prependPrefix(this.getPrefix(), topic);
    }

    public String prependPrefix(String topicPrefix, String topic) {
        int topicPrefixLength;
        if (topicPrefix != null && (topicPrefixLength = topicPrefix.length()) > 0) {
            int topicLength = topic.length();
            char[] characters = new char[topicPrefixLength + topicLength + 1];
            System.arraycopy(topicPrefix.toCharArray(), 0, characters, 0, topicPrefixLength);
            characters[topicPrefixLength] = 47;
            System.arraycopy(topic.toCharArray(), 0, characters, topicPrefixLength + 1, topicLength);
            return new String(characters).intern();
        }
        return topic.intern();
    }

    protected void processEvents() throws Exception {
    }

    public void processInput(ChannelService channel) throws Exception {
    }

    public void putConfigurationInformation(String propertyName, Object value) {
        if (this.configurationService == null) {
            this.setConfigurationInformation(new Hashtable());
        }
        this.getConfigurationInformation().put(propertyName, value);
    }

    protected int read(byte[] bytes, int offset, int length) throws IOException {
        return 0;
    }

    protected int read(ChannelService channel, byte[] bytes, int offset, int length) throws IOException {
        return 0;
    }

    public void removeInterest(InterestService interest) {
        this.getInterestMask().remove(interest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransportListener(TransportListener transportListener) {
        Object object = this.transportListenerSync;
        synchronized (object) {
            this.setTransportListener(TransportListeners.remove(this.transportListener, transportListener));
        }
    }

    public void restart() {
        this.getController().restartTransport();
    }

    public void restartProcessing(boolean output) {
        this.stop();
        if (output || Transport.isTrace()) {
            this.report(null, 2028, this.getHistory());
        }
        this.start();
    }

    public void send(byte[] sendBytes) throws IOException {
        try {
            this.write(sendBytes);
        }
        catch (Exception exception) {
            this.handleError(exception, 2012, new Message(sendBytes), this.getHistory());
        }
    }

    public void send(byte[] sendBytes, ResponseListener responseListener) throws IOException {
        try {
            this.write(sendBytes, responseListener);
        }
        catch (Exception exception) {
            responseListener.noResponseReceived((TransportService)this, null, Transport.getCurrentTimestamp(), (Object)sendBytes);
            this.handleError(exception, 2012, new Message(sendBytes), this.getHistory());
        }
    }

    public void send(ChannelService channel, byte[] sendBytes) throws IOException {
        try {
            this.write(channel, sendBytes);
        }
        catch (Exception exception) {
            this.handleError(exception, 2012, new Message(sendBytes), this.getHistory());
        }
    }

    public void send(ChannelService channel, byte[] sendBytes, ResponseListener responseListener) throws IOException {
        try {
            this.write(channel, sendBytes, responseListener);
        }
        catch (Exception exception) {
            responseListener.noResponseReceived((TransportService)this, channel, Transport.getCurrentTimestamp(), (Object)sendBytes);
            this.handleError(exception, 2012, new Message(sendBytes), this.getHistory());
        }
    }

    public void send(ChannelService channel, MessageService message) {
        try {
            boolean isStarted;
            boolean bl = isStarted = channel.getState() >= 4;
            if (isStarted) {
                this.updateSentMessageCount(channel);
                if (Transport.getTraceLevel() >= 5) {
                    this.report(null, 2024, message, this.getHistory());
                }
                this.write(channel, message);
            } else {
                this.handleError(new IllegalStateException(), 2014, message);
            }
        }
        catch (Exception exception) {
            this.handleError(exception, 2012, message, this.getHistory());
            this.restart();
        }
    }

    public void send(ChannelService channel, MessageService message, ResponseListener responseListener) {
        try {
            boolean isStarted;
            boolean bl = isStarted = channel.getState() >= 4;
            if (isStarted) {
                this.updateSentMessageCount(channel);
                if (Transport.getTraceLevel() >= 5) {
                    this.report(null, 2024, message, this.getHistory());
                }
                this.write(channel, message, responseListener);
            } else {
                responseListener.noResponseReceived((TransportService)this, channel, Transport.getCurrentTimestamp(), (Object)message);
                this.handleError(new IllegalStateException(), 2014, message);
            }
        }
        catch (Exception exception) {
            responseListener.noResponseReceived((TransportService)this, channel, Transport.getCurrentTimestamp(), (Object)message);
            this.handleError(exception, 2012, message, this.getHistory());
            this.restart();
        }
    }

    public void send(MessageService message) {
        try {
            boolean isStarted = this.isStarted();
            if (isStarted) {
                this.updateSentMessageCount();
                if (Transport.getTraceLevel() >= 5) {
                    this.report(null, 2024, message, this.getHistory());
                }
                this.write(message);
            } else {
                this.handleError(new IllegalStateException(), 2014, message);
            }
        }
        catch (Exception exception) {
            this.handleError(exception, 2012, message, this.getHistory());
            this.restart();
        }
    }

    public void send(MessageService message, ResponseListener responseListener) {
        try {
            boolean isStarted = this.isStarted();
            if (isStarted) {
                this.updateSentMessageCount();
                if (Transport.getTraceLevel() >= 5) {
                    this.report(null, 2024, message, this.getHistory());
                }
                this.write(message, responseListener);
            } else {
                responseListener.noResponseReceived((TransportService)this, null, Transport.getCurrentTimestamp(), (Object)message);
                this.handleError(new IllegalStateException(), 2014, message);
            }
        }
        catch (Exception exception) {
            responseListener.noResponseReceived((TransportService)this, null, Transport.getCurrentTimestamp(), (Object)message);
            this.handleError(exception, 2012, message, this.getHistory());
            this.restart();
        }
    }

    public void setActive(boolean active) {
        if (active) {
            this.setInformation(this.getInformation() | 0x10000);
        } else {
            this.setInformation(this.getInformation() & 0xFFFEFFFF);
        }
    }

    public void setConfigurationInformation(Dictionary configurationInformation) {
        if (configurationInformation != null) {
            this.configurationService = new EscConfiguration(configurationInformation);
            this.prefixStatus = this.prependPrefix("Transport/Status");
            this.prefixMetrics = this.prependPrefix("Transport/Metrics");
            this.setLogLevel(this.getInt("loglevel", 0));
        } else {
            this.configurationService = null;
        }
    }

    public void setController(ControllerService controller) {
        this.controller = controller;
    }

    public void setEcho(boolean echo) {
        if (echo) {
            this.setInformation(this.getInformation() | 0x100000);
        } else {
            this.setInformation(this.getInformation() & 0xFFEFFFFF);
        }
    }

    public void setErrorCount(ChannelService channel, int errorCount) {
        ChannelStateService channelState = this.getController().getChannelState(channel);
        channelState.setErrorCount(errorCount);
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
        this.setErrorCount(null, errorCount);
    }

    public void setHistory(HistoryQueue history) {
        this.history = history;
    }

    protected void setInformation(int information) {
        this.information = information;
    }

    public void setInputMessageCount(ChannelService channel, int inputMessageCount) {
        ChannelStateService channelState = this.getController().getChannelState(channel);
        channelState.setInputMessageCount(inputMessageCount);
    }

    public void setInputMessageCount(int inputMessageCount) {
        this.inputMessageCount = inputMessageCount;
        this.setInputMessageCount(null, inputMessageCount);
    }

    public void setInterestMask(InterestMasks interestMask) {
        this.interestMask = interestMask;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public void setMultiplexing(boolean multiplexing) {
        this.multiplexing = multiplexing;
    }

    public void setNoActivityTimeout(long noActivityTimeout) {
        this.noActivityTimeout = noActivityTimeout;
    }

    public void setNotificationPriority(int notificationPriority) {
        this.notificationPriority = notificationPriority;
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setReceivingData() {
        this.setInformation(this.getInformation() | 0x70000);
    }

    public void setReceivingData(boolean receivingData) {
        if (receivingData) {
            this.setInformation(this.getInformation() | 0x70000);
        } else {
            this.setInformation(this.getInformation() & 0xFFFBFFFF);
        }
    }

    public void setReceivingGoodData() {
        this.setInformation(this.getInformation() | 0xF0000);
    }

    public void setReceivingGoodData(boolean receivingGoodData) {
        if (receivingGoodData) {
            this.setInformation(this.getInformation() | 0xF0000);
        } else {
            this.setInformation(this.getInformation() & 0xFFF7FFFF);
        }
    }

    public void setReceivingInput() {
        this.setInformation(this.getInformation() | 0x30000);
    }

    public void setReceivingInput(boolean receivingInput) {
        if (receivingInput) {
            this.setInformation(this.getInformation() | 0x30000);
        } else {
            this.setInformation(this.getInformation() & 0xFFFDFFFF);
        }
    }

    public void setRetryTime(long retryTime) {
        this.retryTime = retryTime;
    }

    public void setSentMessageCount(ChannelService channel, int sentMessageCount) {
        ChannelStateService channelState = this.getController().getChannelState(channel);
        channelState.setSentMessageCount(sentMessageCount);
    }

    public void setSentMessageCount(int sentMessageCount) {
        this.sentMessageCount = sentMessageCount;
        this.setSentMessageCount(null, sentMessageCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setState(int state) {
        if (this.state != state) {
            if (this.state > 0) {
                int oldState = this.state;
                this.state = state;
                Object object = this.stateChanaged;
                synchronized (object) {
                    this.stateChanaged.notifyAll();
                }
                ++this.stateChangeCount;
                this.fireTransportChanged(this, Transport.getCurrentTimestamp(), state, oldState);
                this.report(null, TRANSPORT_STATE_RESOURCE_TABLE[state], STATE_STRINGS[oldState], this.getConfigurationInformation());
                return;
            }
            Object object = this.stateChanaged;
            synchronized (object) {
                this.stateChanaged.notifyAll();
                return;
            }
        }
        Object object = this.stateChanaged;
        synchronized (object) {
            this.stateChanaged.notifyAll();
            return;
        }
    }

    public void setStateChangeCount(long stateChangeCount) {
        this.stateChangeCount = stateChangeCount;
    }

    public void setStyle(short style) {
        this.setInformation(this.getInformation() & 0xFFFF0000 | style);
    }

    public void setTransmitRetries(int transmitRetries) {
        this.transmitRetries = transmitRetries;
    }

    protected void setTransportListener(TransportListener transportListener) {
        this.transportListener = transportListener;
    }

    public void setup() {
        ControllerService controller = this.getController();
        if (controller == null) {
            this.setController(this.createController());
            this.getController().start();
        }
    }

    public void setupCustom() {
    }

    public void shutdown(boolean output) {
        block2: {
            try {
                this.close();
            }
            catch (RuntimeException exception) {
                if (!output && !EscObject.isTrace()) break block2;
                this.handleError(exception, 2011);
            }
        }
        this.setState(1);
    }

    public void start() {
        if (this.getState() < 5) {
            this.setup();
            this.setupCustom();
            this.start(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean output) {
        Transport transport = this;
        synchronized (transport) {
            this.setState(2);
            this.getController().start(output);
        }
    }

    public int startup(boolean output) throws Exception {
        return 5;
    }

    public int startup(ChannelService channel) throws Exception {
        return 5;
    }

    public void startupMessageReceived(TransportService transportService, Object timestamp, ChannelService channel, MessageService message) {
        if (channel == null) {
            this.startupMessageReceived(transportService, timestamp, message);
        }
    }

    public void startupMessageReceived(TransportService source, Object timestamp, MessageService message) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Transport transport = this;
        synchronized (transport) {
            int state = this.getState();
            if (state >= 2) {
                try {
                    this.shutdown(true);
                }
                catch (RuntimeException exception) {
                    EscObject.handleStaticException((Throwable)exception);
                }
                if (state == 5) {
                    this.setState(4);
                }
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(this.getOutputName());
        buffer.append('=');
        buffer.append(STATE_STRINGS[this.state]);
        this.toStringInfo(buffer);
        buffer.append(",statechangecount=");
        buffer.append(this.getStateChangeCount());
        return buffer.toString();
    }

    public void updateErrorCount() {
        this.updateErrorCount(null);
    }

    public void updateErrorCount(ChannelService channel) {
        ++this.errorCount;
        ChannelStateService channelState = this.getController().getChannelState(channel);
        channelState.updateErrorCount();
    }

    public int updateInputMessageCount() {
        this.updateInputMessageCount((ChannelService)null);
        return this.inputMessageCount;
    }

    public int updateInputMessageCount(ChannelService channel) {
        return this.updateInputMessageCount(this.getController().getChannelState(channel));
    }

    public int updateInputMessageCount(ChannelStateService channelState) {
        ++this.inputMessageCount;
        int state = channelState.getState();
        if (state != 3 && state != 5) {
            this.getController().scheduleTimeout(channelState, Transport.getCurrentTimestamp(), this.getNoActivityTimeout());
        }
        return channelState.updateInputMessageCount();
    }

    public void updateSentMessageCount() {
        this.updateSentMessageCount(null);
    }

    public void updateSentMessageCount(ChannelService channel) {
        ++this.sentMessageCount;
        ChannelStateService channelState = this.getController().getChannelState(channel);
        channelState.updateSentMessageCount();
    }

    public int waitStateChange() {
        return this.waitStateChange(this.getRetryTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitStateChange(long timeout) {
        try {
            Object object = this.stateChanaged;
            synchronized (object) {
                this.stateChanaged.wait(timeout);
            }
        }
        catch (InterruptedException interruptedException) {}
        return this.getState();
    }

    public void write(byte[] bytes) throws Exception {
        this.write(null, bytes);
    }

    protected void write(byte[] sendBytes, ResponseListener responseListener) throws Exception {
        this.write(sendBytes);
        if (responseListener != null && !this.isEcho()) {
            responseListener.responseReceived((TransportService)this, null, Transport.getCurrentTimestamp(), (Object)sendBytes);
        }
    }

    public void write(ChannelService channel, byte[] sendBytes) throws Exception {
    }

    protected void write(ChannelService channel, byte[] sendBytes, ResponseListener responseListener) throws Exception {
        this.write(channel, sendBytes);
        if (responseListener != null && !this.isEcho()) {
            responseListener.responseReceived((TransportService)this, channel, Transport.getCurrentTimestamp(), (Object)sendBytes);
        }
    }

    protected void write(ChannelService channel, MessageService message) throws Exception {
        this.write(channel, message.getBytes());
    }

    protected void write(ChannelService channel, MessageService message, ResponseListener responseListener) throws Exception {
        this.write(channel, message);
        if (responseListener != null && !this.isEcho()) {
            responseListener.responseReceived((TransportService)this, channel, Transport.getCurrentTimestamp(), (Object)message);
        }
    }

    protected void write(MessageService message) throws Exception {
        this.write(message.getBytes());
    }

    protected void write(MessageService message, ResponseListener responseListener) throws Exception {
        this.write(message);
        if (responseListener != null && !this.isEcho()) {
            responseListener.responseReceived((TransportService)this, null, Transport.getCurrentTimestamp(), (Object)message);
        }
    }

    public void writeAndReport(byte[] bytes) {
        try {
            this.write(bytes);
        }
        catch (Exception exception) {
            this.handleError(exception, 2030, new Message(bytes), this.getHistory());
        }
    }

    public void writeAndReport(ChannelService channel, byte[] bytes) {
        try {
            this.write(channel, bytes);
        }
        catch (Exception exception) {
            this.handleError(exception, 2030, new Message(bytes), this.getHistory());
        }
    }

    public void writeAndReport(ChannelService channel, MessageService message) {
        try {
            this.write(channel, message);
        }
        catch (Exception exception) {
            this.handleError(exception, 2030, message, this.getHistory());
        }
    }

    public void writeAndReport(MessageService message) {
        try {
            this.write(message);
        }
        catch (Exception exception) {
            this.handleError(exception, 2030, message, this.getHistory());
        }
    }
}

