/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.testmanager.view;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.soda.devicekit.ui.testmanager.TestManagerMessages;
import org.eclipse.soda.devicekit.ui.testmanager.model.TestModel;
import org.eclipse.soda.devicekit.ui.testmanager.model.TestRunSession;
import org.eclipse.soda.devicekit.ui.testmanager.view.CopyFailureListAction;
import org.eclipse.soda.devicekit.ui.testmanager.view.TestReportContentProvider;
import org.eclipse.soda.devicekit.ui.testmanager.view.TestReportLabelDecorator;
import org.eclipse.soda.devicekit.ui.testmanager.view.TestReportLabelProvider;
import org.eclipse.soda.devicekit.ui.testmanager.view.TestRunnerViewPart;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestViewer {
    private final FailuresOnlyFilter fFailuresOnlyFilter = new FailuresOnlyFilter();
    private final TestRunnerViewPart fTestRunnerPart;
    private final Clipboard fClipboard;
    protected TreeViewer fTreeViewer;
    private ITreeContentProvider fTreeContentProvider;
    private ILabelProvider fTreeLabelProvider;
    private TestRunSession fTestRunSession;
    private HashSet fNeedUpdate;
    private Element fAutoScrollTarget;
    private LinkedList fAutoClose;
    private HashSet fAutoExpand;
    private boolean fTreeHasFilter;
    private boolean fTreeNeedsRefresh;

    public TestViewer(Composite parent, Clipboard clipboard, TestRunnerViewPart runner) {
        this.fTestRunnerPart = runner;
        this.fClipboard = clipboard;
        this.createTestViewers(parent);
        this.registerViewersRefresh();
        this.initContextMenu();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoScrollInUI() {
        if (!this.fTestRunnerPart.isAutoScroll()) {
            this.clearAutoExpand();
            this.fAutoClose.clear();
            return;
        }
        TestViewer testViewer = this;
        synchronized (testViewer) {
            Element parent;
            Iterator iter = this.fAutoExpand.iterator();
            while (iter.hasNext()) {
                Element suite = (Element)iter.next();
                this.fTreeViewer.setExpandedState((Object)suite, true);
            }
            this.clearAutoExpand();
            Element current = this.fAutoScrollTarget;
            this.fAutoScrollTarget = null;
            Element element = parent = current == null ? null : (Element)this.fTreeContentProvider.getParent((Object)current);
            if (this.fAutoClose.isEmpty() || !this.fAutoClose.getLast().equals(parent)) {
                ListIterator iter2 = this.fAutoClose.listIterator(this.fAutoClose.size());
                while (iter2.hasPrevious()) {
                    Element previousAutoOpened = (Element)iter2.previous();
                    if (previousAutoOpened.equals(parent)) break;
                }
                while (parent != null && !this.fTestRunSession.getTestRoot().equals(parent) && !this.fTreeViewer.getExpandedState((Object)parent)) {
                    this.fAutoClose.add(parent);
                    parent = (Element)this.fTreeContentProvider.getParent((Object)parent);
                }
            }
            if (current != null) {
                this.fTreeViewer.reveal((Object)current);
            }
        }
    }

    private synchronized void clearAutoExpand() {
        this.fAutoExpand.clear();
    }

    private void clearUpdateAndExpansion() {
        this.fNeedUpdate = new LinkedHashSet();
        this.fAutoClose = new LinkedList();
        this.fAutoExpand = new HashSet();
    }

    private void createTestViewers(Composite parent) {
        this.fTreeViewer = new TreeViewer(parent, 516);
        this.fTreeViewer.setUseHashlookup(true);
        this.fTreeContentProvider = new TestReportContentProvider();
        this.fTreeViewer.setContentProvider((IContentProvider)this.fTreeContentProvider);
        this.fTreeLabelProvider = new DecoratingLabelProvider((ILabelProvider)new TestReportLabelProvider(), (ILabelDecorator)new TestReportLabelDecorator());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.fTreeLabelProvider);
        this.fTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new TestSelectionListener());
    }

    public void expandFirstLevel() {
        this.fTreeViewer.expandToLevel(2);
    }

    private StructuredViewer getActiveViewer() {
        return this.fTreeViewer;
    }

    private boolean getActiveViewerHasFilter() {
        return this.fTreeHasFilter;
    }

    private boolean getActiveViewerNeedsRefresh() {
        return this.fTreeNeedsRefresh;
    }

    private Element getErrorOrFailure(Node node) {
        if (TestModel.isErrorOrFailure(node)) {
            return (Element)node;
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (TestModel.isErrorOrFailure(child)) {
                return (Element)child;
            }
            ++i;
        }
        return null;
    }

    private Node getNextFailure(Node selected, boolean showNext) {
        Node sibling = this.getNextSibling(selected, showNext);
        return (sibling = this.getNextFailureSibling(sibling, showNext)) != null ? sibling : selected;
    }

    private Node getNextFailureSibling(Node start, boolean showNext) {
        Node child;
        Node current = start;
        do {
            Element element;
            if (!(current instanceof Element) || !TestModel.isErrorOrFailure(element = (Element)current)) continue;
            return element.getParentNode();
        } while ((current = (child = showNext ? current.getFirstChild() : current.getLastChild()) != null ? child : this.getNextSibling(current, showNext)) != null);
        return null;
    }

    private Node getNextSibling(Node current, boolean showNext) {
        Node sibling;
        Node node = sibling = showNext ? current.getNextSibling() : current.getPreviousSibling();
        if (sibling != null) {
            return sibling;
        }
        if (current instanceof Attr) {
            Element parent = ((Attr)current).getOwnerElement();
            return showNext ? parent : parent.getPreviousSibling();
        }
        Node parent = current.getParentNode();
        if (parent != null) {
            return showNext ? parent.getNextSibling() : parent.getPreviousSibling();
        }
        return null;
    }

    public Control getTestViewerControl() {
        return this.fTreeViewer.getControl();
    }

    void handleMenuAboutToShow(IMenuManager manager) {
        manager.add((IAction)new ExpandAllAction());
        if (this.fTestRunSession != null && this.fTestRunSession.getFailureCount() + this.fTestRunSession.getErrorCount() > 0) {
            manager.add((IAction)new CopyFailureListAction(this.fTestRunnerPart, this.fClipboard));
        }
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator("additions-end"));
    }

    void handleSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        Element testElement = null;
        if (selection.size() == 1) {
            testElement = this.getErrorOrFailure((Node)selection.getFirstElement());
        }
        this.fTestRunnerPart.handleTestSelected(testElement);
    }

    private void initContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TestViewer.this.handleMenuAboutToShow(manager);
            }
        });
        this.fTestRunnerPart.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.fTreeViewer);
        Menu menu = menuMgr.createContextMenu(this.fTreeViewer.getControl());
        this.fTreeViewer.getTree().setMenu(menu);
    }

    private boolean isShown(Node testElement) {
        return !this.getActiveViewerHasFilter() || this.fFailuresOnlyFilter.select(testElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processChangesInUI() {
        if (this.fTestRunSession == null) {
            this.registerViewersRefresh();
            this.fTreeNeedsRefresh = false;
            this.fTreeViewer.setInput(null);
            return;
        }
        Element testRoot = this.fTestRunSession.getTestRoot();
        StructuredViewer viewer = this.getActiveViewer();
        if (this.getActiveViewerNeedsRefresh()) {
            this.clearUpdateAndExpansion();
            this.setActiveViewerRefreshed();
            viewer.setInput((Object)testRoot);
        } else {
            Object[] toUpdate;
            TestViewer testViewer = this;
            synchronized (testViewer) {
                toUpdate = this.fNeedUpdate.toArray();
                this.fNeedUpdate.clear();
            }
            if (!this.fTreeNeedsRefresh && toUpdate.length > 0) {
                int i = 0;
                while (i < toUpdate.length) {
                    this.updateElementInTree((Element)toUpdate[i]);
                    ++i;
                }
            }
        }
        this.autoScrollInUI();
    }

    public synchronized void registerActiveSession(TestRunSession testRunSession) {
        this.fTestRunSession = testRunSession;
        this.registerAutoScrollTarget(null);
        this.registerViewersRefresh();
    }

    public void registerAutoScrollTarget(Element testCaseElement) {
        this.fAutoScrollTarget = testCaseElement;
    }

    public synchronized void registerFailedForAutoScroll(Element testElement) {
        Object parent = this.fTreeContentProvider.getParent((Object)testElement);
        if (parent != null) {
            this.fAutoExpand.add(parent);
        }
    }

    public synchronized void registerViewerUpdate(Element testElement) {
        this.fNeedUpdate.add(testElement);
    }

    public synchronized void registerViewersRefresh() {
        this.fTreeNeedsRefresh = true;
        this.clearUpdateAndExpansion();
    }

    public void selectFailure(boolean showNext) {
        IStructuredSelection selection = (IStructuredSelection)this.getActiveViewer().getSelection();
        Node selected = (Node)selection.getFirstElement();
        Node next = selected == null ? this.getNextFailureSibling(this.fTestRunSession.getTestRoot(), showNext) : this.getNextFailure(selected, showNext);
        if (next != null) {
            this.getActiveViewer().setSelection((ISelection)new StructuredSelection((Object)next), true);
        }
    }

    public void selectFirstFailure() {
        Node firstFailure = this.getNextFailureSibling(this.fTestRunSession.getTestRoot(), true);
        if (firstFailure != null) {
            this.getActiveViewer().setSelection((ISelection)new StructuredSelection((Object)firstFailure), true);
        }
    }

    private void setActiveViewerHasFilter(boolean filter) {
        this.fTreeHasFilter = filter;
    }

    private void setActiveViewerRefreshed() {
        this.fTreeNeedsRefresh = false;
    }

    public synchronized void setShowFailuresOnly(boolean failuresOnly) {
        StructuredViewer viewer = this.getActiveViewer();
        if (failuresOnly) {
            if (!this.getActiveViewerHasFilter()) {
                this.setActiveViewerHasFilter(true);
                if (this.getActiveViewerNeedsRefresh()) {
                    viewer.setInput(null);
                }
                viewer.addFilter((ViewerFilter)this.fFailuresOnlyFilter);
            }
        } else if (this.getActiveViewerHasFilter()) {
            this.setActiveViewerHasFilter(false);
            if (this.getActiveViewerNeedsRefresh()) {
                viewer.setInput(null);
            }
            viewer.removeFilter((ViewerFilter)this.fFailuresOnlyFilter);
        }
        this.processChangesInUI();
    }

    private void updateElementInTree(Node testElement) {
        if (this.isShown(testElement)) {
            this.updateShownElementInTree(testElement);
        }
    }

    private void updateShownElementInTree(Node parent2) {
        if (parent2 == null) {
            return;
        }
        Node parent = parent2.getParentNode();
        this.updateShownElementInTree(parent);
        if (this.fTreeViewer.testFindItem((Object)parent2) == null) {
            if (parent != null) {
                this.fTreeViewer.add((Object)parent, (Object)parent2);
            }
        } else {
            this.fTreeViewer.update((Object)parent2, null);
        }
    }

    private class ExpandAllAction
    extends Action {
        public ExpandAllAction() {
            this.setText(TestManagerMessages.ExpandAllAction_text);
            this.setToolTipText(TestManagerMessages.ExpandAllAction_tooltip);
        }

        public void run() {
            TestViewer.this.fTreeViewer.expandAll();
        }
    }

    private final class FailuresOnlyFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return this.select((Node)element);
        }

        public boolean select(Node node) {
            Element element;
            return node instanceof Element && TestModel.hasErrorOrFailureInDecendants(element = (Element)node);
        }
    }

    private final class TestSelectionListener
    implements ISelectionChangedListener {
        public void selectionChanged(SelectionChangedEvent event) {
            TestViewer.this.handleSelected();
        }
    }
}

