/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.testmanager.view;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.IOpenEventListener;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.soda.devicekit.ui.testmanager.model.TestModel;
import org.eclipse.soda.devicekit.ui.testmanager.preferences.TestManagerPreferencePage;
import org.eclipse.soda.devicekit.ui.testmanager.view.EnableStackFilterAction;
import org.eclipse.soda.devicekit.ui.testmanager.view.FailureTableDisplay;
import org.eclipse.soda.devicekit.ui.testmanager.view.OpenEditorAtLineAction;
import org.eclipse.soda.devicekit.ui.testmanager.view.TestRunnerViewPart;
import org.eclipse.soda.devicekit.ui.testmanager.view.TextualTrace;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FailureTrace
implements IMenuListener {
    private static final int MAX_LABEL_LENGTH = 256;
    static final String FRAME_PREFIX = "at ";
    Table fTable;
    private TestRunnerViewPart fTestRunner;
    private String fInputTrace;
    private Element fFailure;
    private final FailureTableDisplay fFailureTableDisplay;

    public FailureTrace(Composite parent, TestRunnerViewPart testRunner, ToolBar toolBar) {
        ToolBarManager failureToolBarmanager = new ToolBarManager(toolBar);
        failureToolBarmanager.add((IAction)new EnableStackFilterAction(this));
        failureToolBarmanager.update(true);
        this.fTable = new Table(parent, 772);
        this.fTestRunner = testRunner;
        OpenStrategy handler = new OpenStrategy((Control)this.fTable);
        handler.addOpenListener(new IOpenEventListener(){

            public void handleOpen(SelectionEvent e) {
                Action a;
                if (FailureTrace.this.fTable.getSelection().length != 0 && (a = FailureTrace.this.createOpenEditorAction(FailureTrace.this.getSelectedText())) != null) {
                    a.run();
                }
            }
        });
        this.initMenu();
        this.fFailureTableDisplay = new FailureTableDisplay(this.fTable);
    }

    public void clear() {
        this.fTable.removeAll();
        this.fInputTrace = null;
    }

    Action createOpenEditorAction(String traceLine) {
        try {
            String testName = traceLine;
            testName = testName.substring(testName.indexOf(FRAME_PREFIX));
            testName = testName.substring(FRAME_PREFIX.length(), testName.lastIndexOf(40)).trim();
            testName = testName.substring(0, testName.lastIndexOf(46));
            int innerSeparatorIndex = testName.indexOf(36);
            if (innerSeparatorIndex != -1) {
                testName = testName.substring(0, innerSeparatorIndex);
            }
            String lineNumber = traceLine;
            lineNumber = lineNumber.substring(lineNumber.indexOf(58) + 1, lineNumber.lastIndexOf(41));
            int line = Integer.valueOf(lineNumber);
            return new OpenEditorAtLineAction(this.fTestRunner, testName, line);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return null;
    }

    Composite getComposite() {
        return this.fTable;
    }

    public Node getFailedTest() {
        return this.fFailure;
    }

    public FailureTableDisplay getFailureTableDisplay() {
        return this.fFailureTableDisplay;
    }

    private String[] getFilterPatterns() {
        if (TestManagerPreferencePage.getFilterStack()) {
            return TestManagerPreferencePage.getFilterPatterns();
        }
        return new String[0];
    }

    String getSelectedText() {
        return this.fTable.getSelection()[0].getText();
    }

    public Shell getShell() {
        return this.fTable.getShell();
    }

    public String getTrace() {
        return this.fInputTrace;
    }

    private void initMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        Menu menu = menuMgr.createContextMenu((Control)this.fTable);
        this.fTable.setMenu(menu);
    }

    public void menuAboutToShow(IMenuManager manager) {
        if (this.fTable.getSelectionCount() > 0) {
            Action a = this.createOpenEditorAction(this.getSelectedText());
            if (a != null) {
                manager.add((IAction)a);
            }
            manager.add(this.fTestRunner.getCopyAction());
        }
    }

    public void refresh() {
        this.updateTable(this.fInputTrace);
    }

    public void setInformation(String text) {
        this.clear();
    }

    public void showFailure(Element test) {
        this.fFailure = test;
        String trace = "";
        if (test != null) {
            trace = TestModel.getTextContent(test);
        }
        if (this.fInputTrace == trace) {
            return;
        }
        this.fInputTrace = trace;
        this.updateTable(trace);
    }

    private void updateTable(String trace) {
        if (trace == null || trace.trim().equals("")) {
            this.clear();
            return;
        }
        String trimmedTrace = trace.trim();
        this.fTable.setRedraw(false);
        this.fTable.removeAll();
        new TextualTrace(trimmedTrace, this.getFilterPatterns()).display(this.fFailureTableDisplay, 256);
        this.fTable.setRedraw(true);
    }
}

