/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.sim;

import java.util.List;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.sim.DkTransportSimGenerator;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.util.KeyValuePair;

public class DkTransportJunitTestGenerator
extends DkTransportSimGenerator {
    public DkTransportJunitTestGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        super(model, generatedInfo);
    }

    protected void codeConstructors(IType test) {
        String name = this.getMainClassName();
        KeyValuePair param = new KeyValuePair("String", "name");
        String contents = this.getConstructorContents();
        String returnType = null;
        String comment = String.valueOf(name) + '.';
        this.codeMethod(test, name, comment, returnType, 1L, contents, new KeyValuePair[]{param}, null);
    }

    private void codeFailuresField(IType test) {
        this.codeField(test, "failures", "boolean", 18L, "Field failures.", "false");
    }

    protected void codeFields(IType test) {
        this.codeTransportComparisionTestField(test);
        this.codeTestRunField(test);
        this.codeFailuresField(test);
        this.codeSuppressConsoleField(test);
        this.codeMaxDisplayedErrorsIndicesField(test);
        this.codeRelativeOutputDirField(test);
        this.codeTransportRecFileNameField(test);
        this.codeTransportCompFileNameField(test);
    }

    protected void codeHandleResults(IType test) {
        String[] comment = null;
        String traceEntryClass = String.valueOf(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT_TRACE_ENTRY)) + "[]";
        KeyValuePair traceEntry = new KeyValuePair(traceEntryClass, "entries");
        KeyValuePair testName = new KeyValuePair("String", "testName");
        KeyValuePair[] parameters = new KeyValuePair[]{traceEntry, testName};
        String contents = this.getHandleResultsContents();
        this.codeMethod(test, "handleResults", comment, "void", 1L, contents, parameters, null);
    }

    private void codeMaxDisplayedErrorsIndicesField(IType test) {
        this.codeField(test, "MAX_DISPLAYED_ERROR_INDICIES", "int", 50L, "Field MAX_DISPLAYED_ERROR_INDICIES.", "5");
    }

    protected void codeMethods(IType test) {
        super.codeMain(test);
        this.codeHandleResults(test);
        this.codeRunTransportPlayback(test);
        this.codeSetup(test);
        this.codeSuite(test);
        this.codeTearDown(test);
        this.codeTests(test);
    }

    private void codeRelativeOutputDirField(IType test) {
        this.codeField(test, "RELATIVE_OUTPUT_DIR", "String", 50L, "Field RELATIVE_OUTPUT_DIR.", "\"/\"");
    }

    protected void codeRunTransportPlayback(IType test) {
        String[] exceptions = new String[]{"Exception"};
        String contents = this.getRunTransportPlaybackContents();
        this.codeMethod(test, "runTransportPlaybackTest", "runTransportPlaybackTest.", "void", 130L, contents, null, exceptions);
    }

    protected void codeSetup(IType test) {
        String[] exceptions = new String[]{"Exception"};
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("super.setUp();\n");
        buffer.append("runTransportPlaybackTest();\n");
        String contents = buffer.toString();
        this.codeMethod(test, "setUp", "setUp.", "void", 4L, contents, null, exceptions);
    }

    protected void codeSuite(IType test) {
        String returnType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_JUNIT_TEST);
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_JUNIT_TEST);
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("return new ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_JUNIT_TESTSUITE));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_JUNIT_TESTSUITE);
        buffer.append('(');
        buffer.append(this.getMainClassName());
        buffer.append(".class);\n");
        String contents = buffer.toString();
        this.codeMethod(test, "suite", "suite.", returnType, 17L, contents);
    }

    private void codeSuppressConsoleField(IType test) {
        this.codeField(test, "supressConsole", "boolean", 18L, "Field supressConsole.", "true");
    }

    protected void codeTearDown(IType test) {
        String[] exceptions = new String[]{"Exception"};
        this.codeMethod(test, "tearDown", "tearDown.", "void", 4L, "super.tearDown();\n", null, exceptions);
    }

    protected void codeTestBytesComparison(IType test) {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("handleResults(comparisonTest.getBytesFailures(), \"message bytes\");\n");
        String contents = buffer.toString();
        this.codeMethod(test, "testBytesComparison", "testBytesComparison.", "void", 1L, contents);
    }

    protected void codeTestClassComparison(IType test) {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("handleResults(comparisonTest.getClassFailures(), \"message class\");\n");
        String contents = buffer.toString();
        this.codeMethod(test, "testClassComparison", "testClassComparison.", "void", 1L, contents);
    }

    protected void codeTestOccurenceNumber(IType test) {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("assertTrue(\"Mismatching number of transport message occurences\", comparisonTest.getOccurenceNumberFailure() == false);\n");
        String contents = buffer.toString();
        this.codeMethod(test, "testOccurenceNumber", "testOccurenceNumber.", "void", 1L, contents);
    }

    private void codeTestRunField(IType test) {
        this.codeField(test, "testRun", "boolean", 18L, "Field testRun.", "false");
    }

    protected void codeTestTimeComparison(IType test) {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("handleResults(comparisonTest.getTimeFailures(), \"time delta\");\n");
        String contents = buffer.toString();
        this.codeMethod(test, "testTimeComparison", "testTimeComparison.", "void", 1L, contents);
    }

    protected void codeTests(IType test) {
        this.codeTestBytesComparison(test);
        this.codeTestClassComparison(test);
        this.codeTestOccurenceNumber(test);
        this.codeTestTimeComparison(test);
    }

    private void codeTransportCompFileNameField(IType test) {
        String value = "\"" + this.getBaseName() + "TransportComparisonRec.xml\"";
        this.codeField(test, "TRANSPORT_COMP_FILENAME", "String", 50L, "Field TRANSPORT_COMP_FILENAME.", value);
    }

    private void codeTransportComparisionTestField(IType test) {
        String fieldType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT_COMPARISON_TESTER);
        String value = null;
        this.codeField(test, "comparisonTest", fieldType, 18L, "Field comparisonTest.", value);
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_TRANSPORT_COMPARISON_TESTER);
    }

    private void codeTransportRecFileNameField(IType test) {
        String value = "\"" + this.getBaseName() + "TransportRec.xml\"";
        this.codeField(test, "TRANSPORT_REC_FILENAME", "String", 50L, "Field TRANSPORT_REC_FILENAME.", value);
    }

    protected boolean doGenerateBundleActivator() {
        return false;
    }

    protected boolean doGenerateService() {
        return false;
    }

    protected String getBaseName() {
        return DeviceKitUtilities.removeLastOccurence(this.getMainClassName(), "JunitTest");
    }

    protected String getConstructorContents() {
        return "super(name);";
    }

    protected String getHandleResultsContents() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("if (entries != null) {\n");
        buffer.append("\tString message = entries.length + \" occurence(s) failed \" + testName\t+ \" comparison test. Failures include those at time \";\n");
        buffer.append("\tfor (int i = 0; i < MAX_DISPLAYED_ERROR_INDICIES && i < entries.length; i++) {\n");
        buffer.append("\t\tmessage += entries[i].getDeltaTime() + \", \";\n");
        buffer.append("\t}\n");
        buffer.append("\tmessage = message.substring(0, message.length() - 2) + \" of comparison trace.\";\n");
        buffer.append("\tfail(message);\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    protected String[] getImplementedInterfaces() {
        return new String[0];
    }

    protected String getMainContents() {
        StringBuffer buffer = new StringBuffer(128);
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_JUNIT_TESTRUNNER);
        buffer.append("final ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_JUNIT_TEST));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_JUNIT_TEST);
        buffer.append(" test = new ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_JUNIT_TESTSUITE));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_JUNIT_TESTSUITE);
        buffer.append('(');
        buffer.append(this.getMainClassName());
        buffer.append(".class);\n");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_JUNIT_TESTRUNNER));
        buffer.append(".run(test);\n");
        buffer.append("System.exit(0);\n");
        return buffer.toString();
    }

    protected String getRunTransportPlaybackContents() {
        StringBuffer buffer = new StringBuffer(512);
        buffer.append("if (");
        buffer.append("testRun");
        buffer.append(") {\n");
        buffer.append("\treturn;\n");
        buffer.append("}\n");
        buffer.append(DeviceKitUtilities.stripPackage("java.io.PrintStream"));
        this.fTestModel.addImport("java.io.PrintStream");
        buffer.append(" origOut = System.out;\n");
        buffer.append(DeviceKitUtilities.stripPackage("java.io.PrintStream"));
        this.fTestModel.addImport("java.io.PrintStream");
        buffer.append(" origErr = System.err;\n");
        buffer.append("if (");
        buffer.append("supressConsole");
        buffer.append(") {\n");
        buffer.append('\t');
        buffer.append(DeviceKitUtilities.stripPackage("java.io.PrintStream"));
        this.fTestModel.addImport("java.io.PrintStream");
        buffer.append(" nullStream = new ");
        buffer.append(DeviceKitUtilities.stripPackage("java.io.PrintStream"));
        buffer.append("(new ");
        buffer.append(DeviceKitUtilities.stripPackage("java.io.OutputStream"));
        this.fTestModel.addImport("java.io.OutputStream");
        buffer.append("() {\n");
        buffer.append("\t\tpublic void write(int oneByte) throws IOException {\n");
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_IOEXCEPTION);
        buffer.append("\t\t}\n");
        buffer.append("\t});\n");
        buffer.append("\tSystem.setOut(nullStream);\n");
        buffer.append("\tSystem.setErr(nullStream);\n");
        buffer.append("}\n");
        buffer.append("testRun");
        buffer.append(" = true;\n");
        String playback = String.valueOf(this.getBaseName()) + "Playback";
        String playbackFqn = String.valueOf(DeviceKitUtilities.getPackageFromClassName(playback, this.getPackageBase())) + '.' + playback;
        this.fTestModel.addImport(playbackFqn);
        buffer.append(playback);
        buffer.append(" playback = new ");
        buffer.append(playback);
        buffer.append("();\n");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT_MEMORY_OUTPUT_HANDLER));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_TRANSPORT_MEMORY_OUTPUT_HANDLER);
        buffer.append(" handler = new ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT_MEMORY_OUTPUT_HANDLER));
        buffer.append("();\n");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_MONITOR_TRANSPORT));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_MONITOR_TRANSPORT);
        buffer.append(" monitorTransport = new ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_MONITOR_TRANSPORT));
        buffer.append("(playback.getTransport(), handler);\n");
        buffer.append("monitorTransport.startMonitoring();\n");
        buffer.append("playback.start();\n");
        buffer.append("for (int i = 1; i < 100; i++){\n");
        buffer.append("\tif (playback.isStarted()){\n");
        buffer.append("\t\tbreak;\n");
        buffer.append("\t} else {\n");
        buffer.append("\t\t");
        buffer.append(DeviceKitUtilities.stripPackage("Thread"));
        this.fTestModel.addImport("Thread");
        buffer.append(".sleep(100);\n");
        buffer.append("\t}\n");
        buffer.append("}\n");
        buffer.append("do {\n");
        buffer.append("\ttry {\n");
        buffer.append("\t\t");
        buffer.append(DeviceKitUtilities.stripPackage("Thread"));
        this.fTestModel.addImport("Thread");
        buffer.append(".sleep(500);\n");
        buffer.append("\t} catch (InterruptedException e){\n");
        buffer.append("\t\tfail(\"InterruptedException\");\n");
        buffer.append("\t}\n");
        buffer.append("} while (playback.isStarted());\n");
        buffer.append("monitorTransport.stopMonitoring();\n");
        buffer.append("System.setOut(origOut);\n");
        buffer.append("System.setErr(origErr);\n");
        buffer.append("String recordedData = handler.getRecordedData();\n");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_FILE_INPUT_STREAM));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_FILE_INPUT_STREAM);
        buffer.append(" originalData = new ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_FILE_INPUT_STREAM));
        buffer.append("(System.getProperty(\"user.dir\") + ");
        buffer.append("RELATIVE_OUTPUT_DIR");
        buffer.append(" + ");
        buffer.append("TRANSPORT_REC_FILENAME");
        buffer.append(");\n");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_BYTE_ARRAY_INPUT_STREAM));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_BYTE_ARRAY_INPUT_STREAM);
        buffer.append(" comparisonData = new ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_BYTE_ARRAY_INPUT_STREAM));
        buffer.append("(recordedData.getBytes());\n");
        buffer.append("comparisonTest");
        buffer.append(" = new ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_XML_TRANSPORT_TESTER));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_XML_TRANSPORT_TESTER);
        buffer.append("(originalData, comparisonData);\n");
        buffer.append("failures = !");
        buffer.append("comparisonTest");
        buffer.append(".compareResultsSuccesful();\n");
        buffer.append("if (failures) {\n");
        buffer.append('\t');
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_FILE));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_FILE);
        buffer.append(" comparisonFile = new File(System.getProperty(\"user.dir\") + ");
        buffer.append("RELATIVE_OUTPUT_DIR");
        buffer.append(" + ");
        buffer.append("TRANSPORT_COMP_FILENAME");
        buffer.append(");\n");
        buffer.append("\tcomparisonFile.createNewFile();\n");
        buffer.append('\t');
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_FILE_WRITER));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_FILE_WRITER);
        buffer.append(" writer = new FileWriter(comparisonFile);\n");
        buffer.append("\twriter.write(recordedData);\n");
        buffer.append("\twriter.close();\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    protected String getSimTestName(String defaultName) {
        String className = DeviceKitUtilities.removeLastOccurence(defaultName, "Test");
        className = String.valueOf(className) + "JunitTest";
        return className;
    }

    protected String getSuperClass() {
        return DeviceKitGenerationConstants.CLASS_JUNIT_TESTCASE;
    }

    protected String getSupressConsole(String defaultSC) {
        TagElement element;
        List junit = this.getTestElement().getAllChildrenWithTagCode(49);
        if (junit.size() > 0 && (element = (TagElement)junit.get(0)).getAttribute("supressconsole") != null) {
            return element.getAttribute("supressconsole");
        }
        return defaultSC;
    }
}

