/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.util;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.soda.sat.plugin.activator.IActivatorWizardModel;
import org.eclipse.soda.sat.plugin.activator.IActivatorWizardPreferences;
import org.eclipse.soda.sat.plugin.activator.IExportedServiceDetails;
import org.eclipse.soda.sat.plugin.activator.IImportedServiceDetails;
import org.eclipse.soda.sat.plugin.activator.bundle.Activator;
import org.eclipse.soda.sat.plugin.activator.internal.ActivatorWizardModel;
import org.eclipse.soda.sat.plugin.activator.internal.ExportedServiceDetails;
import org.eclipse.soda.sat.plugin.activator.internal.ImportedServiceDetails;
import org.eclipse.soda.sat.plugin.activator.util.ITypeModel;

public class FactoryUtility {
    private static final FactoryUtility INSTANCE = new FactoryUtility();
    private IActivatorWizardPreferences preferences;

    public static FactoryUtility getInstance() {
        return INSTANCE;
    }

    private FactoryUtility() {
    }

    public IActivatorWizardModel createActivatorWizardModel(ITypeModel typeModel) {
        ActivatorWizardModel model = new ActivatorWizardModel(typeModel);
        return model;
    }

    public IExportedServiceDetails createExportedServiceDetails(IType type, IJavaProject javaProject, boolean storedInField, boolean hasProperties, boolean proxy) {
        ExportedServiceDetails details = new ExportedServiceDetails(type, javaProject, storedInField, hasProperties, proxy);
        return details;
    }

    public IImportedServiceDetails createImportedServiceDetails(IType type, IJavaProject javaProject, boolean optional) {
        ImportedServiceDetails details = new ImportedServiceDetails(type, javaProject, optional);
        return details;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IActivatorWizardPreferences getPreferences() {
        FactoryUtility factoryUtility = this;
        synchronized (factoryUtility) {
            if (this.preferences == null) {
                Activator activator = Activator.getDefault();
                IActivatorWizardPreferences preferences = activator.getPreferences();
                this.setPreferences(preferences);
            }
        }
        return this.preferences;
    }

    public void setPreferences(IActivatorWizardPreferences preferences) {
        this.preferences = preferences;
    }
}

