/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.framework;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.soda.sat.core.internal.framework.bundle.LazyBundeActivatorProperties;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.record.container.interfaces.IImportServiceRecordContainer;
import org.eclipse.soda.sat.core.record.container.interfaces.IImportServiceRecordContainerOwner;
import org.eclipse.soda.sat.core.record.interfaces.IImportServiceRecord;
import org.eclipse.soda.sat.core.util.Assertion;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.sat.core.util.MessageFormatter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public final class LazyBundleActivator
implements BundleActivator {
    private static final String STARTED_BUNDLE_KEY = "LazyBundleActivator.StartedBundle";
    private static final String STOPPED_BUNDLE_KEY = "LazyBundleActivator.StoppedBundle";
    private BundleContext bundleContext;
    private BundleActivator bundleActivator;
    private IImportServiceRecordContainer container;
    private LazyBundeActivatorProperties lazyBundleActivatorProperties;

    private void acquireImportedServices() throws InvalidSyntaxException, IOException {
        IImportServiceRecordContainer container = this.createImportServiceRecordContainer();
        this.setContainer(container);
        this.populateContainer();
        IImportServiceRecordContainerOwner owner = this.createContainerOwner();
        container.setOwner(owner);
        container.acquire();
    }

    private BundleActivator createBundleActivator() throws ClassNotFoundException, IllegalAccessException, InstantiationException, IOException {
        BundleActivator activator = null;
        Class clazz = this.getBundleActivatorClass();
        if (clazz != null) {
            activator = (BundleActivator)clazz.newInstance();
        }
        return activator;
    }

    private IImportServiceRecordContainerOwner createContainerOwner() {
        return new IImportServiceRecordContainerOwner(){

            public void acquired(IImportServiceRecordContainer container) {
                LazyBundleActivator.this.handleContainerAcquired();
            }

            public void released(IImportServiceRecordContainer container) {
                LazyBundleActivator.this.handleContainerReleased();
            }
        };
    }

    private Filter createFilter(String filterString) {
        BundleContext context = this.getBundleContext();
        Filter filter = null;
        try {
            filter = context.createFilter(filterString);
        }
        catch (InvalidSyntaxException exception) {
            String message = exception.getMessage();
            LogUtility.logError(this, message, exception);
        }
        return filter;
    }

    private Filter createFilterForService(String serviceName) {
        LazyBundeActivatorProperties properties = this.getLazyBundeActivatorProperties();
        String filterString = properties.getImportedServiceFilter(serviceName);
        if (filterString == null) {
            return null;
        }
        Filter filter = this.createFilter(filterString);
        return filter;
    }

    private IImportServiceRecord createImportServiceRecord(String name, Filter filter) {
        FactoryUtility utility = this.getFactoryUtility();
        BundleContext context = this.getBundleContext();
        IImportServiceRecord record = utility.createImportServiceRecord(context, name, filter);
        return record;
    }

    private IImportServiceRecordContainer createImportServiceRecordContainer() {
        FactoryUtility utility = this.getFactoryUtility();
        IImportServiceRecordContainer container = utility.createImportServiceRecordContainer();
        return container;
    }

    private Bundle getBundle() {
        BundleContext bundleContext = this.getBundleContext();
        Bundle bundle = null;
        try {
            bundle = bundleContext.getBundle();
        }
        catch (IllegalStateException illegalStateException) {}
        return bundle;
    }

    private BundleActivator getBundleActivator() {
        return this.bundleActivator;
    }

    private Class getBundleActivatorClass() throws ClassNotFoundException, IOException {
        Class clazz = null;
        Bundle bundle = this.getBundle();
        if (bundle != null) {
            String className = this.getBundleActivatorClassName();
            clazz = bundle.loadClass(className);
        }
        return clazz;
    }

    private String getBundleActivatorClassName() throws IOException {
        LazyBundeActivatorProperties properties = this.getLazyBundeActivatorProperties();
        String value = properties.getBundleActivator();
        return value;
    }

    private BundleContext getBundleContext() {
        return this.bundleContext;
    }

    private String getBundleSymbolicName() {
        String symbolicName = null;
        Bundle bundle = this.getBundle();
        if (bundle != null) {
            symbolicName = bundle.getSymbolicName();
        }
        return symbolicName;
    }

    private IImportServiceRecordContainer getContainer() {
        return this.container;
    }

    private FactoryUtility getFactoryUtility() {
        return FactoryUtility.getInstance();
    }

    private LazyBundeActivatorProperties getLazyBundeActivatorProperties() {
        return this.lazyBundleActivatorProperties;
    }

    private void handleContainerAcquired() {
        this.releaseImportedServices();
        try {
            BundleActivator activator = this.createBundleActivator();
            this.setBundleActivator(activator);
            this.startBundleActivator();
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    private void handleContainerReleased() {
    }

    private void handleException(Exception exception) {
        String message = exception.getMessage();
        LogUtility.logError(this, message, exception);
    }

    private void logStarted() {
        String symbolicName = this.getBundleSymbolicName();
        if (symbolicName == null) {
            return;
        }
        String pattern = Messages.getString(STARTED_BUNDLE_KEY);
        String message = MessageFormatter.format(pattern, symbolicName);
        LogUtility.logDebug(this, message);
    }

    private void logStopped() {
        String symbolicName = this.getBundleSymbolicName();
        if (symbolicName == null) {
            return;
        }
        String pattern = Messages.getString(STOPPED_BUNDLE_KEY);
        String message = MessageFormatter.format(pattern, symbolicName);
        LogUtility.logDebug(this, message);
    }

    private void populateContainer() throws IOException {
        IImportServiceRecordContainer container = this.getContainer();
        LazyBundeActivatorProperties properties = this.getLazyBundeActivatorProperties();
        List serviceNames = properties.getImportedServiceNames();
        Iterator iterator = serviceNames.iterator();
        while (iterator.hasNext()) {
            String serviceName = (String)iterator.next();
            Filter filter = this.createFilterForService(serviceName);
            IImportServiceRecord record = this.createImportServiceRecord(serviceName, filter);
            container.add(record);
        }
    }

    private void releaseImportedServices() {
        IImportServiceRecordContainer container = this.getContainer();
        container.release();
        this.setContainer(null);
    }

    private void setBundleActivator(BundleActivator bundleActivator) {
        this.bundleActivator = bundleActivator;
    }

    private void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    private void setContainer(IImportServiceRecordContainer container) {
        this.container = container;
    }

    private void setLazyBundleActivatorProperties(LazyBundeActivatorProperties lazyBundleActivatorProperties) {
        this.lazyBundleActivatorProperties = lazyBundleActivatorProperties;
    }

    public void start(BundleContext context) throws Exception {
        Assertion.checkArgumentIsNotNull(context, "context");
        this.setBundleContext(context);
        this.setLazyBundleActivatorProperties(new LazyBundeActivatorProperties(context));
        this.logStarted();
        this.acquireImportedServices();
    }

    private void startBundleActivator() throws Exception {
        BundleActivator activator = this.getBundleActivator();
        BundleContext context = this.getBundleContext();
        activator.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        this.stopBundleActivator();
        this.setLazyBundleActivatorProperties(null);
        this.setBundleContext(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void stopBundleActivator() throws Exception {
        BundleActivator activator = this.getBundleActivator();
        if (activator != null) {
            try {
                BundleContext context = this.getBundleContext();
                activator.stop(context);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.setBundleActivator(null);
                throw throwable;
            }
            {
                Object var3_5 = null;
                this.setBundleActivator(null);
            }
        }
        this.logStopped();
    }
}

