/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transport.test.bundle;

import java.util.Hashtable;
import org.eclipse.soda.dk.connection.bundle.ServiceInterestBundle;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.transport.service.TransportService;
import org.eclipse.soda.dk.transport.test.service.TransportTestService;
import org.eclipse.soda.sat.core.record.interfaces.IServiceDetecter;
import org.eclipse.soda.sat.core.record.interfaces.ServiceDetecterListener;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public abstract class TransportTestBundle
extends ServiceInterestBundle
implements BundleActivator,
ServiceDetecterListener {
    public static final String CLASS_NAME;
    protected TransportTestService testCase = null;
    protected IServiceDetecter detecter;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.transport.test.bundle.TransportTestBundle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLASS_NAME = clazz.getName();
    }

    protected void activate() {
        TransportService transport = (TransportService)this.getImportedService(this.getInterestServiceName());
        this.testCase = this.createService(transport);
        if (transport != null) {
            Hashtable properties = this.createProperties();
            String[] names = this.getExportedServiceNames();
            NotificationService notificationService = (NotificationService)this.getImportedService("org.eclipse.soda.dk.notification.service.NotificationService");
            if (notificationService != null) {
                this.testCase.setNotificationService(notificationService);
            }
            this.testCase.start();
            this.addExportedServices(names, this.testCase, properties);
        }
        super.activate();
    }

    public Hashtable createProperties() {
        Hashtable properties = super.createProperties();
        return properties;
    }

    public Object createService() {
        this.testCase = this.createService((TransportService)this.getInterest());
        return this.testCase;
    }

    public TransportTestService createService(TransportService transport) {
        return null;
    }

    protected void deactivate() {
        if (this.testCase != null) {
            this.testCase.exit();
        }
        this.testCase = null;
        super.deactivate();
    }

    public abstract String[] getExportedServiceNames();

    public abstract String getInterestServiceName();

    public void serviceAdded(IServiceDetecter detecter, ServiceReference serviceReference, Object service) {
    }

    public void serviceRemoved(IServiceDetecter detecter, ServiceReference serviceReference, Object service) {
    }

    public void setInterest(Object interest) {
        super.setInterest(interest);
        if (this.testCase != null) {
            this.testCase.setTransport((TransportService)interest);
        }
    }

    protected void start() throws Exception {
        FactoryUtility utility = FactoryUtility.getInstance();
        BundleContext context = this.getBundleContext();
        String[] serviceNames = this.getExportedServiceNames();
        if (serviceNames.length > 0) {
            String serviceName = serviceNames[0];
            this.detecter = utility.createServiceDetecter(context, serviceName);
            this.detecter.addServiceDetecterListener((ServiceDetecterListener)this);
            this.detecter.acquire();
        }
    }

    protected void stop() throws Exception {
        this.detecter.release();
        this.detecter = null;
    }
}

