/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testcontroller.remote.rmi;

import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.testcontroller.remote.rmi.ControllerRegistry;
import org.eclipse.soda.dk.testcontroller.remote.rmi.RemoteTestController;
import org.eclipse.soda.sat.core.util.LogUtility;

public class LocateController {
    public static final int CONTROLLER_NOT_FOUND = 7120;
    public static final int FAILED_TO_BIND_CONTROLLER = 7121;
    public static final int FAILED_TO_UNBIND_CONTROLLER = 7122;
    public static ResourceBundle DefaultResourceBundle;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.testcontroller.remote.rmi.LocateControllerResourceBundle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DefaultResourceBundle = Nls.getResourceBundle((Class)clazz);
    }

    public static ControllerRegistry createRegistry(int port) throws RemoteException {
        return new ControllerRegistry(port);
    }

    public static RemoteTestController getController(String host, int port) {
        RemoteTestController testController;
        String h;
        int p = port <= 0 ? 2099 : port;
        if (host == null || host.length() == 0) {
            try {
                h = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception exception) {
                h = "";
            }
        } else {
            h = host;
        }
        try {
            Socket socket = new Socket(h, p);
            ObjectInputStream in = new ObjectInputStream(socket.getInputStream());
            testController = (RemoteTestController)in.readObject();
            socket.close();
        }
        catch (Exception e) {
            Object[] parms = new Object[]{h, Integer.toString(p), e.getMessage()};
            LogUtility.logInfo((String)Nls.format((String)DefaultResourceBundle.getString(Integer.toString(7120)), (Object[])parms));
            testController = null;
        }
        return testController;
    }
}

