/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.tcpip.multiplex.connection;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.dk.multiplex.connection.MultiplexConnection;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelListener;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.multiplex.connection.service.MultiplexConnectionListener;
import org.eclipse.soda.dk.tcpip.multiplex.connection.TcpipChannelBinding;
import org.eclipse.soda.dk.tcpip.multiplex.connection.service.TcpipMultiplexConnectionService;

public class TcpipMultiplexConnection
extends MultiplexConnection
implements ConnectionService,
TcpipMultiplexConnectionService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.tcpip.multiplex.connection.TcpipMultiplexConnection";
    protected static final char[] TOSTRING_NAME = "TcpipMultiplexConnection[".toCharArray();
    protected Selector selector;
    private List connectRequests = new LinkedList();
    private List writeRequests = new LinkedList();
    private Map writeData = new HashMap();
    private Map channelBindings = Collections.synchronizedMap(new HashMap());

    public TcpipMultiplexConnection(ConfigurationService configuration) {
        super(configuration);
    }

    public TcpipMultiplexConnection(Dictionary properties) {
        this((ConfigurationService)new EscConfiguration(properties));
    }

    public TcpipMultiplexConnection(String remotehost, int remoteport, String localhost, int localport, int linger, int readsize, int writesize) throws IllegalArgumentException {
        Hashtable<String, Object> table = new Hashtable<String, Object>(23);
        if (remotehost != null && !"localhost".equals(remotehost)) {
            table.put("remotehost", remotehost);
        }
        if (remoteport != -1) {
            table.put("remoteport", TcpipMultiplexConnection.createInteger((int)remoteport));
        }
        if (localhost != null && !"0.0.0.0".equals(localhost)) {
            table.put("localhost", localhost);
        }
        if (localport != 0) {
            table.put("localport", TcpipMultiplexConnection.createInteger((int)localport));
        }
        if (linger != -1) {
            table.put("linger", TcpipMultiplexConnection.createInteger((int)linger));
        }
        if (readsize != -1) {
            table.put("readsize", TcpipMultiplexConnection.createInteger((int)readsize));
        }
        if (writesize != -1) {
            table.put("writesize", TcpipMultiplexConnection.createInteger((int)writesize));
        }
        this.setConfigurationService((ConfigurationService)new EscConfiguration(table));
    }

    protected TcpipMultiplexConnection() {
    }

    public TcpipMultiplexConnection(String targetHost, int targetPort) {
        this(targetHost, targetPort, -1);
    }

    public TcpipMultiplexConnection(String targetHost, int targetPort, int localPort) {
        this(targetHost, targetPort, localPort, -1, -1, -1);
    }

    public TcpipMultiplexConnection(String targetHost, int targetPort, int localPort, int sendBufferSize, int receiveBufferSize) {
        this(targetHost, targetPort, localPort, sendBufferSize, receiveBufferSize, 0);
    }

    public TcpipMultiplexConnection(String targetHost, int targetPort, int localPort, int sendBufferSize, int receiveBufferSize, int linger) {
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        table.put("remotehost", targetHost);
        table.put("remoteport", TcpipMultiplexConnection.createInteger((int)targetPort));
        table.put("localport", TcpipMultiplexConnection.createInteger((int)localPort));
        table.put("readsize", TcpipMultiplexConnection.createInteger((int)receiveBufferSize));
        table.put("writesize", TcpipMultiplexConnection.createInteger((int)sendBufferSize));
        table.put("linger", TcpipMultiplexConnection.createInteger((int)linger));
        this.setConfigurationService((ConfigurationService)new EscConfiguration(table));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelChanged(ChannelService channel, int newState, int oldState) {
        if (newState > 1 && oldState <= 1) {
            this.channelBindings.put(this.getSocketChannel(channel), channel);
        }
        super.channelChanged(channel, newState, oldState);
        if (newState <= 1 && oldState > 1) {
            this.channelBindings.remove(this.getSocketChannel(channel));
            List list = this.connectRequests;
            synchronized (list) {
                this.connectRequests.remove(channel);
            }
            list = this.writeRequests;
            synchronized (list) {
                Map map = this.writeData;
                synchronized (map) {
                    this.writeData.remove(channel);
                }
            }
        }
    }

    public synchronized void close() throws IOException {
        super.close();
        Exception exception = null;
        try {
            Iterator iterator = this.getChannels().values().iterator();
            while (iterator.hasNext()) {
                ChannelService channel = (ChannelService)iterator.next();
                channel.exit();
            }
            this.selector.close();
            this.selector = null;
        }
        catch (Exception e) {
            exception = e;
        }
        this.report(exception, 1002, this.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connect(TcpipChannelBinding channel) {
        List list = this.connectRequests;
        synchronized (list) {
            this.connectRequests.add(channel);
            this.selector.wakeup();
        }
    }

    protected TcpipChannelBinding createChannel(String channelId) {
        TcpipChannelBinding channel = new TcpipChannelBinding(channelId);
        channel.setListener((ChannelListener)this);
        return channel;
    }

    public void errorOccurred(Object source, Object timestamp, Object data) {
    }

    private ChannelService getChannel(Channel socketChannel) {
        return (ChannelService)this.channelBindings.get(socketChannel);
    }

    private SocketChannel getSocketChannel(ChannelService channel) {
        return ((TcpipChannelBinding)channel).getSocketChannel();
    }

    private void initSelector() throws IOException {
        this.selector = SelectorProvider.provider().openSelector();
    }

    public synchronized void open() throws IOException {
        if (this.selector == null) {
            this.initSelector();
        }
        super.open();
        int targetPortNumber = this.getInt("remoteport", -1);
        if (targetPortNumber != -1) {
            String targetAddress = this.getString("remotehost", this.getString("host", "localhost"));
            String localAddress = this.getString("localhost", "0.0.0.0");
            int localPortNumber = this.getInt("localport", 0);
            this.openChannel(this.createChannelId(), targetAddress, targetPortNumber, localAddress, localPortNumber);
        }
    }

    public ChannelService openChannel(Map parameters) throws IOException {
        EscConfiguration config = new EscConfiguration(new Hashtable(parameters));
        String targetAddress = config.getString("remotehost", this.getString("host", "localhost"));
        int targetPortNumber = config.getInt("remoteport", -1);
        String localAddress = config.getString("localhost", "0.0.0.0");
        int localPortNumber = config.getInt("localport", 0);
        return this.openChannel(this.createChannelId(), targetAddress, targetPortNumber, localAddress, localPortNumber);
    }

    protected ChannelService openChannel(String channelId, String targetAddress, int targetPortNumber, String localAddress, int localPortNumber) throws IOException {
        TcpipChannelBinding channel = this.createChannel(channelId);
        channel.setRemoteAddress(new InetSocketAddress(targetAddress, targetPortNumber));
        channel.setLocalAddress(new InetSocketAddress(localAddress, localPortNumber));
        channel.open();
        return channel;
    }

    protected void processAccept(MultiplexConnectionListener listener, SelectionKey key) throws IOException {
    }

    private void processConnect(MultiplexConnectionListener listener, SelectionKey key) {
        SocketChannel socketChannel = (SocketChannel)key.channel();
        ChannelService channel = this.getChannel(socketChannel);
        channel.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvents() throws Exception {
        Iterator iterator;
        List list = this.writeRequests;
        synchronized (list) {
            iterator = this.writeRequests.iterator();
            while (iterator.hasNext()) {
                SocketChannel socketChannel = (SocketChannel)iterator.next();
                SelectionKey key = socketChannel.keyFor(this.selector);
                if (key == null || !key.isValid()) continue;
                key.interestOps(4);
            }
            this.writeRequests.clear();
        }
        if (this.selector != null) {
            this.selector.select();
            list = this.connectRequests;
            synchronized (list) {
                iterator = this.connectRequests.iterator();
                while (iterator.hasNext()) {
                    TcpipChannelBinding channel = (TcpipChannelBinding)((Object)iterator.next());
                    try {
                        SocketChannel socketChannel = channel.getSocketChannel();
                        socketChannel.register(this.selector, 8);
                        socketChannel.socket().bind(channel.getLocalAddress());
                        socketChannel.connect(channel.getRemoteAddress());
                    }
                    catch (Exception e) {
                        this.handleError(e, 1015, (Object)channel);
                        channel.exit();
                    }
                }
                this.connectRequests.clear();
            }
            MultiplexConnectionListener listener = this.getConnectionListener();
            Iterator<SelectionKey> selectedKeys = this.selector.selectedKeys().iterator();
            while (selectedKeys.hasNext()) {
                SelectionKey key = selectedKeys.next();
                selectedKeys.remove();
                if (!key.isValid()) continue;
                if (key.isConnectable()) {
                    this.processConnect(listener, key);
                    continue;
                }
                if (key.isWritable()) {
                    this.processWrite(key);
                    continue;
                }
                if (key.isReadable()) {
                    ChannelService channel = this.getChannel(key.channel());
                    listener.processInput(channel);
                    continue;
                }
                if (!key.isAcceptable()) continue;
                this.processAccept(listener, key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWrite(SelectionKey key) {
        SocketChannel socketChannel = (SocketChannel)key.channel();
        Map map = this.writeData;
        synchronized (map) {
            List buffers;
            block8: {
                buffers = (List)this.writeData.get(socketChannel);
                try {
                    if (buffers == null) break block8;
                    while (!buffers.isEmpty()) {
                        ByteBuffer buf = (ByteBuffer)buffers.get(0);
                        socketChannel.write(buf);
                        if (buf.remaining() <= 0) {
                            buffers.remove(0);
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    this.handleError(e, 1015, socketChannel);
                    buffers.clear();
                }
            }
            if (buffers == null || buffers.isEmpty()) {
                key.interestOps(1);
            }
        }
    }

    public int read(ChannelService channel, byte[] bytes, int offset, int length) throws IOException {
        SocketChannel socketChannel = this.getSocketChannel(channel);
        int count = -1;
        if (socketChannel != null && socketChannel.isOpen()) {
            ByteBuffer readBuffer = ByteBuffer.wrap(bytes, offset, length);
            try {
                count = socketChannel.read(readBuffer);
            }
            catch (IOException e) {
                this.handleError(e, 1015, channel);
            }
            if (count == -1) {
                SelectionKey key = socketChannel.keyFor(this.selector);
                key.cancel();
                if (channel.isReconnectable()) {
                    channel.close();
                } else {
                    channel.exit();
                }
                return -1;
            }
        }
        return count;
    }

    public void toStringInfo(StringBuffer buffer) {
        super.toStringInfo(buffer);
        buffer.append(',');
        buffer.append(this.getString("remotehost", this.getString("host", "localhost")));
        buffer.append(':');
        buffer.append(this.getInt("remoteport", -1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelService channel, byte[] bytes, int offset, int count) throws IOException {
        if (channel != null && channel.getState() > 3) {
            SocketChannel socketChannel = this.getSocketChannel(channel);
            List list = this.writeRequests;
            synchronized (list) {
                if (this.selector != null && socketChannel != null) {
                    this.writeRequests.add(socketChannel);
                    Map map = this.writeData;
                    synchronized (map) {
                        ArrayList<ByteBuffer> buffers = (ArrayList<ByteBuffer>)this.writeData.get(socketChannel);
                        if (buffers == null) {
                            buffers = new ArrayList<ByteBuffer>();
                            this.writeData.put(socketChannel, buffers);
                        }
                        buffers.add(ByteBuffer.wrap(bytes, offset, count));
                    }
                    this.selector.wakeup();
                }
            }
        }
    }
}

