/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.ssl.connection;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.soda.dk.connection.StreamConnection;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.dk.nls.Os;
import org.eclipse.soda.dk.ssl.connection.service.SslConnectionService;

public class SslConnection
extends StreamConnection
implements ConnectionService,
SslConnectionService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.ssl.connection.SslConnection";
    private Socket port = null;

    public SslConnection(ConfigurationService configuration) {
        super(configuration);
    }

    public SslConnection(Dictionary properties) {
        this((ConfigurationService)new EscConfiguration(properties));
    }

    public SslConnection(String localhost, int localport, String remotehost, int remoteport, int readtimeout, int readsize, int writesize, int linger) throws IllegalArgumentException {
        Hashtable<String, Object> table = new Hashtable<String, Object>(23);
        if (localhost != null && !"0.0.0.0".equals(localhost)) {
            table.put("localhost", localhost);
        }
        if (localport != -1) {
            table.put("localport", SslConnection.createInteger((int)localport));
        }
        if (remotehost != null && !"localhost".equals(remotehost)) {
            table.put("remotehost", remotehost);
        }
        if (remoteport != 23) {
            table.put("remoteport", SslConnection.createInteger((int)remoteport));
        }
        if (readtimeout != 1000) {
            table.put("readtimeout", SslConnection.createInteger((int)readtimeout));
        }
        if (readsize != -1) {
            table.put("readsize", SslConnection.createInteger((int)readsize));
        }
        if (writesize != -1) {
            table.put("writesize", SslConnection.createInteger((int)writesize));
        }
        if (linger != -1) {
            table.put("linger", SslConnection.createInteger((int)linger));
        }
        this.setConfigurationService((ConfigurationService)new EscConfiguration(table));
    }

    public SslConnection(Socket port) {
        this.port = port;
    }

    public SslConnection(String targetHost, int targetPort) {
        this(targetHost, targetPort, -1);
    }

    public SslConnection(String targetHost, int targetPort, int localPort) {
        this(targetHost, targetPort, localPort, 100);
    }

    public SslConnection(String targetHost, int targetPort, int localPort, int timeout) {
        this(targetHost, targetPort, localPort, timeout, -1, -1, -1);
    }

    public SslConnection(String targetHost, int targetPort, int localPort, int timeout, int sendBufferSize, int receiveBufferSize) {
        this(targetHost, targetPort, localPort, timeout, sendBufferSize, receiveBufferSize, 0);
    }

    public SslConnection(String targetHost, int targetPort, int localPort, int timeout, int sendBufferSize, int receiveBufferSize, int linger) {
        Hashtable<String, Object> table = new Hashtable<String, Object>(17);
        table.put("remotehost", targetHost);
        table.put("remoteport", SslConnection.createInteger((int)targetPort));
        table.put("readtimeout", SslConnection.createInteger((int)timeout));
        table.put("localport", SslConnection.createInteger((int)localPort));
        table.put("readsize", SslConnection.createInteger((int)receiveBufferSize));
        table.put("writesize", SslConnection.createInteger((int)sendBufferSize));
        table.put("linger", SslConnection.createInteger((int)linger));
        this.setConfigurationService((ConfigurationService)new EscConfiguration(table));
    }

    public synchronized void close() throws IOException {
        super.close();
        if (this.port != null) {
            Exception exception = null;
            try {
                this.port.close();
            }
            catch (Exception e) {
                exception = e;
            }
            this.port = null;
            this.handleError(exception, 1002, this.toString());
        }
    }

    public void exit() throws IOException {
        try {
            this.close();
        }
        catch (Exception exception) {}
        this.port = null;
    }

    public Socket getPort() {
        return this.port;
    }

    public boolean isOpen() {
        return this.port != null;
    }

    public synchronized void open() throws IOException {
        if (this.port == null) {
            String targetAddress = this.getString("remotehost", "localhost");
            int targetPortNumber = this.getInt("remoteport", 23);
            int localPortNumber = this.getInt("localport", -1);
            int timeout = this.getInt("readtimeout", 1000);
            int receiveBufferSize = this.getInt("readsize", -1);
            int sendBufferSize = this.getInt("writesize", -1);
            int linger = this.getInt("linger", -1);
            if (localPortNumber >= 0) {
                InetAddress localAddress = InetAddress.getLocalHost();
                this.port = SSLSocketFactory.getDefault().createSocket(targetAddress, targetPortNumber, localAddress, localPortNumber);
            } else {
                this.port = SSLSocketFactory.getDefault().createSocket(targetAddress, targetPortNumber);
            }
            this.port.setTcpNoDelay(true);
            if (timeout >= 0) {
                this.port.setSoTimeout(timeout);
            }
            if (linger >= 0) {
                if (linger == 0) {
                    this.port.setSoLinger(false, 0);
                } else {
                    this.port.setSoLinger(true, linger);
                }
            }
            if (receiveBufferSize > 0 && !Os.isNeutrino()) {
                this.port.setReceiveBufferSize(receiveBufferSize);
            }
            if (sendBufferSize > 0 && !Os.isNeutrino()) {
                this.port.setSendBufferSize(sendBufferSize);
            }
            this.setInputStream(this.port.getInputStream());
            this.setOutputStream(this.port.getOutputStream());
            super.open();
        }
    }

    public int read(byte[] bytes, int offset, int length) throws IOException {
        return 0;
    }

    public void setPort(Socket port) {
        this.port = port;
    }

    public void toStringInfo(StringBuffer buffer) {
        super.toStringInfo(buffer);
        buffer.append(',');
        if (this.port == null) {
            buffer.append(this.getString("remotehost", "localhost"));
            buffer.append(':');
            buffer.append(this.getInt("remoteport", 23));
        } else {
            buffer.append(this.port);
        }
    }

    public void write(byte[] bytes, int offset, int count) throws IOException {
    }
}

