/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.rfid.inventory.benchmark.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.soda.dk.device.servlet.DeviceServlet;
import org.eclipse.soda.dk.device.servlet.DeviceServletContext;
import org.eclipse.soda.dk.rfid.inventory.benchmark.servlet.RfidInventoryBenchmarkServletConsole;
import org.eclipse.soda.dk.rfid.inventory.benchmark.servlet.RfidInventoryBenchmarkServletContext;

public class RfidInventoryBenchmarkServlet
extends DeviceServlet {
    private static final long serialVersionUID = 1L;
    private static final String DURATION_KEY = "duration";
    private static final String CYCLES_KEY = "cycles";
    private static final String DELAY_KEY = "delay";
    private static final String ENABLE_KEY = "Enable";
    private static final String DISABLE_KEY = "Disable";
    private static final String SAVE_KEY = "Save";
    private static final String REPORTFILENAME_KEY = "reportfilename";
    private static final String NOTE_KEY = "note";
    private static final String ACTION_KEY = "action";
    private static final String START_KEY = "start";
    private static final String STOP_KEY = "stop";
    private static final String CLEAN_KEY = "clean";
    private static final String READER = "reader";
    private static final String SERIALNUM = "serialnum";
    private static final String SERVLET_ALIAS = "/device/benchmark";
    private static final String EMPTY_REQUEST = "";
    private static final String BENCHMARK_REPORT = "benchmark_report";
    private static final String BENCHMARK_REPORT_URL = "/device/benchmark/benchmark_report";
    private static final String BENCHMARK_DETAIL = "benchmark_detail";
    private static final int DEFAULT_REPORT_REFRESH_RATE = 5000;
    private RfidInventoryBenchmarkServletConsole console;
    private int duration = 4000;
    private int cycles = 1;
    private long delay = 0L;
    private String reportFileName = "";
    private String detailReportFileName = "";

    public DeviceServletContext createContext(HttpServletRequest request, HttpServletResponse response) {
        RfidInventoryBenchmarkServletContext context = new RfidInventoryBenchmarkServletContext(request, response, this.getServletAlias());
        return context;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DeviceServletContext context = this.createContext(request, response);
        String subRequest = this.extractRequest(request.getRequestURI());
        if (subRequest.equals(EMPTY_REQUEST)) {
            this.setup(context);
            context.begin();
            String action = request.getParameter(ACTION_KEY);
            boolean benchmark_report_anchor_printed = false;
            if (action != null) {
                if (action.equals(START_KEY)) {
                    String cyclesStr = request.getParameter(CYCLES_KEY);
                    String durationStr = request.getParameter(DURATION_KEY);
                    String delayStr = request.getParameter(DELAY_KEY);
                    if (cyclesStr != null) {
                        this.cycles = Integer.parseInt(cyclesStr);
                    }
                    if (durationStr != null) {
                        this.duration = Integer.parseInt(durationStr);
                    }
                    if (delayStr != null) {
                        this.delay = Long.parseLong(delayStr);
                    }
                    this.getConsole().startBenchmarkRuns(this.cycles, this.duration, this.delay);
                    if ((long)this.duration + this.delay > 0L) {
                        this.printReportAnchor(context, BENCHMARK_REPORT, BENCHMARK_REPORT_URL, (long)this.duration + this.delay);
                        benchmark_report_anchor_printed = true;
                    }
                } else if (action.equals(STOP_KEY)) {
                    this.getConsole().stopBenchmarkRuns();
                } else if (action.equals(CLEAN_KEY)) {
                    this.getConsole().clearBenchmarkReports();
                } else if (this.getConsole().containsPrefix(action)) {
                    String prefix = action;
                    this.getConsole().setCurrentPrefix(prefix);
                } else if (action.equals(ENABLE_KEY)) {
                    this.getConsole().changeBenchmarkState(true);
                } else if (action.equals(DISABLE_KEY)) {
                    this.getConsole().changeBenchmarkState(false);
                } else if (action.equals(SAVE_KEY)) {
                    this.reportFileName = request.getParameter(REPORTFILENAME_KEY);
                    String note = request.getParameter(NOTE_KEY);
                    this.getConsole().saveToFile(this.reportFileName, note, this.createContext(request, response));
                }
            }
            if (!benchmark_report_anchor_printed) {
                this.printReportAnchor(context, BENCHMARK_REPORT, BENCHMARK_REPORT_URL, 5000L);
                benchmark_report_anchor_printed = true;
            }
            context.addEntity("reportfilename_key", (Object)REPORTFILENAME_KEY);
            context.addEntity(REPORTFILENAME_KEY, (Object)this.reportFileName);
            context.addEntity("Button", (Object)SAVE_KEY);
            context.template("report_save");
            this.printBenchmarkTestForm(context);
            context.end();
            return;
        }
        if (subRequest.equals(BENCHMARK_REPORT)) {
            context.setupResponse(response);
            this.getConsole().getBenchmarkReport_ajax(context);
            return;
        }
        if (subRequest.equals(BENCHMARK_DETAIL)) {
            String reader = request.getParameter(READER);
            String serialNum = request.getParameter(SERIALNUM);
            if (reader != null && serialNum != null) {
                context.setupResponse(response);
                context.begin();
                this.getConsole().displayDetailReport(context, reader, Integer.valueOf(serialNum));
                context.addEntity("Reader", (Object)reader);
                context.addEntity(SERIALNUM, (Object)serialNum);
                context.addEntity("reportfilename_key", (Object)REPORTFILENAME_KEY);
                context.addEntity(REPORTFILENAME_KEY, (Object)this.detailReportFileName);
                context.addEntity("Button", (Object)SAVE_KEY);
                context.template("detail_save");
                String action = request.getParameter(ACTION_KEY);
                if (SAVE_KEY.equals(action)) {
                    this.detailReportFileName = request.getParameter(REPORTFILENAME_KEY);
                    String note = request.getParameter(NOTE_KEY);
                    this.getConsole().saveDetailToFile(reader, Integer.parseInt(serialNum), this.detailReportFileName, note, this.createContext(request, response));
                }
            }
        }
    }

    private String extractRequest(String uri) {
        if (uri.length() == SERVLET_ALIAS.length()) {
            return EMPTY_REQUEST;
        }
        String request = uri.substring(SERVLET_ALIAS.length() + 1);
        return request;
    }

    public RfidInventoryBenchmarkServletConsole getConsole() {
        return this.console;
    }

    public String getServletAlias() {
        return SERVLET_ALIAS;
    }

    public void printBenchmarkTestForm(DeviceServletContext context) {
        context.addEntity("ObjectName", (Object)"Benchmark Test");
        context.template("benchmark_form_begin");
        context.addEntity("Value4cycles", (Object)new Integer(this.cycles));
        context.addEntity("Message4cycles", (Object)CYCLES_KEY);
        context.addEntity("Value4duration", (Object)new Integer(this.duration));
        context.addEntity("Message4duration", (Object)DURATION_KEY);
        context.addEntity("Value4delay", (Object)new Long(this.delay));
        context.addEntity("Message4delay", (Object)DELAY_KEY);
        context.template("benchmark_form_entry");
        context.addEntity("Start", (Object)START_KEY);
        context.addEntity("Stop", (Object)STOP_KEY);
        context.template("benchmark_form_end");
    }

    private void printReportAnchor(DeviceServletContext context, String reportName, String reportURL, long refreshRate) {
        this.getConsole().displayReaderList(context);
        boolean benchmarkState = this.getConsole().getBenchmarkState();
        context.addEntity("Status", (Object)(benchmarkState ? "Enabled" : "Disabled"));
        context.addEntity("Button", (Object)(benchmarkState ? DISABLE_KEY : ENABLE_KEY));
        context.template("benchmark_state");
        context.addEntity("DivId", (Object)reportName);
        context.addEntity("requestURL", (Object)reportURL);
        context.addEntity("RefreshRate", (Object)String.valueOf(refreshRate));
        context.template("ajax_function");
        context.addEntity("DivId", (Object)reportName);
        context.template("ajax_anchor");
        context.addEntity("Button", (Object)CLEAN_KEY);
        context.template("report_clean");
    }

    public void setConsole(RfidInventoryBenchmarkServletConsole console) {
        this.console = console;
    }
}

