/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.notification;

import java.util.Dictionary;
import org.eclipse.soda.dk.core.ConfigurableObject;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.notification.service.NotificationExtensionService;

public class NotificationExtensions
extends EscObject
implements NotificationExtensionService {
    private NotificationExtensionService[] objects;

    public NotificationExtensions(NotificationExtensionService currentObject, NotificationExtensionService newObject) {
        if (currentObject instanceof NotificationExtensions) {
            NotificationExtensions currentMulticaster = (NotificationExtensions)currentObject;
            NotificationExtensionService[] oldList = currentMulticaster.getObjects();
            this.objects = new NotificationExtensionService[oldList.length + 1];
            System.arraycopy(oldList, 0, this.objects, 0, oldList.length);
            this.objects[oldList.length] = newObject;
        } else {
            this.objects = new NotificationExtensionService[2];
            this.objects[0] = currentObject;
            this.objects[1] = newObject;
        }
    }

    public NotificationExtensions(NotificationExtensionService[] objects) {
        this.setObjects(objects);
    }

    public static NotificationExtensionService add(NotificationExtensionService currentObject, NotificationExtensionService newObject) {
        if (currentObject == null) {
            return newObject;
        }
        if (newObject == null) {
            return currentObject;
        }
        return new NotificationExtensions(currentObject, newObject);
    }

    public static NotificationExtensionService remove(NotificationExtensionService currentObject, NotificationExtensionService removeObject) {
        if (currentObject == removeObject) {
            return null;
        }
        if (currentObject instanceof NotificationExtensions) {
            return ((NotificationExtensions)currentObject).remove(removeObject);
        }
        return currentObject;
    }

    public NotificationExtensionService[] getObjects() {
        return this.objects;
    }

    public int receiving(String topic, Dictionary data) {
        int length = this.objects.length;
        int i = 0;
        while (i < length) {
            try {
                this.objects[i].receiving(topic, data);
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
            ++i;
        }
        return 0;
    }

    protected NotificationExtensionService remove(NotificationExtensionService removeHandler) {
        NotificationExtensionService[] oldList = this.getObjects();
        switch (oldList.length) {
            case 0: {
                return null;
            }
            case 1: {
                if (oldList[0] != removeHandler) break;
                return null;
            }
            case 2: {
                if (oldList[1] == removeHandler) {
                    return oldList[0];
                }
                if (oldList[0] != removeHandler) break;
                return oldList[1];
            }
            default: {
                int index = oldList.length - 1;
                while (index >= 0) {
                    if (oldList[index] == removeHandler) {
                        NotificationExtensionService[] newList = new NotificationExtensionService[oldList.length - 1];
                        if (index == oldList.length - 1) {
                            System.arraycopy(oldList, 0, newList, 0, newList.length);
                        } else {
                            if (index > 0) {
                                System.arraycopy(oldList, 0, newList, 0, index);
                            }
                            System.arraycopy(oldList, index + 1, newList, index, newList.length - index);
                        }
                        return new NotificationExtensions(newList);
                    }
                    --index;
                }
                break block0;
            }
        }
        return this;
    }

    public int sending(String topic, Dictionary data) {
        int length = this.objects.length;
        int i = 0;
        while (i < length) {
            try {
                this.objects[i].sending(topic, data);
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
            ++i;
        }
        return 0;
    }

    public void setConfigurationInformation(Dictionary dictionary) {
        int length = this.objects.length;
        int i = 0;
        while (i < length) {
            try {
                NotificationExtensionService extensionService = this.objects[i];
                if (extensionService instanceof ConfigurableObject) {
                    ConfigurableObject configurableObject = (ConfigurableObject)extensionService;
                    configurableObject.setConfigurationInformation(dictionary);
                }
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
            ++i;
        }
    }

    private void setObjects(NotificationExtensionService[] objects) {
        this.objects = objects;
    }
}

