/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.notification.testcase;

import java.util.Dictionary;
import java.util.Hashtable;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.notification.Notification;
import org.eclipse.soda.dk.notification.NotificationBase;
import org.eclipse.soda.dk.notification.NotificationDataExtension;
import org.eclipse.soda.dk.notification.NotificationQueue;
import org.eclipse.soda.dk.notification.service.NotificationExtendableService;
import org.eclipse.soda.dk.notification.service.NotificationExtensionService;
import org.eclipse.soda.dk.notification.service.NotificationListener;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.notification.testcase.NotificationDelayTestListener;
import org.eclipse.soda.dk.notification.testcase.NotificationTestListener;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class NotificationTestcase
extends TestCase
implements NotificationListener,
BundleActivator {
    static /* synthetic */ Class class$0;

    public static void main(String[] arguments) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.notification.testcase.NotificationTestcase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
        System.exit(0);
    }

    public void notificationReceived(String topic, Dictionary data) {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("notificationReceived ");
        buffer.append(topic);
        buffer.append('=');
        buffer.append(data);
        System.out.println(buffer.toString());
    }

    public void start(BundleContext context) throws Exception {
        NotificationTestcase test = new NotificationTestcase();
        test.test1();
        test.test2();
        test.test3();
        test.test4();
        test.test5();
    }

    public void stop(BundleContext context) throws Exception {
    }

    public void test1() {
        System.out.println("start test1");
        NotificationQueue queue = new NotificationQueue(1);
        int i = 0;
        while (i < 10) {
            Hashtable<String, Integer> data = new Hashtable<String, Integer>();
            data.put("test", new Integer(i));
            queue.broadcast("externalkey/" + i, data);
            ++i;
        }
        i = 0;
        while (i < 10) {
            Object[] element = queue.dequeue(1L);
            StringBuffer buffer = new StringBuffer(256);
            buffer.append("dequeue ");
            buffer.append(element[0]);
            buffer.append('=');
            buffer.append(element[1]);
            System.out.println(buffer.toString());
            ++i;
        }
    }

    public void test2() {
        System.out.println("start test2");
        NotificationService miniBroker = Notification.getBroker();
        miniBroker.register(new String[]{"externalkey/0", "externalkey/9"}, (NotificationListener)this);
        miniBroker.register(new String[]{"#"}, (NotificationListener)this);
        NotificationTestListener listener = new NotificationTestListener();
        miniBroker.register(new String[]{"externalkey/0", "externalkey/9"}, (NotificationListener)listener);
        int i = 0;
        while (i < 10) {
            Hashtable<String, Integer> data = new Hashtable<String, Integer>();
            data.put("test", new Integer(i));
            miniBroker.broadcast("externalkey/" + i, data);
            ++i;
        }
        try {
            Thread.sleep(100L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        miniBroker.unregister((NotificationListener)this);
        if (miniBroker instanceof Notification) {
            Notification notification = (Notification)miniBroker;
            notification.exit();
        }
    }

    public void test3() {
        Hashtable<String, Integer> data;
        System.out.println("start test3");
        NotificationService miniBroker = Notification.getBroker();
        miniBroker.register(new String[]{"#/0", "#/middle/1"}, (NotificationListener)this);
        int i = 0;
        while (i < 3) {
            data = new Hashtable<String, Integer>();
            data.put("test", new Integer(i));
            miniBroker.broadcast("key/" + i, data);
            miniBroker.broadcast("key/middle/" + i, data);
            ++i;
        }
        try {
            Thread.sleep(200L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        miniBroker.unregister((NotificationListener)this);
        System.out.println("Should not see anything");
        i = 0;
        while (i < 3) {
            data = new Hashtable();
            data.put("test", new Integer(i));
            miniBroker.broadcast("key/" + i, data);
            miniBroker.broadcast("key/middle/" + i, data);
            ++i;
        }
        if (miniBroker instanceof Notification) {
            Notification notification = (Notification)miniBroker;
            notification.exit();
        }
    }

    public void test4() {
        System.out.println("start test4");
        NotificationService miniBroker = Notification.getBroker();
        miniBroker.register(new String[]{"key/#"}, (NotificationListener)this);
        int i = 0;
        while (i < 1000) {
            Hashtable<String, Integer> data = new Hashtable<String, Integer>();
            data.put("test", new Integer(i));
            miniBroker.broadcast("key/" + i, data);
            miniBroker.broadcast("key/middle/" + i, data);
            ++i;
        }
        try {
            Thread.sleep(200L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        miniBroker.unregister((NotificationListener)this);
        if (miniBroker instanceof Notification) {
            Notification notification = (Notification)miniBroker;
            notification.exit();
        }
    }

    public void test5() {
        System.out.println("start test5");
        String[] keys = new String[]{"a", "b"};
        String[] newKeys = Notification.getExternalKeys((String)"prefix", (String[])keys);
        int i = 0;
        while (i < keys.length) {
            System.out.println(newKeys[i]);
            ++i;
        }
    }

    public void test6() {
        int level = 0;
        while (level <= 3) {
            System.out.println("start test6 level " + level);
            NotificationBase.setBroadcastThresholdDefault((long)1L);
            NotificationBase.setNotifyThresholdDefault((long)0L);
            NotificationService miniBroker = Notification.getBroker();
            if (miniBroker instanceof NotificationBase) {
                NotificationBase notification = (NotificationBase)miniBroker;
                notification.setLevel(level);
            }
            if (miniBroker instanceof NotificationExtendableService) {
                NotificationExtendableService notificationExtendable = (NotificationExtendableService)miniBroker;
                NotificationDataExtension notificationExtension = new NotificationDataExtension();
                notificationExtendable.setNotificationExtension((NotificationExtensionService)notificationExtension);
            }
            NotificationDelayTestListener listener = new NotificationDelayTestListener();
            miniBroker.register(new String[]{"externalkey/0", "externalkey/9"}, (NotificationListener)listener);
            int i = 0;
            while (i < 10) {
                Hashtable<String, Integer> data = new Hashtable<String, Integer>();
                data.put("test", new Integer(i));
                miniBroker.broadcast("externalkey/" + i, data);
                ++i;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            miniBroker.unregister((NotificationListener)this);
            if (miniBroker instanceof Notification) {
                Notification notification = (Notification)miniBroker;
                notification.exit();
            }
            System.out.println("stop test6 level " + level);
            ++level;
        }
    }

    public void test7() {
        NotificationBase.setBroadcastThresholdDefault((long)-1L);
        NotificationBase.setNotifyThresholdDefault((long)-1L);
        int level = 0;
        while (level <= 10) {
            System.out.println("start test7 level " + level);
            NotificationService miniBroker = Notification.getBroker();
            if (miniBroker instanceof Notification) {
                Notification notification = (Notification)miniBroker;
                notification.setLevel(level);
            }
            if (miniBroker instanceof NotificationExtendableService) {
                NotificationExtendableService notificationExtendable = (NotificationExtendableService)miniBroker;
                NotificationDataExtension notificationExtension = new NotificationDataExtension();
                notificationExtendable.setNotificationExtension((NotificationExtensionService)notificationExtension);
            }
            NotificationDelayTestListener listener = new NotificationDelayTestListener();
            miniBroker.register(new String[]{"externalkey/0", "externalkey/9"}, (NotificationListener)listener);
            int i = 0;
            while (i < 10) {
                Hashtable<String, Integer> data = new Hashtable<String, Integer>();
                data.put("test", new Integer(i));
                miniBroker.broadcast("externalkey/" + i, data);
                ++i;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            miniBroker.unregister((NotificationListener)this);
            if (miniBroker instanceof Notification) {
                Notification notification = (Notification)miniBroker;
                notification.exit();
            }
            System.out.println("stop test7 level " + level);
            ++level;
        }
    }
}

