/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.multicast.transport;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.MulticastSocket;
import org.eclipse.soda.dk.multicast.transport.service.MulticastTransportService;
import org.eclipse.soda.dk.transport.service.TransportService;
import org.eclipse.soda.dk.udp.transport.UdpTransport;

public class MulticastTransport
extends UdpTransport
implements TransportService,
MulticastTransportService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.multicast.transport.MulticastTransport";
    public static final String DEFAULT_LOCAL_HOST = "experiment.mcast.net";
    public static final int DEFAULT_LOCAL_PORT_NUM = 2000;
    public static final String DEFAULT_REMOTE_HOST = "experiment.mcast.net";
    public static final int DEFAULT_SIZE = 1024;
    public static final int DEFAULT_TIMEOUT = 1000;
    private byte ttl = 1;
    private String localhost;
    private int localport;
    private int packetsize;
    private String remotehost;
    private int remoteport;

    public MulticastTransport() {
    }

    public MulticastTransport(String remoteHostString, int remotePortNum, String localHostString, int localPortNum, int packetSize, int readTimeout) {
        super(remoteHostString, remotePortNum, localHostString, localPortNum, packetSize, readTimeout);
    }

    protected synchronized DatagramSocket createSocket() throws IOException {
        MulticastSocket socket = new MulticastSocket(this.localPortNum);
        socket.joinGroup(this.remoteHostAddress);
        if (this.ttl != 0) {
            socket.setTimeToLive(this.ttl);
        }
        return socket;
    }

    public String getLocalhost() {
        return this.localhost;
    }

    public int getLocalport() {
        return this.localport;
    }

    public int getPacketsize() {
        return this.packetsize;
    }

    public String getRemotehost() {
        return this.remotehost;
    }

    public int getRemoteport() {
        return this.remoteport;
    }

    public void setLocalhost(String localhost) {
        this.localhost = localhost;
    }

    public void setLocalport(int localport) {
        this.localport = localport;
    }

    public void setPacketsize(int packetsize) {
        this.packetsize = packetsize;
    }

    public void setRemotehost(String remotehost) {
        this.remotehost = remotehost;
    }

    public void setRemoteport(int remoteport) {
        this.remoteport = remoteport;
    }

    public void setup() {
        super.setup();
        this.setRemotehost(this.getString("multicasttransport.remotehost", this.getRemotehost()));
        this.setRemoteport(this.getInt("multicasttransport.remoteport", this.getRemoteport()));
        this.setLocalhost(this.getString("multicasttransport.localhost", this.getLocalhost()));
        this.setLocalport(this.getInt("multicasttransport.localport", this.getLocalport()));
        this.setPacketsize(this.getInt("multicasttransport.packetsize", this.getPacketsize()));
        this.setRetryTime(this.getLong("multicasttransport.retrytime", this.getRetryTime()));
        this.setPriority(this.getInt("multicasttransport.priority", this.getPriority()));
        this.setNotificationPriority(this.getInt("multicasttransport.notificationpriority", this.getNotificationPriority()));
        this.setTransmitRetries(this.getInt("multicasttransport.transmitretries", this.getTransmitRetries()));
        this.setNoActivityTimeout(this.getLong("multicasttransport.noactivitytimeout", this.getNoActivityTimeout()));
    }
}

