/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.matrix.lcd.simulator.view;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import org.eclipse.soda.dk.matrix.lcd.simulator.view.AbstractPanelWithBackground;
import org.eclipse.soda.dk.matrix.lcd.simulator.view.ButtonWithBackground;
import org.eclipse.soda.dk.matrix.lcd.simulator.view.LcdDisplayPanel;
import org.eclipse.soda.dk.matrix.lcd.simulator.view.PowerButton;
import org.eclipse.soda.dk.matrix.lcd.simulator.view.interfaces.SimulatorPanelConstants;
import org.eclipse.soda.dk.matrix.lcd.simulator.view.interfaces.SimulatorPanelListener;

public class SimulatorPanel
extends AbstractPanelWithBackground
implements SimulatorPanelConstants,
MouseListener {
    private static final long serialVersionUID = 6659529690771602491L;
    private ButtonWithBackground upButton;
    private ButtonWithBackground downButton;
    private ButtonWithBackground leftButton;
    private ButtonWithBackground rightButton;
    private ButtonWithBackground f1Button;
    private ButtonWithBackground f2Button;
    private ButtonWithBackground enterButton;
    private PowerButton powerButton;
    private LcdDisplayPanel lcdDisplayPanel;
    private SimulatorPanelListener listener;

    public SimulatorPanel() {
        this.setSize(758, 183);
        this.populate();
        this.initialize();
    }

    protected ButtonWithBackground generateButton(String upSrc, String dnSrc, int width, int height, int xpos, int ypos) {
        ButtonWithBackground button = new ButtonWithBackground(upSrc, dnSrc);
        button.setSize(width, height);
        button.setLocation(xpos, ypos);
        button.addMouseListener(this);
        return button;
    }

    public ButtonWithBackground getDownButton() {
        return this.downButton;
    }

    public ButtonWithBackground getEnterButton() {
        return this.enterButton;
    }

    public ButtonWithBackground getF1Button() {
        return this.f1Button;
    }

    public ButtonWithBackground getF2Button() {
        return this.f2Button;
    }

    public LcdDisplayPanel getLcdDisplayPanel() {
        return this.lcdDisplayPanel;
    }

    public ButtonWithBackground getLeftButton() {
        return this.leftButton;
    }

    public PowerButton getPowerButton() {
        return this.powerButton;
    }

    public ButtonWithBackground getRightButton() {
        return this.rightButton;
    }

    public ButtonWithBackground getUpButton() {
        return this.upButton;
    }

    protected void initialize() {
        this.setCurrentImage(this.loadImage(BG_IMAGE_SRC));
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.listener != null) {
            this.listener.mouseClicked(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    protected void populate() {
        this.setLayout(null);
        this.setUpButton(this.generateButton(UP_UP_SRC, UP_DOWN_SRC, 40, 40, 57, 10));
        this.add(this.getUpButton());
        this.setDownButton(this.generateButton(DOWN_UP_SRC, DOWN_DOWN_SRC, 40, 40, 57, 97));
        this.add(this.getDownButton());
        this.setLeftButton(this.generateButton(LEFT_UP_SRC, LEFT_DOWN_SRC, 40, 40, 13, 54));
        this.add(this.getLeftButton());
        this.setRightButton(this.generateButton(RIGHT_UP_SRC, RIGHT_DOWN_SRC, 40, 40, 101, 54));
        this.add(this.getRightButton());
        LcdDisplayPanel disp = new LcdDisplayPanel();
        disp.setSize(353, 70);
        disp.setLocation(161, 39);
        this.setLcdDisplayPanel(disp);
        this.add(disp);
        this.setEnterButton(this.generateButton(ENTER_UP_SRC, ENTER_DOWN_SRC, 40, 40, 536, 8));
        this.add(this.getEnterButton());
        this.setF1Button(this.generateButton(F1_UP_SRC, F1_DOWN_SRC, 40, 40, 536, 103));
        this.add(this.getF1Button());
        this.setF2Button(this.generateButton(F2_UP_SRC, F2_DOWN_SRC, 40, 40, 536, 56));
        this.add(this.getF2Button());
        PowerButton but = new PowerButton(POWER_UNLIT_SRC, POWER_UNLIT_DOWN_SRC, POWER_LIT_SRC, POWER_LIT_DOWN_SRC);
        but.setSize(106, 109);
        but.setLocation(615, 19);
        this.setPowerButton(but);
        but.addMouseListener(this);
        this.add(but);
    }

    public void setDownButton(ButtonWithBackground background) {
        this.downButton = background;
    }

    public void setEnterButton(ButtonWithBackground background) {
        this.enterButton = background;
    }

    public void setF1Button(ButtonWithBackground background) {
        this.f1Button = background;
    }

    public void setF2Button(ButtonWithBackground background) {
        this.f2Button = background;
    }

    public void setLcdDisplayPanel(LcdDisplayPanel panel) {
        this.lcdDisplayPanel = panel;
    }

    public void setLeftButton(ButtonWithBackground background) {
        this.leftButton = background;
    }

    public void setPowerButton(PowerButton button) {
        this.powerButton = button;
    }

    public void setRightButton(ButtonWithBackground background) {
        this.rightButton = background;
    }

    public void setSimulatorPanelListener(SimulatorPanelListener listener) {
        this.listener = listener;
    }

    public void setUpButton(ButtonWithBackground background) {
        this.upButton = background;
    }
}

