/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.gps.nmea.simulator;

import java.util.Calendar;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.data.Degree;
import org.eclipse.soda.dk.data.LatitudeData;
import org.eclipse.soda.dk.data.LongitudeData;
import org.eclipse.soda.dk.message.AsciiMessage;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.tcpip.server.connection.TcpipServerConnection;
import org.eclipse.soda.dk.tcpip.server.connection.service.TcpipServerConnectionService;
import org.eclipse.soda.dk.transport.ConnectionTransport;
import org.eclipse.soda.dk.transport.service.TransportService;

public class GpsNmeaSimulator
extends ConnectionTransport
implements TransportService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.gps.nmea.transport.GpsNmeaTransport";
    public static final byte[] HEX_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    public static void main(String[] arguments) {
        GpsNmeaSimulator gpsNmeaSimulator = new GpsNmeaSimulator();
        gpsNmeaSimulator.start();
        try {
            Thread.sleep(600000L);
        }
        catch (InterruptedException exception) {
            exception.printStackTrace();
        }
    }

    public ConnectionService getDefaultConnection() {
        return this.getDefaultTcpipServerConnection();
    }

    public TcpipServerConnectionService getDefaultTcpipServerConnection() {
        return new TcpipServerConnection(this.getInt("gpsnmeasimulator.remoteport", 8901));
    }

    public LatitudeData getLatitude(String nmeaString) {
        try {
            int lenght = nmeaString.length();
            String data = nmeaString.substring(0, lenght - 1);
            int value = Degree.parseNmeaDegree((String)data);
            if (nmeaString.endsWith("S")) {
                value = -value;
            }
            return new LatitudeData(value);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public LongitudeData getLongitude(String nmeaString) {
        try {
            int lenght = nmeaString.length();
            String data = nmeaString.substring(0, lenght - 1);
            int value = Degree.parseNmeaDegree((String)data);
            if (nmeaString.endsWith("W")) {
                value = -value;
            }
            return new LongitudeData(value);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public void processInput() throws Exception {
        LatitudeData latitudeData = this.getLatitude("3547.426N");
        LongitudeData longitudeData = this.getLongitude("07842.076W");
        Float latitudeDelta = new Float(0.01);
        Float longitudeDelta = new Float(0.01);
        while (this.isRunning()) {
            long timenow = System.currentTimeMillis();
            long delay = 1000L - timenow % 1000L;
            if (delay > 10L) {
                this.sleep(delay);
            }
            StringBuffer buffer = new StringBuffer(100);
            Calendar calendar = Calendar.getInstance();
            int hour = calendar.get(11);
            int minute = calendar.get(12);
            int second = calendar.get(13);
            buffer.append("$GPGGA,");
            String hourString = Integer.toString(hour);
            String minuteString = Integer.toString(minute);
            String secondString = Integer.toString(second);
            buffer.append(hourString);
            if (minuteString.length() == 1) {
                buffer.append('0');
            }
            buffer.append(minuteString);
            if (secondString.length() == 1) {
                buffer.append('0');
            }
            buffer.append(secondString);
            buffer.append(".0,");
            buffer.append(latitudeData.toNmeaString());
            buffer.append(',');
            buffer.append(longitudeData.toNmeaString());
            buffer.append(",1,4,1.94,00141,M,-033,M,,");
            AsciiMessage message = new AsciiMessage(buffer.toString());
            this.write((MessageService)message);
            longitudeData.add((Number)longitudeDelta);
            latitudeData = new LatitudeData((int)(((Number)latitudeDelta).doubleValue() * 1000.0) + latitudeData.getThousandSeconds());
            longitudeData = new LongitudeData((int)(((Number)longitudeDelta).doubleValue() * 1000.0) + longitudeData.getThousandSeconds());
        }
    }

    public int processInput(byte[] bytes, int length) throws Exception {
        return length;
    }

    public void setup() {
        super.setup();
        this.setRetryTime(this.getLong("gpsnmeatransport.retrytime", this.getRetryTime()));
        this.setNoActivityTimeout(this.getLong("gpsnmeatransport.noactivitytimeout", this.getNoActivityTimeout()));
    }

    protected void write(MessageService message) throws Exception {
        byte[] obytes = message.getBytes();
        int length = obytes.length;
        byte[] mbytes = new byte[length + 5];
        int index = 0;
        int checksum = 36;
        index = 0;
        while (index < length) {
            mbytes[index] = obytes[index];
            checksum ^= mbytes[index];
            ++index;
        }
        mbytes[index++] = 42;
        mbytes[index++] = HEX_TABLE[(checksum &= 0xFF) >> 4];
        mbytes[index++] = HEX_TABLE[checksum & 0xF];
        mbytes[index++] = 13;
        mbytes[index++] = 10;
        this.write(mbytes);
    }
}

