/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.gps.nmea.device;

import java.util.HashMap;
import org.eclipse.soda.dk.device.TransportDevice;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.gps.nmea.device.messages.GpsNmeaDeviceMessages;
import org.eclipse.soda.dk.gps.nmea.device.service.GpsNmeaDeviceService;
import org.eclipse.soda.dk.gps.nmea.transport.service.GpsNmeaTransportService;
import org.eclipse.soda.dk.interest.InterestMask;
import org.eclipse.soda.dk.interest.service.InterestService;
import org.eclipse.soda.dk.measurement.SignalMeasurement;
import org.eclipse.soda.dk.message.Messages;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.FieldParameter;
import org.eclipse.soda.dk.parameter.service.ParameterService;
import org.eclipse.soda.dk.signal.DataSignal;
import org.eclipse.soda.dk.signal.ParameterSignal;
import org.eclipse.soda.dk.signal.service.SignalService;
import org.eclipse.soda.dk.transport.service.TransportService;

public class GpsNmeaDevice
extends TransportDevice
implements DeviceService,
GpsNmeaDeviceService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.gps.nmea.device.GpsNmeaDevice";
    private final InterestService interest = new InterestMask(new byte[]{36, 71, 80, 66, 68, 64}, new byte[]{-1, -1, -1, -30, -28, -16});
    private final DataSignal gPGLL = new DataSignal("GPGLL", GpsNmeaDeviceMessages.getGPGLLMessage());
    private final DataSignal gPRMC = new DataSignal("GPRMC", GpsNmeaDeviceMessages.getGPRMCMessage());
    private final DataSignal gPGGA = new DataSignal("GPGGA", GpsNmeaDeviceMessages.getGPGGAMessage());
    private final DataSignal gPVTG = new DataSignal("GPVTG", GpsNmeaDeviceMessages.getGPVTGMessage());
    private final DataSignal gPZDA = new DataSignal("GPZDA", GpsNmeaDeviceMessages.getGPZDAMessage());
    private final ParameterSignal timeReport = new ParameterSignal("TimeReport", (MessageService)new Messages(new MessageService[]{GpsNmeaDeviceMessages.getGPRMCMessage(), GpsNmeaDeviceMessages.getGPGGAMessage()}), null, (ParameterService)new FieldParameter("Time", null, "Time", 96));
    private final SignalMeasurement time = new SignalMeasurement("Time", new HashMap(), null, null, (SignalService)this.timeReport);
    private final ParameterSignal statusReport = new ParameterSignal("StatusReport", GpsNmeaDeviceMessages.getGPRMCMessage(), null, (ParameterService)new FieldParameter("Status", null, "Status"));
    private final SignalMeasurement status = new SignalMeasurement("Status", new HashMap(), null, null, (SignalService)this.statusReport);
    private final ParameterSignal latitudeReport = new ParameterSignal("LatitudeReport", (MessageService)new Messages(new MessageService[]{GpsNmeaDeviceMessages.getGPRMCMessage(), GpsNmeaDeviceMessages.getGPGGAMessage(), GpsNmeaDeviceMessages.getGPGLLMessage()}), null, (ParameterService)new FieldParameter("Latitude", null, "Latitude"));
    private final ParameterSignal positionReport = new ParameterSignal("PositionReport", (MessageService)new Messages(new MessageService[]{GpsNmeaDeviceMessages.getGPRMCMessage(), GpsNmeaDeviceMessages.getGPGGAMessage(), GpsNmeaDeviceMessages.getGPGLLMessage()}), null, (ParameterService)new FieldParameter("Position", null, "Position"));
    private final SignalMeasurement position = new SignalMeasurement("Position", new HashMap(), null, null, (SignalService)this.positionReport);
    private final SignalMeasurement latitude = new SignalMeasurement("Latitude", new HashMap(), null, null, (SignalService)this.latitudeReport);
    private final ParameterSignal longitudeReport = new ParameterSignal("LongitudeReport", (MessageService)new Messages(new MessageService[]{GpsNmeaDeviceMessages.getGPRMCMessage(), GpsNmeaDeviceMessages.getGPGGAMessage(), GpsNmeaDeviceMessages.getGPGLLMessage()}), null, (ParameterService)new FieldParameter("Longitude", null, "Longitude"));
    private final SignalMeasurement longitude = new SignalMeasurement("Longitude", new HashMap(), null, null, (SignalService)this.longitudeReport);
    private final ParameterSignal speedKnotsReport = new ParameterSignal("SpeedKnotsReport", (MessageService)new Messages(new MessageService[]{GpsNmeaDeviceMessages.getGPRMCMessage(), GpsNmeaDeviceMessages.getGPVTGMessage()}), null, (ParameterService)new FieldParameter("SpeedKnots", null, "SpeedKnots", 96));
    private final SignalMeasurement speedKnots = new SignalMeasurement("SpeedKnots", new HashMap(), null, null, (SignalService)this.speedKnotsReport);
    private final ParameterSignal speedKPHReport = new ParameterSignal("SpeedKPHReport", GpsNmeaDeviceMessages.getGPVTGMessage(), null, (ParameterService)new FieldParameter("SpeedKPH", null, "SpeedKPH", 96));
    private final SignalMeasurement speedKPH = new SignalMeasurement("SpeedKPH", new HashMap(), null, null, (SignalService)this.speedKPHReport);
    private final ParameterSignal trackReport = new ParameterSignal("TrackReport", (MessageService)new Messages(new MessageService[]{GpsNmeaDeviceMessages.getGPRMCMessage(), GpsNmeaDeviceMessages.getGPVTGMessage()}), null, (ParameterService)new FieldParameter("Track", null, "Track", 96));
    private final SignalMeasurement track = new SignalMeasurement("Track", new HashMap(), null, null, (SignalService)this.trackReport);
    private final ParameterSignal trackMagneticReport = new ParameterSignal("TrackMagneticReport", GpsNmeaDeviceMessages.getGPVTGMessage(), null, (ParameterService)new FieldParameter("TrackMagnetic", null, "TrackMagnetic", 96));
    private final SignalMeasurement trackMagnetic = new SignalMeasurement("TrackMagnetic", new HashMap(), null, null, (SignalService)this.trackMagneticReport);
    private final ParameterSignal altitudeReport = new ParameterSignal("AltitudeReport", GpsNmeaDeviceMessages.getGPGGAMessage(), null, (ParameterService)new FieldParameter("Altitude", null, "Altitude"));
    private final SignalMeasurement altitude = new SignalMeasurement("Altitude", new HashMap(), null, null, (SignalService)this.altitudeReport);
    private final ParameterSignal qualityReport = new ParameterSignal("QualityReport", GpsNmeaDeviceMessages.getGPGGAMessage(), null, (ParameterService)new FieldParameter("Quality", null, "Quality"));
    private final SignalMeasurement quality = new SignalMeasurement("Quality", new HashMap(), null, null, (SignalService)this.qualityReport);
    private final ParameterSignal numberSatellitesReport = new ParameterSignal("NumberSatellitesReport", GpsNmeaDeviceMessages.getGPGGAMessage(), null, (ParameterService)new FieldParameter("NumberSatellites", null, "NumberSatellites"));
    private final SignalMeasurement numberSatellites = new SignalMeasurement("NumberSatellites", new HashMap(), null, null, (SignalService)this.numberSatellitesReport);
    private final ParameterSignal dateReport = new ParameterSignal("DateReport", GpsNmeaDeviceMessages.getGPRMCMessage(), null, (ParameterService)new FieldParameter("Date", null, "Date"));
    private final SignalMeasurement date = new SignalMeasurement("Date", new HashMap(), null, null, (SignalService)this.dateReport);
    private final ParameterSignal horizontalDilutionOfPrecisionReport = new ParameterSignal("HorizontalDilutionOfPrecisionReport", GpsNmeaDeviceMessages.getGPGGAMessage(), null, (ParameterService)new FieldParameter("HorizontalDilutionOfPrecision", null, "HorizontalDilutionOfPrecision"));
    private final SignalMeasurement horizontalDilutionOfPrecision = new SignalMeasurement("HorizontalDilutionOfPrecision", new HashMap(), null, null, (SignalService)this.horizontalDilutionOfPrecisionReport);

    public GpsNmeaDevice() {
        super("Device/Capabilities", "Status", "Device/Configuration", "Device/Metrics");
        this.setKey(this.getDefaultKey());
        this.initialize();
    }

    public InterestService getInterest() {
        return this.interest;
    }

    public String getDefaultKey() {
        return "GpsNmeaDevice";
    }

    public TransportService getDefaultTransport() {
        return (GpsNmeaTransportService)GpsNmeaDevice.loadService((String)TransportService.SERVICE_NAME, (String)"org.eclipse.soda.dk.gps.nmea.transport.GpsNmeaTransport");
    }

    public int getControlCapacity() {
        return 47;
    }

    public int getMessageCapacity() {
        return 41;
    }

    public Object getMessageKey(MessageService message) {
        byte[] bytes = message.getBytes();
        if (bytes.length >= 6 && (bytes[5] & 0xF0) == 64 && (bytes[4] & 0xE4) == 68 && (bytes[3] & 0xE2) == 66 && bytes[2] == 80 && bytes[1] == 71 && bytes[0] == 36) {
            return GpsNmeaDevice.createInteger((int)(bytes[3] & 0x1D ^ (bytes[4] & 0x1B) << 5 ^ (bytes[5] & 0xF) << 10));
        }
        return null;
    }

    private void initialize() {
        DataSignal gPGLL = this.gPGLL;
        this.put((ControlService)gPGLL);
        DataSignal gPRMC = this.gPRMC;
        this.put((ControlService)gPRMC);
        DataSignal gPGGA = this.gPGGA;
        this.put((ControlService)gPGGA);
        DataSignal gPVTG = this.gPVTG;
        this.put((ControlService)gPVTG);
        DataSignal gPZDA = this.gPZDA;
        this.put((ControlService)gPZDA);
        ParameterSignal timeReport = this.timeReport;
        this.put((ControlService)timeReport);
        SignalMeasurement time = this.time;
        this.put((ControlService)time);
        ParameterSignal statusReport = this.statusReport;
        this.put((ControlService)statusReport);
        SignalMeasurement status = this.status;
        this.put((ControlService)status);
        ParameterSignal latitudeReport = this.latitudeReport;
        this.put((ControlService)latitudeReport);
        ParameterSignal positionReport = this.positionReport;
        this.put((ControlService)positionReport);
        SignalMeasurement position = this.position;
        this.put((ControlService)position);
        SignalMeasurement latitude = this.latitude;
        this.put((ControlService)latitude);
        ParameterSignal longitudeReport = this.longitudeReport;
        this.put((ControlService)longitudeReport);
        SignalMeasurement longitude = this.longitude;
        this.put((ControlService)longitude);
        ParameterSignal speedKnotsReport = this.speedKnotsReport;
        this.put((ControlService)speedKnotsReport);
        SignalMeasurement speedKnots = this.speedKnots;
        this.put((ControlService)speedKnots);
        ParameterSignal speedKPHReport = this.speedKPHReport;
        this.put((ControlService)speedKPHReport);
        SignalMeasurement speedKPH = this.speedKPH;
        this.put((ControlService)speedKPH);
        ParameterSignal trackReport = this.trackReport;
        this.put((ControlService)trackReport);
        SignalMeasurement track = this.track;
        this.put((ControlService)track);
        ParameterSignal trackMagneticReport = this.trackMagneticReport;
        this.put((ControlService)trackMagneticReport);
        SignalMeasurement trackMagnetic = this.trackMagnetic;
        this.put((ControlService)trackMagnetic);
        ParameterSignal altitudeReport = this.altitudeReport;
        this.put((ControlService)altitudeReport);
        SignalMeasurement altitude = this.altitude;
        this.put((ControlService)altitude);
        ParameterSignal qualityReport = this.qualityReport;
        this.put((ControlService)qualityReport);
        SignalMeasurement quality = this.quality;
        this.put((ControlService)quality);
        ParameterSignal numberSatellitesReport = this.numberSatellitesReport;
        this.put((ControlService)numberSatellitesReport);
        SignalMeasurement numberSatellites = this.numberSatellites;
        this.put((ControlService)numberSatellites);
        ParameterSignal dateReport = this.dateReport;
        this.put((ControlService)dateReport);
        SignalMeasurement date = this.date;
        this.put((ControlService)date);
        ParameterSignal horizontalDilutionOfPrecisionReport = this.horizontalDilutionOfPrecisionReport;
        this.put((ControlService)horizontalDilutionOfPrecisionReport);
        SignalMeasurement horizontalDilutionOfPrecision = this.horizontalDilutionOfPrecision;
        this.put((ControlService)horizontalDilutionOfPrecision);
    }

    public void setup() {
        super.setup();
        this.setNotificationPriority(this.getInt("gpsnmeadevice.notificationpriority", this.getNotificationPriority()));
    }
}

