/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.generic.barcode.reader.profile;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.generic.adapter.service.GenericBarcodeListener;
import org.eclipse.soda.dk.generic.adapter.service.GenericBarcodeListenerService;
import org.eclipse.soda.dk.generic.adapter.service.GenericBarcodeService;
import org.eclipse.soda.dk.generic.barcode.reader.profile.service.GenericBarcodeReaderProfileService;
import org.eclipse.soda.dk.profile.service.ProfileService;
import org.eclipse.soda.dk.rfid.inventory.profile.RfidInventoryProfile;

public class GenericBarcodeReaderProfile
extends RfidInventoryProfile
implements ProfileService,
GenericBarcodeReaderProfileService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.generic.barcode.reader.profile.GenericBarcodeReaderProfile";
    private GenericBarcodeListener barcodeListener = new GenericBarcodeListener(){

        public void receiveBarcodeEvent(String barcode, Map barcodeData) {
            GenericBarcodeReaderProfile.this.handleBarcodeEvent(barcode, barcodeData);
        }
    };
    private GenericBarcodeService adapter;

    public GenericBarcodeReaderProfile() {
        this.setKey(this.getDefaultKey());
        this.initialize();
    }

    public void activate() {
        super.activate();
        GenericBarcodeListenerService adapter = (GenericBarcodeListenerService)this.getBarcodeAdapterService();
        if (adapter != null) {
            adapter.setBarcodeListener(this.barcodeListener);
        }
    }

    protected boolean autonomousModeOff() {
        if (this.adapter != null) {
            return this.adapter.turnOffBarcode();
        }
        return false;
    }

    protected boolean autonomousModeOn() {
        if (this.adapter != null) {
            return this.adapter.turnOnBarcode();
        }
        return false;
    }

    public GenericBarcodeService getBarcodeAdapterService() {
        return this.adapter;
    }

    public DeviceService getDefaultDevice() {
        return null;
    }

    public String getDefaultKey() {
        return "GenericBarcodeReaderProfile";
    }

    protected void handleBarcodeEvent(String barcode, Map barcodeData) {
        this.log(4, "Receive barcode: " + barcode);
        Hashtable<String, Map> tagReportMap = new Hashtable<String, Map>();
        Map readData = barcodeData != null ? barcodeData : new Hashtable();
        tagReportMap.put(barcode, readData);
        this.notifyTagRead(tagReportMap, GenericBarcodeReaderProfile.getCurrentTimestamp());
    }

    private void initialize() {
    }

    public boolean isAdapterNeeded() {
        return true;
    }

    public boolean isDeviceNeeded() {
        return false;
    }

    public void setBarcodeAdapterService(GenericBarcodeService adapter) {
        this.adapter = adapter;
    }

    public void setup() {
        super.setup();
        this.setNotificationPriority(this.getInt("genericbarcodereaderprofile.notificationpriority", this.getNotificationPriority()));
    }

    protected byte[] strToBytes(String str) {
        if (str == null) {
            return null;
        }
        return str.getBytes();
    }
}

