/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.soda.dk.core.EscObject;

public class LLRPUtils {
    public static String byteArray2Str(byte[] bytes) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            String oneByte = Integer.toHexString(bytes[i] & 0xFF);
            if (oneByte.length() == 1) {
                result.append("0");
            }
            result.append(oneByte);
            ++i;
        }
        return result.toString();
    }

    public static byte[] convertIntListToBytes(List intList) {
        if (intList != null) {
            byte[] readDataBytes = new byte[intList.size() * 2];
            int k = 0;
            while (k < intList.size()) {
                short value = ((Integer)intList.get(k)).shortValue();
                readDataBytes[2 * k] = EscObject.createInteger((int)(value >> 8 & 0xFF)).byteValue();
                readDataBytes[2 * k + 1] = EscObject.createInteger((int)(value & 0xFF)).byteValue();
                ++k;
            }
            return readDataBytes;
        }
        return null;
    }

    public static String displayByteArray(byte[] bytes) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            result.append(Integer.toHexString(bytes[i] & 0xFF));
            result.append(",");
            ++i;
        }
        return result.toString();
    }

    public static Number extractAntennaId(Map antennaIdParam) {
        if (antennaIdParam != null) {
            return (Number)antennaIdParam.get("AntennaID");
        }
        return null;
    }

    public static int extractROSpecStartTrigger(Map rOSpecParameter) {
        Number rOSpecStartTriggerType;
        Map rOSpecStartTriggerParameter;
        Map rOBoundarySpecParameter;
        if (rOSpecParameter != null && (rOBoundarySpecParameter = (Map)rOSpecParameter.get("ROBoundarySpecParameter")) != null && (rOSpecStartTriggerParameter = (Map)rOBoundarySpecParameter.get("ROSpecStartTriggerParameter")) != null && (rOSpecStartTriggerType = (Number)rOSpecStartTriggerParameter.get("ROSpecStartTriggerType")) != null) {
            return rOSpecStartTriggerType.intValue();
        }
        return -1;
    }

    public static int extractROSpecStopTrigger(Map rOSpecParameter) {
        Number rOSpecStopTriggerType;
        Map rOSpecStopTriggerParameter;
        Map rOBoundarySpecParameter;
        if (rOSpecParameter != null && (rOBoundarySpecParameter = (Map)rOSpecParameter.get("ROBoundarySpecParameter")) != null && (rOSpecStopTriggerParameter = (Map)rOBoundarySpecParameter.get("ROSpecStopTriggerParameter")) != null && (rOSpecStopTriggerType = (Number)rOSpecStopTriggerParameter.get("ROSpecStopTriggerType")) != null) {
            return rOSpecStopTriggerType.intValue();
        }
        return -1;
    }

    public static String extractTag(Map EPCParameterChoice) {
        if (EPCParameterChoice != null) {
            String tagType = (String)EPCParameterChoice.get("key");
            String tagKey = "";
            if ("EPCDataParameter".equals(tagType)) {
                tagKey = "EPCData_EPC";
            } else if ("EPC_96Parameter".equals(tagType)) {
                tagKey = "EPC_96_EPC";
            }
            byte[] param_EPC = (byte[])EPCParameterChoice.get(tagKey);
            if (param_EPC == null) {
                return null;
            }
            StringBuffer tag = new StringBuffer();
            int j = 0;
            while (j < param_EPC.length) {
                int n = 0;
                while (n < 2) {
                    int nibble = param_EPC[j] >> 4 * (1 - n) & 0xF;
                    char ch = (char)(nibble < 10 ? 48 + nibble : 65 + (nibble - 10));
                    tag.append(ch);
                    ++n;
                }
                ++j;
            }
            return tag.toString();
        }
        return null;
    }

    public static Number extractTagSeenCount(Map tagSeenCountParam) {
        if (tagSeenCountParam != null) {
            return (Number)tagSeenCountParam.get("TagCount");
        }
        return null;
    }

    public static int getAccessOpResultCode(Map resultMap) {
        String key = (String)resultMap.get("key");
        if ("C1G2ReadOpSpecResultParameter".equals(key)) {
            return ((Number)resultMap.get("C1G2ReadOpSpecResult_Result")).intValue();
        }
        if ("C1G2WriteOpSpecResultParameter".equals(key)) {
            return ((Number)resultMap.get("C1G2WriteOpSpecResult_Result")).intValue();
        }
        if ("C1G2KillOpSpecResultParameter".equals(key)) {
            return ((Number)resultMap.get("C1G2KillOpSpecResult_Result")).intValue();
        }
        if ("C1G2LockOpSpecResultParameter".equals(key)) {
            return ((Number)resultMap.get("C1G2LockOpSpecResult_Result")).intValue();
        }
        if ("C1G2BlockEraseOpSpecResultParameter".equals(key)) {
            return ((Number)resultMap.get("C1G2BlockEraseOpSpecResult_Result")).intValue();
        }
        if ("C1G2BlockWriteOpSpecResultParameter".equals(key)) {
            return ((Number)resultMap.get("C1G2BlockWriteOpSpecResult_Result")).intValue();
        }
        return 0;
    }

    public static String handleErrorResponse(String sourceTask, Map paramMap) {
        if (paramMap == null) {
            return "Task Error: " + sourceTask;
        }
        Map LLRPStatusParam = (Map)paramMap.get("LLRPStatusParameter");
        if (LLRPStatusParam == null) {
            return "";
        }
        Integer statusCode = (Integer)LLRPStatusParam.get("StatusCode");
        String errorDesc = (String)LLRPStatusParam.get("ErrorDescription");
        errorDesc = errorDesc != null && errorDesc.length() > 0 ? "," + errorDesc : "";
        return "Error Occurred In " + sourceTask + ": code=" + statusCode + errorDesc;
    }

    public static String hexStrIncrement(String str, int inc) {
        if (str == null) {
            return null;
        }
        char[] baseStr = str.toCharArray();
        byte[] baseBits = new byte[baseStr.length];
        int i = 0;
        while (i < baseStr.length) {
            baseBits[i] = Integer.valueOf(String.valueOf(baseStr[i]), 16).byteValue();
            ++i;
        }
        char[] incStr = Integer.toHexString(inc).toCharArray();
        int extra = 0;
        int i2 = 1;
        while (i2 <= baseBits.length) {
            if (i2 > incStr.length && extra == 0) break;
            char incChar = i2 <= incStr.length ? incStr[incStr.length - i2] : (char)'0';
            int incBit = Integer.valueOf(String.valueOf(incChar), 16);
            int addition = baseBits[baseBits.length - i2] + incBit + extra;
            char[] resultBits = Integer.toHexString(addition).toCharArray();
            switch (resultBits.length) {
                case 1: {
                    baseStr[baseStr.length - i2] = resultBits[0];
                    extra = 0;
                    break;
                }
                case 2: {
                    baseStr[baseStr.length - i2] = resultBits[1];
                    extra = Integer.valueOf(String.valueOf(resultBits[0]), 16);
                }
            }
            ++i2;
        }
        return new String(baseStr);
    }

    public static boolean isValidTagId(String tagId) {
        try {
            char[] tagIdChars = tagId.toCharArray();
            int i = 0;
            while (i < tagIdChars.length) {
                Integer.valueOf(String.valueOf(tagIdChars[i]), 16);
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static void main(String[] arguments) {
        String epc = "300833B2DDD9058035050005";
        System.out.println("epc: " + epc);
        byte[] epcbytes = LLRPUtils.str2byteArray(epc);
        System.out.println("epcbytes2: " + LLRPUtils.displayByteArray(epcbytes));
        String epc2 = LLRPUtils.byteArray2Str(epcbytes);
        System.out.println("epc2: " + epc2);
        byte[] epcbytes2 = LLRPUtils.str2byteArray(epc2);
        System.out.println("epcbytes2: " + LLRPUtils.displayByteArray(epcbytes2));
    }

    public static byte[] str2byteArray(String str) {
        char[] strChars = str.toCharArray();
        ArrayList<String> byteStrs = new ArrayList<String>();
        int i = 0;
        while (i < strChars.length) {
            StringBuffer byteStr = new StringBuffer();
            byteStr.append(strChars[i++]);
            if (i < strChars.length && strChars[i] != ',') {
                byteStr.append(strChars[i]);
                if (i + 1 < strChars.length && strChars[i + 1] == ',') {
                    ++i;
                }
            }
            byteStrs.add(byteStr.toString());
            ++i;
        }
        byte[] bytes = new byte[byteStrs.size()];
        int i2 = 0;
        while (i2 < byteStrs.size()) {
            String byteStr = (String)byteStrs.get(i2);
            bytes[i2] = Integer.valueOf(byteStr, 16).byteValue();
            ++i2;
        }
        return bytes;
    }

    public static List str2wordList(String str) {
        Vector<Integer> result = new Vector<Integer>();
        int i = 0;
        while (i < str.length() / 4) {
            String wordStr = str.substring(4 * i, 4 * (i + 1));
            result.add(Integer.valueOf(wordStr, 16));
            ++i;
        }
        return result;
    }
}

