/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.helper.task;

import java.util.Map;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.AbstractTask;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITask;
import org.eclipse.soda.dk.signal.service.SignalService;

public abstract class AbstractLLRPTask
extends AbstractTask {
    private CommandService command;
    private Map parameters;
    private SignalService signal;
    private int errorCode;
    private Map errorFields;
    private long timeoutValue;

    protected AbstractLLRPTask(CommandService command, Map parameters, SignalService signal) {
        this(command, parameters, signal, 0L);
    }

    protected AbstractLLRPTask(CommandService command, Map parameters, SignalService signal, long timeoutValue) {
        this.command = command;
        this.parameters = parameters;
        this.signal = signal;
        this.timeoutValue = timeoutValue;
    }

    public CommandService getCommand() {
        return this.command;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public Map getErrorFields() {
        return this.errorFields;
    }

    public Map getParameters() {
        return this.parameters;
    }

    public SignalService getSignal() {
        return this.signal;
    }

    public boolean isResponseExpected(SignalService source, Object timestamp, Object data) {
        return this.signal == source;
    }

    protected abstract boolean isSameTaskType(ITask var1);

    public synchronized boolean launchTask() {
        if (this.command != null) {
            this.startTimer(this.timeoutValue);
            if (this.parameters != null) {
                this.command.execute((Object)this.parameters);
            } else {
                this.command.execute();
            }
            this.setState(1);
            return true;
        }
        return false;
    }

    protected boolean matchResponse(Object data) {
        return this.signal == data;
    }

    public void setCommand(CommandService command) {
        this.command = command;
    }

    public void setParameters(Map parameters) {
        this.parameters = parameters;
    }

    public void setSignal(SignalService signal) {
        this.signal = signal;
    }

    protected boolean successInLLRPStatus(Map data) {
        if (data == null) {
            return false;
        }
        Map LLRPStatusParam = (Map)data.get("LLRPStatusParameter");
        if (LLRPStatusParam == null) {
            return false;
        }
        Number statusCode = (Number)LLRPStatusParam.get("StatusCode");
        if (statusCode != null) {
            if (statusCode.intValue() == 0) {
                this.errorCode = 0;
                return true;
            }
            this.errorCode = statusCode.intValue();
            this.errorFields = data;
            this.notifyListener(this.getTaskName(), 0, data);
        }
        return false;
    }
}

