/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.device;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.soda.dk.command.SimpleDataCommand;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.device.TransportDevice;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.epcglobal.llrp.device.messages.EpcglobalLlrpDeviceMessages;
import org.eclipse.soda.dk.epcglobal.llrp.device.service.EpcglobalLlrpDeviceService;
import org.eclipse.soda.dk.interest.InterestMask;
import org.eclipse.soda.dk.interest.service.InterestService;
import org.eclipse.soda.dk.measurement.CommandMeasurement;
import org.eclipse.soda.dk.measurement.MeasurementFieldMeasurement;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.signal.DataSignal;
import org.eclipse.soda.dk.signal.SignalFieldSignal;
import org.eclipse.soda.dk.signal.service.SignalService;
import org.eclipse.soda.dk.transport.service.TransportService;

public class EpcglobalLlrpDevice
extends TransportDevice
implements DeviceService,
EpcglobalLlrpDeviceService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.epcglobal.llrp.device.EpcglobalLlrpDevice";
    private final InterestService interest = new InterestMask(new byte[]{4}, new byte[]{-4});
    private final SimpleDataCommand customMessageRequest = new SimpleDataCommand("CustomMessageRequest", EpcglobalLlrpDeviceMessages.getCustomMessageMessage());
    private final DataSignal customMessageReport = new DataSignal("CustomMessageReport", EpcglobalLlrpDeviceMessages.getCustomMessageMessage());
    private final SimpleDataCommand getReaderCapabilities = new SimpleDataCommand("GetReaderCapabilities", EpcglobalLlrpDeviceMessages.getGetReaderCapabilitiesMessage());
    private final SimpleDataCommand getReaderCapabilities_All = new SimpleDataCommand("GetReaderCapabilities_All", EpcglobalLlrpDeviceMessages.getGetReaderCapabilities_AllMessage());
    private final SimpleDataCommand getReaderCapabilities_GeneralDeviceCapabilities = new SimpleDataCommand("GetReaderCapabilities_GeneralDeviceCapabilities", EpcglobalLlrpDeviceMessages.getGetReaderCapabilities_GeneralDeviceCapabilitiesMessage());
    private final SimpleDataCommand getReaderCapabilities_LLRPCapabilities = new SimpleDataCommand("GetReaderCapabilities_LLRPCapabilities", EpcglobalLlrpDeviceMessages.getGetReaderCapabilities_LLRPCapabilitiesMessage());
    private final SimpleDataCommand getReaderCapabilities_RegulatoryCapabilities = new SimpleDataCommand("GetReaderCapabilities_RegulatoryCapabilities", EpcglobalLlrpDeviceMessages.getGetReaderCapabilities_RegulatoryCapabilitiesMessage());
    private final SimpleDataCommand getReaderCapabilities_LLRPAirProtocolCapabilities = new SimpleDataCommand("GetReaderCapabilities_LLRPAirProtocolCapabilities", EpcglobalLlrpDeviceMessages.getGetReaderCapabilities_LLRPAirProtocolCapabilitiesMessage());
    private final SimpleDataCommand addRospec = new SimpleDataCommand("AddRospec", EpcglobalLlrpDeviceMessages.getAddRospecMessage());
    private final SimpleDataCommand deleteRospec = new SimpleDataCommand("DeleteRospec", EpcglobalLlrpDeviceMessages.getDeleteRospecMessage());
    private final SimpleDataCommand startRospec = new SimpleDataCommand("StartRospec", EpcglobalLlrpDeviceMessages.getStartRospecMessage());
    private final SimpleDataCommand stopRospec = new SimpleDataCommand("StopRospec", EpcglobalLlrpDeviceMessages.getStopRospecMessage());
    private final SimpleDataCommand enableRospec = new SimpleDataCommand("EnableRospec", EpcglobalLlrpDeviceMessages.getEnableRospecMessage());
    private final SimpleDataCommand disableRospec = new SimpleDataCommand("DisableRospec", EpcglobalLlrpDeviceMessages.getDisableRospecMessage());
    private final SimpleDataCommand getRospecs = new SimpleDataCommand("GetRospecs", EpcglobalLlrpDeviceMessages.getGetRospecsMessage());
    private final SimpleDataCommand addAccessspec = new SimpleDataCommand("AddAccessspec", EpcglobalLlrpDeviceMessages.getAddAccessspecMessage());
    private final SimpleDataCommand deleteAccessspec = new SimpleDataCommand("DeleteAccessspec", EpcglobalLlrpDeviceMessages.getDeleteAccessspecMessage());
    private final SimpleDataCommand enableAccessspec = new SimpleDataCommand("EnableAccessspec", EpcglobalLlrpDeviceMessages.getEnableAccessspecMessage());
    private final SimpleDataCommand disableAccessspec = new SimpleDataCommand("DisableAccessspec", EpcglobalLlrpDeviceMessages.getDisableAccessspecMessage());
    private final SimpleDataCommand getAccessspecs = new SimpleDataCommand("GetAccessspecs", EpcglobalLlrpDeviceMessages.getGetAccessspecsMessage());
    private final SimpleDataCommand getReaderConfig = new SimpleDataCommand("GetReaderConfig", EpcglobalLlrpDeviceMessages.getGetReaderConfigMessage());
    private final SimpleDataCommand getReaderConfig_All = new SimpleDataCommand("GetReaderConfig_All", EpcglobalLlrpDeviceMessages.getGetReaderConfig_AllMessage());
    private final SimpleDataCommand getReaderConfig_Identification = new SimpleDataCommand("GetReaderConfig_Identification", EpcglobalLlrpDeviceMessages.getGetReaderConfig_IdentificationMessage());
    private final SimpleDataCommand getReaderConfig_AntennaProperties = new SimpleDataCommand("GetReaderConfig_AntennaProperties", EpcglobalLlrpDeviceMessages.getGetReaderConfig_AntennaPropertiesMessage());
    private final SimpleDataCommand getReaderConfig_AntennaConfiguration = new SimpleDataCommand("GetReaderConfig_AntennaConfiguration", EpcglobalLlrpDeviceMessages.getGetReaderConfig_AntennaConfigurationMessage());
    private final SimpleDataCommand getReaderConfig_ROReportSpec = new SimpleDataCommand("GetReaderConfig_ROReportSpec", EpcglobalLlrpDeviceMessages.getGetReaderConfig_ROReportSpecMessage());
    private final SimpleDataCommand getReaderConfig_ReaderEventNotificationSpec = new SimpleDataCommand("GetReaderConfig_ReaderEventNotificationSpec", EpcglobalLlrpDeviceMessages.getGetReaderConfig_ReaderEventNotificationSpecMessage());
    private final SimpleDataCommand getReaderConfig_AccessReportSpec = new SimpleDataCommand("GetReaderConfig_AccessReportSpec", EpcglobalLlrpDeviceMessages.getGetReaderConfig_AccessReportSpecMessage());
    private final SimpleDataCommand getReaderConfig_LLRPConfigurationStateValue = new SimpleDataCommand("GetReaderConfig_LLRPConfigurationStateValue", EpcglobalLlrpDeviceMessages.getGetReaderConfig_LLRPConfigurationStateValueMessage());
    private final SimpleDataCommand getReaderConfig_KeepaliveSpec = new SimpleDataCommand("GetReaderConfig_KeepaliveSpec", EpcglobalLlrpDeviceMessages.getGetReaderConfig_KeepaliveSpecMessage());
    private final SimpleDataCommand getReaderConfig_GPIPortCurrentState = new SimpleDataCommand("GetReaderConfig_GPIPortCurrentState", EpcglobalLlrpDeviceMessages.getGetReaderConfig_GPIPortCurrentStateMessage());
    private final SimpleDataCommand getReaderConfig_GPOWriteData = new SimpleDataCommand("GetReaderConfig_GPOWriteData", EpcglobalLlrpDeviceMessages.getGetReaderConfig_GPOWriteDataMessage());
    private final SimpleDataCommand getReaderConfig_EventsAndReports = new SimpleDataCommand("GetReaderConfig_EventsAndReports", EpcglobalLlrpDeviceMessages.getGetReaderConfig_EventsAndReportsMessage());
    private final SimpleDataCommand setReaderConfig = new SimpleDataCommand("SetReaderConfig", EpcglobalLlrpDeviceMessages.getSetReaderConfigMessage());
    private final SimpleDataCommand setReaderConfig_ForInventory = new SimpleDataCommand("SetReaderConfig_ForInventory", EpcglobalLlrpDeviceMessages.getSetReaderConfig_ForInventoryMessage());
    private final SimpleDataCommand setReaderConfig_ReaderEventNotificationSpec = new SimpleDataCommand("SetReaderConfig_ReaderEventNotificationSpec", EpcglobalLlrpDeviceMessages.getSetReaderConfig_ReaderEventNotificationSpecMessage());
    private final SimpleDataCommand setReaderConfig_AntennaProperties = new SimpleDataCommand("SetReaderConfig_AntennaProperties", EpcglobalLlrpDeviceMessages.getSetReaderConfig_AntennaPropertiesMessage());
    private final SimpleDataCommand setReaderConfig_AntennaConfiguration = new SimpleDataCommand("SetReaderConfig_AntennaConfiguration", EpcglobalLlrpDeviceMessages.getSetReaderConfig_AntennaConfigurationMessage());
    private final SimpleDataCommand setReaderConfig_ROReportSpec = new SimpleDataCommand("SetReaderConfig_ROReportSpec", EpcglobalLlrpDeviceMessages.getSetReaderConfig_ROReportSpecMessage());
    private final SimpleDataCommand setReaderConfig_AccessReportSpec = new SimpleDataCommand("SetReaderConfig_AccessReportSpec", EpcglobalLlrpDeviceMessages.getSetReaderConfig_AccessReportSpecMessage());
    private final SimpleDataCommand setReaderConfig_KeepaliveSpec = new SimpleDataCommand("SetReaderConfig_KeepaliveSpec", EpcglobalLlrpDeviceMessages.getSetReaderConfig_KeepaliveSpecMessage());
    private final SimpleDataCommand setReaderConfig_GPOWriteData = new SimpleDataCommand("SetReaderConfig_GPOWriteData", EpcglobalLlrpDeviceMessages.getSetReaderConfig_GPOWriteDataMessage());
    private final SimpleDataCommand setReaderConfig_GPIPortCurrentState = new SimpleDataCommand("SetReaderConfig_GPIPortCurrentState", EpcglobalLlrpDeviceMessages.getSetReaderConfig_GPIPortCurrentStateMessage());
    private final SimpleDataCommand setReaderConfig_EventsAndReports = new SimpleDataCommand("SetReaderConfig_EventsAndReports", EpcglobalLlrpDeviceMessages.getSetReaderConfig_EventsAndReportsMessage());
    private final SimpleDataCommand closeConnection = new SimpleDataCommand("CloseConnection", EpcglobalLlrpDeviceMessages.getCloseConnectionMessage());
    private final SimpleDataCommand getReport = new SimpleDataCommand("GetReport", EpcglobalLlrpDeviceMessages.getGetReportMessage());
    private final SimpleDataCommand keepaliveAck = new SimpleDataCommand("KeepaliveAck", EpcglobalLlrpDeviceMessages.getKeepaliveAckMessage());
    private final SimpleDataCommand enableEventsAndReports = new SimpleDataCommand("EnableEventsAndReports", EpcglobalLlrpDeviceMessages.getEnableEventsAndReportsMessage());
    private final DataSignal getReaderCapabilitiesResponse = new DataSignal("GetReaderCapabilitiesResponse", EpcglobalLlrpDeviceMessages.getGetReaderCapabilitiesResponseMessage());
    private final DataSignal addRospecResponse = new DataSignal("AddRospecResponse", EpcglobalLlrpDeviceMessages.getAddRospecResponseMessage());
    private final DataSignal deleteRospecResponse = new DataSignal("DeleteRospecResponse", EpcglobalLlrpDeviceMessages.getDeleteRospecResponseMessage());
    private final DataSignal startRospecResponse = new DataSignal("StartRospecResponse", EpcglobalLlrpDeviceMessages.getStartRospecResponseMessage());
    private final DataSignal stopRospecResponse = new DataSignal("StopRospecResponse", EpcglobalLlrpDeviceMessages.getStopRospecResponseMessage());
    private final DataSignal enableRospecResponse = new DataSignal("EnableRospecResponse", EpcglobalLlrpDeviceMessages.getEnableRospecResponseMessage());
    private final DataSignal disableRospecResponse = new DataSignal("DisableRospecResponse", EpcglobalLlrpDeviceMessages.getDisableRospecResponseMessage());
    private final DataSignal getRospecsResponse = new DataSignal("GetRospecsResponse", EpcglobalLlrpDeviceMessages.getGetRospecsResponseMessage());
    private final DataSignal addAccessspecResponse = new DataSignal("AddAccessspecResponse", EpcglobalLlrpDeviceMessages.getAddAccessspecResponseMessage());
    private final DataSignal deleteAccessspecResponse = new DataSignal("DeleteAccessspecResponse", EpcglobalLlrpDeviceMessages.getDeleteAccessspecResponseMessage());
    private final DataSignal enableAccessspecResponse = new DataSignal("EnableAccessspecResponse", EpcglobalLlrpDeviceMessages.getEnableAccessspecResponseMessage());
    private final DataSignal disableAccessspecResponse = new DataSignal("DisableAccessspecResponse", EpcglobalLlrpDeviceMessages.getDisableAccessspecResponseMessage());
    private final DataSignal getAccessspecsResponse = new DataSignal("GetAccessspecsResponse", EpcglobalLlrpDeviceMessages.getGetAccessspecsResponseMessage());
    private final DataSignal getReaderConfigResponse = new DataSignal("GetReaderConfigResponse", EpcglobalLlrpDeviceMessages.getGetReaderConfigResponseMessage());
    private final DataSignal setReaderConfigResponse = new DataSignal("SetReaderConfigResponse", EpcglobalLlrpDeviceMessages.getSetReaderConfigResponseMessage());
    private final DataSignal closeConnectionResponse = new DataSignal("CloseConnectionResponse", EpcglobalLlrpDeviceMessages.getCloseConnectionResponseMessage());
    private final DataSignal roAccessReport = new DataSignal("RoAccessReport", EpcglobalLlrpDeviceMessages.getRoAccessReportMessage());
    private final DataSignal keepalive = new DataSignal("Keepalive", EpcglobalLlrpDeviceMessages.getKeepaliveMessage());
    private final DataSignal readerEventNotification = new DataSignal("ReaderEventNotification", EpcglobalLlrpDeviceMessages.getReaderEventNotificationMessage());
    private final DataSignal errorMessage = new DataSignal("ErrorMessage", EpcglobalLlrpDeviceMessages.getErrorMessageMessage());
    private final CommandMeasurement readerCapabilities = new CommandMeasurement("ReaderCapabilities", new HashMap(), null, null, (SignalService)this.getReaderCapabilitiesResponse, (CommandService)this.getReaderCapabilities_All, null);
    private final SignalFieldSignal generalDeviceCapabilitiesResponse = new SignalFieldSignal("GeneralDeviceCapabilitiesResponse", (SignalService)this.getReaderCapabilitiesResponse, "GeneralDeviceCapabilitiesParameter");
    private final CommandMeasurement generalDeviceCapabilities = new CommandMeasurement("GeneralDeviceCapabilities", new HashMap(), null, null, (SignalService)this.generalDeviceCapabilitiesResponse, (CommandService)this.getReaderCapabilities_GeneralDeviceCapabilities, null);
    private final MeasurementFieldMeasurement generalDeviceCapabilitiesMaxNumberOfAntennaSupported = new MeasurementFieldMeasurement("GeneralDeviceCapabilitiesMaxNumberOfAntennaSupported", (Object)EpcglobalLlrpDevice.createNumber((long)0L), (MeasurementService)this.generalDeviceCapabilities, "MaxNumberOfAntennaSupported");
    private final MeasurementFieldMeasurement generalDeviceCapabilitiesCanSetAntennaProperties = new MeasurementFieldMeasurement("GeneralDeviceCapabilitiesCanSetAntennaProperties", (MeasurementService)this.generalDeviceCapabilities, "CanSetAntennaProperties");
    private final MeasurementFieldMeasurement generalDeviceCapabilitiesHasUTCClockCapability = new MeasurementFieldMeasurement("GeneralDeviceCapabilitiesHasUTCClockCapability", (MeasurementService)this.generalDeviceCapabilities, "HasUTCClockCapability");
    private final MeasurementFieldMeasurement generalDeviceCapabilitiesDeviceManufacturerName = new MeasurementFieldMeasurement("GeneralDeviceCapabilitiesDeviceManufacturerName", (Object)EpcglobalLlrpDevice.createNumber((long)0L), (MeasurementService)this.generalDeviceCapabilities, "DeviceManufacturerName");
    private final MeasurementFieldMeasurement generalDeviceCapabilitiesModelName = new MeasurementFieldMeasurement("GeneralDeviceCapabilitiesModelName", (Object)EpcglobalLlrpDevice.createNumber((long)0L), (MeasurementService)this.generalDeviceCapabilities, "ModelName");
    private final MeasurementFieldMeasurement generalDeviceCapabilitiesReaderFirmwareVersion = new MeasurementFieldMeasurement("GeneralDeviceCapabilitiesReaderFirmwareVersion", (MeasurementService)this.generalDeviceCapabilities, "ReaderFirmwareVersion");
    private final MeasurementFieldMeasurement receiveSensitivityTableEntry = new MeasurementFieldMeasurement("ReceiveSensitivityTableEntry", new ArrayList(), (MeasurementService)this.generalDeviceCapabilities, "ReceiveSensitivityTableEntryParameter");
    private final MeasurementFieldMeasurement perAntennaReceiveSensitivityRange = new MeasurementFieldMeasurement("PerAntennaReceiveSensitivityRange", new ArrayList(), (MeasurementService)this.generalDeviceCapabilities, "PerAntennaReceiveSensitivityRangeParameter");
    private final MeasurementFieldMeasurement gPIOCapabilities = new MeasurementFieldMeasurement("GPIOCapabilities", new HashMap(), (MeasurementService)this.generalDeviceCapabilities, "GPIOCapabilitiesParameter");
    private final MeasurementFieldMeasurement gPIOCapabilitiesNumGPIs = new MeasurementFieldMeasurement("GPIOCapabilitiesNumGPIs", (Object)EpcglobalLlrpDevice.createNumber((long)0L), (MeasurementService)this.gPIOCapabilities, "NumGPIs");
    private final MeasurementFieldMeasurement gPIOCapabilitiesNumGPOs = new MeasurementFieldMeasurement("GPIOCapabilitiesNumGPOs", (Object)EpcglobalLlrpDevice.createNumber((long)0L), (MeasurementService)this.gPIOCapabilities, "NumGPOs");
    private final MeasurementFieldMeasurement perAntennaAirProtocol = new MeasurementFieldMeasurement("PerAntennaAirProtocol", new ArrayList(), (MeasurementService)this.generalDeviceCapabilities, "PerAntennaAirProtocolParameter");
    private final SignalFieldSignal lLRPCapabilitiesResponse = new SignalFieldSignal("LLRPCapabilitiesResponse", (SignalService)this.getReaderCapabilitiesResponse, "LLRPCapabilitiesParameter");
    private final CommandMeasurement lLRPCapabilities = new CommandMeasurement("LLRPCapabilities", new HashMap(), null, null, (SignalService)this.lLRPCapabilitiesResponse, (CommandService)this.getReaderCapabilities_LLRPCapabilities, null);
    private final MeasurementFieldMeasurement lLRPCapabilitiesCanDoRFSurvey = new MeasurementFieldMeasurement("LLRPCapabilitiesCanDoRFSurvey", (MeasurementService)this.lLRPCapabilities, "CanDoRFSurvey");
    private final MeasurementFieldMeasurement lLRPCapabilitiesCanReportBufferFillWarning = new MeasurementFieldMeasurement("LLRPCapabilitiesCanReportBufferFillWarning", (MeasurementService)this.lLRPCapabilities, "CanReportBufferFillWarning");
    private final MeasurementFieldMeasurement lLRPCapabilitiesSupportsClientRequestOpSpec = new MeasurementFieldMeasurement("LLRPCapabilitiesSupportsClientRequestOpSpec", (MeasurementService)this.lLRPCapabilities, "SupportsClientRequestOpSpec");
    private final MeasurementFieldMeasurement lLRPCapabilitiesCanDoTagInventoryStateAwareSingulation = new MeasurementFieldMeasurement("LLRPCapabilitiesCanDoTagInventoryStateAwareSingulation", (MeasurementService)this.lLRPCapabilities, "CanDoTagInventoryStateAwareSingulation");
    private final MeasurementFieldMeasurement lLRPCapabilitiesSupportsEventAndReportHolding = new MeasurementFieldMeasurement("LLRPCapabilitiesSupportsEventAndReportHolding", (MeasurementService)this.lLRPCapabilities, "SupportsEventAndReportHolding");
    private final MeasurementFieldMeasurement lLRPCapabilitiesMaxNumPriorityLevelsSupported = new MeasurementFieldMeasurement("LLRPCapabilitiesMaxNumPriorityLevelsSupported", (MeasurementService)this.lLRPCapabilities, "MaxNumPriorityLevelsSupported");
    private final MeasurementFieldMeasurement lLRPCapabilitiesClientRequestOpSpecTimeout = new MeasurementFieldMeasurement("LLRPCapabilitiesClientRequestOpSpecTimeout", (Object)EpcglobalLlrpDevice.createNumber((long)0L), (MeasurementService)this.lLRPCapabilities, "ClientRequestOpSpecTimeout");
    private final MeasurementFieldMeasurement lLRPCapabilitiesMaxNumROSpecs = new MeasurementFieldMeasurement("LLRPCapabilitiesMaxNumROSpecs", (Object)EpcglobalLlrpDevice.createNumber((long)0L), (MeasurementService)this.lLRPCapabilities, "MaxNumROSpecs");
    private final MeasurementFieldMeasurement lLRPCapabilitiesMaxNumSpecsPerROSpec = new MeasurementFieldMeasurement("LLRPCapabilitiesMaxNumSpecsPerROSpec", (Object)EpcglobalLlrpDevice.createNumber((long)0L), (MeasurementService)this.lLRPCapabilities, "MaxNumSpecsPerROSpec");
    private final MeasurementFieldMeasurement lLRPCapabilitiesMaxNumInventoryParameterSpecsPerAISpec = new MeasurementFieldMeasurement("LLRPCapabilitiesMaxNumInventoryParameterSpecsPerAISpec", (Object)EpcglobalLlrpDevice.createNumber((long)0L), (MeasurementService)this.lLRPCapabilities, "MaxNumInventoryParameterSpecsPerAISpec");
    private final MeasurementFieldMeasurement lLRPCapabilitiesMaxNumAccessSpecs = new MeasurementFieldMeasurement("LLRPCapabilitiesMaxNumAccessSpecs", (Object)EpcglobalLlrpDevice.createNumber((long)0L), (MeasurementService)this.lLRPCapabilities, "MaxNumAccessSpecs");
    private final MeasurementFieldMeasurement lLRPCapabilitiesMaxNumOpSpecsPerAccessSpec = new MeasurementFieldMeasurement("LLRPCapabilitiesMaxNumOpSpecsPerAccessSpec", (Object)EpcglobalLlrpDevice.createNumber((long)0L), (MeasurementService)this.lLRPCapabilities, "MaxNumOpSpecsPerAccessSpec");
    private final SignalFieldSignal regulatoryCapabilitiesResponse = new SignalFieldSignal("RegulatoryCapabilitiesResponse", (SignalService)this.getReaderCapabilitiesResponse, "RegulatoryCapabilitiesParameter");
    private final CommandMeasurement regulatoryCapabilities = new CommandMeasurement("RegulatoryCapabilities", new HashMap(), null, null, (SignalService)this.regulatoryCapabilitiesResponse, (CommandService)this.getReaderCapabilities_RegulatoryCapabilities, null);
    private final MeasurementFieldMeasurement regulatoryCapabilitiesCountryCode = new MeasurementFieldMeasurement("RegulatoryCapabilitiesCountryCode", (Object)EpcglobalLlrpDevice.createNumber((long)0L), (MeasurementService)this.regulatoryCapabilities, "CountryCode");
    private final MeasurementFieldMeasurement regulatoryCapabilitiesCommunicationsStandard = new MeasurementFieldMeasurement("RegulatoryCapabilitiesCommunicationsStandard", (Object)EpcglobalLlrpDevice.createNumber((long)0L), (MeasurementService)this.regulatoryCapabilities, "CommunicationsStandard");
    private final MeasurementFieldMeasurement uHFBandCapabilities = new MeasurementFieldMeasurement("UHFBandCapabilities", new HashMap(), (MeasurementService)this.regulatoryCapabilities, "UHFBandCapabilitiesParameter");
    private final MeasurementFieldMeasurement transmitPowerLevelTableEntry = new MeasurementFieldMeasurement("TransmitPowerLevelTableEntry", new ArrayList(), (MeasurementService)this.uHFBandCapabilities, "TransmitPowerLevelTableEntryParameter");
    private final MeasurementFieldMeasurement frequencyInformation = new MeasurementFieldMeasurement("FrequencyInformation", new HashMap(), (MeasurementService)this.uHFBandCapabilities, "FrequencyInformationParameter");
    private final MeasurementFieldMeasurement frequencyInformationHopping = new MeasurementFieldMeasurement("FrequencyInformationHopping", (MeasurementService)this.frequencyInformation, "Hopping");
    private final MeasurementFieldMeasurement frequencyHopTable = new MeasurementFieldMeasurement("FrequencyHopTable", new ArrayList(), (MeasurementService)this.frequencyInformation, "FrequencyHopTableParameter");
    private final MeasurementFieldMeasurement fixedFrequencyTable = new MeasurementFieldMeasurement("FixedFrequencyTable", new HashMap(), (MeasurementService)this.frequencyInformation, "FixedFrequencyTableParameter");
    private final MeasurementFieldMeasurement fixedFrequencyTableFrequency = new MeasurementFieldMeasurement("FixedFrequencyTableFrequency", (MeasurementService)this.fixedFrequencyTable, "Frequency");
    private final MeasurementFieldMeasurement airProtocolUHFRFModeTable = new MeasurementFieldMeasurement("AirProtocolUHFRFModeTable", new ArrayList(), (MeasurementService)this.uHFBandCapabilities, "AirProtocolUHFRFModeTableChoice");
    private final SignalFieldSignal airProtocolLLRPCapabilitiesChoiceResponse = new SignalFieldSignal("AirProtocolLLRPCapabilitiesChoiceResponse", (SignalService)this.getReaderCapabilitiesResponse, "AirProtocolLLRPCapabilitiesChoice");
    private final CommandMeasurement airProtocolLLRPCapabilities = new CommandMeasurement("AirProtocolLLRPCapabilities", new HashMap(), null, null, (SignalService)this.airProtocolLLRPCapabilitiesChoiceResponse, (CommandService)this.getReaderCapabilities_All, null);
    private final CommandMeasurement readerConfig = new CommandMeasurement("ReaderConfig", new HashMap(), null, null, (SignalService)this.getReaderConfigResponse, (CommandService)this.getReaderConfig_All, (CommandService)this.setReaderConfig);
    private final SignalFieldSignal identificationResponse = new SignalFieldSignal("IdentificationResponse", (SignalService)this.getReaderConfigResponse, "IdentificationParameter");
    private final CommandMeasurement identification = new CommandMeasurement("Identification", new HashMap(), null, null, (SignalService)this.identificationResponse, (CommandService)this.getReaderConfig_Identification, null);
    private final MeasurementFieldMeasurement identificationIDType = new MeasurementFieldMeasurement("IdentificationIDType", (MeasurementService)this.identification, "IDType");
    private final MeasurementFieldMeasurement identificationReaderID = new MeasurementFieldMeasurement("IdentificationReaderID", (MeasurementService)this.identification, "ReaderID");
    private final SignalFieldSignal antennaPropertiesResponse = new SignalFieldSignal("AntennaPropertiesResponse", (SignalService)this.getReaderConfigResponse, "AntennaPropertiesParameter");
    private final CommandMeasurement antennaProperties = new CommandMeasurement("AntennaProperties", new HashMap(), null, null, (SignalService)this.antennaPropertiesResponse, (CommandService)this.getReaderConfig_AntennaProperties, (CommandService)this.setReaderConfig_AntennaProperties);
    private final SignalFieldSignal antennaConfigurationResponse = new SignalFieldSignal("AntennaConfigurationResponse", (SignalService)this.getReaderConfigResponse, "AntennaConfigurationParameter");
    private final CommandMeasurement antennaConfiguration = new CommandMeasurement("AntennaConfiguration", new HashMap(), null, null, (SignalService)this.antennaConfigurationResponse, (CommandService)this.getReaderConfig_AntennaConfiguration, (CommandService)this.setReaderConfig_AntennaConfiguration);
    private final SignalFieldSignal readerEventNotificationSpecResponse = new SignalFieldSignal("ReaderEventNotificationSpecResponse", (SignalService)this.getReaderConfigResponse, "ReaderEventNotificationSpecParameter");
    private final CommandMeasurement readerEventNotificationSpec = new CommandMeasurement("ReaderEventNotificationSpec", new HashMap(), null, null, (SignalService)this.readerEventNotificationSpecResponse, (CommandService)this.getReaderConfig_ReaderEventNotificationSpec, (CommandService)this.setReaderConfig_ReaderEventNotificationSpec);
    private final MeasurementFieldMeasurement eventNotificationState = new MeasurementFieldMeasurement("EventNotificationState", new ArrayList(), (MeasurementService)this.readerEventNotificationSpec, "EventNotificationStateParameter");
    private final SignalFieldSignal rOReportSpecResponse = new SignalFieldSignal("ROReportSpecResponse", (SignalService)this.getReaderConfigResponse, "ROReportSpecParameter");
    private final CommandMeasurement rOReportSpec = new CommandMeasurement("ROReportSpec", new HashMap(), null, null, (SignalService)this.rOReportSpecResponse, (CommandService)this.getReaderConfig_ROReportSpec, (CommandService)this.setReaderConfig_ROReportSpec);
    private final MeasurementFieldMeasurement rOReportSpecROReportTrigger = new MeasurementFieldMeasurement("ROReportSpecROReportTrigger", (MeasurementService)this.rOReportSpec, "ROReportTrigger");
    private final MeasurementFieldMeasurement rOReportSpecN = new MeasurementFieldMeasurement("ROReportSpecN", (MeasurementService)this.rOReportSpec, "N");
    private final MeasurementFieldMeasurement tagReportContentSelector = new MeasurementFieldMeasurement("TagReportContentSelector", new HashMap(), (MeasurementService)this.rOReportSpec, "TagReportContentSelectorParameter");
    private final MeasurementFieldMeasurement tagReportContentSelectorEnableROSpecID = new MeasurementFieldMeasurement("TagReportContentSelectorEnableROSpecID", (MeasurementService)this.tagReportContentSelector, "EnableROSpecID");
    private final MeasurementFieldMeasurement tagReportContentSelectorEnableSpecIndex = new MeasurementFieldMeasurement("TagReportContentSelectorEnableSpecIndex", (MeasurementService)this.tagReportContentSelector, "EnableSpecIndex");
    private final MeasurementFieldMeasurement tagReportContentSelectorEnableInventoryParameterSpecID = new MeasurementFieldMeasurement("TagReportContentSelectorEnableInventoryParameterSpecID", (MeasurementService)this.tagReportContentSelector, "EnableInventoryParameterSpecID");
    private final MeasurementFieldMeasurement tagReportContentSelectorEnableAntennaID = new MeasurementFieldMeasurement("TagReportContentSelectorEnableAntennaID", (MeasurementService)this.tagReportContentSelector, "EnableAntennaID");
    private final MeasurementFieldMeasurement tagReportContentSelectorEnableChannelIndex = new MeasurementFieldMeasurement("TagReportContentSelectorEnableChannelIndex", (MeasurementService)this.tagReportContentSelector, "EnableChannelIndex");
    private final MeasurementFieldMeasurement tagReportContentSelectorEnablePeakRSSI = new MeasurementFieldMeasurement("TagReportContentSelectorEnablePeakRSSI", (MeasurementService)this.tagReportContentSelector, "EnablePeakRSSI");
    private final MeasurementFieldMeasurement tagReportContentSelectorEnableFirstSeenTimestamp = new MeasurementFieldMeasurement("TagReportContentSelectorEnableFirstSeenTimestamp", (MeasurementService)this.tagReportContentSelector, "EnableFirstSeenTimestamp");
    private final MeasurementFieldMeasurement tagReportContentSelectorEnableLastSeenTimestamp = new MeasurementFieldMeasurement("TagReportContentSelectorEnableLastSeenTimestamp", (MeasurementService)this.tagReportContentSelector, "EnableLastSeenTimestamp");
    private final MeasurementFieldMeasurement tagReportContentSelectorEnableTagSeenCount = new MeasurementFieldMeasurement("TagReportContentSelectorEnableTagSeenCount", (MeasurementService)this.tagReportContentSelector, "EnableTagSeenCount");
    private final MeasurementFieldMeasurement tagReportContentSelectorEnableAccessSpecID = new MeasurementFieldMeasurement("TagReportContentSelectorEnableAccessSpecID", (MeasurementService)this.tagReportContentSelector, "EnableAccessSpecID");
    private final MeasurementFieldMeasurement airProtocolEPCMemorySelector = new MeasurementFieldMeasurement("AirProtocolEPCMemorySelector", new ArrayList(), (MeasurementService)this.tagReportContentSelector, "AirProtocolEPCMemorySelectorChoice");
    private final SignalFieldSignal accessReportSpecResponse = new SignalFieldSignal("AccessReportSpecResponse", (SignalService)this.getReaderConfigResponse, "AccessReportSpecParameter");
    private final CommandMeasurement accessReportSpec = new CommandMeasurement("AccessReportSpec", new HashMap(), null, null, (SignalService)this.accessReportSpecResponse, (CommandService)this.getReaderConfig_AccessReportSpec, (CommandService)this.setReaderConfig_AccessReportSpec);
    private final MeasurementFieldMeasurement accessReportSpecAccessReportTrigger = new MeasurementFieldMeasurement("AccessReportSpecAccessReportTrigger", (MeasurementService)this.accessReportSpec, "AccessReportTrigger");
    private final SignalFieldSignal lLRPConfigurationStateValueResponse = new SignalFieldSignal("LLRPConfigurationStateValueResponse", (SignalService)this.getReaderConfigResponse, "LLRPConfigurationStateValueParameter");
    private final CommandMeasurement readerConfigLLRPConfigurationStateValue = new CommandMeasurement("ReaderConfigLLRPConfigurationStateValue", new HashMap(), null, null, (SignalService)this.lLRPConfigurationStateValueResponse, (CommandService)this.getReaderConfig_LLRPConfigurationStateValue, null);
    private final MeasurementFieldMeasurement readerConfigLLRPConfigurationStateValueLLRPConfigurationStateValue = new MeasurementFieldMeasurement("ReaderConfigLLRPConfigurationStateValueLLRPConfigurationStateValue", (Object)EpcglobalLlrpDevice.createNumber((long)0L), (MeasurementService)this.readerConfigLLRPConfigurationStateValue, "LLRPConfigurationStateValue");
    private final SignalFieldSignal keepaliveSpecResponse = new SignalFieldSignal("KeepaliveSpecResponse", (SignalService)this.getReaderConfigResponse, "KeepaliveSpecParameter");
    private final CommandMeasurement keepaliveSpec = new CommandMeasurement("KeepaliveSpec", new HashMap(), null, null, (SignalService)this.keepaliveSpecResponse, (CommandService)this.getReaderConfig_KeepaliveSpec, (CommandService)this.setReaderConfig_KeepaliveSpec);
    private final MeasurementFieldMeasurement keepaliveSpecKeepaliveTriggerType = new MeasurementFieldMeasurement("KeepaliveSpecKeepaliveTriggerType", (MeasurementService)this.keepaliveSpec, "KeepaliveTriggerType");
    private final MeasurementFieldMeasurement keepaliveSpecPeriodicTriggerValue = new MeasurementFieldMeasurement("KeepaliveSpecPeriodicTriggerValue", (Object)EpcglobalLlrpDevice.createNumber((long)0L), (MeasurementService)this.keepaliveSpec, "PeriodicTriggerValue");
    private final SignalFieldSignal gPIPortCurrentStateResponse = new SignalFieldSignal("GPIPortCurrentStateResponse", (SignalService)this.getReaderConfigResponse, "GPIPortCurrentStateParameter");
    private final CommandMeasurement gPIPortCurrentState = new CommandMeasurement("GPIPortCurrentState", new HashMap(), null, null, (SignalService)this.gPIPortCurrentStateResponse, (CommandService)this.getReaderConfig_GPIPortCurrentState, (CommandService)this.setReaderConfig_GPIPortCurrentState);
    private final SignalFieldSignal gPOWriteDataResponse = new SignalFieldSignal("GPOWriteDataResponse", (SignalService)this.getReaderConfigResponse, "GPOWriteDataParameter");
    private final CommandMeasurement gPOWriteData = new CommandMeasurement("GPOWriteData", new HashMap(), null, null, (SignalService)this.gPOWriteDataResponse, (CommandService)this.getReaderConfig_GPOWriteData, (CommandService)this.setReaderConfig_GPOWriteData);
    private final SignalFieldSignal eventsAndReportsResponse = new SignalFieldSignal("EventsAndReportsResponse", (SignalService)this.getReaderConfigResponse, "EventsAndReportsParameter");
    private final CommandMeasurement eventsAndReports = new CommandMeasurement("EventsAndReports", new HashMap(), null, null, (SignalService)this.eventsAndReportsResponse, (CommandService)this.getReaderConfig_EventsAndReports, (CommandService)this.setReaderConfig_EventsAndReports);
    private final MeasurementFieldMeasurement eventsAndReportsHoldEventsAndReportsUponReconnect = new MeasurementFieldMeasurement("EventsAndReportsHoldEventsAndReportsUponReconnect", (MeasurementService)this.eventsAndReports, "HoldEventsAndReportsUponReconnect");
    private final CommandMeasurement rospecs = new CommandMeasurement("Rospecs", new HashMap(), null, null, (SignalService)this.getRospecsResponse, (CommandService)this.getRospecs, null);
    private final SignalFieldSignal rOSpecResponse = new SignalFieldSignal("ROSpecResponse", (SignalService)this.getRospecsResponse, "ROSpecParameter");
    private final CommandMeasurement rOSpec = new CommandMeasurement("ROSpec", new HashMap(), null, null, (SignalService)this.rOSpecResponse, (CommandService)this.getRospecs, null);
    private final CommandMeasurement accessspecs = new CommandMeasurement("Accessspecs", new HashMap(), null, null, (SignalService)this.getAccessspecsResponse, (CommandService)this.getAccessspecs, null);
    private final SignalFieldSignal accessSpecResponse = new SignalFieldSignal("AccessSpecResponse", (SignalService)this.getAccessspecsResponse, "AccessSpecParameter");
    private final CommandMeasurement accessSpec = new CommandMeasurement("AccessSpec", new HashMap(), null, null, (SignalService)this.accessSpecResponse, (CommandService)this.getAccessspecs, null);

    public EpcglobalLlrpDevice() {
        super("Device/Capabilities", "Status", "Device/Configuration", "Device/Metrics");
        this.setKey(this.getDefaultKey());
        this.initialize();
    }

    public InterestService getInterest() {
        return this.interest;
    }

    public String getDefaultKey() {
        return "EpcglobalLlrpDevice";
    }

    public TransportService getDefaultTransport() {
        return (TransportService)EpcglobalLlrpDevice.loadService((String)TransportService.SERVICE_NAME, (String)"org.eclipse.soda.dk.epcglobal.llrp.transport.EpcglobalLlrpTransport");
    }

    public int getControlCapacity() {
        return 223;
    }

    public int getMessageCapacity() {
        return 31;
    }

    public Object getMessageKey(MessageService message) {
        byte[] bytes = message.getBytes();
        if (bytes.length >= 2 && (bytes[0] == 4 || bytes[0] == 7)) {
            return EpcglobalLlrpDevice.createInteger((int)(bytes[0] & 3 ^ (bytes[1] & 0xFF) << 2));
        }
        return null;
    }

    private void initialize() {
        SimpleDataCommand customMessageRequest = this.customMessageRequest;
        this.put((ControlService)customMessageRequest);
        DataSignal customMessageReport = this.customMessageReport;
        this.put((ControlService)customMessageReport);
        SimpleDataCommand getReaderCapabilities = this.getReaderCapabilities;
        this.put((ControlService)getReaderCapabilities);
        SimpleDataCommand getReaderCapabilities_All = this.getReaderCapabilities_All;
        this.put((ControlService)getReaderCapabilities_All);
        SimpleDataCommand getReaderCapabilities_GeneralDeviceCapabilities = this.getReaderCapabilities_GeneralDeviceCapabilities;
        this.put((ControlService)getReaderCapabilities_GeneralDeviceCapabilities);
        SimpleDataCommand getReaderCapabilities_LLRPCapabilities = this.getReaderCapabilities_LLRPCapabilities;
        this.put((ControlService)getReaderCapabilities_LLRPCapabilities);
        SimpleDataCommand getReaderCapabilities_RegulatoryCapabilities = this.getReaderCapabilities_RegulatoryCapabilities;
        this.put((ControlService)getReaderCapabilities_RegulatoryCapabilities);
        SimpleDataCommand getReaderCapabilities_LLRPAirProtocolCapabilities = this.getReaderCapabilities_LLRPAirProtocolCapabilities;
        this.put((ControlService)getReaderCapabilities_LLRPAirProtocolCapabilities);
        SimpleDataCommand addRospec = this.addRospec;
        this.put((ControlService)addRospec);
        SimpleDataCommand deleteRospec = this.deleteRospec;
        this.put((ControlService)deleteRospec);
        SimpleDataCommand startRospec = this.startRospec;
        this.put((ControlService)startRospec);
        SimpleDataCommand stopRospec = this.stopRospec;
        this.put((ControlService)stopRospec);
        SimpleDataCommand enableRospec = this.enableRospec;
        this.put((ControlService)enableRospec);
        SimpleDataCommand disableRospec = this.disableRospec;
        this.put((ControlService)disableRospec);
        SimpleDataCommand getRospecs = this.getRospecs;
        this.put((ControlService)getRospecs);
        SimpleDataCommand addAccessspec = this.addAccessspec;
        this.put((ControlService)addAccessspec);
        SimpleDataCommand deleteAccessspec = this.deleteAccessspec;
        this.put((ControlService)deleteAccessspec);
        SimpleDataCommand enableAccessspec = this.enableAccessspec;
        this.put((ControlService)enableAccessspec);
        SimpleDataCommand disableAccessspec = this.disableAccessspec;
        this.put((ControlService)disableAccessspec);
        SimpleDataCommand getAccessspecs = this.getAccessspecs;
        this.put((ControlService)getAccessspecs);
        SimpleDataCommand getReaderConfig = this.getReaderConfig;
        this.put((ControlService)getReaderConfig);
        SimpleDataCommand getReaderConfig_All = this.getReaderConfig_All;
        this.put((ControlService)getReaderConfig_All);
        SimpleDataCommand getReaderConfig_Identification = this.getReaderConfig_Identification;
        this.put((ControlService)getReaderConfig_Identification);
        SimpleDataCommand getReaderConfig_AntennaProperties = this.getReaderConfig_AntennaProperties;
        this.put((ControlService)getReaderConfig_AntennaProperties);
        SimpleDataCommand getReaderConfig_AntennaConfiguration = this.getReaderConfig_AntennaConfiguration;
        this.put((ControlService)getReaderConfig_AntennaConfiguration);
        SimpleDataCommand getReaderConfig_ROReportSpec = this.getReaderConfig_ROReportSpec;
        this.put((ControlService)getReaderConfig_ROReportSpec);
        SimpleDataCommand getReaderConfig_ReaderEventNotificationSpec = this.getReaderConfig_ReaderEventNotificationSpec;
        this.put((ControlService)getReaderConfig_ReaderEventNotificationSpec);
        SimpleDataCommand getReaderConfig_AccessReportSpec = this.getReaderConfig_AccessReportSpec;
        this.put((ControlService)getReaderConfig_AccessReportSpec);
        SimpleDataCommand getReaderConfig_LLRPConfigurationStateValue = this.getReaderConfig_LLRPConfigurationStateValue;
        this.put((ControlService)getReaderConfig_LLRPConfigurationStateValue);
        SimpleDataCommand getReaderConfig_KeepaliveSpec = this.getReaderConfig_KeepaliveSpec;
        this.put((ControlService)getReaderConfig_KeepaliveSpec);
        SimpleDataCommand getReaderConfig_GPIPortCurrentState = this.getReaderConfig_GPIPortCurrentState;
        this.put((ControlService)getReaderConfig_GPIPortCurrentState);
        SimpleDataCommand getReaderConfig_GPOWriteData = this.getReaderConfig_GPOWriteData;
        this.put((ControlService)getReaderConfig_GPOWriteData);
        SimpleDataCommand getReaderConfig_EventsAndReports = this.getReaderConfig_EventsAndReports;
        this.put((ControlService)getReaderConfig_EventsAndReports);
        SimpleDataCommand setReaderConfig = this.setReaderConfig;
        this.put((ControlService)setReaderConfig);
        SimpleDataCommand setReaderConfig_ForInventory = this.setReaderConfig_ForInventory;
        this.put((ControlService)setReaderConfig_ForInventory);
        SimpleDataCommand setReaderConfig_ReaderEventNotificationSpec = this.setReaderConfig_ReaderEventNotificationSpec;
        this.put((ControlService)setReaderConfig_ReaderEventNotificationSpec);
        SimpleDataCommand setReaderConfig_AntennaProperties = this.setReaderConfig_AntennaProperties;
        this.put((ControlService)setReaderConfig_AntennaProperties);
        SimpleDataCommand setReaderConfig_AntennaConfiguration = this.setReaderConfig_AntennaConfiguration;
        this.put((ControlService)setReaderConfig_AntennaConfiguration);
        SimpleDataCommand setReaderConfig_ROReportSpec = this.setReaderConfig_ROReportSpec;
        this.put((ControlService)setReaderConfig_ROReportSpec);
        SimpleDataCommand setReaderConfig_AccessReportSpec = this.setReaderConfig_AccessReportSpec;
        this.put((ControlService)setReaderConfig_AccessReportSpec);
        SimpleDataCommand setReaderConfig_KeepaliveSpec = this.setReaderConfig_KeepaliveSpec;
        this.put((ControlService)setReaderConfig_KeepaliveSpec);
        SimpleDataCommand setReaderConfig_GPOWriteData = this.setReaderConfig_GPOWriteData;
        this.put((ControlService)setReaderConfig_GPOWriteData);
        SimpleDataCommand setReaderConfig_GPIPortCurrentState = this.setReaderConfig_GPIPortCurrentState;
        this.put((ControlService)setReaderConfig_GPIPortCurrentState);
        SimpleDataCommand setReaderConfig_EventsAndReports = this.setReaderConfig_EventsAndReports;
        this.put((ControlService)setReaderConfig_EventsAndReports);
        SimpleDataCommand closeConnection = this.closeConnection;
        this.put((ControlService)closeConnection);
        SimpleDataCommand getReport = this.getReport;
        this.put((ControlService)getReport);
        SimpleDataCommand keepaliveAck = this.keepaliveAck;
        this.put((ControlService)keepaliveAck);
        SimpleDataCommand enableEventsAndReports = this.enableEventsAndReports;
        this.put((ControlService)enableEventsAndReports);
        DataSignal getReaderCapabilitiesResponse = this.getReaderCapabilitiesResponse;
        this.put((ControlService)getReaderCapabilitiesResponse);
        DataSignal addRospecResponse = this.addRospecResponse;
        this.put((ControlService)addRospecResponse);
        DataSignal deleteRospecResponse = this.deleteRospecResponse;
        this.put((ControlService)deleteRospecResponse);
        DataSignal startRospecResponse = this.startRospecResponse;
        this.put((ControlService)startRospecResponse);
        DataSignal stopRospecResponse = this.stopRospecResponse;
        this.put((ControlService)stopRospecResponse);
        DataSignal enableRospecResponse = this.enableRospecResponse;
        this.put((ControlService)enableRospecResponse);
        DataSignal disableRospecResponse = this.disableRospecResponse;
        this.put((ControlService)disableRospecResponse);
        DataSignal getRospecsResponse = this.getRospecsResponse;
        this.put((ControlService)getRospecsResponse);
        DataSignal addAccessspecResponse = this.addAccessspecResponse;
        this.put((ControlService)addAccessspecResponse);
        DataSignal deleteAccessspecResponse = this.deleteAccessspecResponse;
        this.put((ControlService)deleteAccessspecResponse);
        DataSignal enableAccessspecResponse = this.enableAccessspecResponse;
        this.put((ControlService)enableAccessspecResponse);
        DataSignal disableAccessspecResponse = this.disableAccessspecResponse;
        this.put((ControlService)disableAccessspecResponse);
        DataSignal getAccessspecsResponse = this.getAccessspecsResponse;
        this.put((ControlService)getAccessspecsResponse);
        DataSignal getReaderConfigResponse = this.getReaderConfigResponse;
        this.put((ControlService)getReaderConfigResponse);
        DataSignal setReaderConfigResponse = this.setReaderConfigResponse;
        this.put((ControlService)setReaderConfigResponse);
        DataSignal closeConnectionResponse = this.closeConnectionResponse;
        this.put((ControlService)closeConnectionResponse);
        DataSignal roAccessReport = this.roAccessReport;
        this.put((ControlService)roAccessReport);
        DataSignal keepalive = this.keepalive;
        this.put((ControlService)keepalive);
        DataSignal readerEventNotification = this.readerEventNotification;
        this.put((ControlService)readerEventNotification);
        DataSignal errorMessage = this.errorMessage;
        this.put((ControlService)errorMessage);
        CommandMeasurement readerCapabilities = this.readerCapabilities;
        this.put((ControlService)readerCapabilities);
        SignalFieldSignal generalDeviceCapabilitiesResponse = this.generalDeviceCapabilitiesResponse;
        this.put((ControlService)generalDeviceCapabilitiesResponse);
        CommandMeasurement generalDeviceCapabilities = this.generalDeviceCapabilities;
        this.put((ControlService)generalDeviceCapabilities);
        MeasurementFieldMeasurement generalDeviceCapabilitiesMaxNumberOfAntennaSupported = this.generalDeviceCapabilitiesMaxNumberOfAntennaSupported;
        this.put((ControlService)generalDeviceCapabilitiesMaxNumberOfAntennaSupported);
        MeasurementFieldMeasurement generalDeviceCapabilitiesCanSetAntennaProperties = this.generalDeviceCapabilitiesCanSetAntennaProperties;
        this.put((ControlService)generalDeviceCapabilitiesCanSetAntennaProperties);
        MeasurementFieldMeasurement generalDeviceCapabilitiesHasUTCClockCapability = this.generalDeviceCapabilitiesHasUTCClockCapability;
        this.put((ControlService)generalDeviceCapabilitiesHasUTCClockCapability);
        MeasurementFieldMeasurement generalDeviceCapabilitiesDeviceManufacturerName = this.generalDeviceCapabilitiesDeviceManufacturerName;
        this.put((ControlService)generalDeviceCapabilitiesDeviceManufacturerName);
        MeasurementFieldMeasurement generalDeviceCapabilitiesModelName = this.generalDeviceCapabilitiesModelName;
        this.put((ControlService)generalDeviceCapabilitiesModelName);
        MeasurementFieldMeasurement generalDeviceCapabilitiesReaderFirmwareVersion = this.generalDeviceCapabilitiesReaderFirmwareVersion;
        this.put((ControlService)generalDeviceCapabilitiesReaderFirmwareVersion);
        MeasurementFieldMeasurement receiveSensitivityTableEntry = this.receiveSensitivityTableEntry;
        this.put((ControlService)receiveSensitivityTableEntry);
        MeasurementFieldMeasurement perAntennaReceiveSensitivityRange = this.perAntennaReceiveSensitivityRange;
        this.put((ControlService)perAntennaReceiveSensitivityRange);
        MeasurementFieldMeasurement gPIOCapabilities = this.gPIOCapabilities;
        this.put((ControlService)gPIOCapabilities);
        MeasurementFieldMeasurement gPIOCapabilitiesNumGPIs = this.gPIOCapabilitiesNumGPIs;
        this.put((ControlService)gPIOCapabilitiesNumGPIs);
        MeasurementFieldMeasurement gPIOCapabilitiesNumGPOs = this.gPIOCapabilitiesNumGPOs;
        this.put((ControlService)gPIOCapabilitiesNumGPOs);
        MeasurementFieldMeasurement perAntennaAirProtocol = this.perAntennaAirProtocol;
        this.put((ControlService)perAntennaAirProtocol);
        SignalFieldSignal lLRPCapabilitiesResponse = this.lLRPCapabilitiesResponse;
        this.put((ControlService)lLRPCapabilitiesResponse);
        CommandMeasurement lLRPCapabilities = this.lLRPCapabilities;
        this.put((ControlService)lLRPCapabilities);
        MeasurementFieldMeasurement lLRPCapabilitiesCanDoRFSurvey = this.lLRPCapabilitiesCanDoRFSurvey;
        this.put((ControlService)lLRPCapabilitiesCanDoRFSurvey);
        MeasurementFieldMeasurement lLRPCapabilitiesCanReportBufferFillWarning = this.lLRPCapabilitiesCanReportBufferFillWarning;
        this.put((ControlService)lLRPCapabilitiesCanReportBufferFillWarning);
        MeasurementFieldMeasurement lLRPCapabilitiesSupportsClientRequestOpSpec = this.lLRPCapabilitiesSupportsClientRequestOpSpec;
        this.put((ControlService)lLRPCapabilitiesSupportsClientRequestOpSpec);
        MeasurementFieldMeasurement lLRPCapabilitiesCanDoTagInventoryStateAwareSingulation = this.lLRPCapabilitiesCanDoTagInventoryStateAwareSingulation;
        this.put((ControlService)lLRPCapabilitiesCanDoTagInventoryStateAwareSingulation);
        MeasurementFieldMeasurement lLRPCapabilitiesSupportsEventAndReportHolding = this.lLRPCapabilitiesSupportsEventAndReportHolding;
        this.put((ControlService)lLRPCapabilitiesSupportsEventAndReportHolding);
        MeasurementFieldMeasurement lLRPCapabilitiesMaxNumPriorityLevelsSupported = this.lLRPCapabilitiesMaxNumPriorityLevelsSupported;
        this.put((ControlService)lLRPCapabilitiesMaxNumPriorityLevelsSupported);
        MeasurementFieldMeasurement lLRPCapabilitiesClientRequestOpSpecTimeout = this.lLRPCapabilitiesClientRequestOpSpecTimeout;
        this.put((ControlService)lLRPCapabilitiesClientRequestOpSpecTimeout);
        MeasurementFieldMeasurement lLRPCapabilitiesMaxNumROSpecs = this.lLRPCapabilitiesMaxNumROSpecs;
        this.put((ControlService)lLRPCapabilitiesMaxNumROSpecs);
        MeasurementFieldMeasurement lLRPCapabilitiesMaxNumSpecsPerROSpec = this.lLRPCapabilitiesMaxNumSpecsPerROSpec;
        this.put((ControlService)lLRPCapabilitiesMaxNumSpecsPerROSpec);
        MeasurementFieldMeasurement lLRPCapabilitiesMaxNumInventoryParameterSpecsPerAISpec = this.lLRPCapabilitiesMaxNumInventoryParameterSpecsPerAISpec;
        this.put((ControlService)lLRPCapabilitiesMaxNumInventoryParameterSpecsPerAISpec);
        MeasurementFieldMeasurement lLRPCapabilitiesMaxNumAccessSpecs = this.lLRPCapabilitiesMaxNumAccessSpecs;
        this.put((ControlService)lLRPCapabilitiesMaxNumAccessSpecs);
        MeasurementFieldMeasurement lLRPCapabilitiesMaxNumOpSpecsPerAccessSpec = this.lLRPCapabilitiesMaxNumOpSpecsPerAccessSpec;
        this.put((ControlService)lLRPCapabilitiesMaxNumOpSpecsPerAccessSpec);
        SignalFieldSignal regulatoryCapabilitiesResponse = this.regulatoryCapabilitiesResponse;
        this.put((ControlService)regulatoryCapabilitiesResponse);
        CommandMeasurement regulatoryCapabilities = this.regulatoryCapabilities;
        this.put((ControlService)regulatoryCapabilities);
        MeasurementFieldMeasurement regulatoryCapabilitiesCountryCode = this.regulatoryCapabilitiesCountryCode;
        this.put((ControlService)regulatoryCapabilitiesCountryCode);
        MeasurementFieldMeasurement regulatoryCapabilitiesCommunicationsStandard = this.regulatoryCapabilitiesCommunicationsStandard;
        this.put((ControlService)regulatoryCapabilitiesCommunicationsStandard);
        MeasurementFieldMeasurement uHFBandCapabilities = this.uHFBandCapabilities;
        this.put((ControlService)uHFBandCapabilities);
        MeasurementFieldMeasurement transmitPowerLevelTableEntry = this.transmitPowerLevelTableEntry;
        this.put((ControlService)transmitPowerLevelTableEntry);
        MeasurementFieldMeasurement frequencyInformation = this.frequencyInformation;
        this.put((ControlService)frequencyInformation);
        MeasurementFieldMeasurement frequencyInformationHopping = this.frequencyInformationHopping;
        this.put((ControlService)frequencyInformationHopping);
        MeasurementFieldMeasurement frequencyHopTable = this.frequencyHopTable;
        this.put((ControlService)frequencyHopTable);
        MeasurementFieldMeasurement fixedFrequencyTable = this.fixedFrequencyTable;
        this.put((ControlService)fixedFrequencyTable);
        MeasurementFieldMeasurement fixedFrequencyTableFrequency = this.fixedFrequencyTableFrequency;
        this.put((ControlService)fixedFrequencyTableFrequency);
        MeasurementFieldMeasurement airProtocolUHFRFModeTable = this.airProtocolUHFRFModeTable;
        this.put((ControlService)airProtocolUHFRFModeTable);
        SignalFieldSignal airProtocolLLRPCapabilitiesChoiceResponse = this.airProtocolLLRPCapabilitiesChoiceResponse;
        this.put((ControlService)airProtocolLLRPCapabilitiesChoiceResponse);
        CommandMeasurement airProtocolLLRPCapabilities = this.airProtocolLLRPCapabilities;
        this.put((ControlService)airProtocolLLRPCapabilities);
        CommandMeasurement readerConfig = this.readerConfig;
        this.put((ControlService)readerConfig);
        SignalFieldSignal identificationResponse = this.identificationResponse;
        this.put((ControlService)identificationResponse);
        CommandMeasurement identification = this.identification;
        this.put((ControlService)identification);
        MeasurementFieldMeasurement identificationIDType = this.identificationIDType;
        this.put((ControlService)identificationIDType);
        MeasurementFieldMeasurement identificationReaderID = this.identificationReaderID;
        this.put((ControlService)identificationReaderID);
        SignalFieldSignal antennaPropertiesResponse = this.antennaPropertiesResponse;
        this.put((ControlService)antennaPropertiesResponse);
        CommandMeasurement antennaProperties = this.antennaProperties;
        this.put((ControlService)antennaProperties);
        SignalFieldSignal antennaConfigurationResponse = this.antennaConfigurationResponse;
        this.put((ControlService)antennaConfigurationResponse);
        CommandMeasurement antennaConfiguration = this.antennaConfiguration;
        this.put((ControlService)antennaConfiguration);
        SignalFieldSignal readerEventNotificationSpecResponse = this.readerEventNotificationSpecResponse;
        this.put((ControlService)readerEventNotificationSpecResponse);
        CommandMeasurement readerEventNotificationSpec = this.readerEventNotificationSpec;
        this.put((ControlService)readerEventNotificationSpec);
        MeasurementFieldMeasurement eventNotificationState = this.eventNotificationState;
        this.put((ControlService)eventNotificationState);
        SignalFieldSignal rOReportSpecResponse = this.rOReportSpecResponse;
        this.put((ControlService)rOReportSpecResponse);
        CommandMeasurement rOReportSpec = this.rOReportSpec;
        this.put((ControlService)rOReportSpec);
        MeasurementFieldMeasurement rOReportSpecROReportTrigger = this.rOReportSpecROReportTrigger;
        this.put((ControlService)rOReportSpecROReportTrigger);
        MeasurementFieldMeasurement rOReportSpecN = this.rOReportSpecN;
        this.put((ControlService)rOReportSpecN);
        MeasurementFieldMeasurement tagReportContentSelector = this.tagReportContentSelector;
        this.put((ControlService)tagReportContentSelector);
        MeasurementFieldMeasurement tagReportContentSelectorEnableROSpecID = this.tagReportContentSelectorEnableROSpecID;
        this.put((ControlService)tagReportContentSelectorEnableROSpecID);
        MeasurementFieldMeasurement tagReportContentSelectorEnableSpecIndex = this.tagReportContentSelectorEnableSpecIndex;
        this.put((ControlService)tagReportContentSelectorEnableSpecIndex);
        MeasurementFieldMeasurement tagReportContentSelectorEnableInventoryParameterSpecID = this.tagReportContentSelectorEnableInventoryParameterSpecID;
        this.put((ControlService)tagReportContentSelectorEnableInventoryParameterSpecID);
        MeasurementFieldMeasurement tagReportContentSelectorEnableAntennaID = this.tagReportContentSelectorEnableAntennaID;
        this.put((ControlService)tagReportContentSelectorEnableAntennaID);
        MeasurementFieldMeasurement tagReportContentSelectorEnableChannelIndex = this.tagReportContentSelectorEnableChannelIndex;
        this.put((ControlService)tagReportContentSelectorEnableChannelIndex);
        MeasurementFieldMeasurement tagReportContentSelectorEnablePeakRSSI = this.tagReportContentSelectorEnablePeakRSSI;
        this.put((ControlService)tagReportContentSelectorEnablePeakRSSI);
        MeasurementFieldMeasurement tagReportContentSelectorEnableFirstSeenTimestamp = this.tagReportContentSelectorEnableFirstSeenTimestamp;
        this.put((ControlService)tagReportContentSelectorEnableFirstSeenTimestamp);
        MeasurementFieldMeasurement tagReportContentSelectorEnableLastSeenTimestamp = this.tagReportContentSelectorEnableLastSeenTimestamp;
        this.put((ControlService)tagReportContentSelectorEnableLastSeenTimestamp);
        MeasurementFieldMeasurement tagReportContentSelectorEnableTagSeenCount = this.tagReportContentSelectorEnableTagSeenCount;
        this.put((ControlService)tagReportContentSelectorEnableTagSeenCount);
        MeasurementFieldMeasurement tagReportContentSelectorEnableAccessSpecID = this.tagReportContentSelectorEnableAccessSpecID;
        this.put((ControlService)tagReportContentSelectorEnableAccessSpecID);
        MeasurementFieldMeasurement airProtocolEPCMemorySelector = this.airProtocolEPCMemorySelector;
        this.put((ControlService)airProtocolEPCMemorySelector);
        SignalFieldSignal accessReportSpecResponse = this.accessReportSpecResponse;
        this.put((ControlService)accessReportSpecResponse);
        CommandMeasurement accessReportSpec = this.accessReportSpec;
        this.put((ControlService)accessReportSpec);
        MeasurementFieldMeasurement accessReportSpecAccessReportTrigger = this.accessReportSpecAccessReportTrigger;
        this.put((ControlService)accessReportSpecAccessReportTrigger);
        SignalFieldSignal lLRPConfigurationStateValueResponse = this.lLRPConfigurationStateValueResponse;
        this.put((ControlService)lLRPConfigurationStateValueResponse);
        CommandMeasurement readerConfigLLRPConfigurationStateValue = this.readerConfigLLRPConfigurationStateValue;
        this.put((ControlService)readerConfigLLRPConfigurationStateValue);
        MeasurementFieldMeasurement readerConfigLLRPConfigurationStateValueLLRPConfigurationStateValue = this.readerConfigLLRPConfigurationStateValueLLRPConfigurationStateValue;
        this.put((ControlService)readerConfigLLRPConfigurationStateValueLLRPConfigurationStateValue);
        SignalFieldSignal keepaliveSpecResponse = this.keepaliveSpecResponse;
        this.put((ControlService)keepaliveSpecResponse);
        CommandMeasurement keepaliveSpec = this.keepaliveSpec;
        this.put((ControlService)keepaliveSpec);
        MeasurementFieldMeasurement keepaliveSpecKeepaliveTriggerType = this.keepaliveSpecKeepaliveTriggerType;
        this.put((ControlService)keepaliveSpecKeepaliveTriggerType);
        MeasurementFieldMeasurement keepaliveSpecPeriodicTriggerValue = this.keepaliveSpecPeriodicTriggerValue;
        this.put((ControlService)keepaliveSpecPeriodicTriggerValue);
        SignalFieldSignal gPIPortCurrentStateResponse = this.gPIPortCurrentStateResponse;
        this.put((ControlService)gPIPortCurrentStateResponse);
        CommandMeasurement gPIPortCurrentState = this.gPIPortCurrentState;
        this.put((ControlService)gPIPortCurrentState);
        SignalFieldSignal gPOWriteDataResponse = this.gPOWriteDataResponse;
        this.put((ControlService)gPOWriteDataResponse);
        CommandMeasurement gPOWriteData = this.gPOWriteData;
        this.put((ControlService)gPOWriteData);
        SignalFieldSignal eventsAndReportsResponse = this.eventsAndReportsResponse;
        this.put((ControlService)eventsAndReportsResponse);
        CommandMeasurement eventsAndReports = this.eventsAndReports;
        this.put((ControlService)eventsAndReports);
        MeasurementFieldMeasurement eventsAndReportsHoldEventsAndReportsUponReconnect = this.eventsAndReportsHoldEventsAndReportsUponReconnect;
        this.put((ControlService)eventsAndReportsHoldEventsAndReportsUponReconnect);
        CommandMeasurement rospecs = this.rospecs;
        this.put((ControlService)rospecs);
        SignalFieldSignal rOSpecResponse = this.rOSpecResponse;
        this.put((ControlService)rOSpecResponse);
        CommandMeasurement rOSpec = this.rOSpec;
        this.put((ControlService)rOSpec);
        CommandMeasurement accessspecs = this.accessspecs;
        this.put((ControlService)accessspecs);
        SignalFieldSignal accessSpecResponse = this.accessSpecResponse;
        this.put((ControlService)accessSpecResponse);
        CommandMeasurement accessSpec = this.accessSpec;
        this.put((ControlService)accessSpec);
    }

    public void setup() {
        super.setup();
        this.setNotificationPriority(this.getInt("epcgloballlrpdevice.notificationpriority", this.getNotificationPriority()));
    }
}

