/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.config.servlet.capabilities;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.soda.dk.epcglobal.llrp.config.servlet.capabilities.IReaderCapabilities;

public class ReaderCapabilities
implements IReaderCapabilities {
    private static final String[] EXTRACT_ITEMS = new String[]{"GeneralDeviceCapabilitiesParameter", "LLRPCapabilitiesParameter", "AirProtocolLLRPCapabilitiesChoice"};
    private final Map capabilities = new HashMap();

    public ReaderCapabilities() {
        this(null);
    }

    public ReaderCapabilities(Map rawCapabilities) {
        if (rawCapabilities != null) {
            this.initialize(rawCapabilities);
        }
    }

    public Object getCapabilityValue(String key) {
        return this.capabilities.get(key);
    }

    public int getParameterMaxSupported(String paramId) {
        Integer max = null;
        if ("ROSpecParameter".equals(paramId)) {
            max = (Integer)this.capabilities.get("MaxNumROSpecs");
        } else if ("AccessSpecParameter".equals(paramId)) {
            max = (Integer)this.capabilities.get("MaxNumAccessSpecs");
        } else if ("SpecParameterChoice".equals(paramId)) {
            max = (Integer)this.capabilities.get("MaxNumSpecsPerROSpec");
        } else if ("InventoryParameterSpecParameter".equals(paramId)) {
            max = (Integer)this.capabilities.get("MaxNumInventoryParameterSpecsPerAISpec");
        } else if ("AccessCommandOpSpecChoice".equals(paramId)) {
            max = (Integer)this.capabilities.get("MaxNumOpSpecsPerAccessSpec");
        }
        if (max != null) {
            return max;
        }
        return 0;
    }

    private void initialize(Map rawCapabilities) {
        int i = 0;
        while (i < EXTRACT_ITEMS.length) {
            Map subCapabilities = (Map)rawCapabilities.get(EXTRACT_ITEMS[i]);
            if (subCapabilities != null) {
                this.capabilities.putAll(subCapabilities);
            }
            ++i;
        }
    }

    public boolean isParameterSupported(String paramId) {
        Boolean isSupported = Boolean.TRUE;
        if ("CustomParameter".equals(paramId)) {
            isSupported = Boolean.FALSE;
        } else if ("RFSurveySpecParameter".equals(paramId)) {
            isSupported = (Boolean)this.capabilities.get("CanDoRFSurvey");
        } else if ("C1G2BlockEraseParameter".equals(paramId)) {
            isSupported = (Boolean)this.capabilities.get("CanSupportBlockErase");
        } else if ("C1G2BlockWriteParameter".equals(paramId)) {
            isSupported = (Boolean)this.capabilities.get("CanSupportBlockWrite");
        }
        if (isSupported != null) {
            return isSupported;
        }
        return true;
    }
}

