/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.config.servlet.store;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.epcglobal.llrp.config.servlet.LLRPConfigConsole;
import org.eclipse.soda.dk.epcglobal.llrp.config.servlet.LLRPConfigServletConstants;
import org.eclipse.soda.dk.epcglobal.llrp.config.servlet.capabilities.IReaderCapabilities;
import org.eclipse.soda.dk.epcglobal.llrp.config.servlet.display.IDisplayElement;
import org.eclipse.soda.dk.epcglobal.llrp.config.servlet.display.ParameterDisplay;
import org.eclipse.soda.dk.epcglobal.llrp.config.servlet.display.ProfileDisplay;
import org.eclipse.soda.dk.epcglobal.llrp.config.servlet.display.ReaderDisplay;
import org.eclipse.soda.dk.epcglobal.llrp.config.servlet.store.LLRPDefStore;
import org.eclipse.soda.dk.epcglobal.llrp.helper.LLRPConfigParser;

public class LLRPConfigStore {
    private LLRPConfigConsole console;
    private Map configStore = new Hashtable();
    private Stack currentparameters = new Stack();
    private ReaderDisplay readerDisplay;

    public LLRPConfigStore(LLRPConfigConsole console) {
        this.console = console;
        this.addStandAlone();
    }

    public static Map getNewParamObj(String paramId) {
        Hashtable<String, Object> paramObj = new Hashtable<String, Object>();
        Map paramDef = LLRPDefStore.getParameterDef(paramId);
        List defItems = (List)paramDef.get("defitems");
        int i = 0;
        while (i < defItems.size()) {
            Map itemDef = (Map)defItems.get(i);
            String itemId = (String)itemDef.get("id");
            int itemType = (Integer)itemDef.get("type");
            switch (itemType) {
                case 0: 
                case 6: 
                case 8: {
                    paramObj.put(itemId, EscObject.createInteger((int)0));
                    break;
                }
                case 10: {
                    int variableLengthType = LLRPDefStore.getVariableLengthType(itemId);
                    if (variableLengthType != 11) break;
                    paramObj.put(itemId, new byte[0]);
                    break;
                }
                case 9: {
                    int listType = LLRPDefStore.getListType(itemId);
                    if (listType != 0) break;
                    ArrayList<Integer> valueList = new ArrayList<Integer>();
                    valueList.add(EscObject.createInteger((int)0));
                    paramObj.put(itemId, valueList);
                }
            }
            ++i;
        }
        return paramObj;
    }

    public synchronized void addReader(String readerPrefix, String readerId) {
        if (readerId == null || readerPrefix == null) {
            return;
        }
        Map readerMap = this.getReaderMap(readerPrefix);
        readerMap.put("id", readerId);
    }

    public synchronized Map addReaderProfile(String readerPrefix, String profileName) {
        Hashtable<String, String> profileMap = new Hashtable<String, String>();
        profileMap.put("ProfileName", profileName);
        this.getReaderProfilesList(readerPrefix).add(profileMap);
        return profileMap;
    }

    private synchronized void addStandAlone() {
        this.addReader("StandAlone", "StandAlone");
        this.addReaderProfile("StandAlone", "StandAlone");
        this.setReaderProfileConfigStr("StandAlone", "StandAlone", "");
    }

    protected void deleteElementFromCurrent(String elementPath) {
        ParameterDisplay currentDisplayElement = (ParameterDisplay)this.getCurrentDisplayElement();
        Map currentDisplayObj = (Map)currentDisplayElement.getParamObj();
        String elementId = ParameterDisplay.getParamId(elementPath);
        int elementSerialNo = ParameterDisplay.getSerialNo(elementPath);
        Object elementsValue = currentDisplayObj.get(elementId);
        if (elementsValue instanceof List) {
            ((List)elementsValue).remove(elementSerialNo);
            if (((List)elementsValue).size() == 0) {
                currentDisplayObj.remove(elementId);
            }
        } else {
            currentDisplayObj.remove(elementId);
        }
    }

    private int getActionNum(HttpServletRequest request) {
        String action = request.getParameter("Action");
        String reader_action = request.getParameter("ReaderAction");
        if (reader_action != null && reader_action.trim().length() > 0) {
            return Integer.parseInt(reader_action);
        }
        if (action != null && action.trim().length() > 0) {
            return Integer.parseInt(action);
        }
        return -1;
    }

    public Map getConfigStore() {
        return this.configStore;
    }

    protected LLRPConfigConsole getConsole() {
        return this.console;
    }

    public synchronized IDisplayElement getCurrentDisplayElement() {
        return (ParameterDisplay)this.getCurrentparametersStack().peek();
    }

    public String getCurrentProfile() {
        return this.getReaderDisplay().getCurrentProfile();
    }

    public String getCurrentReader() {
        return this.getReaderDisplay().getName();
    }

    protected Stack getCurrentparametersStack() {
        return this.currentparameters;
    }

    protected String getDefaultProfile(String readerPrefix) {
        if (readerPrefix == null) {
            return null;
        }
        int i = 0;
        while (i < LLRPConfigServletConstants.LLRP_PROFILES.length) {
            if (this.getReaderProfileMap(readerPrefix, LLRPConfigServletConstants.LLRP_PROFILES[i]) != null) {
                return LLRPConfigServletConstants.LLRP_PROFILES[i];
            }
            ++i;
        }
        return null;
    }

    protected String getDefaultReader() {
        List readers = this.getReaderPrefixs();
        if (readers == null || readers.size() == 0) {
            return null;
        }
        String defaultReader = (String)readers.get(0);
        return defaultReader;
    }

    protected List getHistoryChain() {
        ArrayList<String> historyChain = new ArrayList<String>();
        Stack currentparameters = this.getCurrentparametersStack();
        int i = currentparameters.size() - 1;
        while (i >= 0) {
            ParameterDisplay param = (ParameterDisplay)currentparameters.get(i);
            historyChain.add(param.getParamId());
            --i;
        }
        return historyChain;
    }

    public synchronized String getHtml(String servletPath) {
        if (this.readerDisplay == null) {
            String defaultReader = this.getDefaultReader();
            String defaultProfile = this.getDefaultProfile(defaultReader);
            if (defaultProfile != null) {
                this.readerDisplay = new ReaderDisplay(defaultReader, (Object)this, defaultProfile);
                this.selectProfile(defaultProfile);
            } else {
                return "Reader configuration has not been initialized.";
            }
        }
        return this.readerDisplay.getHtml(servletPath);
    }

    public synchronized IReaderCapabilities getReaderCapabilities(String readerPrefix) {
        return (IReaderCapabilities)this.getReaderMap(readerPrefix).get("ReaderCapabilities");
    }

    protected ReaderDisplay getReaderDisplay() {
        return this.readerDisplay;
    }

    public synchronized String getReaderId(String readerPrefix) {
        return (String)this.getReaderMap(readerPrefix).get("id");
    }

    public synchronized Map getReaderMap(String readerPrefix) {
        if (this.getConfigStore().get(readerPrefix) == null) {
            this.getConfigStore().put(readerPrefix, new Hashtable());
        }
        return (Map)this.getConfigStore().get(readerPrefix);
    }

    public synchronized List getReaderPrefixs() {
        ArrayList readerPrefixs = new ArrayList();
        Iterator prefixs = this.getConfigStore().keySet().iterator();
        while (prefixs.hasNext()) {
            readerPrefixs.add(prefixs.next());
        }
        return readerPrefixs;
    }

    public synchronized String getReaderProfileConfigStr(String readerPrefix, String profileName) {
        Map profileMap = this.getReaderProfileMap(readerPrefix, profileName);
        if (profileMap != null) {
            return (String)profileMap.get("ProfileConfigStr");
        }
        return null;
    }

    public synchronized Map getReaderProfileMap(String readerPrefix, String profileName) {
        List profilesList = this.getReaderProfilesList(readerPrefix);
        int i = 0;
        while (i < profilesList.size()) {
            Map profileMap = (Map)profilesList.get(i);
            String name = (String)profileMap.get("ProfileName");
            if (profileName.equals(name)) {
                return profileMap;
            }
            ++i;
        }
        return null;
    }

    public synchronized List getReaderProfileNamesList(String readerPrefix) {
        List profilesList = this.getReaderProfilesList(readerPrefix);
        ArrayList<String> profileNamesList = new ArrayList<String>();
        int i = 0;
        while (i < profilesList.size()) {
            Map profileMap = (Map)profilesList.get(i);
            String profileName = (String)profileMap.get("ProfileName");
            if (profileName != null) {
                profileNamesList.add(profileName);
            }
            ++i;
        }
        return profileNamesList;
    }

    public synchronized List getReaderProfilesList(String readerPrefix) {
        if (this.getReaderMap(readerPrefix).get("ProfileKey") == null) {
            this.getReaderMap(readerPrefix).put("ProfileKey", new ArrayList());
        }
        return (List)this.getReaderMap(readerPrefix).get("ProfileKey");
    }

    public void processParameterRequest(HttpServletRequest request) {
        ((ParameterDisplay)this.getCurrentDisplayElement()).clearComment();
        String path = request.getParameter("Path");
        int actionNum = this.getActionNum(request);
        if (actionNum == -1) {
            return;
        }
        switch (actionNum) {
            case 2: {
                int listType;
                Map currentParamObj = (Map)((ParameterDisplay)this.getCurrentDisplayElement()).getParamObj();
                String currentParamId = ((ParameterDisplay)this.getCurrentDisplayElement()).getParamId();
                String elementId = path;
                Map elementDef = LLRPDefStore.getParamElementDef(currentParamId, elementId);
                int elementType = (Integer)elementDef.get("type");
                if (3 == elementType) {
                    String maxOccurStr = (String)elementDef.get("occursmaximum");
                    int maxOccur = maxOccurStr.equals("n") ? -1 : Integer.valueOf(maxOccurStr);
                    Map newParamObj = LLRPConfigStore.getNewParamObj(elementId);
                    if (maxOccur > 1 || maxOccur == -1) {
                        List<Map> paramList = currentParamObj.get(elementId) != null ? (List)currentParamObj.get(elementId) : new ArrayList();
                        paramList.add(newParamObj);
                        currentParamObj.put(elementId, paramList);
                        this.selectParamFromCurrent(ParameterDisplay.addSerialNumToPath(ParameterDisplay.getElementPath(elementId), paramList.size() - 1));
                        break;
                    }
                    currentParamObj.put(elementId, newParamObj);
                    this.selectParamFromCurrent(elementId);
                    break;
                }
                if (4 == elementType) {
                    String choiceId = path;
                    String paramId = request.getParameter(choiceId);
                    Map newParamObj = LLRPConfigStore.getNewParamObj(paramId);
                    Hashtable<String, Map> newChoiceObj = new Hashtable<String, Map>();
                    newChoiceObj.put(paramId, newParamObj);
                    List<Hashtable<String, Map>> paramList = currentParamObj.get(choiceId) != null ? (List)currentParamObj.get(choiceId) : new ArrayList();
                    paramList.add(newChoiceObj);
                    currentParamObj.put(choiceId, paramList);
                    this.selectParamFromCurrentChoice(ParameterDisplay.addSerialNumToPath(ParameterDisplay.getElementPath(choiceId, paramId), paramList.size() - 1));
                    break;
                }
                if (9 != elementType || (listType = LLRPDefStore.getListType(elementId)) != 0) break;
                List<Integer> intList = currentParamObj.get(elementId) != null ? (List)currentParamObj.get(elementId) : new ArrayList();
                intList.add(EscObject.createInteger((int)0));
                currentParamObj.put(elementId, intList);
                break;
            }
            case 4: {
                if (!ParameterDisplay.isChoiceParamPath(path)) {
                    this.selectParamFromCurrent(path);
                    break;
                }
                this.selectParamFromCurrentChoice(path);
                break;
            }
            case 3: {
                this.deleteElementFromCurrent(path);
                break;
            }
            case 5: {
                int backLevel = Integer.parseInt(path);
                this.selectParamFromHistoryChain(backLevel);
                break;
            }
            case 15: {
                ((ParameterDisplay)this.getCurrentDisplayElement()).setParamValues(request);
                break;
            }
            case 1: {
                boolean isValueValid = ((ParameterDisplay)this.getCurrentDisplayElement()).setParamValues(request);
                if (!isValueValid) break;
                this.selectParamFromHistoryChain(1);
                break;
            }
            case 6: {
                this.selectParamFromHistoryChain(1);
                break;
            }
            case 9: {
                ((ProfileDisplay)this.getCurrentDisplayElement()).reset();
                break;
            }
            case 13: {
                ((ProfileDisplay)this.getCurrentDisplayElement()).importConfigStr(request.getParameter("configStr"));
                break;
            }
            case 8: {
                boolean isParamComplete = ((ProfileDisplay)this.getCurrentDisplayElement()).isValidSubparameters();
                if (isParamComplete) {
                    String configStr = ((ProfileDisplay)this.getCurrentDisplayElement()).getConfigStr();
                    if (configStr == null || configStr.length() <= 0) break;
                    this.getConsole().sendLLRPConfiguration(this.getCurrentProfile(), this.getCurrentReader(), configStr);
                    break;
                }
                ((ProfileDisplay)this.getCurrentDisplayElement()).addCommentTitle("Fail to send, missing parameter(s):");
                break;
            }
            case 10: {
                this.selectReader(request.getParameter("ReaderId"));
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                String profileName = request.getParameter("Profile");
                this.selectProfile(profileName);
                break;
            }
            case 14: {
                ((ProfileDisplay)this.getCurrentDisplayElement()).processRequest(request);
            }
        }
    }

    public void processRequest(HttpServletRequest request) {
        if (this.getCurrentparametersStack().size() == 0) {
            return;
        }
        this.processParameterRequest(request);
    }

    public void selectParamFromCurrent(String parameterPath) {
        ParameterDisplay currentDisplayElement = (ParameterDisplay)this.getCurrentDisplayElement();
        Map currentDisplayObj = (Map)currentDisplayElement.getParamObj();
        List currentHistoryChain = this.getHistoryChain();
        String paramId = ParameterDisplay.getParamId(parameterPath);
        int parameterserialNo = ParameterDisplay.getSerialNo(parameterPath);
        Object paramObj = currentDisplayObj.get(paramId);
        if (paramObj instanceof List && parameterserialNo != -1) {
            this.getCurrentparametersStack().push(new ParameterDisplay(paramId, ((List)paramObj).get(parameterserialNo), currentHistoryChain, this.getReaderCapabilities(this.getCurrentReader())));
        } else {
            this.getCurrentparametersStack().push(new ParameterDisplay(paramId, paramObj, currentHistoryChain, this.getReaderCapabilities(this.getCurrentReader())));
        }
    }

    public void selectParamFromCurrentChoice(String parameterPath) {
        ParameterDisplay currentDisplayElement = (ParameterDisplay)this.getCurrentDisplayElement();
        Map currentDisplayObj = (Map)currentDisplayElement.getParamObj();
        List currentHistoryChain = this.getHistoryChain();
        String choiceParamPath = ParameterDisplay.getParamId(parameterPath);
        int parameterserialNo = ParameterDisplay.getSerialNo(parameterPath);
        String choiceId = ParameterDisplay.getChoiceId(choiceParamPath);
        String paramId = ParameterDisplay.getChoiceParamId(choiceParamPath);
        Object paramObj = ((Map)((List)currentDisplayObj.get(choiceId)).get(parameterserialNo)).get(paramId);
        this.getCurrentparametersStack().push(new ParameterDisplay(paramId, paramObj, currentHistoryChain, this.getReaderCapabilities(this.getCurrentReader())));
    }

    public void selectParamFromHistoryChain(int backNum) {
        int i = 0;
        while (i < backNum) {
            this.getCurrentparametersStack().pop();
            ++i;
        }
    }

    public void selectProfile(String profileName) {
        this.getCurrentparametersStack().clear();
        this.getReaderDisplay().setCurrentProfile(profileName);
        ProfileDisplay profileDisplay = new ProfileDisplay(profileName, (Object)this.getReaderProfileMap(this.getCurrentReader(), profileName), this.getReaderCapabilities(this.getCurrentReader()));
        this.getCurrentparametersStack().push(profileDisplay);
    }

    public void selectReader(String readerPrefix) {
        this.getReaderDisplay().setName(readerPrefix);
        this.selectProfile(this.getDefaultProfile(readerPrefix));
    }

    public synchronized void setReaderCapabilities(String readerPrefix, IReaderCapabilities readerCapabilities) {
        this.getReaderMap(readerPrefix).put("ReaderCapabilities", readerCapabilities);
    }

    public synchronized void setReaderProfileConfigStr(String readerPrefix, String profileName, String configStr) {
        Map profileMap = this.getReaderProfileMap(readerPrefix, profileName);
        if (profileMap == null) {
            profileMap = this.addReaderProfile(readerPrefix, profileName);
        }
        if (configStr != null) {
            profileMap.put("ProfileConfigStr", configStr);
            profileMap.put("ProfileParameters", LLRPConfigParser.parseConfig((String)configStr));
        }
    }
}

