/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.tk.conn.echo;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.soda.dk.core.EscObject;

public class EchoJni {
    private String portName = "";
    private int osHandle;

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.loadLibrary(EscObject.getLoadLibraryName((String)"dkecho"));
                return null;
            }
        });
    }

    public void close() throws IOException {
        try {
            this.ensureOpen();
        }
        catch (IOException iOException) {
            return;
        }
        this.nativeClose(this.osHandle);
        this.osHandle = -1;
    }

    protected void ensureOpen() throws IOException {
        if (this.isClosed()) {
            throw new IOException("port " + this.portName + " is not open.");
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {}
    }

    public String getPortName() {
        return this.portName;
    }

    public boolean isClosed() {
        return -1 == this.osHandle;
    }

    private native void nativeClose(int var1) throws IOException;

    private native int nativeOpen(String var1) throws IOException;

    private native int nativeRead(int var1, byte[] var2, int var3, int var4) throws IOException;

    private native int nativeWrite(int var1, byte[] var2, int var3, int var4) throws IOException;

    public void open(String portName) throws IOException {
        this.portName = portName;
        this.osHandle = this.nativeOpen(portName);
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        this.ensureOpen();
        int rc = this.nativeRead(this.osHandle, buffer, offset, length);
        return rc;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("Echo(");
        buffer.append(this.portName);
        buffer.append("; ");
        buffer.append(this.isClosed() ? "closed" : "open");
        buffer.append(')');
        return buffer.toString();
    }

    public int write(byte[] buffer, int offset, int length) throws IOException {
        this.ensureOpen();
        int rc = this.nativeWrite(this.osHandle, buffer, offset, length);
        return rc;
    }
}

