/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.measurement;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.soda.dk.device.Control;
import org.eclipse.soda.dk.measurement.MeasurementListeners;
import org.eclipse.soda.dk.measurement.service.MeasurementListener;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.measurement.service.MultiplexMeasurementListener;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.units.service.UnitsService;

public class Measurement
extends Control
implements MeasurementService {
    private MeasurementListener measurementListener;
    private Object value;
    private Object timestamp;

    public Measurement(String key) {
        this(key, null);
    }

    public Measurement(String key, Object value) {
        super(key);
        this.setValue(null, value, Measurement.getCurrentTimestamp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMeasurementListener(Collection channels, MeasurementListener measurementListener) {
        this.addMeasurementListener(measurementListener);
        if (measurementListener != null) {
            Collection collection = channels;
            synchronized (collection) {
                Iterator iterator = channels.iterator();
                while (iterator.hasNext()) {
                    ChannelService channel = (ChannelService)iterator.next();
                    Object newValue = this.getValue(channel);
                    if (newValue == null) continue;
                    this.fireValueChanged(measurementListener, this.getTimestamp(channel), channel, newValue, null);
                }
            }
        }
    }

    public synchronized void addMeasurementListener(MeasurementListener measurementListener) {
        if (measurementListener != null) {
            this.setMeasurementListener(MeasurementListeners.add(this.getMeasurementListener(), measurementListener));
            Object newValue = this.getValue(null);
            if (newValue != null) {
                this.fireValueChanged(measurementListener, this.getTimestamp(), null, newValue, null);
            }
        }
    }

    public void executeRead() {
        this.executeRead(null);
    }

    public void executeRead(ChannelService channel) {
    }

    public void executeWrite(ChannelService channel, Object value) {
        this.setValue(channel, value);
    }

    public void executeWrite(Object value) {
        this.executeWrite(null, value);
    }

    protected void fireErrorOccurred(MeasurementListener measurementListener, Object timestamp, Object data) {
        try {
            measurementListener.errorOccurred((Object)this, timestamp, data);
        }
        catch (RuntimeException exception) {
            this.log(exception, 1);
        }
    }

    public void fireErrorOccurred(Object timestamp, Object data) {
        MeasurementListener measurementListener = this.getMeasurementListener();
        if (measurementListener != null) {
            this.fireErrorOccurred(measurementListener, Measurement.getCurrentTimestamp(), data);
        }
    }

    public void fireValueChanged(MeasurementListener measurementListener, Object timestamp, ChannelService channel, Object newValue, Object oldValue) {
        try {
            if (measurementListener instanceof MultiplexMeasurementListener || channel != null) {
                ((MultiplexMeasurementListener)measurementListener).measurementChanged((MeasurementService)this, timestamp, channel, newValue, oldValue);
            } else {
                measurementListener.measurementChanged((MeasurementService)this, timestamp, newValue, oldValue);
            }
        }
        catch (RuntimeException exception) {
            this.handleError(exception, 1);
        }
    }

    public void fireValueChanged(MeasurementListener measurementListener, Object timestamp, Object newValue, Object oldValue) {
        this.fireValueChanged(measurementListener, timestamp, null, newValue, oldValue);
    }

    public MeasurementListener getMeasurementListener() {
        return this.measurementListener;
    }

    public Object getTimestamp() {
        return this.getTimestamp(null);
    }

    public Object getTimestamp(ChannelService channel) {
        if (channel == null) {
            return this.timestamp;
        }
        Object timestamp = channel.getChannelData().get(this.getTimestampKey());
        return timestamp == null ? this.timestamp : timestamp;
    }

    public String getTimestampKey() {
        return String.valueOf(this.getKey()) + '#';
    }

    public UnitsService getUnits() {
        return null;
    }

    public Object getValue() {
        return this.getValue(null);
    }

    public Object getValue(ChannelService channel) {
        return this.getValueRaw(channel);
    }

    public Object getValueRaw() {
        return this.getValueRaw(null);
    }

    public Object getValueRaw(ChannelService channel) {
        if (channel == null) {
            return this.value;
        }
        Object value = channel.getChannelData().get(this.getKey());
        return value == null ? this.value : value;
    }

    public Object read(ChannelService channel, long timeout) throws RuntimeException {
        return this.getValue(channel);
    }

    public Object read(long timeout) {
        return this.read(null, timeout);
    }

    public synchronized void removeMeasurementListener(MeasurementListener measurementListener) {
        this.setMeasurementListener(MeasurementListeners.remove(this.getMeasurementListener(), measurementListener));
    }

    protected void reportError(int errorNumber, Throwable error, Object[] errorObjects) throws RuntimeException {
        super.reportError(errorNumber, error, errorObjects);
        MeasurementListener measurementListener = this.getMeasurementListener();
        if (measurementListener != null) {
            this.fireErrorOccurred(measurementListener, Measurement.getCurrentTimestamp(), error);
        }
    }

    public void setMeasurementListener(MeasurementListener measurementListener) {
        this.measurementListener = measurementListener;
    }

    protected void setRawValue(ChannelService channel, Object data, Object timestamp) {
        this.setValue(channel, data, timestamp);
    }

    protected void setRawValue(Object data, Object timestamp) {
        this.setRawValue(null, data, timestamp);
    }

    public void setTimestamp(ChannelService channel, Object timestamp) {
        if (channel == null) {
            if (this.timestamp != timestamp) {
                this.timestamp = timestamp;
            } else {
                long time = 0L;
                time = timestamp instanceof Number ? ((Number)timestamp).longValue() : System.currentTimeMillis();
                this.timestamp = new Long(time);
            }
        } else {
            String key;
            Map channelData = channel.getChannelData();
            Object oldTimestamp = channelData.get(key = this.getTimestampKey());
            if (oldTimestamp != timestamp) {
                channelData.put(key, timestamp);
            } else {
                long time = 0L;
                time = timestamp instanceof Number ? ((Number)timestamp).longValue() : System.currentTimeMillis();
                channelData.put(key, new Long(time));
            }
        }
    }

    public void setTimestamp(Object timestamp) {
        this.setTimestamp(null, timestamp);
    }

    public void setValue(ChannelService channel, Object value) {
        this.setValue(channel, value, Measurement.getCurrentTimestamp());
    }

    public void setValue(ChannelService channel, Object value, Object timestamp) {
        Object oldValue;
        Map channelData;
        String key = this.getKey();
        if (channel == null) {
            channelData = null;
            oldValue = this.value;
        } else {
            channelData = channel.getChannelData();
            oldValue = channelData.get(key);
            if (oldValue == null) {
                oldValue = this.value;
            }
        }
        if (this.equalsValue(oldValue, value)) {
            this.setTimestamp(channel, timestamp);
        } else {
            if (channelData == null) {
                this.value = value;
            } else {
                channelData.put(key, value);
            }
            this.setTimestamp(channel, timestamp);
            MeasurementListener measurementListener = this.getMeasurementListener();
            if (measurementListener != null) {
                this.fireValueChanged(measurementListener, timestamp, channel, value, oldValue);
            }
        }
    }

    public void setValue(Object value) {
        this.setValue(null, value);
    }

    public void setValue(Object value, Object timestamp) {
        this.setValue(null, value, timestamp);
    }
}

