/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transform;

import org.eclipse.soda.dk.data.IntegerFraction;
import org.eclipse.soda.dk.data.Numeric;
import org.eclipse.soda.dk.transform.Transform;
import org.eclipse.soda.dk.transform.service.TransformService;

public class IntegerScaleTransform
extends Transform
implements TransformService {
    private Number numerator;

    public IntegerScaleTransform(int numerator) throws IllegalArgumentException {
        if (numerator == 0) {
            throw new IllegalArgumentException(String.valueOf(numerator));
        }
        this.numerator = IntegerScaleTransform.createInteger(numerator);
    }

    public Object decode(Object value) throws ClassCastException {
        if (value instanceof Numeric) {
            return ((Numeric)value).multiply(this.getNumerator());
        }
        return IntegerScaleTransform.createInteger(((Number)value).intValue() * this.getNumerator().intValue());
    }

    public Object encode(Object value) throws ClassCastException {
        if (value instanceof Numeric) {
            return ((Numeric)value).divide(this.getNumerator());
        }
        int numerator = this.getNumerator().intValue();
        int intValue = ((Number)value).intValue();
        if (intValue % numerator == 0) {
            return IntegerScaleTransform.createInteger(intValue / numerator);
        }
        return new IntegerFraction(intValue, numerator);
    }

    public Number getNumerator() {
        return this.numerator;
    }
}

