/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transform;

import org.eclipse.soda.dk.transform.Transform;
import org.eclipse.soda.dk.transform.service.TransformService;

public class IntegerDivideTransform
extends Transform
implements TransformService {
    private int denominator;

    public IntegerDivideTransform(int denominator) throws IllegalArgumentException {
        if (denominator == 0) {
            throw new IllegalArgumentException(String.valueOf(denominator));
        }
        this.denominator = denominator;
    }

    public Object decode(Object value) throws ClassCastException {
        return IntegerDivideTransform.createInteger(((Number)value).intValue() / this.getDenominator());
    }

    public Object encode(Object value) throws ClassCastException {
        return IntegerDivideTransform.createInteger(((Number)value).intValue() * this.getDenominator());
    }

    public int getDenominator() {
        return this.denominator;
    }
}

