/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter;

import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.ParameterCursor;
import org.eclipse.soda.dk.parameter.service.ParameterCursorService;
import org.eclipse.soda.dk.parameter.service.ParameterService;

public class ComplexStreamParameter
extends EscObject {
    protected ParameterService[] parameters;
    protected String key;

    public ComplexStreamParameter(String key, ParameterService[] parameters) {
        this.setKey(key);
        this.setParameters(parameters);
    }

    protected Object decodeMessage(MessageService message, ParameterCursorService cursor) {
        ParameterCursorService tcursor = cursor != null ? cursor : new ParameterCursor();
        Object result = message;
        int length = this.parameters.length;
        int index = 0;
        while (index < length) {
            ParameterService parameter = this.parameters[index];
            Object tresult = parameter.decodeValue(message, tcursor);
            if (!parameter.isConstantParameter()) {
                result = tresult;
            }
            ++index;
        }
        return result;
    }

    public MessageService encodeMessage(MessageService message, Object value, int offset, ParameterCursorService cursor) {
        ParameterCursorService tcursor = cursor != null ? cursor : new ParameterCursor();
        MessageService resultMessage = message;
        int length = this.parameters.length;
        int index = 0;
        while (index < length) {
            ParameterService parameter = this.parameters[index];
            resultMessage = parameter.encodeValue(resultMessage, value, tcursor);
            ++index;
        }
        return resultMessage;
    }

    public String getKey() {
        return this.key;
    }

    public ParameterService[] getParameters() {
        return this.parameters;
    }

    public boolean isConstantParameter() {
        int length = this.parameters.length;
        int index = 0;
        while (index < length) {
            ParameterService parameter = this.parameters[index];
            if (!parameter.isConstantParameter()) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setParameters(ParameterService[] parameters) {
        this.parameters = parameters;
    }
}

