/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter;

import java.util.Map;
import org.eclipse.soda.dk.parameter.BytesParameter;
import org.eclipse.soda.dk.parameter.service.ParameterCursorService;

public class BitsParameter
extends BytesParameter {
    private int length = Integer.MAX_VALUE;
    private int offset = Integer.MAX_VALUE;

    public BitsParameter(String key) {
        super(key);
    }

    public BitsParameter() {
    }

    public BitsParameter(String key, int length) {
        super(key);
        this.setLength(length);
    }

    public BitsParameter(String key, int offset, int length) {
        super(key);
        this.setOffset(offset);
        this.setLength(length);
    }

    public String dataToString(Object data) {
        return data.toString();
    }

    public Object decodeBytes(byte[] container, ParameterCursorService cursor) {
        int length = this.getLength(cursor);
        if ((length & 7) == 0) {
            return super.decodeBytes(container, cursor);
        }
        boolean[] bits = new boolean[length];
        int offset = this.getOffsetAbsolute(cursor);
        int i = 0;
        while (i < length) {
            long value = BitsParameter.getUnsignedLong(container, offset + i, 1);
            bits[i] = value == 1L;
            ++i;
        }
        return bits;
    }

    public byte[] encodeBytes(byte[] bytes, Object data, ParameterCursorService cursor) {
        Object value = data;
        if (data instanceof Map) {
            Map map = (Map)data;
            String key = this.getKey();
            if (key != null && key.length() > 0 && (value = map.get(key)) == null) {
                value = data;
            }
        }
        if (data instanceof byte[]) {
            byte[] byteData = (byte[])data;
            byte[] result = super.encodeBytes(bytes, byteData, cursor);
            return result;
        }
        return bytes;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }
}

