/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.ParameterCursor;
import org.eclipse.soda.dk.parameter.service.ParameterCursorService;
import org.eclipse.soda.dk.parameter.service.ParameterService;

public class BaseParameter
extends EscObject
implements ParameterService {
    public static final int[] BIT_MASKS = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
    public static final int[] MASKS = new int[]{255, 127, 63, 31, 15, 7, 3, 1};
    public static final int[] SET_MASKS;
    public static final int[] SET_TOP_MASKS;

    static {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 7;
        nArray[4] = 15;
        nArray[5] = 31;
        nArray[6] = 63;
        nArray[7] = 127;
        SET_MASKS = nArray;
        SET_TOP_MASKS = new int[]{128, 192, 224, 240, 248, 252, 254, 255};
    }

    public static byte[] expand(byte[] bytes, int offset, int length) {
        return BaseParameter.expand(bytes, bytes.length << 3, offset, length);
    }

    public static byte[] expand(byte[] bytes, int bytesLength, int offset, int length) {
        int upperLength;
        int newSize = Math.max(offset + length + 7 >> 3, bytesLength + length + 7 >> 3);
        int index = offset + 7 >> 3;
        int size = length + 7 >> 3;
        byte[] returnBytes = bytes;
        if (newSize > bytes.length) {
            if ((offset & 7) == 0 && (length & 7) == 0) {
                returnBytes = new byte[Math.max(size + bytes.length, size + index) << 2];
                if (index > bytes.length) {
                    System.arraycopy(bytes, 0, returnBytes, 0, bytes.length);
                } else {
                    System.arraycopy(bytes, 0, returnBytes, 0, index);
                    int endSize = bytes.length - index;
                    System.arraycopy(bytes, index, returnBytes, size + index, endSize);
                }
                return returnBytes;
            }
            returnBytes = new byte[newSize << 2];
            int moffset = offset;
            if (offset > bytes.length << 3) {
                moffset = bytes.length << 3;
            }
            BaseParameter.setBytes(returnBytes, 0, moffset, bytes);
        }
        if ((upperLength = bytesLength - offset) > 0) {
            byte[] upperBytes = BaseParameter.getBytes(bytes, offset, upperLength);
            BaseParameter.setBytes(returnBytes, offset + length, upperLength, upperBytes);
        }
        return returnBytes;
    }

    public static final int getAbsoluteOffset(int offset) {
        int ioffset = offset >= 0 ? offset : -offset;
        return ioffset;
    }

    public static byte[] getBytes(byte[] bytes, int offset, int length) {
        int ioffset = BaseParameter.getAbsoluteOffset(offset);
        int resultsLength = length + 7 >> 3;
        byte[] results = new byte[resultsLength];
        if ((ioffset & 7) == 0) {
            System.arraycopy(bytes, ioffset >> 3, results, 0, resultsLength);
            int bitOffset = length & 7;
            if (bitOffset != 0) {
                results[resultsLength - 1] = (byte)(results[resultsLength - 1] & SET_TOP_MASKS[bitOffset - 1]);
            }
        } else if (length <= 64) {
            long value = BaseParameter.getUnsignedLong(bytes, ioffset, length);
            BaseParameter.setBits(results, 0, length, value);
        } else {
            int count = length + 63 >> 6;
            int toffset = ioffset;
            int tnewOffset = 0;
            int i = 0;
            while (i < count) {
                int tlength = length - (i << 6);
                if (tlength > 64) {
                    tlength = 64;
                }
                long value = BaseParameter.getUnsignedLong(bytes, toffset, tlength);
                BaseParameter.setBits(results, tnewOffset, tlength, value);
                tnewOffset += 64;
                toffset += 64;
                tlength = length - (i << 6);
                ++i;
            }
        }
        return results;
    }

    public static short getDefaultStyle() {
        return 0;
    }

    public static long getLittleEndianLong(byte[] bytes, int offset, int length) {
        int size;
        int ioffset = BaseParameter.getAbsoluteOffset(offset);
        long result = 0L;
        int index = ioffset >> 3;
        boolean negative = false;
        if ((offset & 7) == 0 && (length & 7) == 0) {
            size = length >> 3;
            int i = size - 1;
            while (i >= 0) {
                result = (result << 8) + (long)(bytes[index + i] & 0xFF);
                if (size - 1 == i) {
                    negative = bytes[index + i] < 0;
                }
                --i;
            }
        } else {
            size = length + 7 >> 3;
            byte[] dbytes = BaseParameter.getBytes(bytes, offset, length);
            int i = size - 1;
            while (i >= 0) {
                result = (result << 8) + (long)(dbytes[index + i] & 0xFF);
                if (size - 1 == i) {
                    negative = dbytes[index + i] < 0;
                }
                --i;
            }
        }
        if (negative) {
            int deltaShift = 64 - length;
            if (deltaShift > 0) {
                result <<= deltaShift;
                result >>= deltaShift;
            }
            return result;
        }
        return result;
    }

    public static long getLong(byte[] bytes, int offset, int length) {
        int ioffset = BaseParameter.getAbsoluteOffset(offset);
        long result = 0L;
        int index = ioffset >> 3;
        boolean negative = false;
        if ((ioffset & 7) == 0 && (length & 7) == 0) {
            int size = length >> 3;
            if (size > 0) {
                negative = (result = (long)bytes[index++]) < 0L;
                result &= 0xFFL;
                --size;
                while (size > 0) {
                    result <<= 8;
                    result += (long)(bytes[index++] & 0xFF);
                    --size;
                }
            }
        } else {
            int currentOffset = ioffset;
            int currentLength = length;
            boolean first = true;
            while (currentLength > 0) {
                int currentBit = currentOffset & 7;
                int shiftAmount = 8 - currentBit;
                byte byteValue = bytes[index++];
                if (first) {
                    negative = (byteValue & BIT_MASKS[currentBit]) != 0;
                    first = false;
                }
                int value = byteValue & MASKS[currentBit];
                int shiftEnd = shiftAmount - currentLength;
                if (shiftEnd > 0) {
                    shiftAmount -= shiftEnd;
                    value >>= shiftEnd;
                }
                result = (result << shiftAmount) + (long)value;
                currentOffset += shiftAmount;
                currentLength -= shiftAmount;
            }
        }
        if (negative) {
            int deltaShift = 64 - length;
            if (deltaShift > 0) {
                result <<= deltaShift;
                result >>= deltaShift;
            }
            return result;
        }
        return result;
    }

    public static int getUnsignedInteger(byte[] bytes, int offset, int length) {
        int ioffset = BaseParameter.getAbsoluteOffset(offset);
        int index = ioffset >> 3;
        if ((ioffset & 7) == 0 && (length & 7) == 0) {
            int result = 0;
            int size = length >> 3;
            while (size > 0) {
                result <<= 8;
                result += bytes[index++] & 0xFF;
                --size;
            }
            return result;
        }
        long result = 0L;
        int currentOffset = ioffset;
        int currentLength = length;
        while (currentLength > 0) {
            int currentBit = currentOffset & 7;
            int shiftAmount = 8 - currentBit;
            int value = bytes[index++] & MASKS[currentBit];
            int shiftEnd = shiftAmount - currentLength;
            if (shiftEnd > 0) {
                shiftAmount -= shiftEnd;
                value >>= shiftEnd;
            }
            result = (result << shiftAmount) + (long)value;
            currentOffset += shiftAmount;
            currentLength -= shiftAmount;
        }
        return (int)result;
    }

    public static long getUnsignedLittleEndianLong(byte[] bytes, int offset, int length) {
        int ioffset = BaseParameter.getAbsoluteOffset(offset);
        long result = 0L;
        int index = ioffset >> 3;
        if ((ioffset & 7) == 0 && (length & 7) == 0) {
            int size = length >> 3;
            int i = 0;
            while (i < size) {
                result = (result << 8) + (long)(bytes[index + i] & 0xFF);
                ++i;
            }
        } else {
            int currentOffset = ioffset;
            int currentLength = length;
            while (currentLength > 0) {
                int currentBit = currentOffset & 7;
                int shiftAmount = 8 - currentBit;
                int value = bytes[index++] & MASKS[currentBit];
                int shiftEnd = shiftAmount - currentLength;
                if (shiftEnd > 0) {
                    shiftAmount -= shiftEnd;
                    value >>= shiftEnd;
                }
                result = (result << shiftAmount) + (long)value;
                currentOffset += shiftAmount;
                currentLength -= shiftAmount;
            }
        }
        return result;
    }

    public static long getUnsignedLittleEngianLong(byte[] bytes, int offset, int length) {
        return BaseParameter.getUnsignedLittleEndianLong(bytes, offset, length);
    }

    public static long getUnsignedLong(byte[] bytes, int offset, int length) {
        int ioffset = BaseParameter.getAbsoluteOffset(offset);
        long result = 0L;
        int index = ioffset >> 3;
        if ((ioffset & 7) == 0 && (length & 7) == 0) {
            int size = length >> 3;
            while (size > 0) {
                result <<= 8;
                result += (long)(bytes[index++] & 0xFF);
                --size;
            }
        } else {
            int currentOffset = ioffset;
            int currentLength = length;
            while (currentLength > 0) {
                int currentBit = currentOffset & 7;
                int shiftAmount = 8 - currentBit;
                int value = bytes[index++] & MASKS[currentBit];
                int shiftEnd = shiftAmount - currentLength;
                if (shiftEnd > 0) {
                    shiftAmount -= shiftEnd;
                    value >>= shiftEnd;
                }
                result = (result << shiftAmount) + (long)value;
                currentOffset += shiftAmount;
                currentLength -= shiftAmount;
            }
        }
        return result;
    }

    public static byte[] setBits(byte[] bytes, int bytesLength, int offset, int length, long value, boolean insert) {
        if (offset < 0) {
            throw new IllegalArgumentException(String.valueOf(offset));
        }
        byte[] tbytes = bytes;
        if (insert) {
            tbytes = BaseParameter.expand(bytes, bytesLength, offset, length);
        }
        long currentValue = value;
        int currentOffset = offset + length - 1;
        int currentLength = length;
        int index = currentOffset >> 3;
        while (currentLength > 0) {
            int currentBit = currentOffset & 7;
            int shiftAmount = currentBit + 1;
            int tvalue = tbytes[index];
            int mask = SET_MASKS[7 - currentBit];
            int startBit = currentBit - currentLength;
            if (startBit >= 0) {
                mask |= SET_TOP_MASKS[startBit];
            }
            tvalue &= mask;
            int newValue = (int)(currentValue & (long)MASKS[7 - currentBit]);
            int extraShift = 8 - shiftAmount;
            if (extraShift > 0) {
                newValue <<= extraShift;
            }
            currentValue >>>= shiftAmount;
            tbytes[index--] = (byte)(tvalue | newValue);
            currentOffset -= shiftAmount;
            currentLength -= shiftAmount;
        }
        return tbytes;
    }

    public static byte[] setBits(byte[] bytes, int offset, int length, long value) {
        boolean insert = offset < 0;
        return BaseParameter.setBits(bytes, BaseParameter.getAbsoluteOffset(offset), length, value, insert);
    }

    public static byte[] setBits(byte[] bytes, int offset, int length, long value, boolean insert) {
        return BaseParameter.setBits(bytes, bytes.length << 3, offset, length, value, insert);
    }

    public static byte[] setBitsLittleEngian(byte[] bytes, int bytesLength, int offset, int length, long value, boolean insert) {
        if (offset < 0) {
            throw new IllegalArgumentException(String.valueOf(offset));
        }
        byte[] tbytes = bytes;
        if (insert) {
            tbytes = BaseParameter.expand(bytes, bytesLength, offset, length);
        }
        long currentValue = value;
        int currentOffset = offset;
        int currentLength = length;
        int index = offset >> 3;
        while (currentLength > 0) {
            int currentBit = currentOffset & 7;
            int shiftAmount = 8 - currentBit;
            int tvalue = tbytes[index];
            int mask = SET_MASKS[currentBit];
            int startBit = currentBit - currentLength;
            if (startBit >= 0) {
                mask |= SET_TOP_MASKS[startBit];
            }
            tvalue &= mask;
            int newValue = (int)(currentValue & (long)MASKS[currentBit]);
            int extraShift = 8 - shiftAmount;
            if (extraShift > 0) {
                newValue <<= extraShift;
            }
            currentValue >>>= shiftAmount;
            tbytes[index++] = (byte)(tvalue | newValue);
            currentOffset += shiftAmount;
            currentLength -= shiftAmount;
        }
        return tbytes;
    }

    public static byte[] setBytes(byte[] bytes, int offset, int length, byte[] data) {
        boolean insert = offset < 0;
        return BaseParameter.setBytes(bytes, BaseParameter.getAbsoluteOffset(offset), length, data, insert);
    }

    public static byte[] setBytes(byte[] bytes, int offset, int length, byte[] data, boolean insert) {
        return BaseParameter.setBytes(bytes, bytes.length << 3, offset, length, data, insert);
    }

    public static byte[] setBytes(byte[] bytes, int bytesLength, int offset, int length, byte[] data, boolean insert) {
        if (offset < 0) {
            throw new IllegalArgumentException(String.valueOf(offset));
        }
        byte[] tbytes = bytes;
        if (insert) {
            tbytes = BaseParameter.expand(bytes, bytesLength, offset, length);
        }
        if ((offset & 7) == 0 && (length & 7) == 0) {
            System.arraycopy(data, 0, tbytes, offset >> 3, length >> 3);
        } else if (length <= 64) {
            long value = BaseParameter.getUnsignedLong(data, 0, length);
            tbytes = BaseParameter.setBits(tbytes, offset, length, value);
        } else {
            int count = (length + 63) / 64;
            int toffset = offset;
            int tnewOffset = 0;
            int i = 0;
            while (i < count) {
                int tlength = length - (i << 6);
                if (tlength > 64) {
                    tlength = 64;
                }
                long value = BaseParameter.getLong(data, toffset - offset, tlength);
                tbytes = BaseParameter.setBits(tbytes, toffset, tlength, value);
                tnewOffset += 64;
                toffset += 64;
                tlength = length - (i << 6);
                ++i;
            }
        }
        return tbytes;
    }

    public static byte[] setBytesLittleEndian(byte[] bytes, int bytesLength, int offset, int length, byte[] data, boolean insert) {
        if (offset < 0) {
            throw new IllegalArgumentException(String.valueOf(offset));
        }
        byte[] tbytes = bytes;
        if (insert) {
            tbytes = BaseParameter.expand(bytes, bytesLength, offset, length);
        }
        if ((offset & 7) == 0 && (length & 7) == 0) {
            int index = offset >> 3;
            int size = length >> 3;
            int i = 0;
            while (i < size) {
                tbytes[i + index] = data[size - 1 - i];
                ++i;
            }
        } else if (length <= 64) {
            long value = BaseParameter.getUnsignedLong(data, 0, length);
            tbytes = BaseParameter.setBitsLittleEngian(tbytes, tbytes.length >> 3, offset, length, value, false);
        } else {
            int count = (length + 63) / 64;
            int toffset = offset;
            int tnewOffset = 0;
            int i = 0;
            while (i < count) {
                int tlength = length - (i << 6);
                if (tlength > 64) {
                    tlength = 64;
                }
                long value = BaseParameter.getLong(data, toffset - offset, tlength);
                tbytes = BaseParameter.setBits(tbytes, toffset, tlength, value);
                tnewOffset += 64;
                toffset += 64;
                tlength = length - (i << 6);
                ++i;
            }
        }
        return tbytes;
    }

    public ParameterCursorService createCursorChild(ParameterCursorService parent) {
        ParameterCursor parameterCursor = new ParameterCursor();
        parameterCursor.setParent(parent);
        parameterCursor.setOffsetDelta(parent.getOffsetAbsolute());
        parameterCursor.setInsert(this.isInsert() || parent.isInsert());
        parameterCursor.setMessageLength(parent.getMessageLength());
        return parameterCursor;
    }

    public Object decode(Object container) {
        if (container instanceof MessageService) {
            return this.decodeValue((MessageService)container);
        }
        Object returnValue = container;
        if (container instanceof byte[]) {
            byte[] bytes = (byte[])container;
            returnValue = this.decodeBytes(bytes, new ParameterCursor(bytes.length << 3));
        } else if (container instanceof String) {
            byte[] bytes = ((String)container).getBytes();
            returnValue = this.decodeString((String)container, new ParameterCursor(bytes.length << 3));
        }
        return this.decodeEnd(returnValue);
    }

    public Object decodeBytes(byte[] container, ParameterCursorService cursor) {
        int offset = this.getOffsetAbsolute(cursor);
        int length = this.getLength(cursor);
        int containerLength = container.length << 3;
        int remainingLength = cursor != null ? Math.min(cursor.getRemainingLength(), containerLength - offset) : containerLength - offset;
        int correctLength = remainingLength > 0 ? Math.min(length, remainingLength) : length;
        return BaseParameter.getBytes(container, offset, correctLength);
    }

    public Object decodeEnd(Object object) {
        return object;
    }

    public Object decodeString(String container, ParameterCursorService cursor) {
        return this.decodeBytes(container.getBytes(), cursor);
    }

    public Object decodeValue(MessageService message) {
        if (this.needsCursor()) {
            ParameterCursor cursor = new ParameterCursor(message.getBytes().length << 3);
            try {
                return this.decodeValue(message, cursor);
            }
            catch (Exception exception) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream(4096);
                PrintStream printStream = new PrintStream(outputStream);
                printStream.println();
                printStream.print("message ");
                printStream.println(message);
                printStream.print("cursor ");
                printStream.println(cursor);
                printStream.println(exception.getLocalizedMessage());
                exception.printStackTrace(printStream);
                RuntimeException runtimeException = new RuntimeException(((Object)outputStream).toString());
                throw runtimeException;
            }
        }
        return this.decodeValue(message, null);
    }

    public Object decodeValue(MessageService message, ParameterCursorService cursor) {
        Object results = this.decodeBytes(message.getBytes(), cursor);
        this.updateCursor(cursor);
        return results;
    }

    public Object encode(Object container, Object data) {
        if (container instanceof MessageService) {
            return this.encodeValue((MessageService)container, data, null);
        }
        Object returnValue = container;
        if (container instanceof byte[]) {
            returnValue = this.encodeBytes((byte[])container, data, null);
        } else if (container instanceof String) {
            returnValue = this.encodeString((String)container, data, null);
        }
        return returnValue;
    }

    public byte[] encodeBytes(byte[] bytes, Object data, ParameterCursorService cursor) {
        Object encodeData = this.encodeData(data);
        if (encodeData instanceof byte[]) {
            byte[] encodeBytes = (byte[])encodeData;
            if (cursor != null) {
                cursor.setLength(encodeBytes.length << 3);
            }
            int bytesLength = cursor != null ? cursor.getMessageLength() : bytes.length << 3;
            int offset = this.getOffsetAbsolute(cursor);
            int length = this.getLength(cursor);
            boolean insert = this.isInsert(cursor);
            return BaseParameter.setBytes(bytes, bytesLength, offset, length, encodeBytes, insert);
        }
        return bytes;
    }

    public Object encodeData(Object data) {
        return data;
    }

    public Object encodeString(String container, Object data, ParameterCursorService cursor) {
        return this.encodeBytes(container.getBytes(), data, cursor);
    }

    public MessageService encodeValue(MessageService message, Object value) {
        if (this.needsCursor()) {
            ParameterCursor cursor = new ParameterCursor(message.getBytes().length << 3);
            MessageService resultMessage = this.encodeValue(message, value, cursor);
            byte[] bytes = resultMessage.getBytes();
            int length = cursor.getMessageLength();
            int size = length + 7 >> 3;
            if (size == bytes.length) {
                return resultMessage;
            }
            if (size > bytes.length) {
                throw new IllegalArgumentException("size > bytes.length " + resultMessage);
            }
            if (size < bytes.length) {
                byte[] newBytes = new byte[size];
                System.arraycopy(bytes, 0, newBytes, 0, size);
                resultMessage.setBytes(newBytes);
            }
            return resultMessage;
        }
        return this.encodeValue(message, value, null);
    }

    public MessageService encodeValue(MessageService message, Object value, ParameterCursorService cursor) {
        byte[] bytes = this.encodeBytes(message.getBytes(), value, cursor);
        message.setBytes(bytes);
        this.updateCursor(cursor);
        return message;
    }

    public String getKey() {
        return null;
    }

    public int getLength() {
        return Integer.MAX_VALUE;
    }

    protected int getLength(ParameterCursorService cursor) {
        int length = this.getLength();
        if (length == Integer.MAX_VALUE || length == Integer.MIN_VALUE) {
            return cursor.getLength();
        }
        return length;
    }

    public int getOffset() {
        return Integer.MAX_VALUE;
    }

    protected int getOffsetAbsolute(ParameterCursorService cursor) {
        int toffset;
        int offset = this.getOffset();
        if (offset == Integer.MAX_VALUE) {
            return cursor.getOffsetAbsolute();
        }
        if (offset == Integer.MIN_VALUE) {
            return cursor.getOffsetAbsolute();
        }
        int n = toffset = offset < 0 ? -offset : offset;
        if (cursor != null) {
            return toffset + cursor.getOffsetDelta();
        }
        return toffset;
    }

    public int getOffsetDefault() {
        return 0;
    }

    public int getOffsetLength() {
        return 8;
    }

    protected int getOffsetValue(ParameterCursorService cursor) {
        int offset = this.getOffset();
        if (offset == Integer.MAX_VALUE) {
            int absoluteOffset = cursor.getOffsetAbsolute();
            if (cursor.isInsert()) {
                return -absoluteOffset;
            }
            return absoluteOffset;
        }
        if (offset == Integer.MIN_VALUE) {
            return -cursor.getOffsetAbsolute();
        }
        if (cursor != null) {
            return offset + cursor.getOffsetDelta();
        }
        return offset;
    }

    public boolean isConstantParameter() {
        return false;
    }

    public boolean isInsert() {
        return false;
    }

    public boolean isInsert(ParameterCursorService cursor) {
        if (cursor != null && cursor.isInsert()) {
            return true;
        }
        return this.getOffset() == Integer.MIN_VALUE;
    }

    public boolean needsCursor() {
        return false;
    }

    protected void updateCursor(ParameterCursorService cursor) {
        if (cursor != null) {
            int length = this.getLength(cursor);
            this.updateCursor(cursor, length);
        }
    }

    protected void updateCursor(ParameterCursorService cursor, int length) {
        if (cursor != null) {
            int offset = this.getOffsetAbsolute(cursor);
            int newOffset = offset + length;
            cursor.setOffsetAbsolute(newOffset);
            if (this.isInsert(cursor)) {
                cursor.updateMessageLength(length);
            }
        }
    }
}

