/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.nls;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.sat.core.framework.interfaces.ICharBuffer;
import org.eclipse.soda.sat.core.util.FactoryUtility;

public class Nls {
    public static final int TIMESTAMP_MILLISECOND_FORMAT = 1;
    public static final int TIMESTAMP_SECOND_FORMAT = 2;
    public static final int TIMESTAMP_MINUTE_FORMAT = 4;
    public static final int TIMESTAMP_HOUR_FORMAT = 8;
    public static final int TIMESTAMP_DAY_FORMAT = 16;
    public static final int TIMESTAMP_MONTH_FORMAT = 32;
    public static final int TIMESTAMP_YEAR_FORMAT = 64;
    private static final String CR_STRING = "\\r";
    public static final byte[] HEX_UPPER_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    public static final char[] HEX_CHAR_LOWER_TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final char[] HEX_CHAR_UPPER_TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String PROPERTY_EXTENSION = ".properties";
    private static final int PROPERTY_EXTENSION_LENGTH = ".properties".length();
    private static final String[] NLS_ADDITIONS = Nls.computeNlsAdditions();
    protected static final char[] CR = "\\r".toCharArray();
    protected static final char[] LF = "\\n".toCharArray();
    protected static final char[] TAB = "\\t".toCharArray();
    protected static final char[] OPEN_TIME = " (.".toCharArray();
    protected static final char[] OBJECT_ARRAY_CHARS = "[]{".toCharArray();
    protected static final char[] END_START_LINE_CHARS = "\r\n\t".toCharArray();
    protected static final char[] LIST_CHARS = "[]{".toCharArray();
    protected static final Comparator ComparatorObject = new Comparator(){

        public int compare(Object var0, Object var1) {
            return String.valueOf(var0).compareTo(String.valueOf(var1));
        }
    };

    public static final int append(char[] characters, int index, char[] data) {
        int length = data.length;
        System.arraycopy(data, 0, characters, index, length);
        return index + length;
    }

    public static final int append(char[] characters, int index, int data) {
        if (data >= 0 && data < 10) {
            characters[index] = (char)(data + 48);
            return index + 1;
        }
        char[] charData = Integer.toString(data).toCharArray();
        return Nls.append(characters, index, charData);
    }

    public static final int append(char[] characters, int index, String data) {
        char[] charData = data.toCharArray();
        return Nls.append(characters, index, charData);
    }

    private static String[] computeNlsAdditions() {
        Locale locale = Locale.getDefault();
        ArrayList<String> list = new ArrayList<String>(3);
        list.add("");
        StringBuffer buffer = new StringBuffer();
        String[] possible = new String[]{locale.getLanguage(), locale.getCountry(), locale.getVariant()};
        int plength = possible.length;
        int i = 0;
        while (i < plength) {
            if (possible[i] != null && possible[i].length() > 0) {
                buffer.append('_');
                buffer.append(possible[i]);
                list.add(buffer.toString());
            }
            ++i;
        }
        String[] results = new String[list.size()];
        int max = results.length - 1;
        int i2 = 0;
        while (i2 < results.length) {
            results[i2] = String.valueOf(list.get(max - i2));
            ++i2;
        }
        return results;
    }

    public static String format(String pattern, Object object) {
        return Nls.format(pattern, new Object[]{object});
    }

    public static String format(String pattern, Object[] objects) {
        char[] patternChar = pattern.toCharArray();
        int length = (pattern.length() << 2) + (objects.length << 7);
        StringBuffer buffer = new StringBuffer(length);
        int index = 0;
        int copyIndex = 0;
        boolean ok = true;
        while (ok) {
            int first = pattern.indexOf(123, index);
            if (first == -1) {
                ok = false;
                continue;
            }
            int last = pattern.indexOf(125, first);
            if (last == -1) {
                ok = false;
                continue;
            }
            index = first + 1;
            if (last >= first + 3) continue;
            try {
                char number = patternChar[first + 1];
                int value = number - 48;
                if (value < 0) {
                    value = Character.digit(number, 16);
                } else if (value > 9 && ((value = number - 97 + 10) < 10 || value > 15)) {
                    value = Character.digit(number, 16);
                }
                buffer.append(patternChar, copyIndex, first - copyIndex);
                Object object = objects[value];
                if (object instanceof String) {
                    buffer.append(object);
                } else {
                    Nls.formatData(buffer, object, 0, 100, 10);
                }
                copyIndex = last + 1;
            }
            catch (RuntimeException exception) {
                EscObject.handleStaticException(exception);
            }
        }
        buffer.append(patternChar, copyIndex, patternChar.length - copyIndex);
        return buffer.toString();
    }

    public static String formatAsciiBytes(byte[] bytes, int index, int length) {
        StringBuffer buffer = new StringBuffer(length * 5);
        Nls.formatAsciiBytes(bytes, index, length, buffer);
        return buffer.toString();
    }

    public static void formatAsciiBytes(byte[] bytes, int index, int length, StringBuffer buffer) {
        buffer.append('\"');
        int i = 0;
        while (i < length) {
            char character = (char)bytes[i + index];
            if (character < '\u0010') {
                if (character == '\r') {
                    buffer.append(CR);
                } else if (character == '\n') {
                    buffer.append(LF);
                } else if (character == '\t') {
                    buffer.append(TAB);
                } else {
                    buffer.append('\\');
                    if (character > '\t') {
                        buffer.append('1');
                        buffer.append(HEX_CHAR_LOWER_TABLE[character % 10]);
                    } else {
                        buffer.append(HEX_CHAR_LOWER_TABLE[character]);
                    }
                }
            } else {
                buffer.append(character);
            }
            ++i;
        }
        buffer.append('\"');
    }

    public static String formatData(Object data) {
        StringBuffer buffer = new StringBuffer(1024);
        if (data instanceof String) {
            Nls.formatStringData(buffer, data);
        } else {
            Nls.formatData(buffer, data, 0);
        }
        return buffer.toString();
    }

    public static void formatData(StringBuffer buffer, Object data) {
        Nls.formatData(buffer, data, 0);
    }

    public static void formatData(StringBuffer buffer, Object data, int depth) {
        Nls.formatData(buffer, data, depth, 128);
    }

    public static void formatData(StringBuffer buffer, Object data, int depth, int maxLineSize) {
        Nls.formatData(buffer, data, depth, maxLineSize, 0);
    }

    public static void formatData(StringBuffer buffer, Object data, int depth, int maxLineSize, int verboseLevel) {
        int currentLineOffset = 0;
        if (data instanceof String[]) {
            String[] strings = (String[])data;
            int length = strings.length;
            if (length > 0) {
                StringBuffer tbuffer = new StringBuffer(length << 8);
                tbuffer.append('[');
                int i = 0;
                while (i < length) {
                    if (i != 0) {
                        tbuffer.append(' ');
                    }
                    Nls.formatData(tbuffer, strings[i], depth + 1, maxLineSize, verboseLevel);
                    ++i;
                }
                tbuffer.append(']');
                buffer.append(tbuffer.toString());
            } else {
                buffer.append('[');
                buffer.append(']');
            }
        } else if (data instanceof Object[]) {
            buffer.append(OBJECT_ARRAY_CHARS);
            Object[] objects = (Object[])data;
            int length = objects.length;
            int i = 0;
            while (i < length) {
                if (i != 0) {
                    buffer.append(' ');
                }
                Nls.formatData(buffer, objects[i], depth + 1, maxLineSize, verboseLevel);
                ++i;
            }
            buffer.append('}');
        } else if (data instanceof byte[]) {
            byte[] bytes = (byte[])data;
            int length = bytes.length;
            buffer.append("[0x");
            int i = 0;
            while (i < length) {
                int dataByte;
                int upperByte;
                if (i != 0) {
                    buffer.append(' ');
                }
                if ((upperByte = (dataByte = bytes[i] & 0xFF) >> 4) > 0) {
                    buffer.append(HEX_CHAR_LOWER_TABLE[upperByte]);
                }
                buffer.append(HEX_CHAR_LOWER_TABLE[dataByte & 0xF]);
                ++i;
            }
            buffer.append(']');
        } else if (data instanceof int[]) {
            int[] ints = (int[])data;
            int length = ints.length;
            buffer.append('[');
            int i = 0;
            while (i < length) {
                if (i != 0) {
                    buffer.append(' ');
                }
                buffer.append(ints[i]);
                ++i;
            }
            buffer.append(']');
        } else if (data instanceof Map) {
            buffer.append('{');
            Map map = (Map)data;
            int size = map.size();
            if (size > 0) {
                Set set = map.keySet();
                Object[] keys = new Object[size];
                keys = set.toArray(keys);
                if (size > 1) {
                    Arrays.sort(keys, ComparatorObject);
                }
                boolean large = false;
                int i = 0;
                while (i < size) {
                    if (i != 0) {
                        buffer.append(',');
                        if (large && verboseLevel > 5) {
                            int currentOffset;
                            buffer.append(END_START_LINE_CHARS);
                            int m = 0;
                            while (m < depth) {
                                buffer.append('\t');
                                ++m;
                            }
                            currentLineOffset = currentOffset = buffer.length();
                        }
                    }
                    Object key = keys[i];
                    int checkOffset = buffer.length();
                    if (key instanceof String) {
                        Nls.formatStringData(buffer, key);
                    } else {
                        Nls.formatData(buffer, key, depth + 1, maxLineSize, verboseLevel);
                    }
                    buffer.append('=');
                    Nls.formatData(buffer, map.get(key), depth + 1, maxLineSize, verboseLevel);
                    int currentOffset = buffer.length();
                    int csize = currentOffset - currentLineOffset;
                    if (verboseLevel > 5 && csize > maxLineSize) {
                        buffer.insert(checkOffset, END_START_LINE_CHARS);
                        int m = 0;
                        while (m < depth) {
                            buffer.insert(checkOffset + 3, '\t');
                            ++m;
                        }
                        currentLineOffset = currentOffset;
                        large = true;
                    } else {
                        large = false;
                    }
                    ++i;
                }
            }
            buffer.append('}');
        } else if (data instanceof Dictionary) {
            buffer.append('{');
            boolean first = true;
            Dictionary map = (Dictionary)data;
            int size = map.size();
            if (size > 0) {
                Enumeration enumeration = map.keys();
                while (enumeration.hasMoreElements()) {
                    String key = String.valueOf(enumeration.nextElement());
                    if (first) {
                        first = false;
                    } else {
                        buffer.append(',');
                    }
                    int checkOffset = buffer.length();
                    Nls.formatData(buffer, key, depth + 1, maxLineSize, verboseLevel);
                    buffer.append('=');
                    Nls.formatData(buffer, map.get(key), depth + 1, maxLineSize, verboseLevel);
                    Nls.formatData(buffer, map.get(key), depth + 1, maxLineSize, verboseLevel);
                    int currentOffset = buffer.length();
                    int csize = currentOffset - currentLineOffset;
                    if (verboseLevel <= 5 || csize <= maxLineSize) continue;
                    buffer.insert(checkOffset, END_START_LINE_CHARS);
                    int m = 0;
                    while (m < depth) {
                        buffer.insert(checkOffset + 3, '\t');
                        ++m;
                    }
                    currentLineOffset = currentOffset;
                }
            }
            buffer.append('}');
        } else if (data instanceof List) {
            buffer.append(LIST_CHARS);
            List objects = (List)data;
            int length = objects.size();
            int i = 0;
            while (i < length) {
                if (i != 0) {
                    buffer.append(' ');
                }
                Nls.formatData(buffer, objects.get(i), depth + 1, maxLineSize, verboseLevel);
                ++i;
            }
            buffer.append('}');
        } else if (data instanceof String) {
            Nls.formatStringData(buffer, data.toString());
        } else {
            buffer.append(data);
        }
    }

    public static String formatHexBytes(byte[] bytes, int index, int length) {
        char[] characters = new char[(length << 4) + 4];
        int tindex = 0;
        characters[tindex++] = 123;
        int charCount = 0;
        int i = 0;
        while (i < length) {
            int data;
            int upperByte;
            if (i != 0) {
                characters[tindex++] = 44;
            }
            if ((upperByte = (data = bytes[i + index] & 0xFF) >> 4) > 0) {
                characters[tindex++] = HEX_CHAR_LOWER_TABLE[upperByte];
                if (data >= 32 && data <= 127) {
                    ++charCount;
                }
            } else if (data == 13 || data == 10 || data == 9) {
                ++charCount;
            }
            characters[tindex++] = HEX_CHAR_LOWER_TABLE[data & 0xF];
            ++i;
        }
        characters[tindex++] = 125;
        if (charCount > 0 && charCount >= length >> 1) {
            if (charCount == length) {
                tindex = 0;
            } else {
                characters[tindex++] = 61;
            }
            characters[tindex++] = 34;
            String data = new String(bytes, index, length);
            int dataLength = data.length();
            int i2 = 0;
            while (i2 < dataLength) {
                char character = data.charAt(i2);
                if (character < '\u0010') {
                    if (character == '\r') {
                        characters[tindex++] = 92;
                        characters[tindex++] = 114;
                    } else if (character == '\n') {
                        characters[tindex++] = 92;
                        characters[tindex++] = 110;
                    } else if (character == '\t') {
                        characters[tindex++] = 92;
                        characters[tindex++] = 116;
                    } else {
                        characters[tindex++] = 92;
                        if (character > '\t') {
                            characters[tindex++] = 49;
                            characters[tindex++] = HEX_CHAR_LOWER_TABLE[character % 10];
                        } else {
                            characters[tindex++] = HEX_CHAR_LOWER_TABLE[character];
                        }
                    }
                } else {
                    characters[tindex++] = character;
                }
                ++i2;
            }
            characters[tindex++] = 34;
        }
        return new String(characters, 0, tindex);
    }

    public static void formatHexBytes(byte[] bytes, int index, int length, StringBuffer buffer) {
        String result = Nls.formatHexBytes(bytes, index, length);
        buffer.append(result);
    }

    public static void formatHexBytesOnly(byte[] bytes, int index, int length, StringBuffer buffer) {
        int charCount = 0;
        int i = 0;
        while (i < length) {
            int data;
            int upperByte;
            if (i != 0) {
                buffer.append(',');
            }
            if ((upperByte = (data = bytes[i + index] & 0xFF) >> 4) > 0) {
                buffer.append(HEX_CHAR_LOWER_TABLE[upperByte]);
                if (data >= 32 && data <= 127) {
                    ++charCount;
                }
            } else if (data == 13 || data == 10 || data == 9) {
                ++charCount;
            }
            buffer.append(HEX_CHAR_LOWER_TABLE[data & 0xF]);
            ++i;
        }
    }

    public static String formatNew(String pattern, Object[] objects) {
        char[] patternChar = pattern.toCharArray();
        int length = (pattern.length() << 2) + (objects.length << 7);
        ICharBuffer buffer = FactoryUtility.getInstance().createCharBuffer(length);
        int index = 0;
        int copyIndex = 0;
        boolean ok = true;
        while (ok) {
            int first = pattern.indexOf(123, index);
            if (first == -1) {
                ok = false;
                continue;
            }
            int last = pattern.indexOf(125, first);
            if (last == -1) {
                ok = false;
                continue;
            }
            index = first + 1;
            if (last >= first + 3) continue;
            try {
                char number = patternChar[first + 1];
                int value = number - 48;
                if (value < 0) {
                    value = Character.digit(number, 16);
                } else if (value > 9 && ((value = number - 97 + 10) < 10 || value > 15)) {
                    value = Character.digit(number, 16);
                }
                buffer.append(patternChar, copyIndex, first - copyIndex);
                Object object = objects[value];
                if (object instanceof String) {
                    buffer.append((String)object);
                } else {
                    StringBuffer stringBuffer = new StringBuffer(256);
                    Nls.formatData(stringBuffer, object, 0, 100, 10);
                    buffer.append((Object)stringBuffer);
                }
                copyIndex = last + 1;
            }
            catch (RuntimeException exception) {
                EscObject.handleStaticException(exception);
            }
        }
        int remainingLength = patternChar.length - copyIndex;
        if (remainingLength > 0) {
            buffer.append(patternChar, copyIndex, remainingLength);
        }
        return buffer.toString();
    }

    public static void formatStringData(StringBuffer buffer, Object data) {
        buffer.append('\"');
        if (data != null) {
            String string = data.toString();
            int length = string.length();
            int i = 0;
            while (i < length) {
                char character = string.charAt(i);
                switch (character) {
                    case '\r': {
                        buffer.append(CR);
                        break;
                    }
                    case '\n': {
                        buffer.append(LF);
                        break;
                    }
                    case '\t': {
                        buffer.append(TAB);
                        break;
                    }
                    case '\"': {
                        buffer.append("\\\"");
                        break;
                    }
                    default: {
                        buffer.append(character);
                    }
                }
                ++i;
            }
        }
        buffer.append('\"');
    }

    public static String formatTimestamp(long timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(timestamp));
        char[] characters = new char[48];
        int index = 0;
        int year = calendar.get(1);
        index = Nls.append(characters, index, year);
        characters[index++] = 45;
        int month = calendar.get(2) + 1;
        if (month < 10) {
            characters[index++] = 48;
        }
        index = Nls.append(characters, index, month);
        characters[index++] = 45;
        int day = calendar.get(5);
        if (day < 10) {
            characters[index++] = 48;
        }
        index = Nls.append(characters, index, day);
        characters[index++] = 32;
        int hour = calendar.get(11);
        if (hour < 10) {
            characters[index++] = 48;
        }
        index = Nls.append(characters, index, hour);
        characters[index++] = 58;
        int minute = calendar.get(12);
        if (minute < 10) {
            characters[index++] = 48;
        }
        index = Nls.append(characters, index, minute);
        characters[index++] = 58;
        int second = calendar.get(13);
        if (second < 10) {
            characters[index++] = 48;
        }
        index = Nls.append(characters, index, second);
        characters[index++] = 46;
        int millisecond = calendar.get(14);
        if (millisecond < 100) {
            characters[index++] = 48;
        }
        if (millisecond < 10) {
            characters[index++] = 48;
        }
        index = Nls.append(characters, index, millisecond);
        return new String(characters, 0, index);
    }

    public static String formatTimestamp(long timestamp, int format) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(timestamp));
        char[] characters = new char[48];
        int index = 0;
        boolean separator = false;
        if ((format & 0x40) != 0) {
            int year = calendar.get(1);
            index = Nls.append(characters, index, year);
            separator = true;
        }
        if ((format & 0x20) != 0) {
            int month;
            if (separator) {
                characters[index++] = 45;
                separator = false;
            }
            if ((month = calendar.get(2) + 1) < 10) {
                characters[index++] = 48;
            }
            index = Nls.append(characters, index, month);
            separator = true;
        }
        if ((format & 0x10) != 0) {
            int day;
            if (separator) {
                characters[index++] = 45;
                separator = false;
            }
            if ((day = calendar.get(5)) < 10) {
                characters[index++] = 48;
            }
            index = Nls.append(characters, index, day);
            separator = true;
        }
        if ((format & 8) != 0) {
            int hour;
            if (separator) {
                characters[index++] = 32;
                separator = false;
            }
            if ((hour = calendar.get(11)) < 10) {
                characters[index++] = 48;
            }
            index = Nls.append(characters, index, hour);
            separator = true;
        }
        if ((format & 4) != 0) {
            int minute;
            if (separator) {
                characters[index++] = 58;
                separator = false;
            }
            if ((minute = calendar.get(12)) < 10) {
                characters[index++] = 48;
            }
            index = Nls.append(characters, index, minute);
            separator = true;
        }
        if ((format & 2) != 0) {
            int second;
            if (separator) {
                characters[index++] = 58;
                separator = false;
            }
            if ((second = calendar.get(13)) < 10) {
                characters[index++] = 48;
            }
            index = Nls.append(characters, index, second);
            separator = true;
        }
        if ((format & 1) != 0) {
            int millisecond;
            if (separator) {
                characters[index++] = 46;
                separator = false;
            }
            if ((millisecond = calendar.get(14)) < 100) {
                characters[index++] = 48;
            }
            if (millisecond < 10) {
                characters[index++] = 48;
            }
            index = Nls.append(characters, index, millisecond);
            separator = true;
        }
        return new String(characters, 0, index);
    }

    public static String formatTimestamp(Object timestampObject) {
        if (timestampObject instanceof Number) {
            return Nls.formatTimestamp(((Number)timestampObject).longValue());
        }
        return "null";
    }

    public static String formatTimestampNew(long timestamp, int format) {
        return Nls.formatTimestamp(timestamp, format);
    }

    public static String getName(Class resourceClass, String name, String extension) {
        int length = name.length() + extension.length() + PROPERTY_EXTENSION_LENGTH;
        String[] myadditions = Nls.getNlsAdditions();
        int i = 0;
        while (i < myadditions.length) {
            StringBuffer buffer = new StringBuffer(length);
            buffer.append(name);
            buffer.append(myadditions[i]);
            buffer.append(extension);
            URL url = resourceClass.getResource(buffer.toString());
            if (url != null) {
                return String.valueOf(name) + myadditions[i];
            }
            ++i;
        }
        return name;
    }

    public static String[] getNlsAdditions() {
        return NLS_ADDITIONS;
    }

    public static Hashtable getProperties(Class resourceClass, String name) {
        Properties table = null;
        String[] myadditions = Nls.getNlsAdditions();
        int nlength = name.length();
        int length = nlength + PROPERTY_EXTENSION_LENGTH + 6;
        StringBuffer buffer = new StringBuffer(length);
        buffer.append(name);
        int i = 0;
        while (i < myadditions.length) {
            buffer.append(myadditions[i]);
            buffer.append(PROPERTY_EXTENSION);
            InputStream ris = resourceClass.getResourceAsStream(buffer.toString());
            if (ris != null) {
                BufferedInputStream is = new BufferedInputStream(ris);
                try {
                    table = new Properties();
                    table.load(is);
                    is.close();
                    return table;
                }
                catch (Exception exception) {
                    EscObject.handleStaticException(exception);
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            buffer.setLength(nlength);
            ++i;
        }
        return table;
    }

    public static ResourceBundle getResourceBundle(Class resourceBaseClass) {
        String name = resourceBaseClass.getName();
        String[] myadditions = Nls.getNlsAdditions();
        int nlength = name.length();
        int length = nlength + 6;
        StringBuffer buffer = new StringBuffer(length);
        buffer.append(name);
        ClassLoader classLoader = resourceBaseClass.getClassLoader();
        if (classLoader != null) {
            int i = 0;
            while (i < myadditions.length) {
                buffer.append(myadditions[i]);
                try {
                    Class<?> resourceBundle = classLoader.loadClass(buffer.toString());
                    if (resourceBundle != null) {
                        return (ResourceBundle)resourceBundle.newInstance();
                    }
                }
                catch (Exception exception) {}
                buffer.setLength(nlength);
                ++i;
            }
        }
        return ResourceBundle.getBundle(name);
    }

    public static ResourceBundle getResourceBundle(String name) {
        return ResourceBundle.getBundle(name);
    }

    public static URL getUrl(Class resourceClass, String name, String extension) {
        int length = name.length() + extension.length() + PROPERTY_EXTENSION_LENGTH;
        URL url = null;
        String[] myadditions = Nls.getNlsAdditions();
        int i = 0;
        while (i < myadditions.length) {
            StringBuffer buffer = new StringBuffer(length);
            buffer.append(name);
            buffer.append(myadditions[i]);
            buffer.append(extension);
            url = resourceClass.getResource(buffer.toString());
            if (url != null) {
                return url;
            }
            ++i;
        }
        return url;
    }

    public static byte[] parseCompressedHexString(String string) {
        int length = string.length();
        if (length > 0) {
            int size = length + 1 >> 1;
            byte[] bytes = new byte[size];
            int index = 0;
            while (index < length) {
                char character = string.charAt(index);
                int digit = character - 48;
                if (digit > 9 ? ((digit = character - 87) & 0xFFFFFFF0) != 0 && ((digit = character - 55) & 0xFFFFFFF0) != 0 : digit < 0) {
                    throw new NumberFormatException();
                }
                int offset = index >> 1;
                bytes[offset] = (index & 1) == 0 ? (byte)(digit << 4) : (byte)((bytes[offset] & 0xF0) + digit);
                ++index;
            }
            return bytes;
        }
        return new byte[0];
    }
}

