/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.interest;

import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.interest.service.InterestService;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.Parameter;

public class InterestMask
implements InterestService {
    public static final byte[] MASK_DEFAULT = EscObject.EMPTY_BYTES;
    public static final byte[] DEFAULT_MASK = MASK_DEFAULT;
    private byte[] careMask;
    private byte[] patternMask;

    public InterestMask() {
        this(MASK_DEFAULT, MASK_DEFAULT);
    }

    public InterestMask(byte[] patternMask, byte[] careMask) {
        this.setPatternMask(patternMask);
        this.setCareMask(careMask);
    }

    public InterestMask(int offset, int length, byte[] patternMask) {
        int toffset;
        int tlength;
        byte[] newPattern;
        int start = offset >> 3;
        int size = offset + length + 7 >> 3;
        int startOffset = offset & 7;
        if (startOffset == 0) {
            if (start == 0) {
                this.setPatternMask(patternMask);
            } else {
                newPattern = new byte[size];
                System.arraycopy(patternMask, 0, newPattern, start, patternMask.length);
                this.setPatternMask(newPattern);
            }
        } else {
            newPattern = new byte[size];
            tlength = length;
            toffset = offset;
            int voffset = 0;
            while (tlength > 0) {
                long tvalue;
                if (tlength >= 64) {
                    tvalue = Parameter.getLong(patternMask, voffset, 64);
                    Parameter.setBits(newPattern, toffset, 64, tvalue);
                } else {
                    tvalue = Parameter.getLong(patternMask, voffset, tlength);
                    Parameter.setBits(newPattern, toffset, tlength, tvalue);
                }
                tlength -= 64;
                toffset += 64;
                voffset += 64;
            }
            this.setPatternMask(newPattern);
        }
        byte[] careMask = new byte[size];
        tlength = length;
        toffset = offset;
        while (tlength > 0) {
            if (tlength >= 64) {
                Parameter.setBits(careMask, toffset, 64, -1L);
            } else {
                Parameter.setBits(careMask, toffset, tlength, -1L);
            }
            tlength -= 64;
            toffset += 64;
        }
        this.setCareMask(careMask);
    }

    public byte[] getCareMask() {
        return this.careMask;
    }

    public byte[] getPatternMask() {
        return this.patternMask;
    }

    public boolean isInterested(byte[] bytes) {
        int length = this.careMask.length;
        if (bytes.length >= length) {
            int i = length - 1;
            while (i >= 0) {
                if ((bytes[i] & this.careMask[i]) != this.patternMask[i]) {
                    return false;
                }
                --i;
            }
            return true;
        }
        return false;
    }

    public boolean isInterested(MessageService message) {
        int length = this.careMask.length;
        byte[] messageBytes = message.getBytes();
        if (messageBytes.length >= length) {
            int i = length - 1;
            while (i >= 0) {
                if ((messageBytes[i] & this.careMask[i]) != this.patternMask[i]) {
                    return false;
                }
                --i;
            }
            return true;
        }
        return false;
    }

    public void setCareMask(byte[] careMask) {
        this.careMask = careMask;
    }

    public void setPatternMask(byte[] patternMask) {
        this.patternMask = patternMask;
    }
}

