/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.core.factory;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.soda.dk.core.ConfigurableObject;
import org.eclipse.soda.sat.core.framework.BaseBundleActivator;
import org.eclipse.soda.sat.core.framework.ManagedServiceFactoryBundleActivator;
import org.eclipse.soda.sat.core.framework.interfaces.IBundleActivationManager;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceFactoryAdvisor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;

public abstract class CoreFactory
extends ManagedServiceFactoryBundleActivator
implements ManagedServiceFactory,
IManagedServiceFactoryAdvisor {
    public static final int CHANGES_NONE = 0;
    public static final int CHANGES_MINOR = 1;
    public static final int CHANGES_MAJOR = 2;
    public static final String METATYPE_SERVICE;
    public static final String CONFIGURATION_ADMIN_SERVICE;
    public static final String[] IMPORTED_SERVICES;
    public static final String[] OPTIONAL_SERVICES;
    public static final String ID_KEY_FILTER = "(id=";
    public static final String ID_KEY = "id";
    protected Map ids = new Hashtable();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.metatype.MetaTypeService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        METATYPE_SERVICE = clazz.getName();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.osgi.service.cm.ConfigurationAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CONFIGURATION_ADMIN_SERVICE = clazz2.getName();
        IMPORTED_SERVICES = new String[]{CONFIGURATION_ADMIN_SERVICE};
        OPTIONAL_SERVICES = new String[]{METATYPE_SERVICE};
    }

    protected CoreFactory() {
    }

    public int compare(Dictionary oldProperties, Dictionary properties, Dictionary minorProperties) {
        Object oldValue;
        Object value;
        Object key;
        if (oldProperties == null || properties == null) {
            return 2;
        }
        int miror = 0;
        Enumeration enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            key = enumeration.nextElement();
            value = properties.get(key);
            if (value.equals(oldValue = oldProperties.get(key))) continue;
            if (minorProperties == null || minorProperties.get(key) == null) {
                return 2;
            }
            ++miror;
        }
        if (miror == 0) {
            enumeration = oldProperties.keys();
            while (enumeration.hasMoreElements()) {
                key = enumeration.nextElement();
                value = properties.get(key);
                oldValue = oldProperties.get(key);
                if (oldValue.equals(value)) continue;
                if (minorProperties == null || minorProperties.get(key) == null) {
                    return 2;
                }
                ++miror;
            }
        }
        if (miror > 0) {
            return 1;
        }
        return 0;
    }

    protected IManagedServiceFactoryAdvisor createAdvisor() {
        return this;
    }

    public void createImportedServiceFilters(String pid, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager) {
        String interestServiceName = this.getInterestServiceName();
        if (interestServiceName != null && interestServiceName.length() > 0) {
            Object idFilter = properties.get("idimportfilter");
            String idFilterString = String.valueOf(idFilter);
            if (idFilter != null && idFilterString.length() > 0) {
                manager.addImportedServiceFilter(this.getInterestServiceName(), idFilterString);
            } else {
                String id = String.valueOf(properties.get(ID_KEY));
                String idString = String.valueOf(id);
                if (id != null && idString.length() > 0) {
                    StringBuffer buffer = new StringBuffer(ID_KEY_FILTER);
                    buffer.append(idString);
                    buffer.append(')');
                    String filter = buffer.toString();
                    manager.addImportedServiceFilter(this.getInterestServiceName(), filter);
                }
            }
        }
    }

    public Hashtable createProperties() {
        Bundle bundle = this.getBundle();
        return ConfigurableObject.createPropertiesFromHeaders(bundle.getHeaders());
    }

    public synchronized void destroy(String pid, Object object, Dictionary properties, IBundleActivationManager manager) {
        Object idObject = properties.get(ID_KEY);
        if (idObject != null) {
            String id = String.valueOf(idObject);
            this.getIds().remove(id);
        }
    }

    public abstract String[] getExportedServiceNames(String var1, Dictionary var2, Dictionary var3, IBundleActivationManager var4);

    public Map getIds() {
        return this.ids;
    }

    protected String[] getImportedServiceNames() {
        return IMPORTED_SERVICES;
    }

    public String[] getImportedServiceNames(String arg0, Dictionary arg1, Dictionary arg2, IBundleActivationManager manager) {
        return BaseBundleActivator.NO_SERVICES;
    }

    public String getInterestServiceName() {
        return "";
    }

    public Dictionary getMinorProperties() {
        Hashtable<String, String> minorProperties = new Hashtable<String, String>();
        minorProperties.put("loglevel", "loglevel");
        return minorProperties;
    }

    protected String[] getOptionalImportedServiceNames() {
        return OPTIONAL_SERVICES;
    }

    public String[] getOptionalImportedServiceNames(String arg0, Dictionary arg1, Dictionary arg2, IBundleActivationManager arg3) {
        return BaseBundleActivator.NO_SERVICES;
    }

    protected void handleAcquiredOptionalImportedService(String serviceName, Object service) {
    }

    public void handleAcquiredOptionalImportedService(String arg0, Object arg1, String arg2, Object arg3, IBundleActivationManager arg4) {
    }

    protected void handleReleasedOptionalImportedService(String serviceName, Object service) {
    }

    public void handleReleasedOptionalImportedService(String arg0, Object arg1, String arg2, Object arg3, IBundleActivationManager arg4) {
    }

    public void setIds(Hashtable ids) {
        this.ids = ids;
    }

    public void updateProperties(Dictionary table, Dictionary from) {
        if (from != null) {
            if (from instanceof Map) {
                if (table instanceof Map) {
                    Map map = (Map)((Object)table);
                    map.putAll((Map)((Object)from));
                } else {
                    this.updateProperties(table, (Map)((Object)from));
                }
            } else {
                Enumeration enumeration = from.keys();
                while (enumeration.hasMoreElements()) {
                    Object key = enumeration.nextElement();
                    Object value = from.get(key);
                    table.put(key, value);
                }
            }
        }
    }

    public void updateProperties(Dictionary table, Map from) {
        if (from != null) {
            Iterator iterator = from.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                table.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public void validateConfiguration(String pid, Dictionary properties) throws ConfigurationException {
        Object service;
        String idFilter;
        Object idFilterObject = properties.get("idimportfilter");
        if (idFilterObject != null && (idFilter = idFilterObject.toString()).length() > 0) {
            try {
                BundleContext bundleContext = this.getBundleContext();
                bundleContext.createFilter(idFilter);
            }
            catch (Exception exception) {
                this.handleException((Exception)new ConfigurationException("idimportfilter", idFilter, (Throwable)exception));
            }
        }
        if ((service = this.getOptionalImportedService(METATYPE_SERVICE)) instanceof MetaTypeService) {
            MetaTypeService metatypeService = (MetaTypeService)service;
            MetaTypeInformation info = metatypeService.getMetaTypeInformation(this.getBundle());
            ConfigurableObject.validateConfiguration(pid, properties, info);
        }
    }

    public void validateConfigurationIds(String pid, Dictionary properties) {
        Object idObject = properties.get(ID_KEY);
        String id = String.valueOf(idObject);
        if (idObject == null) {
            this.handleException((Exception)new ConfigurationException(ID_KEY, id));
        } else {
            Object otherId = this.getIds().get(id);
            if (otherId != null) {
                this.handleException((Exception)new ConfigurationException(ID_KEY, id, (Throwable)new RuntimeException("multiple ids")));
            } else {
                this.getIds().put(id, properties);
            }
        }
    }
}

