/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.filter;

import org.eclipse.soda.dk.filter.service.FilterService;
import org.eclipse.soda.dk.message.service.MessageService;

public class SimpleFilter
implements FilterService {
    private int start = 0;
    private int end = -1;

    public SimpleFilter(int index) {
        this(index, 1);
    }

    public SimpleFilter(int index, int size) {
        this.start = index;
        this.end = index + size - 1;
    }

    public boolean matches(MessageService message0, MessageService message1) {
        byte[] bytes1 = message1.getBytes();
        if (bytes1.length > this.end) {
            byte[] bytes0 = message0.getBytes();
            return this.matches(bytes0, bytes1);
        }
        return false;
    }

    public boolean matches(byte[] bytes0, byte[] bytes1) {
        if (bytes1.length > this.end && bytes0.length > this.end) {
            int i = this.end;
            while (i >= this.start) {
                if (bytes0[i] != bytes1[i]) {
                    return false;
                }
                --i;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SimpleFilter(");
        buffer.append(this.start);
        int size = this.end - this.start;
        if (size != 1) {
            buffer.append(',');
            buffer.append(size);
        }
        buffer.append(')');
        return buffer.toString();
    }
}

