/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.data;

public class Data {
    public static int parseInt(String string) throws RuntimeException {
        return Data.parseInt(string, 0, string.length());
    }

    public static int parseInt(String string, int start, int length) throws RuntimeException {
        int result = 0;
        if (length > 0) {
            if (string.charAt(start) == '-') {
                result = -Data.parseUint(string, start + 1, length);
            } else {
                int i = start;
                while (i < length) {
                    int digit = string.charAt(i) - 48;
                    if (digit < 0 || digit > 9) {
                        throw new NumberFormatException(string);
                    }
                    result = result * 10 + digit;
                    ++i;
                }
            }
        } else {
            throw new NumberFormatException(string);
        }
        return result;
    }

    public static long parseLong(String string) throws RuntimeException {
        return Data.parseLong(string, 0, string.length());
    }

    public static long parseLong(String string, int start, int length) throws RuntimeException {
        long result = 0L;
        if (length > 0) {
            if (string.charAt(start) == '-') {
                result = -Data.parseUlong(string, start + 1, length);
            } else {
                int i = start;
                while (i < length) {
                    int digit = string.charAt(i) - 48;
                    result = result * 10L + (long)digit;
                    if (digit < 0 || digit > 9) {
                        throw new NumberFormatException(string);
                    }
                    ++i;
                }
            }
        } else {
            throw new NumberFormatException(string);
        }
        return result;
    }

    public static int parseUint(String string, int start, int length) throws RuntimeException {
        int result = 0;
        if (length > 0) {
            int i = start;
            while (i < length) {
                int digit = string.charAt(i) - 48;
                if (digit < 0 || digit > 9) {
                    throw new NumberFormatException(string);
                }
                result = result * 10 + digit;
                ++i;
            }
        } else {
            throw new NumberFormatException(string);
        }
        return result;
    }

    public static long parseUlong(String string, int start, int length) throws RuntimeException {
        long result = 0L;
        if (length > 0) {
            int i = start;
            while (i < length) {
                int digit = string.charAt(i) - 48;
                result = result * 10L + (long)digit;
                if (digit < 0 || digit > 9) {
                    throw new NumberFormatException(string);
                }
                ++i;
            }
        } else {
            throw new NumberFormatException(string);
        }
        return result;
    }

    public static String toString(long value) {
        boolean minus;
        long tvalue = value;
        boolean bl = minus = tvalue < 0L;
        if (minus) {
            tvalue = -tvalue;
        }
        char[] chars = new char[20];
        int i = 19;
        while (i >= 0) {
            int digit = (int)(tvalue % 10L);
            chars[i] = (char)(digit + 48);
            if ((tvalue /= 10L) == 0L) break;
            --i;
        }
        if (minus) {
            chars[--i] = 45;
        }
        return new String(chars, i, 20 - i);
    }

    public static String toString(int value) {
        boolean minus;
        int tvalue = value;
        boolean bl = minus = tvalue < 0;
        if (minus) {
            tvalue = -tvalue;
        }
        char[] chars = new char[11];
        int i = 10;
        while (i >= 0) {
            int digit = tvalue % 10;
            chars[i] = (char)(digit + 48);
            if ((tvalue /= 10) == 0) break;
            --i;
        }
        if (minus) {
            chars[--i] = 45;
        }
        return new String(chars, i, 11 - i);
    }

    public static String toUString(int value) {
        int tvalue = value;
        char[] chars = new char[11];
        int i = 10;
        while (i >= 0) {
            int digit = tvalue % 10;
            chars[i] = (char)(digit + 48);
            if ((tvalue /= 10) == 0) break;
            --i;
        }
        return new String(chars, i, 11 - i);
    }
}

