/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.control.profile;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.soda.dk.command.Command;
import org.eclipse.soda.dk.command.MethodCommand;
import org.eclipse.soda.dk.control.profile.service.ControlProfileService;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.measurement.Measurement;
import org.eclipse.soda.dk.measurement.MethodMeasurement;
import org.eclipse.soda.dk.measurement.ReadOnlyMeasurement;
import org.eclipse.soda.dk.measurement.service.MeasurementListener;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.profile.Profile;
import org.eclipse.soda.dk.profile.service.ProfileService;
import org.osgi.framework.Filter;

public class ControlProfile
extends Profile
implements ProfileService,
ControlProfileService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.control.profile.ControlProfile";
    private final MethodCommand bitsChangeRequest = new MethodCommand("Control/BitsChangeRequest");
    private final MethodCommand longsChangeRequest = new MethodCommand("Control/LongsChangeRequest");
    private final ReadOnlyMeasurement bitsCount = new ReadOnlyMeasurement("Control/BitsCount", (Object)ControlProfile.createInteger((int)32));
    private final ReadOnlyMeasurement longsCount = new ReadOnlyMeasurement("Control/LongsCount", (Object)ControlProfile.createInteger((int)32));
    private final MethodMeasurement bits = new MethodMeasurement("Control/Bits", new HashMap());
    private final MethodMeasurement longs = new MethodMeasurement("Control/Longs", new HashMap());
    private final Measurement b1Expression = new Measurement("Control/B1Expression", (Object)"");
    private final Measurement b2Expression = new Measurement("Control/B2Expression", (Object)"");
    private final Measurement b3Expression = new Measurement("Control/B3Expression", (Object)"");
    private final Measurement b4Expression = new Measurement("Control/B4Expression", (Object)"");
    private final Measurement b5Expression = new Measurement("Control/B5Expression", (Object)"");
    private final Measurement b6Expression = new Measurement("Control/B6Expression", (Object)"");
    private final Measurement b7Expression = new Measurement("Control/B7Expression", (Object)"");
    private final Measurement b8Expression = new Measurement("Control/B8Expression", (Object)"");
    private final Measurement b9Expression = new Measurement("Control/B9Expression", (Object)"");
    private final Measurement b10Expression = new Measurement("Control/B10Expression", (Object)"");
    private final Measurement b11Expression = new Measurement("Control/B11Expression", (Object)"");
    private final Measurement b12Expression = new Measurement("Control/B12Expression", (Object)"");
    private final Measurement b13Expression = new Measurement("Control/B13Expression", (Object)"");
    private final Measurement b14Expression = new Measurement("Control/B14Expression", (Object)"");
    private final Measurement b15Expression = new Measurement("Control/B15Expression", (Object)"");
    private final Measurement b16Expression = new Measurement("Control/B16Expression", (Object)"");
    private final Measurement b17Expression = new Measurement("Control/B17Expression", (Object)"");
    private final Measurement b18Expression = new Measurement("Control/B18Expression", (Object)"");
    private final Measurement b19Expression = new Measurement("Control/B19Expression", (Object)"");
    private final Measurement b20Expression = new Measurement("Control/B20Expression", (Object)"");
    private final Measurement b21Expression = new Measurement("Control/B21Expression", (Object)"");
    private final Measurement b22Expression = new Measurement("Control/B22Expression", (Object)"");
    private final Measurement b23Expression = new Measurement("Control/B23Expression", (Object)"");
    private final Measurement b24Expression = new Measurement("Control/B24Expression", (Object)"");
    private final Measurement b25Expression = new Measurement("Control/B25Expression", (Object)"");
    private final Measurement b26Expression = new Measurement("Control/B26Expression", (Object)"");
    private final Measurement b27Expression = new Measurement("Control/B27Expression", (Object)"");
    private final Measurement b28Expression = new Measurement("Control/B28Expression", (Object)"");
    private final Measurement b29Expression = new Measurement("Control/B29Expression", (Object)"");
    private final Measurement b30Expression = new Measurement("Control/B30Expression", (Object)"");
    private final Measurement b31Expression = new Measurement("Control/B31Expression", (Object)"");
    private final Measurement b32Expression = new Measurement("Control/B32Expression", (Object)"");
    private final MethodMeasurement rateTime = new MethodMeasurement("Control/RateTime");
    public static final int SIZE = 32;
    public static final int HASH_SIZE = 61;
    public static final String[] BIT_NAMES = new String[]{"b0", "b1", "b2", "b3", "b4", "b5", "b6", "b7", "b8", "b9", "b10", "b11", "b12", "b13", "b14", "b15", "b16", "b17", "b18", "b19", "b20", "b21", "b22", "b23", "b24", "b25", "b26", "b27", "b28", "b29", "b30", "b31", "b32"};
    public static final String[] LONG_NAMES = new String[]{"l0", "l1", "l2", "l3", "l4", "l5", "l6", "l7", "l8", "l9", "l10", "l11", "l12", "l13", "l14", "l15", "l16", "l17", "l18", "l19", "l20", "l21", "l22", "l23", "l24", "l25", "l26", "l27", "l28", "l29", "l30", "l31", "l32"};
    public static final String[] BIT_DURATION_NAMES = new String[]{"b0duration", "b1duration", "b2duration", "b3duration", "b4duration", "b5duration", "b6duration", "b7duration", "b8duration", "b9duration", "b10duration", "b11duration", "b12duration", "b13duration", "b14duration", "b15duration", "b16duration", "b17duration", "b18duration", "b19duration", "b20duration", "b21duration", "b22duration", "b23duration", "b24duration", "b25duration", "b26duration", "b27duration", "b28duration", "b29duration", "b30duration", "b31duration", "b32duration"};
    protected int expressionCount = 0;
    protected boolean running = false;
    protected Filter[] bitFilters = new Filter[33];
    protected Boolean[] bitValues = new Boolean[33];
    protected long[] duration = new long[33];
    private Thread thread;
    private long rate = 100L;
    protected long startTime = System.currentTimeMillis();
    private Hashtable dictionary = new Hashtable(151);

    public ControlProfile() {
        super("ControlProfile/Capabilities", "ControlProfile/Status", "ControlProfile/Configuration", "ControlProfile/Metrics");
        this.setKey(this.getDefaultKey());
        this.initialize();
    }

    public void measurementChanged(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        if (this.b1Expression == source) {
            this.handleB1Expression(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.b2Expression == source) {
            this.handleB2Expression(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.b3Expression == source) {
            this.handleB3Expression(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.b4Expression == source) {
            this.handleB4Expression(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.b5Expression == source) {
            this.handleB5Expression(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.b6Expression == source) {
            this.handleB6Expression(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.b7Expression == source) {
            this.handleB7Expression(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.b8Expression == source) {
            this.handleB8Expression(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.b9Expression == source) {
            this.handleB9Expression(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.b10Expression == source) {
            this.handleB10Expression(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.b11Expression == source) {
            this.handleB11Expression(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.b12Expression == source) {
            this.handleB12Expression(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.b13Expression == source) {
            this.handleB13Expression(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.b14Expression == source) {
            this.handleB14Expression(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.b15Expression == source) {
            this.handleB15Expression(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.b16Expression == source) {
            this.handleB16Expression(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.b17Expression == source) {
            this.handleB17Expression(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.b18Expression == source) {
            this.handleB18Expression(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.b19Expression == source) {
            this.handleB19Expression(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.b20Expression == source) {
            this.handleB20Expression(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.b21Expression == source) {
            this.handleB21Expression(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.b22Expression == source) {
            this.handleB22Expression(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.b23Expression == source) {
            this.handleB23Expression(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.b24Expression == source) {
            this.handleB24Expression(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.b25Expression == source) {
            this.handleB25Expression(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.b26Expression == source) {
            this.handleB26Expression(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.b27Expression == source) {
            this.handleB27Expression(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.b28Expression == source) {
            this.handleB28Expression(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.b29Expression == source) {
            this.handleB29Expression(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.b30Expression == source) {
            this.handleB30Expression(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.b31Expression == source) {
            this.handleB31Expression(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.b32Expression == source) {
            this.handleB32Expression(source, timestamp, newValue, oldValue);
            return;
        }
        super.measurementChanged(source, timestamp, newValue, oldValue);
    }

    public String getDefaultKey() {
        return "ControlProfile";
    }

    public DeviceService getDefaultDevice() {
        return null;
    }

    public boolean isDeviceNeeded() {
        return false;
    }

    public int getControlCapacity() {
        return 59;
    }

    public int getMessageCapacity() {
        return 2;
    }

    private void initialize() {
        MethodCommand bitsChangeRequest = this.bitsChangeRequest;
        this.put((ControlService)bitsChangeRequest);
        MethodCommand longsChangeRequest = this.longsChangeRequest;
        this.put((ControlService)longsChangeRequest);
        ReadOnlyMeasurement bitsCount = this.bitsCount;
        this.put((ControlService)bitsCount);
        ReadOnlyMeasurement longsCount = this.longsCount;
        this.put((ControlService)longsCount);
        MethodMeasurement bits = this.bits;
        this.put((ControlService)bits);
        MethodMeasurement longs = this.longs;
        this.put((ControlService)longs);
        Measurement b1Expression = this.b1Expression;
        this.put((ControlService)b1Expression);
        this.b1Expression.addMeasurementListener((MeasurementListener)this);
        Measurement b2Expression = this.b2Expression;
        this.put((ControlService)b2Expression);
        this.b2Expression.addMeasurementListener((MeasurementListener)this);
        Measurement b3Expression = this.b3Expression;
        this.put((ControlService)b3Expression);
        this.b3Expression.addMeasurementListener((MeasurementListener)this);
        Measurement b4Expression = this.b4Expression;
        this.put((ControlService)b4Expression);
        this.b4Expression.addMeasurementListener((MeasurementListener)this);
        Measurement b5Expression = this.b5Expression;
        this.put((ControlService)b5Expression);
        this.b5Expression.addMeasurementListener((MeasurementListener)this);
        Measurement b6Expression = this.b6Expression;
        this.put((ControlService)b6Expression);
        this.b6Expression.addMeasurementListener((MeasurementListener)this);
        Measurement b7Expression = this.b7Expression;
        this.put((ControlService)b7Expression);
        this.b7Expression.addMeasurementListener((MeasurementListener)this);
        Measurement b8Expression = this.b8Expression;
        this.put((ControlService)b8Expression);
        this.b8Expression.addMeasurementListener((MeasurementListener)this);
        Measurement b9Expression = this.b9Expression;
        this.put((ControlService)b9Expression);
        this.b9Expression.addMeasurementListener((MeasurementListener)this);
        Measurement b10Expression = this.b10Expression;
        this.put((ControlService)b10Expression);
        this.b10Expression.addMeasurementListener((MeasurementListener)this);
        Measurement b11Expression = this.b11Expression;
        this.put((ControlService)b11Expression);
        this.b11Expression.addMeasurementListener((MeasurementListener)this);
        Measurement b12Expression = this.b12Expression;
        this.put((ControlService)b12Expression);
        this.b12Expression.addMeasurementListener((MeasurementListener)this);
        Measurement b13Expression = this.b13Expression;
        this.put((ControlService)b13Expression);
        this.b13Expression.addMeasurementListener((MeasurementListener)this);
        Measurement b14Expression = this.b14Expression;
        this.put((ControlService)b14Expression);
        this.b14Expression.addMeasurementListener((MeasurementListener)this);
        Measurement b15Expression = this.b15Expression;
        this.put((ControlService)b15Expression);
        this.b15Expression.addMeasurementListener((MeasurementListener)this);
        Measurement b16Expression = this.b16Expression;
        this.put((ControlService)b16Expression);
        this.b16Expression.addMeasurementListener((MeasurementListener)this);
        Measurement b17Expression = this.b17Expression;
        this.put((ControlService)b17Expression);
        this.b17Expression.addMeasurementListener((MeasurementListener)this);
        Measurement b18Expression = this.b18Expression;
        this.put((ControlService)b18Expression);
        this.b18Expression.addMeasurementListener((MeasurementListener)this);
        Measurement b19Expression = this.b19Expression;
        this.put((ControlService)b19Expression);
        this.b19Expression.addMeasurementListener((MeasurementListener)this);
        Measurement b20Expression = this.b20Expression;
        this.put((ControlService)b20Expression);
        this.b20Expression.addMeasurementListener((MeasurementListener)this);
        Measurement b21Expression = this.b21Expression;
        this.put((ControlService)b21Expression);
        this.b21Expression.addMeasurementListener((MeasurementListener)this);
        Measurement b22Expression = this.b22Expression;
        this.put((ControlService)b22Expression);
        this.b22Expression.addMeasurementListener((MeasurementListener)this);
        Measurement b23Expression = this.b23Expression;
        this.put((ControlService)b23Expression);
        this.b23Expression.addMeasurementListener((MeasurementListener)this);
        Measurement b24Expression = this.b24Expression;
        this.put((ControlService)b24Expression);
        this.b24Expression.addMeasurementListener((MeasurementListener)this);
        Measurement b25Expression = this.b25Expression;
        this.put((ControlService)b25Expression);
        this.b25Expression.addMeasurementListener((MeasurementListener)this);
        Measurement b26Expression = this.b26Expression;
        this.put((ControlService)b26Expression);
        this.b26Expression.addMeasurementListener((MeasurementListener)this);
        Measurement b27Expression = this.b27Expression;
        this.put((ControlService)b27Expression);
        this.b27Expression.addMeasurementListener((MeasurementListener)this);
        Measurement b28Expression = this.b28Expression;
        this.put((ControlService)b28Expression);
        this.b28Expression.addMeasurementListener((MeasurementListener)this);
        Measurement b29Expression = this.b29Expression;
        this.put((ControlService)b29Expression);
        this.b29Expression.addMeasurementListener((MeasurementListener)this);
        Measurement b30Expression = this.b30Expression;
        this.put((ControlService)b30Expression);
        this.b30Expression.addMeasurementListener((MeasurementListener)this);
        Measurement b31Expression = this.b31Expression;
        this.put((ControlService)b31Expression);
        this.b31Expression.addMeasurementListener((MeasurementListener)this);
        Measurement b32Expression = this.b32Expression;
        this.put((ControlService)b32Expression);
        this.b32Expression.addMeasurementListener((MeasurementListener)this);
        MethodMeasurement rateTime = this.rateTime;
        this.put((ControlService)rateTime);
    }

    public void setup() {
        super.setup();
        this.setNotificationPriority(this.getInt("controlprofile.notificationpriority", this.getNotificationPriority()));
    }

    public boolean isAdapterNeeded() {
        return false;
    }

    public void evaluate(boolean changes, long time) {
        boolean changed = changes;
        int i = 1;
        while (i <= 32) {
            boolean value;
            Filter filter = this.bitFilters[i];
            if (filter != null && (value = filter.match((Dictionary)this.dictionary)) != this.bitValues[i]) {
                this.duration[i] = time;
                this.bitValues[i] = value ? Boolean.TRUE : Boolean.FALSE;
                changed = true;
            }
            ++i;
        }
        if (changed) {
            Hashtable<String, Boolean> table = new Hashtable<String, Boolean>(61);
            int i2 = 1;
            while (i2 <= 32) {
                table.put(BIT_NAMES[i2], this.bitValues[i2]);
                ++i2;
            }
            this.bits.setValue(table, ControlProfile.getCurrentTimestamp());
            this.dictionary.putAll(table);
        }
    }

    public int getExpressionCount() {
        return this.expressionCount;
    }

    public int getNotificationPriorityDefault() {
        return 0;
    }

    public long getRate() {
        return this.rate;
    }

    protected void handleB10Expression(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateFilter(10, newValue);
    }

    protected void handleB11Expression(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateFilter(11, newValue);
    }

    protected void handleB12Expression(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateFilter(12, newValue);
    }

    protected void handleB13Expression(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateFilter(13, newValue);
    }

    protected void handleB14Expression(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateFilter(14, newValue);
    }

    protected void handleB15Expression(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateFilter(15, newValue);
    }

    protected void handleB16Expression(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateFilter(16, newValue);
    }

    protected void handleB17Expression(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateFilter(17, newValue);
    }

    protected void handleB18Expression(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateFilter(18, newValue);
    }

    protected void handleB19Expression(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateFilter(19, newValue);
    }

    protected void handleB1Expression(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateFilter(1, newValue);
    }

    protected void handleB20Expression(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateFilter(20, newValue);
    }

    protected void handleB21Expression(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateFilter(21, newValue);
    }

    protected void handleB22Expression(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateFilter(22, newValue);
    }

    protected void handleB23Expression(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateFilter(23, newValue);
    }

    protected void handleB24Expression(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateFilter(24, newValue);
    }

    protected void handleB25Expression(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateFilter(25, newValue);
    }

    protected void handleB26Expression(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateFilter(26, newValue);
    }

    protected void handleB27Expression(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateFilter(27, newValue);
    }

    protected void handleB28Expression(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateFilter(28, newValue);
    }

    protected void handleB29Expression(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateFilter(29, newValue);
    }

    protected void handleB2Expression(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateFilter(2, newValue);
    }

    protected void handleB30Expression(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateFilter(30, newValue);
    }

    protected void handleB31Expression(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateFilter(31, newValue);
    }

    protected void handleB32Expression(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateFilter(32, newValue);
    }

    protected void handleB3Expression(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateFilter(3, newValue);
    }

    protected void handleB4Expression(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateFilter(4, newValue);
    }

    protected void handleB5Expression(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateFilter(5, newValue);
    }

    protected void handleB6Expression(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateFilter(6, newValue);
    }

    protected void handleB7Expression(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateFilter(7, newValue);
    }

    protected void handleB8Expression(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateFilter(8, newValue);
    }

    protected void handleB9Expression(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateFilter(9, newValue);
    }

    public Object handleMethodBits(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                if (data instanceof Map) {
                    Map map = (Map)data;
                    this.updateBits(map);
                    break;
                }
                throw new IllegalArgumentException(String.valueOf(data));
            }
        }
        return null;
    }

    public Object handleMethodBitsChangeRequest(int code, Command command, Object data) {
        switch (code) {
            case 0: {
                if (data instanceof Map) {
                    Map map = (Map)data;
                    this.updateBits(map);
                    break;
                }
                throw new IllegalArgumentException(String.valueOf(data));
            }
        }
        return null;
    }

    public Object handleMethodLongs(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                if (data instanceof Map) {
                    Map map = (Map)data;
                    this.updateLongs(map);
                    break;
                }
                throw new IllegalArgumentException(String.valueOf(data));
            }
        }
        return null;
    }

    public Object handleMethodLongsChangeRequest(int code, Command command, Object data) {
        switch (code) {
            case 0: {
                if (data instanceof Map) {
                    Map map = (Map)data;
                    this.updateLongs(map);
                    break;
                }
                throw new IllegalArgumentException(String.valueOf(data));
            }
        }
        return null;
    }

    public Object handleMethodRateTime(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                Number numberValue = this.getNumberValue(data);
                if (numberValue != null) {
                    long rate = numberValue.longValue();
                    this.setRate(rate);
                    measurement.setValue((Object)numberValue, ControlProfile.getCurrentTimestamp());
                }
                this.updateExpressionCount();
            }
        }
        return null;
    }

    public boolean hasExpressions() {
        return this.getExpressionCount() > 0;
    }

    public int search(String[] names, String key) {
        int i = 0;
        while (i < names.length) {
            if (key.equals(names[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setExpressionCount(int expressionCount) {
        this.expressionCount = expressionCount;
    }

    public void setRate(long rate) {
        this.rate = rate;
    }

    public void setupCustom() {
        this.startTime = System.currentTimeMillis();
        Object timestamp = ControlProfile.getCurrentTimestamp();
        this.dictionary = new Hashtable(151);
        Hashtable<String, Boolean> table = new Hashtable<String, Boolean>(61);
        Boolean bitStart = Boolean.FALSE;
        Integer durationObject = ControlProfile.createInteger((int)0);
        int i = 1;
        while (i <= 32) {
            this.duration[i] = this.startTime;
            this.bitValues[i] = bitStart;
            table.put(BIT_NAMES[i], this.bitValues[i]);
            this.dictionary.put(BIT_DURATION_NAMES[i], durationObject);
            ++i;
        }
        this.dictionary.putAll(table);
        this.bits.setValue(table, timestamp);
        Hashtable<String, Long> longs = new Hashtable<String, Long>(61);
        Long longStart = ControlProfile.createLong((long)0L);
        int i2 = 1;
        while (i2 <= 32) {
            longs.put(LONG_NAMES[i2], longStart);
            ++i2;
        }
        this.dictionary.putAll(longs);
        this.longs.setValue(longs, timestamp);
        this.timer();
        super.setupCustom();
    }

    public void stop() {
        this.stopTimer();
        super.stop();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopTimer() {
        this.running = false;
        if (this.thread == null) return;
        try {
            try {
                this.thread.interrupt();
                this.thread.join(this.rate);
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.thread = null;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.thread = null;
            return;
        }
    }

    protected void timer() {
        if (this.thread == null) {
            if (this.hasExpressions() && this.rate > 0L) {
                this.thread = new Thread(new Runnable(){

                    public void run() {
                        ControlProfile.this.timerRun();
                    }
                }, "ControlProfileTimer");
                this.thread.setDaemon(true);
                this.running = true;
                this.thread.start();
            }
        } else if (!this.hasExpressions() || this.rate <= 0L) {
            this.stopTimer();
        }
    }

    public void timerRun() {
        while (this.running) {
            try {
                Thread.sleep(this.rate);
                if (!this.running) continue;
                this.updateDuration(false, System.currentTimeMillis());
            }
            catch (Exception exception) {
                this.running = false;
                return;
            }
        }
    }

    protected synchronized void update(boolean changes) {
        long time = System.currentTimeMillis();
        this.update(changes, time);
    }

    public synchronized void update(boolean changes, long time) {
        long durationLast = 0L;
        Number numberLast = ControlProfile.createNumber((long)durationLast);
        int i = 1;
        while (i <= 32) {
            long duration = time - this.duration[i];
            if (duration == durationLast) {
                this.dictionary.put(BIT_DURATION_NAMES[i], numberLast);
            } else {
                Number number = ControlProfile.createNumber((long)duration);
                this.dictionary.put(BIT_DURATION_NAMES[i], number);
                durationLast = duration;
                numberLast = number;
            }
            this.dictionary.put(BIT_NAMES[i], this.bitValues[i]);
            ++i;
        }
        this.evaluate(changes, time);
    }

    public void updateBits(Map map) throws RuntimeException {
        long time = System.currentTimeMillis();
        boolean changes = false;
        Boolean[] bitValueNew = new Boolean[this.bitValues.length];
        System.arraycopy(this.bitValues, 0, bitValueNew, 0, this.bitValues.length);
        long[] durationNew = new long[this.duration.length];
        System.arraycopy(this.duration, 0, durationNew, 0, this.duration.length);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = String.valueOf(entry.getKey());
            int index = this.search(BIT_NAMES, key);
            if (index < 0) {
                throw new IllegalArgumentException(key);
            }
            if (this.bitFilters[index] == null) {
                Object value = entry.getValue();
                Boolean booleanValue = this.getBooleanValue(value);
                if (booleanValue.equals(bitValueNew[index])) continue;
                bitValueNew[index] = booleanValue;
                durationNew[index] = time;
                changes = true;
                continue;
            }
            throw new IllegalArgumentException(key);
        }
        this.bitValues = bitValueNew;
        this.duration = durationNew;
        this.update(changes, time);
    }

    public synchronized void updateDuration(boolean changes, long time) {
        long durationLast = 0L;
        Number numberLast = null;
        int i = 1;
        while (i <= 32) {
            long duration = time - this.duration[i];
            if (duration == durationLast && i > 1) {
                this.dictionary.put(BIT_DURATION_NAMES[i], numberLast);
            } else {
                Number number = ControlProfile.createNumber((long)duration);
                this.dictionary.put(BIT_DURATION_NAMES[i], number);
                durationLast = duration;
                numberLast = number;
            }
            ++i;
        }
        this.evaluate(changes, time);
    }

    public void updateExpressionCount() {
        int count = 0;
        int i = 1;
        while (i <= 32) {
            Filter filter = this.bitFilters[i];
            if (filter != null) {
                ++count;
            }
            ++i;
        }
        this.setExpressionCount(count);
        this.timer();
    }

    protected void updateFilter(int index, Object newValue) {
        Filter filter = null;
        if (newValue instanceof String) {
            String filterString = (String)newValue;
            try {
                if (filterString.length() > 0) {
                    filter = this.createFilter(filterString);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.bitFilters[index] = filter;
        this.updateExpressionCount();
    }

    public void updateLongs(Map map) throws RuntimeException {
        boolean changes = false;
        Object object = this.longs.getValue();
        if (object instanceof Map) {
            Map currentMap = (Map)object;
            Hashtable<String, Long> newMap = new Hashtable<String, Long>(61);
            newMap.putAll(currentMap);
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String key = String.valueOf(entry.getKey());
                int index = this.search(LONG_NAMES, key);
                if (index < 0) {
                    throw new IllegalArgumentException(key);
                }
                Object value = entry.getValue();
                Long longValue = this.getLongValue(value);
                if (longValue.equals(currentMap.get(key))) continue;
                newMap.put(LONG_NAMES[index], longValue);
                this.dictionary.put(LONG_NAMES[index], longValue);
                changes = true;
            }
            if (changes) {
                this.longs.setValue(newMap, ControlProfile.getCurrentTimestamp());
                this.evaluate(changes, System.currentTimeMillis());
            }
        }
    }
}

