/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.transport.wizard;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.soda.devicekit.generator.model.ConfigurationModel;
import org.eclipse.soda.devicekit.preference.DeviceKitPreferenceInitializer;
import org.eclipse.soda.devicekit.ui.transport.wizard.ConnectionModelPage;
import org.eclipse.soda.devicekit.ui.transport.wizard.DeviceKitConnectionPage;
import org.eclipse.soda.devicekit.ui.transport.wizard.FileConnectionPage;
import org.eclipse.soda.devicekit.ui.transport.wizard.RandomAccessFileConnectionPage;
import org.eclipse.soda.devicekit.ui.transport.wizard.SerialConnectionPage;
import org.eclipse.soda.devicekit.ui.transport.wizard.SslConnectionPage;
import org.eclipse.soda.devicekit.ui.transport.wizard.SslServerConnectionPage;
import org.eclipse.soda.devicekit.ui.transport.wizard.TcpipConnectionPage;
import org.eclipse.soda.devicekit.ui.transport.wizard.TcpipServerConnectionPage;
import org.eclipse.soda.devicekit.ui.transport.wizard.TransportMessages;
import org.eclipse.soda.devicekit.ui.transport.wizard.UdpConnectionPage;
import org.eclipse.soda.devicekit.ui.transport.wizard.UdpServerConnectionPage;
import org.eclipse.soda.devicekit.ui.transport.wizard.UrlConnectionPage;
import org.eclipse.soda.devicekit.ui.wizard.DeviceKitBasePage;
import org.eclipse.soda.devicekit.ui.wizard.DeviceKitPage;
import org.eclipse.soda.devicekit.ui.wizard.IWizardMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class TransportDetailsPage
extends DeviceKitBasePage {
    private static IWizardMessages messages = TransportMessages.getInstance();
    private WizardPage nextPage;
    private String custom;
    private String none;
    protected Map connectionModelPages = new HashMap(57);
    private DeviceKitConnectionPage filePage;
    private DeviceKitConnectionPage randomaccessfilePage;
    private DeviceKitConnectionPage serialPage;
    private DeviceKitConnectionPage sslPage;
    private DeviceKitConnectionPage sslserverPage;
    private DeviceKitConnectionPage tcpipPage;
    private DeviceKitConnectionPage tcpipserverPage;
    private DeviceKitConnectionPage urlPage;
    private DeviceKitConnectionPage udpPage;
    private DeviceKitConnectionPage udpserverPage;

    public TransportDetailsPage(String pageName) {
        this(pageName, "transport", TransportMessages.getInstance());
    }

    public TransportDetailsPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public TransportDetailsPage(String pageName, String key, IWizardMessages messages) {
        super(messages.getString("new." + key));
        TransportDetailsPage.messages = messages;
        this.custom = TransportDetailsPage.messages.getString("custom");
        this.none = TransportDetailsPage.messages.getString("none");
        this.setTitle(TransportDetailsPage.messages.getString(String.valueOf(key) + ".details"));
    }

    private boolean connectionOk() {
        this.updateConnection();
        String value = this.getWidgetText("connection");
        if (this.none.equals(value)) {
            return true;
        }
        if (this.custom.equals(value)) {
            String custom = this.getWidgetText("custom.connection.implementation");
            if (custom.trim().length() == 0) {
                String message = this.getString("custom.connection.implementation.empty");
                this.update(false, false, null, message);
                return false;
            }
            this.update(true, false, null, null);
            return true;
        }
        this.update(false, true, null, null);
        return false;
    }

    protected void createCommonControl(Composite composite) {
    }

    protected void createCustomControl(Composite composite) {
        this.createTextControl(composite, "response.timeout");
        this.createTextControl(composite, "retry.time");
        this.createTextControl(composite, "transmit.retries");
        Combo combo = this.createComboControl(composite, "connection", this.getConnections(), 2060);
        combo.select(0);
        Text customImpl = this.createTextControl(composite, "custom.connection.implementation");
        customImpl.setEnabled(false);
        this.createComboControl(composite, "superclass", this.getSuperclass(), 2060);
        this.createOptions(composite);
    }

    protected void createOptions(Composite composite) {
        SelectionListener listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TransportDetailsPage.this.handleButtonSelection();
            }
        };
        String labelString = this.getString("options");
        Button button = this.createCheckBoxControl(composite, "abstract.transport", labelString);
        button.setEnabled(false);
        button.addSelectionListener(listener);
        button = this.createCheckBoxControl(composite, "processInput");
        button.setSelection(true);
        button = this.createCheckBoxControl(composite, "write");
        button.setSelection(true);
    }

    public ConnectionModelPage getConnectionModelPage(String type) {
        Object value = this.getConnectionModelPages().get(type);
        if (value instanceof ConnectionModelPage) {
            return (ConnectionModelPage)((Object)value);
        }
        ConfigurationModel connectionModel = ConfigurationModel.getConnection((String)type);
        if (connectionModel != null) {
            ConnectionModelPage connectionModelPage = new ConnectionModelPage(type, this, messages, this.getDefaultMessage());
            connectionModelPage.setWizard(this.getWizard());
            this.getConnectionModelPages().put(type, connectionModelPage);
            return connectionModelPage;
        }
        return null;
    }

    public Map getConnectionModelPages() {
        return this.connectionModelPages;
    }

    protected String[] getConnections() {
        String[] modelConnections = ConfigurationModel.CONNECTION_KEYS;
        String[] specialConnections = new String[]{this.none, this.custom};
        String[] connections = new String[specialConnections.length + modelConnections.length];
        System.arraycopy(specialConnections, 0, connections, 0, specialConnections.length);
        System.arraycopy(modelConnections, 0, connections, specialConnections.length, modelConnections.length);
        return connections;
    }

    public DeviceKitConnectionPage getFileConnectionPage() {
        if (this.filePage == null) {
            this.filePage = new FileConnectionPage("file", messages, this.getDefaultMessage(), this);
            this.filePage.setWizard(this.getWizard());
        }
        return this.filePage;
    }

    protected String getKey() {
        return "transport";
    }

    public IWizardPage getNextPage() {
        return this.nextPage;
    }

    public DeviceKitConnectionPage getRandomAccessFileConnectionPage() {
        if (this.randomaccessfilePage == null) {
            this.randomaccessfilePage = new RandomAccessFileConnectionPage("randomaccessfile", messages, this.getDefaultMessage(), this);
            this.randomaccessfilePage.setWizard(this.getWizard());
        }
        return this.randomaccessfilePage;
    }

    public DeviceKitConnectionPage getSSLConnectionPage() {
        if (this.sslPage == null) {
            this.sslPage = new SslConnectionPage("ssl", messages, this.getDefaultMessage(), this);
            this.sslPage.setWizard(this.getWizard());
        }
        return this.sslPage;
    }

    public DeviceKitConnectionPage getSSLServerConnectionPage() {
        if (this.sslserverPage == null) {
            this.sslserverPage = new SslServerConnectionPage("sslserver", messages, this.getDefaultMessage(), this);
            this.sslserverPage.setWizard(this.getWizard());
        }
        return this.sslserverPage;
    }

    public DeviceKitConnectionPage getSerialConnectionPage() {
        if (this.serialPage == null) {
            this.serialPage = new SerialConnectionPage("serial", messages, this.getDefaultMessage(), this);
            this.serialPage.setWizard(this.getWizard());
        }
        return this.serialPage;
    }

    public String getString(String key) {
        try {
            return messages.getString(key);
        }
        catch (Exception exception) {
            return super.getString(key);
        }
    }

    protected String[] getSuperclass() {
        String value = DeviceKitPreferenceInitializer.getPreferenceString((String)"transport.superclass");
        if (value != null) {
            return DeviceKitPreferenceInitializer.parsePrefArray((String)value);
        }
        return new String[0];
    }

    public DeviceKitConnectionPage getTcpipConnectionPage() {
        if (this.tcpipPage == null) {
            this.tcpipPage = new TcpipConnectionPage("tcpip", messages, this.getDefaultMessage(), this);
            this.tcpipPage.setWizard(this.getWizard());
        }
        return this.tcpipPage;
    }

    public DeviceKitConnectionPage getTcpipServerConnectionPage() {
        if (this.tcpipserverPage == null) {
            this.tcpipserverPage = new TcpipServerConnectionPage("tcpipserver", messages, this.getDefaultMessage(), this);
            this.tcpipserverPage.setWizard(this.getWizard());
        }
        return this.tcpipserverPage;
    }

    public DeviceKitConnectionPage getUdpConnectionPage() {
        if (this.udpPage == null) {
            this.udpPage = new UdpConnectionPage("udp", messages, this.getDefaultMessage(), this);
            this.udpPage.setWizard(this.getWizard());
        }
        return this.udpPage;
    }

    public DeviceKitConnectionPage getUdpPage() {
        return this.udpPage;
    }

    public DeviceKitConnectionPage getUdpServerConnectionPage() {
        if (this.udpserverPage == null) {
            this.udpserverPage = new UdpServerConnectionPage("udpserver", messages, this.getDefaultMessage(), this);
            this.udpserverPage.setWizard(this.getWizard());
        }
        return this.udpserverPage;
    }

    public DeviceKitConnectionPage getUdpServerPage() {
        return this.udpserverPage;
    }

    public DeviceKitConnectionPage getUrlConnectionPage() {
        if (this.urlPage == null) {
            this.urlPage = new UrlConnectionPage("url", messages, this.getDefaultMessage(), this);
            this.urlPage.setWizard(this.getWizard());
        }
        return this.urlPage;
    }

    public Map getVariables() {
        if (this.getNextPage() != null) {
            return this.mergeVariableTables();
        }
        return super.getVariables();
    }

    protected void handleButtonSelection() {
        Button createTest = (Button)this.getWidget("create.test");
        Button abstractTransport = (Button)this.getWidget("abstract.transport");
        if (createTest == null || abstractTransport == null) {
            return;
        }
        boolean createTestValue = createTest.getSelection();
        boolean abstractTransportValue = abstractTransport.getSelection();
        if (createTestValue) {
            abstractTransport.setSelection(false);
            abstractTransport.setEnabled(false);
        } else if (abstractTransportValue) {
            createTest.setSelection(false);
            createTest.setEnabled(false);
        } else {
            abstractTransport.setEnabled(true);
            createTest.setEnabled(true);
        }
    }

    public boolean isDisplayTest() {
        return false;
    }

    private Map mergeVariableTables() {
        DeviceKitPage page = (DeviceKitPage)this.getNextPage();
        Map transportVariables = super.getVariables();
        Map conVariables = page.getVariables();
        Iterator conKeys = conVariables.keySet().iterator();
        while (conKeys.hasNext()) {
            Object conKey = conKeys.next();
            Object conValue = conVariables.get(conKey);
            transportVariables.put(conKey, conValue);
        }
        return transportVariables;
    }

    private boolean responseTimeOutOk() {
        return this.isNumberTextEntry("response.timeout", true);
    }

    public void setConnectionModelPages(Map connectionModelPages) {
        this.connectionModelPages = connectionModelPages;
    }

    public void setNextPage(DeviceKitConnectionPage page) {
        if (page == null) {
            this.nextPage = page;
        } else if (!((Object)((Object)page)).equals(this.nextPage)) {
            this.nextPage = page;
        }
    }

    public void setUdpPage(DeviceKitConnectionPage udpPage) {
        this.udpPage = udpPage;
    }

    public void setUdpserverPage(DeviceKitConnectionPage udpserverPage) {
        this.udpserverPage = udpserverPage;
    }

    private void updateConnection() {
        Combo connection = (Combo)this.getWidget("connection");
        int index = connection.getSelectionIndex();
        String selection = connection.getItem(index);
        Text customConnection = (Text)this.getWidget("custom.connection.implementation");
        if (this.custom.equals(selection)) {
            customConnection.setEnabled(true);
            this.setNextPage(null);
        } else if (this.none.equals(selection)) {
            customConnection.setEnabled(false);
            this.setNextPage(null);
        } else {
            customConnection.setEnabled(false);
            String key = selection;
            ConnectionModelPage connectionModelPage = this.getConnectionModelPage(key);
            if (connectionModelPage != null) {
                this.setNextPage(connectionModelPage);
            }
        }
    }

    protected boolean updatePageErrors() {
        if (!this.responseTimeOutOk()) {
            return false;
        }
        if (!this.connectionOk()) {
            return false;
        }
        this.update(true, this.getNextPage() != null, null, null);
        return true;
    }
}

