/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.samples.wizard;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.soda.devicekit.ui.samples.SampleImages;
import org.eclipse.soda.devicekit.ui.samples.SamplePlugin;
import org.eclipse.soda.devicekit.ui.samples.extension.WizardContent;
import org.eclipse.soda.devicekit.ui.samples.extension.WizardContentLoader;
import org.eclipse.soda.devicekit.ui.samples.wizard.SampleWizardPage;
import org.eclipse.soda.devicekit.ui.samples.wizard.ZipToProjectOperation;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class SampleCreationWizard
extends Wizard
implements INewWizard {
    boolean success = false;
    protected List projects;
    WizardContent[] wizardContent;

    public SampleCreationWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(this.getWindowTitle());
        this.setDefaultPageImageDescriptor(SampleImages.DESC_WIZBAN);
        this.projects = new ArrayList();
    }

    public void addPages() {
        this.loadContent();
        SampleWizardPage page = new SampleWizardPage(this.getPageName(), this.getPageDescription(), this.wizardContent);
        this.addPage((IWizardPage)page);
        super.addPages();
    }

    private void extractZips() throws Exception {
        boolean pref = this.getBuildPreference();
        this.setBuild(false);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                IWorkspaceRoot root = SamplePlugin.getWorkspace().getRoot();
                ZipToProjectOperation op = null;
                monitor.beginTask("Creating Sample Projects", SampleCreationWizard.this.getTotalProjectNum());
                op = new ZipToProjectOperation(SampleCreationWizard.this.wizardContent, root);
                op.run(monitor);
                SampleCreationWizard.this.success = op.success();
                monitor.done();
            }
        };
        this.getContainer().run(false, true, (IRunnableWithProgress)op);
        WorkspaceModifyOperation build = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                IWorkspaceRoot root = SamplePlugin.getWorkspace().getRoot();
                root.getWorkspace().build(6, monitor);
            }
        };
        this.getContainer().run(false, false, (IRunnableWithProgress)build);
        this.setBuild(pref);
    }

    private boolean getBuildPreference() {
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        return description.isAutoBuilding();
    }

    public String getPageDescription() {
        return "Creates sample projects";
    }

    public String getPageName() {
        return "Sample Projects";
    }

    int getTotalProjectNum() {
        int totalProjectNum = 0;
        int i = 0;
        while (i < this.wizardContent.length) {
            if (this.wizardContent[i].doInstall()) {
                totalProjectNum += this.wizardContent[i].getProjectNum();
            }
            ++i;
        }
        return totalProjectNum;
    }

    public String getWindowTitle() {
        return "New Sample Projects";
    }

    File[] getZipFiles() {
        ArrayList<File> zipFiles = new ArrayList<File>();
        int i = 0;
        while (i < this.wizardContent.length) {
            File[] files = this.getZipFiles(this.wizardContent[i]);
            int j = 0;
            while (j < files.length) {
                zipFiles.add(files[j]);
                ++j;
            }
            ++i;
        }
        File[] result = new File[zipFiles.size()];
        zipFiles.toArray(result);
        return result;
    }

    private File[] getZipFiles(WizardContent content) {
        return content.getSelectedFiles();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    boolean isEclipse32jar() {
        boolean result = false;
        int i = 0;
        while (i < this.wizardContent.length) {
            if (this.wizardContent[i].isEclipse32PluginJar()) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    private void loadContent() {
        WizardContentLoader loader = new WizardContentLoader();
        this.wizardContent = loader.loadWizardContent("org.eclipse.soda.devicekit.ui.wizard1");
    }

    public boolean performFinish() {
        try {
            this.extractZips();
            return this.success;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    private void setBuild(boolean value) {
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        description.setAutoBuilding(value);
        try {
            ResourcesPlugin.getWorkspace().setDescription(description);
        }
        catch (CoreException coreException) {}
    }
}

