/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.soda.devicekit.util.DkSsiInputStream;

public class DkSsiFileInputStream
extends DkSsiInputStream {
    protected String path;

    public DkSsiFileInputStream(String path, String fileName) throws FileNotFoundException {
        super(new FileInputStream(new File(path, fileName)));
        this.path = path;
    }

    public InputStream getIncludeFile(String value) {
        try {
            return new FileInputStream(new File(this.path, value));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public InputStream getIncludeVirtual(String value) {
        try {
            return new FileInputStream(value);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        if (b != null) {
            if (offset >= 0 && offset <= b.length && length >= 0 && length <= b.length - offset) {
                int i = 0;
                while (i < length) {
                    int c;
                    try {
                        c = this.read();
                        if (c == -1) {
                            return i == 0 ? -1 : i;
                        }
                    }
                    catch (IOException e) {
                        if (i != 0) {
                            return i;
                        }
                        throw e;
                    }
                    b[offset + i] = (byte)c;
                    ++i;
                }
                return length;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        throw new NullPointerException();
    }
}

