/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.util.doc;

import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;

public class DocChanges {
    public static final String[][] OK_CHANGES = DocChanges.createOkChanges();
    public static final char[] AMP = "&amp;".toCharArray();
    public static final char[] GT = "&gt;".toCharArray();
    public static final char[] LT = "&lt;".toCharArray();
    public static final char[] QUOT = "&quot;".toCharArray();

    public static boolean contentSame(String leftTrimString, String rightTrimString) {
        boolean result = leftTrimString.equals(rightTrimString);
        if (!result) {
            int length = OK_CHANGES.length;
            int i = 0;
            while (i < length) {
                if (leftTrimString.equals(OK_CHANGES[i][0]) && rightTrimString.equals(OK_CHANGES[i][1])) {
                    return true;
                }
                ++i;
            }
            try {
                Date.parse(leftTrimString);
                Date.parse(rightTrimString);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return result;
    }

    private static String[][] createOkChanges() {
        int year = Calendar.getInstance().get(1);
        String yearString = Integer.toString(year);
        String yearLastString = Integer.toString(year - 1);
        String[][] results = new String[][]{{yearString, yearLastString}, {String.valueOf(yearLastString) + ", " + yearString, yearLastString}, {String.valueOf(yearString) + '.', String.valueOf(yearLastString) + '.'}};
        return results;
    }

    public static String getXmlString(String string) {
        boolean mod = false;
        int length = string.length();
        StringBuffer buffer = new StringBuffer(length + 32);
        int i = 0;
        while (i < length) {
            char character = string.charAt(i);
            if (character == '&') {
                buffer.append(AMP);
                mod = true;
            } else if (character == '<') {
                buffer.append(LT);
                mod = true;
            } else if (character == '>') {
                buffer.append(GT);
                mod = true;
            } else if (character == '\"') {
                buffer.append(QUOT);
                mod = true;
            } else {
                buffer.append(character);
            }
            ++i;
        }
        if (mod) {
            return buffer.toString();
        }
        return string;
    }

    public static String insertEm(String larger, String smaller) {
        StringBuffer buffer = new StringBuffer(larger.length() + 32);
        int smallerLength = smaller.length();
        if (smallerLength == 0) {
            buffer.append("<ins title=\"New\">");
            buffer.append(larger);
            buffer.append("</ins>");
        } else {
            int index = larger.indexOf(smaller);
            if (index == 0) {
                buffer.append(smaller);
                String add = larger.substring(smallerLength);
                buffer.append("<ins title=\"Added: ");
                DocChanges.trimTitle(add, buffer);
                buffer.append("\">");
                buffer.append(add);
                buffer.append("</ins>");
            } else if (index > 0) {
                if (index == larger.length() - smallerLength) {
                    buffer.append("<ins title=\"Added: ");
                    DocChanges.trimTitle(larger.substring(0, larger.length() - smallerLength), buffer);
                    buffer.append("\">");
                    buffer.append(larger.substring(0, larger.length() - smallerLength));
                    buffer.append("</ins>");
                    buffer.append(smaller);
                } else {
                    buffer.append("<ins title=\"Added: ");
                    DocChanges.trimTitle(larger.substring(0, index), buffer);
                    buffer.append("\">");
                    buffer.append(larger.substring(0, index));
                    buffer.append("</ins>");
                    buffer.append(smaller);
                    buffer.append("<ins title=\"Added: ");
                    DocChanges.trimTitle(larger.substring(index + smallerLength), buffer);
                    buffer.append("\">");
                    buffer.append(larger.substring(index + smallerLength));
                    buffer.append("</ins>");
                }
            } else {
                buffer.append("<em title=\"Changed: ");
                DocChanges.trimTitle(smaller, buffer);
                buffer.append(" to: ");
                DocChanges.trimTitle(larger, buffer);
                buffer.append("\">");
                buffer.append(larger);
                buffer.append("</em>");
            }
        }
        return buffer.toString();
    }

    public static boolean isSingleToken(String string, char delimiter) {
        return string.indexOf(delimiter) == -1;
    }

    public static void main(String[] arguments) {
        String content = DocChanges.insertEm("abc def", "<def>");
        System.out.println(content);
        content = DocChanges.insertEm("&copy; ", "(C) ");
        System.out.println(content);
        content = DocChanges.insertEm("abc <b>f</b>iles <b>p</b>ackages", "abc resouces packages");
        System.out.println(content);
        content = DocChanges.insertEm("<def x=\"abc\">abc</def>", "abc");
        System.out.println(content);
        content = DocChanges.insertEm("abc def xyz", "def");
        System.out.println(content);
        content = DocChanges.insertEm("abc", "def");
        System.out.println(content);
        System.out.println(DocChanges.contentSame("1", "2"));
        System.out.println(DocChanges.contentSame(new Date().toString(), new Date().toGMTString().toString()));
        System.out.println(DocChanges.contentSame("2006", "2005"));
        System.out.println(DocChanges.contentSame("2005, 2006", "2005"));
        System.out.println(DocChanges.contentSame("2005", "2006"));
        content = DocChanges.insertEm("Copyright (c) 2007, 2009 IBM", "Copyright (c) 2007 IBM");
        System.out.println(content);
        content = DocChanges.markChanges("Copyright (c) 2007, 2009 IBM", "Copyright (c) 2007 IBM");
        System.out.println("content " + content);
        content = DocChanges.markChanges("Copyright (c) 1999, 2009 IBM", "Copyright (c) 1999, 2009 IBM");
        System.out.println("content " + content);
        content = DocChanges.markChanges("Copyright (c) 2008 IBM", "Copyright (c) 1999, 2009 IBM");
        System.out.println("content " + content);
        content = DocChanges.markChanges("Copyright (c) 2008 IBM.", "Copyright (c) 2008 IBM.  More stuff");
        System.out.println("content " + content);
        content = DocChanges.markChanges("1.2.0.qualifier", "1.1.0.qualifier");
        System.out.println("content " + content);
        content = DocChanges.markChanges("a,b,c", "a,c");
        System.out.println("content " + content);
    }

    public static String markChanges(String currentContent, String oldContent) {
        char delimiter = ' ';
        if (DocChanges.isSingleToken(currentContent, delimiter) && DocChanges.isSingleToken(currentContent, delimiter)) {
            delimiter = '.';
            if (DocChanges.isSingleToken(currentContent, delimiter) && DocChanges.isSingleToken(currentContent, delimiter)) {
                return DocChanges.markChanges(currentContent, oldContent, ',');
            }
            return DocChanges.markChanges(currentContent, oldContent, delimiter);
        }
        return DocChanges.markChanges(currentContent, oldContent, ' ');
    }

    public static String markChanges(String currentContent, String oldContent, char delimiter) {
        String delimiters = Character.toString(delimiter);
        StringTokenizer oldTokenizer = new StringTokenizer(oldContent, delimiters);
        StringTokenizer currentTokenizer = new StringTokenizer(currentContent, delimiters);
        int oldCount = oldTokenizer.countTokens();
        int currentCount = currentTokenizer.countTokens();
        int smallest = Math.min(oldCount, currentCount);
        int frontExtra = 0;
        String[] oldTokens = new String[oldCount];
        int i = 0;
        while (i < oldCount) {
            oldTokens[i] = oldTokenizer.nextToken();
            ++i;
        }
        String[] currentTokens = new String[currentCount];
        int i2 = 0;
        while (i2 < currentCount) {
            currentTokens[i2] = currentTokenizer.nextToken();
            ++i2;
        }
        i2 = 0;
        while (i2 < smallest - 1) {
            String oldToken = oldTokens[i2];
            String currentToken = currentTokens[i2];
            if (!oldToken.equals(currentToken)) break;
            frontExtra = frontExtra + 1 + oldToken.length();
            ++i2;
        }
        int backExtra = 0;
        int oldIndex = oldCount;
        int currentIndex = currentCount;
        int j = smallest - 1;
        while (j > i2) {
            String currentToken;
            String oldToken;
            if (!(oldToken = oldTokens[--oldIndex]).equals(currentToken = currentTokens[--currentIndex])) break;
            backExtra = backExtra + 1 + oldToken.length();
            --j;
        }
        String oldSmaller = oldContent;
        String currentSmaller = currentContent;
        if (backExtra > 0) {
            oldSmaller = oldSmaller.substring(0, oldSmaller.length() - backExtra);
            currentSmaller = currentSmaller.substring(0, currentSmaller.length() - backExtra);
        }
        if (frontExtra > 0) {
            oldSmaller = oldSmaller.substring(frontExtra);
            currentSmaller = currentSmaller.substring(frontExtra);
        }
        String oldXml = DocChanges.getXmlString(oldSmaller.trim());
        String currentXml = DocChanges.getXmlString(currentSmaller.trim());
        if (oldXml.length() <= currentXml.length()) {
            currentXml = DocChanges.insertEm(currentXml, oldXml);
        } else {
            currentXml = DocChanges.insertEm(currentXml, oldXml);
            oldXml = DocChanges.insertEm(oldXml, currentXml);
        }
        StringBuffer buffer = new StringBuffer(128);
        if (frontExtra > 0) {
            buffer.append(currentContent.substring(0, frontExtra));
        }
        buffer.append(currentXml);
        if (backExtra > 0) {
            String ending = currentContent.substring(currentContent.length() - backExtra, currentContent.length());
            buffer.append(ending);
        }
        return buffer.toString();
    }

    public static String[] smallestString(String larger, String smaller) {
        if (smaller.length() == 0) {
            return new String[]{larger, ""};
        }
        int index = larger.indexOf(smaller);
        if (index == 0) {
            return new String[]{larger.substring(smaller.length()), ""};
        }
        if (index > 0) {
            if (index == larger.length() - smaller.length()) {
                return new String[]{larger.substring(0, larger.length() - smaller.length()), ""};
            }
            return new String[]{larger, ""};
        }
        return new String[]{larger, smaller};
    }

    public static void trimTitle(String data, StringBuffer buffer) {
        int length = data.length();
        if (length < 80) {
            buffer.append(DocChanges.getXmlString(data));
        } else {
            buffer.append(DocChanges.getXmlString(data.substring(0, 20)));
            buffer.append(" ... ");
            buffer.append(DocChanges.getXmlString(data.substring(length - 20, length - 1)));
        }
    }
}

