/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import org.eclipse.soda.devicekit.generator.model.elements.AsciiElement;
import org.eclipse.soda.devicekit.generator.model.elements.BigDecimalElement;
import org.eclipse.soda.devicekit.generator.model.elements.BigIntegerElement;
import org.eclipse.soda.devicekit.generator.model.elements.BytesElement;
import org.eclipse.soda.devicekit.generator.model.elements.ListElement;
import org.eclipse.soda.devicekit.generator.model.elements.MapElement;
import org.eclipse.soda.devicekit.generator.model.elements.StringElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public class ValueElement
extends TagElement {
    private String fBoolean;
    private String fDouble;
    private String fByte;
    private String fChar;
    private String fString;
    private String fFloat;
    private String fInt;
    private String fLong;
    private String fShort;

    public ValueElement(Node node, TagElement parent) {
        super(node, parent);
    }

    public String getBoolean() {
        return this.fBoolean;
    }

    public String getByte() {
        return this.fByte;
    }

    public String getChar() {
        return this.fChar;
    }

    public String getDouble() {
        return this.fDouble;
    }

    public String getFloat() {
        return this.fFloat;
    }

    public String getInt() {
        return this.fInt;
    }

    public String getLong() {
        return this.fLong;
    }

    public String getShort() {
        return this.fShort;
    }

    public String getString() {
        return this.fString;
    }

    public int getTagCode() {
        return 13;
    }

    protected void handleAscii(Node node) {
        AsciiElement element = new AsciiElement(node, this);
        this.addChild(element);
    }

    protected void handleBigDecimal(Node node) {
        BigDecimalElement element = new BigDecimalElement(node, this);
        this.addChild(element);
    }

    protected void handleBigInteger(Node node) {
        BigIntegerElement element = new BigIntegerElement(node, this);
        this.addChild(element);
    }

    private void handleBytes(Node node) {
        BytesElement element = new BytesElement(node, this);
        this.addChild(element);
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("int".equals(childNodeName)) {
            this.setInt(ParserUtilities.extractData(childNode));
        } else if ("ascii".equals(childNodeName)) {
            this.handleAscii(childNode);
        } else if ("bigdecimal".equals(childNodeName)) {
            this.handleBigDecimal(childNode);
        } else if ("biginteger".equals(childNodeName)) {
            this.handleBigInteger(childNode);
        } else if ("bytes".equals(childNodeName)) {
            this.handleBytes(childNode);
        } else if ("map".equals(childNodeName)) {
            this.handleMap(childNode);
        } else if ("list".equals(childNodeName)) {
            this.handleList(childNode);
        } else if ("double".equals(childNodeName)) {
            this.setDouble(ParserUtilities.extractData(childNode));
        } else if ("character".equals(childNodeName)) {
            this.setChar(ParserUtilities.extractData(childNode));
        } else if ("string".equals(childNodeName)) {
            this.handleString(childNode);
            this.setString(ParserUtilities.extractData(childNode));
        } else if ("byte".equals(childNodeName)) {
            this.setByte(ParserUtilities.extractData(childNode));
        } else if ("long".equals(childNodeName)) {
            this.setLong(ParserUtilities.extractData(childNode));
        } else if ("short".equals(childNodeName)) {
            this.setShort(ParserUtilities.extractData(childNode));
        } else if ("float".equals(childNodeName)) {
            this.setFloat(ParserUtilities.extractData(childNode));
        } else if ("boolean".equals(childNodeName)) {
            this.setBoolean(ParserUtilities.extractData(childNode));
        } else if ("false".equals(childNodeName)) {
            this.setBoolean("false");
        } else if ("true".equals(childNodeName)) {
            this.setBoolean("true");
        } else {
            super.handleChild(childNode);
        }
    }

    private void handleList(Node node) {
        ListElement element = new ListElement(node, this);
        this.addChild(element);
    }

    private void handleMap(Node node) {
        MapElement element = new MapElement(node, this);
        this.addChild(element);
    }

    protected void handleString(Node node) {
        StringElement element = new StringElement(node, this);
        this.addChild(element);
    }

    protected void setBoolean(String b) {
        this.fBoolean = b;
    }

    protected void setByte(String b) {
        this.fByte = b;
    }

    protected void setChar(String c) {
        this.fChar = c;
    }

    protected void setDouble(String d) {
        this.fDouble = d;
    }

    protected void setFloat(String f) {
        this.fFloat = f;
    }

    protected void setInt(String i) {
        this.fInt = i;
    }

    protected void setLong(String l) {
        this.fLong = l;
    }

    protected void setShort(String s) {
        this.fShort = s;
    }

    protected void setString(String s) {
        this.fString = s;
    }
}

