/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitTagConstants;
import org.eclipse.soda.devicekit.generator.messageanalyzer.FilterComputer;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.AbstractDkGenerator;
import org.eclipse.soda.devicekit.generator.model.DeviceFactoryMetaDataBuilder;
import org.eclipse.soda.devicekit.generator.model.DeviceKitGenerator;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.EscPropertiesModel;
import org.eclipse.soda.devicekit.generator.model.NewCodeGenerator;
import org.eclipse.soda.devicekit.generator.model.elements.CommandElement;
import org.eclipse.soda.devicekit.generator.model.elements.CommandsElement;
import org.eclipse.soda.devicekit.generator.model.elements.CommonConfigurationElement;
import org.eclipse.soda.devicekit.generator.model.elements.ConfigurationField;
import org.eclipse.soda.devicekit.generator.model.elements.ControlItem;
import org.eclipse.soda.devicekit.generator.model.elements.CustomParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.FilterElement;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.MeasurementElement;
import org.eclipse.soda.devicekit.generator.model.elements.MessageClassItem;
import org.eclipse.soda.devicekit.generator.model.elements.ParametersElement;
import org.eclipse.soda.devicekit.generator.model.elements.PidElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TransportServiceElement;
import org.eclipse.soda.devicekit.generator.model.elements.UnitsElement;
import org.eclipse.soda.devicekit.generator.model.java.CodeUtilities;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.model.java.JavaFileModel;
import org.eclipse.soda.devicekit.generator.model.java.JavaModelException;
import org.eclipse.soda.devicekit.generator.templates.GeneratorTemplates;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;
import org.eclipse.soda.devicekit.util.KeyValuePair;
import org.eclipse.soda.devicekit.util.Nls;

public class DkDeviceGenerator
extends AbstractDkGenerator {
    protected int bundleType = 0;
    protected JavaFileModel fDeviceModel;
    protected List fGetMethods = new ArrayList(1024);
    protected List fRateElements = new ArrayList();
    protected boolean hasPids = false;
    protected boolean initializeMeasurements = false;
    protected boolean initializeWithMethods = false;
    protected boolean isLazyDevice = false;
    protected MainTagElement mainTarget;
    protected TagElement tService;
    static /* synthetic */ Class class$0;

    protected DkDeviceGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        this(model, generatedInfo, new HashMap(), 0);
    }

    protected DkDeviceGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, Map table, int bundleType) {
        super(model, generatedInfo, table);
        this.bundleType = bundleType;
        this.otherManifestFiles = new HashMap();
    }

    protected boolean addTypePackageToBuildModel() {
        return true;
    }

    protected void codeBACreateService(IType ba) {
        KeyValuePair parameter;
        String[] comment;
        String returnType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
        this.fBundleActivatorModel.addImport(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
        String contents = this.getBACreateServiceContents();
        if (this.tService != null) {
            comment = new String[]{"Creates the device using the specified transport service.", "", "@param transportService The transport service to used when creating the device service.", "@return Object The device service created by this bundle.", "@see " + this.getMainFqn()};
            parameter = new KeyValuePair(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE), "transportService");
            this.fBundleActivatorModel.addImport(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE);
        } else {
            comment = new String[]{"Creates the device service using the specified bundleContext.", "", "@param bundleContext The osgi bundle context to used when creating the device service.", "@return Object The device service created by this bundle.", "@see " + this.getMainFqn()};
            parameter = new KeyValuePair(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE), "bundleContext");
            this.fBundleActivatorModel.addImport(DeviceKitGenerationConstants.CLASS_BUNDLE_CONTEXT);
        }
        this.codeMethod(ba, "createService", comment, returnType, 1L, contents, new KeyValuePair[]{parameter}, null);
    }

    protected void codeBAExportedServiceNamesField(IType ba) {
        String bundle = this.mainTarget.getBundleName();
        StringBuffer fieldComment = new StringBuffer(64);
        fieldComment.append("Defines the service name(s) to be registered by the " + bundle + " bundle.\n");
        List list = this.getManifestExportServices();
        String[] services = new String[list.size()];
        services = list.toArray(services);
        int indentation = 0;
        if (services.length > 0) {
            fieldComment.append(this.getHtmlHelper().startTable(0));
            ++indentation;
            int i = 0;
            while (i < services.length) {
                fieldComment.append(this.getHtmlHelper().getTableRow(indentation, services[i]));
                ++i;
            }
            fieldComment.append(this.getHtmlHelper().endTable(--indentation));
        }
        StringBuffer value = new StringBuffer(64);
        this.fBundleActivatorModel.addImport(this.getServiceFqn());
        this.getManifestModel().addImportPackage(this.getServicePackage());
        int i = 0;
        while (i < services.length) {
            if (i > 0) {
                value.append(',');
            }
            String curr = services[i];
            this.fBundleActivatorModel.addImport(curr);
            String currPack = DeviceKitUtilities.extractPackage(curr);
            this.getManifestModel().addImportPackage(currPack);
            if (curr.equals(DeviceKitGenerationConstants.CLASS_OSGI_DEVICE)) {
                value.append("\n\t" + this.quote(curr));
            } else {
                value.append("\n\t" + DeviceKitUtilities.stripPackage(curr) + '.' + "SERVICE_NAME");
            }
            ++i;
        }
        this.codeBAExportedServiceNamesField(ba, value.toString(), fieldComment.toString());
    }

    protected void codeBAFields(IType ba) {
        super.codeBAFields(ba);
    }

    protected void codeBAGetExportedServiceNames(IType ba) {
        this.codeBAExportedServiceNamesField(ba);
        StringBuffer buffer = new StringBuffer(64);
        String bundle = this.mainTarget.getBundleName();
        buffer.append("Return the exported service name(s) to be registered by the " + bundle + " bundle.\n");
        buffer.append("\n@return String[] The exported service name(s).\n");
        this.codeBAGetExportedServiceNames(ba, buffer.toString());
    }

    protected void codeBAGetImportedServiceNames(IType ba) {
        this.codeBAGetImportedServiceNames(this.mainTarget.getBundleName(), ba);
    }

    protected void codeBAGetInterestServiceName(IType ba) {
        if (this.tService != null) {
            String service = this.tService.getAttribute("service");
            if (service == null) {
                service = this.tService.getServiceNameFull();
            }
            if (service != null) {
                if (service.indexOf(46) == -1) {
                    service = String.valueOf(DeviceKitUtilities.getPackageFromClassName(service, this.getPackageBase())) + '.' + service;
                }
                String[] comment = new String[]{"Return the transport service name used by this bundle.", "", "@return String The interest service name.", "@see " + service};
                this.fBundleActivatorModel.addImport(service);
                String contents = this.getBAGetInterestServiceNameContents(service);
                this.codeMethod(ba, "getInterestServiceName", comment, "String", 1L, contents);
            }
        }
    }

    protected void codeBAGetMatchDeviceClasses(IType ba) {
        String dev = this.getMainClassName();
        if (dev.endsWith("Device")) {
            int index = dev.lastIndexOf("Device");
            dev = dev.substring(0, index);
        }
        this.codeBAMatchingDevicesField(ba, this.quote(dev));
        String comment = Nls.format(DeviceKitGenerator.getResource("DkDeviceGenerator.ba.get.match.device.classes.comment1"), dev);
        this.codeBAGetMatchingDevicesMethod(ba, comment);
    }

    protected void codeBAMethods(IType ba) {
        super.codeBAMethods(ba);
        this.codeBACreateService(ba);
        this.codeBAGetInterestServiceName(ba);
        this.codeBAGetExportedServiceNames(ba);
        this.codeBAGetImportedServiceNames(ba);
    }

    protected void codeCommandsSignalsMeasurementsFields(IType device) {
        List commands = this.getMainElement().getAllChildrenWithTagCodes(new int[]{1, 19}, new int[]{82});
        String commandComments = DeviceKitGenerator.getResource("DkDeviceGenerator.commands.ids.comment");
        this.codeStaticIdField(device, commands, "ALL_COMMANDS", commandComments);
        List signals = this.getMainElement().getAllChildrenWithTagCodes(new int[]{3}, new int[]{82});
        String signalComments = DeviceKitGenerator.getResource("DkDeviceGenerator.signals.ids.comment");
        this.codeStaticIdField(device, signals, "ALL_SIGNALS", signalComments);
        List measurements = this.getMainElement().getAllChildrenWithTagCodes(new int[]{2}, new int[]{82});
        String measurementContents = DeviceKitGenerator.getResource("DkDeviceGenerator.measurements.ids.comment");
        this.codeStaticIdField(device, measurements, "ALL_MEASUREMENTS", measurementContents);
    }

    protected void codeConstructors(IType device) throws IOException {
        String name = device.getName();
        String comment = Nls.format(DeviceKitGenerator.getResource("DkDeviceGenerator.constructor.comment1"), device.getName());
        String contents = this.getConstructorContents();
        this.codeMethod(device, name, comment, null, 1L, contents);
    }

    private void codeCreateAllControls(IType device) {
        String comment = DeviceKitGenerator.getResource("DkDeviceGenerator.createallcontrols.comment1");
        String contents = this.getCodeCreateAllControlsContents();
        this.codeMethod(device, "createAllControls", comment, "void", 1L, contents);
    }

    protected void codeCreateStaticIdMethod(IType messgageType, String returnType, String methodName, long identifiers, String value, String fieldName) {
        StringBuffer valueBuffer = new StringBuffer(value.length() + 10);
        valueBuffer.append("return ");
        valueBuffer.append(value);
        StringBuffer commentBuffer = new StringBuffer(64);
        commentBuffer.append("Creates and returns the ");
        commentBuffer.append(returnType);
        commentBuffer.append(' ');
        commentBuffer.append(fieldName);
        this.codeMethod(messgageType, methodName, commentBuffer.toString(), returnType, identifiers, valueBuffer.toString());
    }

    private void codeDefaultKey(IType device) {
        String[] comment = new String[]{"Gets the default key of the " + this.getMainTagName() + '.', "@return String The default key"};
        String contents = this.getDefaultKeyContents();
        this.codeMethod(device, "getDefaultKey", comment, "String", 1L, contents);
    }

    private void codeDefaultStyle(IType device) {
        if (this.initializeMeasurements) {
            String[] comment = new String[]{"Gets the default style of the " + this.getMainTagName() + '.', "return short The default style"};
            String contents = this.getDefaultStyleContents();
            this.codeMethod(device, "getDefaultStyle", comment, "short", 1L, contents);
        }
    }

    protected void codeDefaultTransport(IType device) {
        String transportServiceName = DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE;
        String returnType = DeviceKitUtilities.stripPackage(transportServiceName);
        String comment = Nls.format(DeviceKitGenerator.getResource("DkDeviceGenerator.get.default.transport.comment1"), DeviceKitUtilities.stripPackage(transportServiceName));
        this.fDeviceModel.addImport(transportServiceName);
        String contents = this.getDefaultTransportContents(transportServiceName);
        this.codeMethod(device, "getDefaultTransport", comment, returnType, 1L, contents);
    }

    private void codeDeviceField(IType device, TagElement element) {
        long identifiers = 2L;
        if (this.isAbstract()) {
            identifiers = 4L;
        }
        if (!this.isLazyDevice) {
            identifiers |= 0x20L;
        }
        this.codeDeviceField(device, element, identifiers, false);
    }

    private void codeDeviceField(IType device, TagElement element, long identifiers, boolean full) {
        String[] comment;
        String fieldTypeFull = element.getType();
        String fieldType = DeviceKitUtilities.stripPackage(fieldTypeFull);
        this.fDeviceModel.addImport(fieldTypeFull);
        String fieldName = CodeUtilities.fieldName(element.getId());
        if (full) {
            String serviceType = element.getParent().getServiceNameFull();
            String serviceName = DeviceKitUtilities.stripPackage(serviceType);
            fieldName = CodeUtilities.fieldName(String.valueOf(serviceName) + element.getId());
        }
        if ((comment = element.getFieldComment()) != null && comment.length > 0 && !comment[0].trim().endsWith(".")) {
            comment[0] = String.valueOf(comment[0]) + '.';
        }
        String value = new String();
        if (!this.isLazyDevice) {
            if (this.hasRateControlChild(element)) {
                this.fRateElements.add(element);
            }
            NewCodeGenerator generator = new NewCodeGenerator(this.getMainFqn(), this.getMessageFqn(), this.getServiceFqn(), this.isLazyDevice);
            value = generator.getNewCode(0, element);
            List imports = generator.getImports();
            int j = 0;
            while (j < imports.size()) {
                String importedItem = (String)imports.get(j);
                this.fDeviceModel.addImport(importedItem);
                String importedPack = DeviceKitUtilities.extractPackage(importedItem);
                this.getManifestModel().addImportPackage(importedPack);
                ++j;
            }
        } else if (this.hasRateControlChild(element)) {
            this.fRateElements.add(element);
        }
        this.codeField(device, fieldName, fieldType, identifiers, comment, value);
    }

    private void codeDeviceServiceConfigurationDefaultValue(String id, String type, String defaultValue, IType service) {
        if (defaultValue != null) {
            String tdefaultValue = defaultValue;
            String fieldName = "DEFAULT_" + id.toUpperCase();
            String fieldNameNew = "DEFAULT_" + CodeUtilities.validStaticIdentifier(id);
            String javaDoc = "Configuration  " + fieldNameNew + " default value.";
            String fieldType = "String";
            if (type.equals("Integer")) {
                fieldType = "int";
            } else if (type.equals("Boolean")) {
                fieldType = "boolean";
            } else {
                tdefaultValue = this.quote(tdefaultValue);
            }
            this.codeFieldWithOld(service, fieldNameNew, fieldName, fieldType, 49L, new String[]{javaDoc}, tdefaultValue, true);
        }
    }

    protected void codeDeviceServiceConfigurationField(CommonConfigurationElement element, IType service) {
        String id = element.getId();
        String type = element.getType();
        String defaultValue = element.getDefaultValue();
        this.codeDeviceServiceConfigurationKey(id, service);
        this.codeDeviceServiceConfigurationDefaultValue(id, type, defaultValue, service);
    }

    private void codeDeviceServiceConfigurationKey(String id, IType service) {
        String fieldName = String.valueOf(id.toUpperCase()) + "_KEY";
        String fieldNameNew = String.valueOf(CodeUtilities.validStaticIdentifier(id)) + "_KEY";
        String javaDoc = "Configuration " + fieldNameNew + " key.";
        String value = this.quote(id);
        this.codeFieldWithOld(service, fieldNameNew, fieldName, "String", 49L, new String[]{javaDoc}, value, true);
    }

    private void codeDeviceServiceDataKeyField(IType service, TagElement element) {
        String fieldName = element.getId();
        if (fieldName != null) {
            String value = this.quote(element.getId());
            String[] comment = element.getServiceFieldComment();
            if (comment == null) {
                comment = new String[]{};
            }
            StringBuffer commentBuffer = new StringBuffer(128);
            if (comment.length > 0) {
                if (!comment[0].trim().endsWith(".")) {
                    comment[0] = String.valueOf(comment[0]) + '.';
                }
                int j = 0;
                while (j < comment.length) {
                    commentBuffer.append(comment[j]);
                    commentBuffer.append('\n');
                    ++j;
                }
            }
            if (element.hasChildWithTagCode(65)) {
                String specRefComment = this.getSpecReferenceComment(element);
                commentBuffer.append(specRefComment);
            }
            commentBuffer.append("The value of this field is ");
            commentBuffer.append(value);
            commentBuffer.append('\n');
            comment = DeviceKitUtilities.convertStringToArrayComments(commentBuffer.toString());
            String fieldNameUpper = fieldName.toUpperCase();
            String externalKeyBase = String.valueOf(fieldNameUpper) + "_DATA_KEY";
            String externalKeyBaseNew = String.valueOf(CodeUtilities.validStaticIdentifier(fieldName)) + "_DATA_KEY";
            comment = DeviceKitUtilities.convertStringToArrayComments(commentBuffer.toString());
            this.codeFieldWithOld(service, externalKeyBaseNew, externalKeyBase, "String", 49L, comment, value, true);
        }
    }

    private void codeDeviceServiceField(IType service) {
        String fieldName = this.getMainClassName();
        String value = this.quote(this.getMainClassName());
        String comment = Nls.format(DeviceKitGenerator.getResource("DkDeviceGenerator.service.device.key.comment1"), this.getMainClassName());
        this.codeField(service, fieldName, "String", 49L, comment, value);
    }

    protected void codeDeviceServiceKeyField(IType service, ControlItem element) {
        String[] comment = element.getServiceFieldComment();
        if (comment == null) {
            comment = new String[]{};
        }
        StringBuffer commentBuffer = new StringBuffer(128);
        if (comment.length > 0) {
            if (!comment[0].trim().endsWith(".")) {
                comment[0] = String.valueOf(comment[0]) + '.';
            }
            int j = 0;
            while (j < comment.length) {
                commentBuffer.append(comment[j]);
                commentBuffer.append('\n');
                ++j;
            }
        }
        if (element.hasChildWithTagCode(65)) {
            String specRefComment = this.getSpecReferenceComment(element);
            commentBuffer.append(specRefComment);
            comment = DeviceKitUtilities.convertStringToArrayComments(commentBuffer.toString());
        }
        if (element instanceof MeasurementElement) {
            MeasurementElement measurementElement = (MeasurementElement)element;
            this.codeDeviceServiceKeyField(service, element.getId(), element.getExternalId(), element.getTagCode(), commentBuffer, measurementElement.isExecuteRead(), measurementElement.isExecuteWrite(), measurementElement.isError());
        } else {
            this.codeDeviceServiceKeyField(service, element.getId(), element.getExternalId(), element.getTagCode(), commentBuffer, true, true, element.isError());
        }
        List configurations = element.getAllChildrenWithTagCode(70);
        if (configurations != null) {
            int i = 0;
            while (i < configurations.size()) {
                CommonConfigurationElement celement = (CommonConfigurationElement)configurations.get(i);
                this.codeDeviceServiceConfigurationField(celement, service);
                ++i;
            }
        }
    }

    protected void codeDeviceServiceKeyField(IType service, String id, String externalId, int type, StringBuffer commentBuffer, boolean executeRead, boolean executeWrite, boolean error) {
        if (commentBuffer.length() == 0) {
            commentBuffer.append("Define the ");
            commentBuffer.append(CodeUtilities.betterName(externalId, 2));
            commentBuffer.append(' ');
            switch (type) {
                case 19: {
                    commentBuffer.append("commands");
                    break;
                }
                case 1: {
                    commentBuffer.append("command");
                    break;
                }
                case 2: {
                    commentBuffer.append("measurement");
                    break;
                }
                case 3: {
                    commentBuffer.append("signal");
                }
            }
            commentBuffer.append(".\r\n");
        }
        String[] comment = DeviceKitUtilities.convertStringToArrayComments(commentBuffer.toString());
        String fieldName = id;
        String value = this.quote(externalId);
        this.codeField(service, fieldName, "String", 49L, comment, value, Character.isUpperCase(fieldName.charAt(0)));
        String notificationServiceFull = DeviceKitGenerationConstants.CLASS_NOTIFICATION_SERVICE;
        this.fServiceModel.addImport(notificationServiceFull);
        String fieldNameUpper = fieldName.toUpperCase();
        String fieldNameUpperNice = CodeUtilities.validStaticIdentifier(fieldName);
        String externalKeyBase = this.getExternalKey(fieldName);
        String externalKeyBaseFull = String.valueOf(service.getName()) + '.' + externalKeyBase;
        commentBuffer.append("@see #");
        commentBuffer.append(fieldName);
        commentBuffer.append('\n');
        StringBuffer baseValueBuffer = new StringBuffer(256);
        baseValueBuffer.append("<i>prefix/<i><b>");
        baseValueBuffer.append(externalId);
        baseValueBuffer.append("</b>");
        String baseValue = baseValueBuffer.toString();
        StringBuffer newCommentBuffer = new StringBuffer(4096);
        newCommentBuffer.append(commentBuffer.toString());
        newCommentBuffer.append("\nThe value of this field is \"");
        newCommentBuffer.append(baseValue);
        newCommentBuffer.append('\"');
        comment = DeviceKitUtilities.convertStringToArrayComments(newCommentBuffer.toString());
        this.codeFieldWithOld(service, String.valueOf(fieldNameUpperNice) + "_EXTERNAL_KEY", String.valueOf(fieldNameUpper) + "_EXTERNAL_KEY", "String", 49L, comment, value, true);
        newCommentBuffer = new StringBuffer(4096);
        newCommentBuffer.append(commentBuffer.toString());
        newCommentBuffer.append("\nThe value of this field is \"");
        newCommentBuffer.append(baseValue);
        String key = "EXECUTE_EXTERNAL_KEY";
        switch (type) {
            case 1: 
            case 19: {
                commentBuffer.append("@see ");
                commentBuffer.append(notificationServiceFull);
                commentBuffer.append('#');
                commentBuffer.append(key);
                commentBuffer.append('\n');
                newCommentBuffer.append("/execute\"");
                comment = DeviceKitUtilities.convertStringToArrayComments(newCommentBuffer.toString());
                this.codeField(service, String.valueOf(fieldNameUpper) + '_' + key, "String", 49L, comment, String.valueOf(externalKeyBaseFull) + "+ NotificationService." + key);
                break;
            }
            case 2: {
                key = "GET_EXTERNAL_KEY";
                commentBuffer.append("@see ");
                commentBuffer.append(notificationServiceFull);
                commentBuffer.append('#');
                commentBuffer.append(key);
                commentBuffer.append('\n');
                newCommentBuffer.append("/get\"");
                comment = DeviceKitUtilities.convertStringToArrayComments(newCommentBuffer.toString());
                this.codeFieldWithOld(service, String.valueOf(fieldNameUpperNice) + '_' + key, String.valueOf(fieldNameUpper) + '_' + key, "String", 49L, comment, String.valueOf(externalKeyBaseFull) + "+ NotificationService." + key, true);
                if (executeRead) {
                    key = "READ_EXTERNAL_KEY";
                    commentBuffer.append("@see ");
                    commentBuffer.append(notificationServiceFull);
                    commentBuffer.append('#');
                    commentBuffer.append(key);
                    commentBuffer.append('\n');
                    newCommentBuffer = new StringBuffer(4096);
                    newCommentBuffer.append(commentBuffer.toString());
                    newCommentBuffer.append("\nThe value of this field is \"");
                    newCommentBuffer.append(baseValue);
                    newCommentBuffer.append("/read\"");
                    comment = DeviceKitUtilities.convertStringToArrayComments(newCommentBuffer.toString());
                    this.codeFieldWithOld(service, String.valueOf(fieldNameUpperNice) + '_' + key, String.valueOf(fieldNameUpper) + '_' + key, "String", 49L, comment, String.valueOf(externalKeyBaseFull) + "+ NotificationService." + key, true);
                }
                if (!executeWrite) break;
                key = "WRITE_EXTERNAL_KEY";
                commentBuffer.append("@see ");
                commentBuffer.append(notificationServiceFull);
                commentBuffer.append('#');
                commentBuffer.append(key);
                commentBuffer.append('\n');
                newCommentBuffer = new StringBuffer(4096);
                newCommentBuffer.append(commentBuffer.toString());
                newCommentBuffer.append("\nThe value of this field is \"");
                newCommentBuffer.append(baseValue);
                newCommentBuffer.append("/write\"");
                comment = DeviceKitUtilities.convertStringToArrayComments(newCommentBuffer.toString());
                this.codeFieldWithOld(service, String.valueOf(fieldNameUpperNice) + '_' + key, String.valueOf(fieldNameUpper) + '_' + key, "String", 49L, comment, String.valueOf(externalKeyBaseFull) + "+ NotificationService." + key, true);
                break;
            }
            case 3: {
                key = "TRIGGER_EXTERNAL_KEY";
                commentBuffer.append("@see ");
                commentBuffer.append(notificationServiceFull);
                commentBuffer.append('#');
                commentBuffer.append(key);
                commentBuffer.append('\n');
                newCommentBuffer.append("/trigger\"");
                comment = DeviceKitUtilities.convertStringToArrayComments(newCommentBuffer.toString());
                this.codeFieldWithOld(service, String.valueOf(fieldNameUpperNice) + '_' + key, String.valueOf(fieldNameUpper) + '_' + key, "String", 49L, comment, String.valueOf(externalKeyBaseFull) + "+ NotificationService." + key, true);
            }
        }
        if (error) {
            key = "ERROR_EXTERNAL_KEY";
            commentBuffer.append("@see ");
            commentBuffer.append(notificationServiceFull);
            commentBuffer.append('#');
            commentBuffer.append(key);
            commentBuffer.append('\n');
            newCommentBuffer = new StringBuffer(4096);
            newCommentBuffer.append(commentBuffer.toString());
            newCommentBuffer.append("\nThe value of this field is \"");
            newCommentBuffer.append(baseValue);
            newCommentBuffer.append("/error\"");
            comment = DeviceKitUtilities.convertStringToArrayComments(newCommentBuffer.toString());
            this.codeFieldWithOld(service, String.valueOf(fieldNameUpperNice) + '_' + key, String.valueOf(fieldNameUpper) + '_' + key, "String", 49L, comment, String.valueOf(externalKeyBaseFull) + "+ NotificationService." + key, true);
        }
    }

    private void codeElements(IType device) {
        String returnType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_ENUMERATION);
        String contents = this.getElementsContents();
        this.fDeviceModel.addImport(DeviceKitGenerationConstants.CLASS_ENUMERATION);
        this.codeMethod(device, "elements", "@see org.eclipse.soda.dk.device.service.DeviceService#elements()", returnType, 1L, contents, false);
    }

    protected void codeFields(IType device) {
        KeyValuePair[] keyValuePairArray;
        KeyValuePair[] keyValuePairArray2;
        this.codeClassNameField(device, this.getMainFqn());
        this.codeInterestFilterField(device);
        this.codeStaticIdFields(device);
        this.codeUses(device);
        List elements = this.getMainElement().getAllChildrenWithTagCodes(new int[]{1, 19, 2, 3, 4}, false);
        StringBuffer measurementBuffer = new StringBuffer(2048);
        KeyValuePair channelParameter = new KeyValuePair(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CHANNEL_SERVICE), "channel");
        KeyValuePair signalParameter = new KeyValuePair(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_SIGNAL_SERVICE), "source");
        KeyValuePair timestampParameter = new KeyValuePair(DeviceKitUtilities.stripPackage("Object"), "timestamp");
        KeyValuePair measurementParameter = new KeyValuePair(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_MEASUREMENT_SERVICE), "source");
        KeyValuePair sparameter2 = new KeyValuePair(DeviceKitUtilities.stripPackage("Object"), "data");
        KeyValuePair mparameter2 = new KeyValuePair(DeviceKitUtilities.stripPackage("Object"), "newValue");
        KeyValuePair mparameter3 = new KeyValuePair(DeviceKitUtilities.stripPackage("Object"), "oldValue");
        if (this.isMultiplex()) {
            KeyValuePair[] keyValuePairArray3 = new KeyValuePair[4];
            keyValuePairArray3[0] = signalParameter;
            keyValuePairArray3[1] = timestampParameter;
            keyValuePairArray3[2] = channelParameter;
            keyValuePairArray2 = keyValuePairArray3;
            keyValuePairArray3[3] = sparameter2;
        } else {
            KeyValuePair[] keyValuePairArray4 = new KeyValuePair[3];
            keyValuePairArray4[0] = signalParameter;
            keyValuePairArray4[1] = timestampParameter;
            keyValuePairArray2 = keyValuePairArray4;
            keyValuePairArray4[2] = sparameter2;
        }
        KeyValuePair[] sparameters = keyValuePairArray2;
        if (this.isMultiplex()) {
            KeyValuePair[] keyValuePairArray5 = new KeyValuePair[5];
            keyValuePairArray5[0] = measurementParameter;
            keyValuePairArray5[1] = timestampParameter;
            keyValuePairArray5[2] = channelParameter;
            keyValuePairArray5[3] = mparameter2;
            keyValuePairArray = keyValuePairArray5;
            keyValuePairArray5[4] = mparameter3;
        } else {
            KeyValuePair[] keyValuePairArray6 = new KeyValuePair[4];
            keyValuePairArray6[0] = measurementParameter;
            keyValuePairArray6[1] = timestampParameter;
            keyValuePairArray6[2] = mparameter2;
            keyValuePairArray = keyValuePairArray6;
            keyValuePairArray6[3] = mparameter3;
        }
        KeyValuePair[] mparameters = keyValuePairArray;
        KeyValuePair deviceparameter0 = new KeyValuePair(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE), "source");
        KeyValuePair deviceparameter1 = new KeyValuePair(DeviceKitUtilities.stripPackage("Object"), "timestamp");
        KeyValuePair deviceparameter2 = new KeyValuePair("int", "newState");
        KeyValuePair deviceparameter3 = new KeyValuePair("int", "oldState");
        KeyValuePair[] deviceparameters = new KeyValuePair[]{deviceparameter0, deviceparameter1, deviceparameter2, deviceparameter3};
        int i = 0;
        while (i < elements.size()) {
            TagElement element = (TagElement)elements.get(i);
            if (element.getTagCode() == 1 || element.getTagCode() == 19 || element.getTagCode() == 2 || element.getTagCode() == 3 || element.getTagCode() == 4 && !element.isMessageClassElement()) {
                this.codeDeviceField(device, element);
                if ("true".equals(element.getAttribute("listen"))) {
                    String id = element.getId();
                    String fieldName = CodeUtilities.fieldName(id);
                    String methodName = CodeUtilities.methodName(id);
                    measurementBuffer.append("if (this.");
                    measurementBuffer.append(fieldName);
                    measurementBuffer.append("== source) { /* check my measurement */");
                    measurementBuffer.append("handle");
                    measurementBuffer.append(methodName);
                    if (this.isMultiplex()) {
                        measurementBuffer.append("(source, timestamp, channel, newValue, oldValue);");
                    } else {
                        measurementBuffer.append("(source, timestamp, newValue, oldValue);");
                    }
                    measurementBuffer.append("return;");
                    measurementBuffer.append('}');
                }
            }
            ++i;
        }
        elements = this.getMainElement().getAllChildrenWithTagCodes(new int[]{79, 80, 81}, new int[]{8, 1008});
        if (elements.size() > 0) {
            StringBuffer signalBuffer = new StringBuffer(2048);
            StringBuffer commandBuffer = new StringBuffer(2048);
            StringBuffer startBuffer = new StringBuffer(2048);
            StringBuffer buffer = new StringBuffer(2048);
            StringBuffer oldBuffer = new StringBuffer(2048);
            oldBuffer.append("\tif (getDevice() != null) {\n");
            buffer.append("\tif(device != null) {\n");
            int i2 = 0;
            while (i2 < elements.size()) {
                TagElement element = (TagElement)elements.get(i2);
                String id = element.getId();
                String serviceType = element.getParent().getServiceNameFull();
                String serviceName = DeviceKitUtilities.stripPackage(serviceType);
                String fieldName = CodeUtilities.fieldName(String.valueOf(serviceName) + id);
                String methodName = CodeUtilities.methodName(String.valueOf(serviceName) + id);
                this.fDeviceModel.addImport(serviceType);
                switch (element.getTagCode()) {
                    case 79: 
                    case 80: 
                    case 81: {
                        String typeName = "";
                        switch (element.getTagCode()) {
                            case 79: {
                                typeName = "Command";
                                commandBuffer.append("if (this.");
                                commandBuffer.append(fieldName);
                                commandBuffer.append("== source) { /* check referenced command */");
                                commandBuffer.append("handle");
                                commandBuffer.append(methodName);
                                if (this.isMultiplex()) {
                                    commandBuffer.append("(source, timestamp, channel, data);");
                                } else {
                                    commandBuffer.append("(source, timestamp, data);");
                                }
                                commandBuffer.append("return;");
                                commandBuffer.append('}');
                                break;
                            }
                            case 80: {
                                startBuffer.append("if (this.");
                                startBuffer.append(fieldName);
                                startBuffer.append(" != null) {\n");
                                startBuffer.append("\tthis.");
                                startBuffer.append(fieldName);
                                if (this.isMultiplex()) {
                                    startBuffer.append(".executeRead(channel);\n");
                                } else {
                                    startBuffer.append(".executeRead();\n");
                                }
                                startBuffer.append("}\n");
                                measurementBuffer.append("if (this.");
                                measurementBuffer.append(fieldName);
                                measurementBuffer.append("== source) { /* check referenced measurement */\n");
                                measurementBuffer.append("handle");
                                measurementBuffer.append(methodName);
                                if (this.isMultiplex()) {
                                    measurementBuffer.append("(source, timestamp, channel, newValue, oldValue);");
                                } else {
                                    measurementBuffer.append("(source, timestamp, newValue, oldValue);");
                                }
                                measurementBuffer.append("return;");
                                measurementBuffer.append("}\n");
                                typeName = "Measurement";
                                break;
                            }
                            case 81: {
                                signalBuffer.append("if (this.");
                                signalBuffer.append(fieldName);
                                signalBuffer.append("== source) { /* check referenced signal */");
                                signalBuffer.append("handle");
                                signalBuffer.append(methodName);
                                if (this.isMultiplex()) {
                                    signalBuffer.append("(source, timestamp, channel, data);");
                                } else {
                                    signalBuffer.append("(source, timestamp, data);");
                                }
                                signalBuffer.append("return;");
                                signalBuffer.append('}');
                                typeName = "Signal";
                            }
                        }
                        this.codeDeviceField(device, element, 4L, true);
                        this.fDeviceModel.addImport(DeviceKitUtilities.extractPackage(serviceName));
                        buffer.append("this.");
                        buffer.append(fieldName);
                        buffer.append(" = device.get");
                        buffer.append(typeName);
                        buffer.append('(');
                        buffer.append(DeviceKitUtilities.stripPackage(serviceName));
                        buffer.append('.');
                        buffer.append(id);
                        buffer.append(");\n");
                        oldBuffer.append("if (this.");
                        oldBuffer.append(fieldName);
                        oldBuffer.append("!= null) {");
                        oldBuffer.append("this.");
                        oldBuffer.append(fieldName);
                        oldBuffer.append(".remove");
                        oldBuffer.append(typeName);
                        oldBuffer.append("Listener(this);");
                        oldBuffer.append('}');
                        buffer.append("initialize");
                        buffer.append(typeName);
                        buffer.append("(this.");
                        buffer.append(fieldName);
                        buffer.append(");");
                    }
                }
                ++i2;
            }
            buffer.append("}\n");
            buffer.append("\tsuper.setDevice(device);\n");
            oldBuffer.append("}\n");
            oldBuffer.append(buffer.toString());
            KeyValuePair parameter = new KeyValuePair(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE), "device");
            KeyValuePair[] parameters = new KeyValuePair[]{parameter};
            this.codeMethod(device, "setDevice", "", "void", 1L, oldBuffer.toString(), parameters, null, true);
            if (signalBuffer.length() > 0) {
                if (this.isMultiplex()) {
                    signalBuffer.append("super.signalOccurred(source, timestamp, channel, data);");
                } else {
                    signalBuffer.append("super.signalOccurred(source, timestamp, data);");
                }
                this.codeMethod(device, "signalOccurred", "", "void", 1L, signalBuffer.toString(), sparameters, null, true);
            }
            if (startBuffer.length() > 0) {
                StringBuffer startFinalBuffer = new StringBuffer(2048);
                startFinalBuffer.append("super.deviceChanged(source, timestamp, newState, oldState);");
                startFinalBuffer.append("\tif (newState == ");
                startFinalBuffer.append("DeviceService.STARTED) {\n");
                startFinalBuffer.append(startBuffer.toString());
                startFinalBuffer.append("\t}\n");
                this.codeMethod(device, "deviceChanged", "", "void", 1L, startFinalBuffer.toString(), deviceparameters, null, true);
            }
        }
        if (measurementBuffer.length() > 0) {
            if (this.isMultiplex()) {
                measurementBuffer.append("super.measurementChanged(source, timestamp, channel, newValue, oldValue);");
            } else {
                measurementBuffer.append("super.measurementChanged(source, timestamp, newValue, oldValue);");
            }
            this.codeMethod(device, "measurementChanged", "", "void", 1L, measurementBuffer.toString(), mparameters, null, true);
        }
        if (TagElement.collection.getPids().size() > 0) {
            this.hasPids = true;
            this.codePidsLengthField(device);
        }
    }

    private void codeGetControl(IType device) {
        this.fDeviceModel.addImport(DeviceKitGenerationConstants.CLASS_CONTROL_SERVICE);
        this.fDeviceModel.addImport(DeviceKitGenerationConstants.CLASS_METHOD);
        String[] comment = new String[]{"@see org.eclipse.soda.dk.service.device.DeviceService#get(String)"};
        String returnType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONTROL_SERVICE);
        KeyValuePair parameter = new KeyValuePair("String", "key");
        KeyValuePair[] parameters = new KeyValuePair[]{parameter};
        String contents = this.getGetControlContents();
        this.codeMethod(device, "get", comment, returnType, 1L, contents, parameters, null);
    }

    private void codeGetControlCapacity(IType device) {
        int controlCapacity = this.fGetMethods.size();
        if (controlCapacity > 0) {
            String comment = DeviceKitGenerator.getResource("DkDeviceGenerator.get.control.capacity.comment1");
            String contents = this.getGetControlCapacityContents();
            this.codeMethod(device, "getControlCapacity", comment, "int", 1L, contents);
        }
    }

    protected void codeGetInterestMask(IType device) {
        String[] comment = new String[]{"Gets the interest filter for the " + this.getMainTagName() + '.', "@return InterestService The interest filter for this " + this.getMainTagName() + '.'};
        String returnType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_INTEREST_SERVICE);
        String contents = this.getGetInterestMaskContents();
        this.codeMethod(device, "getInterest", comment, returnType, 1L, contents);
        this.fDeviceModel.addImport(DeviceKitGenerationConstants.CLASS_INTEREST_SERVICE);
    }

    private void codeGetMessageCapacityAndKey(IType device) {
        int size = this.fGetMethods.size();
        if (size > 0) {
            String[] comment = new String[]{"Gets the message capacity.", "", "@return int The message capacity."};
            byte[] filterBytes = null;
            byte[] tand = null;
            byte[] tor = null;
            byte[] mbytes = null;
            ArrayList<Object> messageBytes = new ArrayList<Object>();
            int messageCount = 0;
            int j = 0;
            while (j < size) {
                TagElement ci = (TagElement)this.fGetMethods.get(j);
                boolean include = true;
                if ((ci instanceof CommandElement || ci instanceof CommandsElement) && !this.getDevice().includeCommandReceived()) {
                    include = false;
                }
                if (include) {
                    List messages = ci.getMessageChildren(false);
                    int i = 0;
                    while (i < messages.size()) {
                        String value;
                        String idref;
                        ++messageCount;
                        MessageClassItem me = (MessageClassItem)messages.get(i);
                        if (me.getAttribute("id") == null && (idref = me.getAttribute("idref")) != null) {
                            me = (MessageClassItem)TagElement.collection.getMessage(idref);
                        }
                        if ((mbytes = me.getBytes()) == null && (value = me.getTextData()) != null) {
                            mbytes = value.getBytes();
                        }
                        if (mbytes != null) {
                            messageBytes.add(mbytes.clone());
                            tand = DeviceKitUtilities.andMask(mbytes, tand);
                            tor = DeviceKitUtilities.orMask(mbytes, tor);
                        }
                        boolean filterFound = false;
                        List filters = me.getFilterChildren(false);
                        int k = 0;
                        while (k < filters.size()) {
                            String idref2;
                            FilterElement fe = (FilterElement)filters.get(k);
                            if (fe.getAttribute("id") == null && (idref2 = fe.getAttribute("idref")) != null) {
                                fe = (FilterElement)TagElement.collection.getFilter(idref2);
                            }
                            byte[] sFilterBytes = fe.getBytes();
                            filterBytes = DeviceKitUtilities.andMask(sFilterBytes, filterBytes);
                            filterFound = true;
                            ++k;
                        }
                        if (!filterFound && mbytes != null) {
                            k = 0;
                            while (k < mbytes.length) {
                                mbytes[k] = -1;
                                ++k;
                            }
                            filterBytes = DeviceKitUtilities.andMask(mbytes, filterBytes);
                        }
                        ++i;
                    }
                }
                ++j;
            }
            int result = DeviceKitUtilities.getPrime(messageCount * 4 / 3);
            StringBuffer buffer = new StringBuffer(16);
            buffer.append("return ");
            buffer.append(result);
            buffer.append(';');
            String contents = buffer.toString();
            this.codeMethod(device, "getMessageCapacity", comment, "int", 1L, contents);
            if (filterBytes != null) {
                KeyValuePair parameter2 = new KeyValuePair(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_MESSAGE_SERVICE), "message");
                String[] comment2 = new String[]{"Gets the message key.", "", "@param message The message service.", "@return Object The message key."};
                this.fDeviceModel.addImport(DeviceKitGenerationConstants.CLASS_MESSAGE_SERVICE);
                StringBuffer getMKBody = new StringBuffer(64);
                if (filterBytes.length == 1 && filterBytes[0] == 0) {
                    getMKBody.append("return this;");
                } else {
                    getMKBody.append("final byte[] bytes = message.getBytes();\n");
                    getMKBody.append("if ((bytes.length >= " + filterBytes.length + ')');
                    if (tand != null && tor != null) {
                        byte[] andMask = new byte[tand.length];
                        int i = filterBytes.length - 1;
                        while (i >= 0) {
                            if (filterBytes[i] != 0 && i < tand.length) {
                                andMask[i] = (byte)(tand[i] ^ tor[i]);
                                andMask[i] = (byte)(filterBytes[i] & ~andMask[i]);
                                byte equals = tand[i];
                                if (andMask[i] != 0) {
                                    if (andMask[i] == -1) {
                                        getMKBody.append("\n\t&& (bytes[");
                                        getMKBody.append(Integer.toString(i));
                                        getMKBody.append("] == 0x");
                                        getMKBody.append(Integer.toHexString(equals));
                                        getMKBody.append(')');
                                    } else {
                                        int[] counts = new int[256];
                                        int k = 0;
                                        while (k < messageBytes.size()) {
                                            byte[] msgByte = (byte[])messageBytes.get(k);
                                            if (i < msgByte.length) {
                                                byte value = (byte)(msgByte[i] & filterBytes[i]);
                                                int n = value & 0xFF;
                                                counts[n] = counts[n] + 1;
                                            }
                                            ++k;
                                        }
                                        int count = 0;
                                        int k2 = 0;
                                        while (k2 < 256) {
                                            if (counts[k2] > 0) {
                                                ++count;
                                            }
                                            ++k2;
                                        }
                                        if (count > 3) {
                                            getMKBody.append("\n\t&& ((bytes[");
                                            getMKBody.append(Integer.toString(i));
                                            getMKBody.append("]");
                                            getMKBody.append(" & 0x");
                                            getMKBody.append(Integer.toHexString(andMask[i] & 0xFF));
                                            getMKBody.append(") == 0x");
                                            getMKBody.append(Integer.toHexString(equals & 0xFF));
                                            getMKBody.append(')');
                                        } else {
                                            getMKBody.append("\n\t&& (");
                                            boolean first = true;
                                            int k3 = 0;
                                            while (k3 < 256) {
                                                if (counts[k3] > 0) {
                                                    if (!first) {
                                                        getMKBody.append("\t\t|| ");
                                                    }
                                                    first = false;
                                                    if (filterBytes[i] != -1) {
                                                        getMKBody.append("((bytes[");
                                                        getMKBody.append(Integer.toString(i));
                                                        getMKBody.append("] & 0x");
                                                        getMKBody.append(Integer.toHexString(filterBytes[i] & 0xFF));
                                                        getMKBody.append(") == 0x");
                                                        getMKBody.append(Integer.toHexString(k3 & 0xFF));
                                                        getMKBody.append(")\n");
                                                    } else {
                                                        getMKBody.append("(bytes[");
                                                        getMKBody.append(Integer.toString(i));
                                                        getMKBody.append("] == 0x");
                                                        getMKBody.append(Integer.toHexString((byte)k3));
                                                        getMKBody.append(')');
                                                    }
                                                }
                                                ++k3;
                                            }
                                            getMKBody.append("\t\t)");
                                        }
                                    }
                                }
                            }
                            --i;
                        }
                        getMKBody.append(") {\n");
                        int shift = 0;
                        boolean first = true;
                        int i2 = 0;
                        while (i2 < filterBytes.length) {
                            byte mask = filterBytes[i2];
                            if (mask != 0) {
                                if (i2 < andMask.length) {
                                    mask = (byte)(mask ^ andMask[i2]);
                                }
                                if (mask != 0) {
                                    if (first) {
                                        getMKBody.append("\treturn createInteger(\n");
                                        getMKBody.append("\t\t");
                                    }
                                    if (!first) {
                                        getMKBody.append(" ^ ");
                                    }
                                    first = false;
                                    int bmask = 1;
                                    int j2 = 0;
                                    while (j2 < 8) {
                                        if ((bmask & mask) != 0) break;
                                        bmask <<= 1;
                                        --shift;
                                        ++j2;
                                    }
                                    if (shift != 0) {
                                        getMKBody.append('(');
                                    }
                                    getMKBody.append("(bytes[");
                                    getMKBody.append(Integer.toString(i2));
                                    getMKBody.append("] & 0x");
                                    getMKBody.append(Integer.toHexString(mask & 0xFF));
                                    getMKBody.append(')');
                                    if (shift > 0) {
                                        getMKBody.append(" << ");
                                        getMKBody.append(Integer.toString(shift));
                                        getMKBody.append(')');
                                    } else if (shift < 0) {
                                        getMKBody.append(" >> ");
                                        getMKBody.append(Integer.toString(-shift));
                                        getMKBody.append(')');
                                    }
                                    int newShift = 8;
                                    bmask = 128;
                                    int j3 = 0;
                                    while (j3 < 8) {
                                        if ((bmask & mask) != 0) break;
                                        bmask >>= 1;
                                        --newShift;
                                        ++j3;
                                    }
                                    if ((shift += newShift) > 24) {
                                        shift = i2;
                                    }
                                }
                            }
                            ++i2;
                        }
                        if (first) {
                            getMKBody.append("\treturn this;\n");
                        } else {
                            getMKBody.append("\t);");
                        }
                        getMKBody.append("\n}\n");
                        getMKBody.append("return null;\t//Not looking for this message.");
                    }
                }
                String contents2 = getMKBody.toString();
                this.codeMethod(device, "getMessageKey", comment2, "Object", 1L, contents2, new KeyValuePair[]{parameter2}, null);
            }
        }
    }

    private void codeGetter(IType device, TagElement ci) {
        String name = "get" + ci.getId();
        String returnTypeFull = ci.getServiceType();
        String returnType = DeviceKitUtilities.stripPackage(returnTypeFull);
        this.fDeviceModel.addImport(returnTypeFull);
        String[] comment = ci.getFieldComment();
        if (comment != null && comment.length > 0 && !comment[0].trim().endsWith(".")) {
            comment[0] = String.valueOf(comment[0]) + '.';
        }
        String contents = this.getControlGetterBody(ci);
        this.codeMethod(device, name, comment, returnType, 1L, contents);
        if (ci.hasChildWithTagCode(7) || ci.hasChildWithTagCode(154) || ci.hasChildWithTagCode(152) || ci.hasChildWithTagCode(153)) {
            this.fDeviceModel.addImport(this.getMessageFqn());
        }
        String type = ci.getType();
        this.fDeviceModel.addImport(type);
        String typePack = DeviceKitUtilities.extractPackage(type);
        this.getManifestModel().addImportPackage(DeviceKitUtilities.extractPackage(returnTypeFull));
        this.getManifestModel().addImportPackage(typePack);
    }

    private void codeGetters(IType device) throws Exception {
        if (this.isCodeGetters()) {
            int i = 0;
            while (i < this.fGetMethods.size()) {
                TagElement ci = (TagElement)this.fGetMethods.get(i);
                this.codeGetter(device, ci);
                ++i;
            }
        }
    }

    protected void codeInitialize(IType device) {
        String comment = Nls.format(DeviceKitGenerator.getResource("DkDeviceGenerator.initialize.comment1"), this.getMainTagName());
        String contents = this.getInitializeContents();
        this.codeMethod(device, "initialize", comment, "void", 2L, contents);
    }

    protected void codeInterestFilterField(IType device) {
        String fieldType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_INTEREST_SERVICE);
        String comment = DeviceKitGenerator.getResource("DkDeviceGenerator.interest.field.comment");
        boolean includeCommands = true;
        if (this.getDevice() != null) {
            includeCommands = this.getDevice().includeCommandReceived();
        }
        FilterComputer fc = new FilterComputer(TagElement.collection, this.getMessageClassElements(), includeCommands);
        fc.compute();
        byte[] mask = fc.getMask();
        byte[] pattern = fc.getPattern();
        if (mask != null && pattern != null) {
            String value = this.getInterestFilterFieldValue(mask, pattern);
            this.codeField(device, "interest", fieldType, 34L, comment, value);
            this.fDeviceModel.addImport(DeviceKitGenerationConstants.CLASS_INTEREST_SERVICE);
            this.fDeviceModel.addImport(DeviceKitGenerationConstants.CLASS_INTEREST_MASK);
            this.codeGetInterestMask(device);
        }
    }

    private void codeMessagePids(IType message) {
        String fieldType = String.valueOf(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_MESSAGE_SERVICE)) + "[]";
        long identifiers = 50L;
        String comment = "The default J1597 message.";
        String value = this.getMessagePidsFieldValue();
        this.codeField(message, "DefaultJ1587Message", fieldType, identifiers, comment, value);
        String returnType = fieldType;
        comment = "Returns the default j1587 message.";
        identifiers = 49L;
        this.codeMethod(message, "getDefaultJ1587Message", comment, returnType, identifiers, "return DefaultJ1587Message;\n");
        this.fDeviceModel.addImport(DeviceKitGenerationConstants.CLASS_MESSAGE_FILTER);
        this.fDeviceModel.addImport(DeviceKitGenerationConstants.CLASS_FILTER);
    }

    protected void codeMethods(IType device) throws Exception {
        this.codeDefaultKey(device);
        this.codeDefaultStyle(device);
        this.codeDefaultTransport(device);
        this.codeGetControlCapacity(device);
        this.codeGetMessageCapacityAndKey(device);
        this.codeGetters(device);
        if (this.isLazyDevice) {
            this.codeElements(device);
            this.codeCreateAllControls(device);
            this.codeGetControl(device);
            if (this.hasPids) {
                this.codeInitialize(device);
            }
        } else {
            this.codeInitialize(device);
        }
        this.codeSetup(device);
    }

    private void codePidsLengthField(IType device) {
        String value = this.getPidsLengthFieldContents();
        this.codeField(device, "pidLengths", "int []", 49L, "The pid lengths.", value);
    }

    public void codeProfilePrefix(IType type, String className) {
        String key = CodeUtilities.methodName(String.valueOf(className) + "Prefix");
        String betterName = CodeUtilities.betterName(key, false);
        String fieldName = CodeUtilities.staticFieldName(String.valueOf(className) + "Prefix", true);
        StringBuffer comment = new StringBuffer(256);
        comment.append("Define the ");
        comment.append(betterName);
        comment.append(" configuration key.");
        this.codeField(type, fieldName, "String", 49L, comment.toString(), DeviceKitUtilities.quote(key));
        String methodName = "get" + CodeUtilities.methodName(key);
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append("\treturn getString(");
        buffer.append(fieldName);
        buffer.append(", getPrefix());\r\n");
        StringBuffer mcomment = new StringBuffer(256);
        mcomment.append("Get the ");
        mcomment.append(betterName);
        mcomment.append(" value.");
        mcomment.append("\n@return The ");
        mcomment.append(betterName);
        mcomment.append(" value.");
        mcomment.append("\n@see #");
        mcomment.append(fieldName);
        this.codeMethod(type, methodName, mcomment.toString(), "String", 1L, buffer.toString());
    }

    protected void codeRateGetters(IType device) {
        int i = 0;
        while (i < this.fRateElements.size()) {
            TagElement element = (TagElement)this.fRateElements.get(i);
            this.codeGetter(device, element);
            ++i;
        }
    }

    protected void codeServiceDataFields(IType service) {
        List datas = this.getMainElement().getAllChildrenWithTagCodes(new int[]{76}, DeviceKitTagConstants.ALL_PARENT_CONTROLS_PLUS_DATA);
        int i = 0;
        while (i < datas.size()) {
            TagElement element = (TagElement)datas.get(i);
            this.codeDeviceServiceDataKeyField(service, element);
            List enums = element.getAllChildrenWithTagCode(77);
            String defaultValue = null;
            if (enums.size() > 0) {
                this.codeServiceEnumKeyField(service, enums, defaultValue);
            }
            ++i;
        }
    }

    protected void codeServiceEnumFields(IType service) {
        List enums = this.getMainElement().getAllSubChildrenWithTagCode(77, false);
        if (enums.size() > 0) {
            this.codeServiceEnumKeyField(service, enums, "");
        }
    }

    protected void codeServiceFields(IType service) {
        super.codeServiceFields(service);
        this.codeDeviceServiceField(service);
        int i = 0;
        while (i < this.fGetMethods.size()) {
            ControlItem element = (ControlItem)this.fGetMethods.get(i);
            this.codeDeviceServiceKeyField(service, element);
            ++i;
        }
        this.codeCommandsSignalsMeasurementsFields(service);
        this.codeServiceDataFields(service);
        this.codeCustomParameterServiceFields(service);
        this.codeParameterServiceFields(service);
        this.codeDescriptionField(service, "SERVICE_DESCRIPTION");
    }

    protected void codeSetup(IType device) {
        String contents = this.getSetupContents(device);
        this.codeMethod(device, "setup", "@see org.eclipse.soda.dk.device.Container#setup()", "void", 1L, contents);
    }

    protected void codeStaticIdField(IType device, List vector, String fieldName, String fieldComment) {
        ArrayList tvector = vector;
        if (tvector == null) {
            tvector = new ArrayList();
        }
        String fieldValue = null;
        fieldValue = this.getStaticIdFieldValue(tvector);
        if (this.initializeWithMethods) {
            String capFieldName = DeviceKitUtilities.capitalizeFirstLetter(fieldName.toLowerCase());
            String methodName = "create" + capFieldName;
            String methodValue = fieldValue;
            fieldValue = String.valueOf(methodName) + "();";
            this.codeCreateStaticIdMethod(device, "String[]", methodName, 50L, methodValue, fieldName);
        }
        this.codeField(device, fieldName, "String[]", 49L, fieldComment, fieldValue);
    }

    protected void codeStaticIdFields(IType device) {
    }

    protected void codeUses(IType device) {
        List parentElements = this.getMainElement().getAllChildrenWithTagCodes(new int[]{85});
        if (parentElements.size() > 0) {
            StringBuffer handleBuffer = new StringBuffer(2048);
            StringBuffer setupBuffer = new StringBuffer(2048);
            StringBuffer registerBuffer = new StringBuffer(2048);
            StringBuffer readBuffer = new StringBuffer(2048);
            registerBuffer.append("register(new String[] {");
            HashMap<String, String> parents = new HashMap<String, String>();
            int i = 0;
            while (i < parentElements.size()) {
                TagElement parentElement = (TagElement)parentElements.get(i);
                List elements = parentElement.getAllChildrenWithTagCodes(new int[]{79, 80, 81}, new int[]{86, 94});
                if (elements.size() > 0) {
                    int j = 0;
                    while (j < elements.size()) {
                        TagElement element = (TagElement)elements.get(j);
                        String id = element.getId();
                        String className = DeviceKitUtilities.stripPackage(element.getParent().getClassNameFull());
                        String prefixField = CodeUtilities.fieldName(String.valueOf(className) + "Prefix");
                        if (parents.get(className) == null) {
                            parents.put(className, className);
                            this.codeProfilePrefix(device, className);
                            setupBuffer.append("\tfinal String ");
                            setupBuffer.append(prefixField);
                            setupBuffer.append(" = get");
                            setupBuffer.append(CodeUtilities.methodName(prefixField));
                            setupBuffer.append("();\t//Setup the prefix to use\r\n");
                        }
                        String serviceType = element.getParent().getServiceNameFull();
                        String serviceName = DeviceKitUtilities.stripPackage(serviceType);
                        this.fDeviceModel.addImport(serviceType);
                        String fieldName = CodeUtilities.fieldName(String.valueOf(serviceName) + id);
                        String fieldNameExternal = String.valueOf(fieldName) + "ExternalKey";
                        String fieldNameGetExternal = String.valueOf(fieldName) + "GetExternalKey";
                        handleBuffer.append("if (externalKey.equals(this.");
                        handleBuffer.append(fieldNameExternal);
                        handleBuffer.append(")) {");
                        handleBuffer.append("handle");
                        handleBuffer.append(CodeUtilities.methodName(fieldName));
                        handleBuffer.append("(externalKey, data);");
                        handleBuffer.append("return;");
                        handleBuffer.append('}');
                        if (j > 0) {
                            registerBuffer.append(',');
                        }
                        registerBuffer.append("this.");
                        registerBuffer.append(fieldNameExternal);
                        setupBuffer.append("this.");
                        setupBuffer.append(fieldNameExternal);
                        setupBuffer.append(" = prependPrefix(");
                        setupBuffer.append(prefixField);
                        setupBuffer.append(',');
                        setupBuffer.append(serviceName);
                        setupBuffer.append('.');
                        setupBuffer.append(this.getExternalKey(CodeUtilities.fieldName(id)));
                        setupBuffer.append(");");
                        StringBuffer nameBuffer = new StringBuffer();
                        nameBuffer.append(fieldNameExternal);
                        this.codeField(device, nameBuffer.toString(), "String", 4L, "", "null");
                        switch (element.getTagCode()) {
                            case 79: {
                                break;
                            }
                            case 80: {
                                setupBuffer.append("this.");
                                setupBuffer.append(fieldNameGetExternal);
                                setupBuffer.append(" = prependPrefix(");
                                setupBuffer.append(prefixField);
                                setupBuffer.append(',');
                                setupBuffer.append(serviceName);
                                setupBuffer.append('.');
                                setupBuffer.append(this.getGetExternalKey(CodeUtilities.fieldName(id)));
                                setupBuffer.append(");");
                                readBuffer.append("broadcast(this.");
                                readBuffer.append(fieldNameGetExternal);
                                readBuffer.append(", new Hashtable());");
                                Class<?> clazz = class$0;
                                if (clazz == null) {
                                    try {
                                        clazz = Class.forName("java.util.Map");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                this.fDeviceModel.addImport(clazz.getName());
                                this.codeField(device, fieldNameGetExternal, "String", 4L, "", "null");
                                break;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            KeyValuePair parameter0 = new KeyValuePair("String", "externalKey");
            KeyValuePair parameter1 = new KeyValuePair("Dictionary", "data");
            KeyValuePair[] parameters = new KeyValuePair[]{parameter0, parameter1};
            this.fDeviceModel.addImport("java.util.Dictionary");
            if (handleBuffer.length() > 0) {
                handleBuffer.append("super.notificationReceived(externalKey, data);");
                this.codeMethod(device, "notificationReceived", "", "void", 1L, handleBuffer.toString(), parameters, null);
            }
            if (setupBuffer.length() > 0) {
                registerBuffer.append("});");
                setupBuffer.append(registerBuffer.toString());
                setupBuffer.append("super.setupNotification();");
                setupBuffer.append(readBuffer.toString());
                this.codeMethod(device, "setupNotification", "", "void", 1L, setupBuffer.toString(), new KeyValuePair[0], null);
            }
        }
    }

    protected IType createBundleActivatorType() throws Exception {
        String baName = this.getBundleActivatorClass();
        String baPackage = this.getBundleActivatorPackage();
        this.fBundleActivatorModel = new JavaFileModel(baName);
        this.fBundleActivatorModel.setComment(this.getCopyright());
        this.fBundleActivatorModel.setPackage(baPackage);
        IType baType = this.createClass(this.fBundleActivatorModel, baPackage, baName, this.getSourceFolderName());
        if (this.bundleType != 4) {
            String baSuperClass = this.getBASuperClass();
            baType.setSuperClass(DeviceKitUtilities.stripPackage(baSuperClass));
            this.fBundleActivatorModel.addImport(baSuperClass);
            baType.addSuperInterface(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_OSGI_BUNDLE_ACTIVATOR));
            this.fBundleActivatorModel.addImport(DeviceKitGenerationConstants.CLASS_OSGI_BUNDLE_ACTIVATOR);
        } else {
            baType.setSuperClass("Object");
        }
        baType.setComment(this.getBundleActivatorComment());
        if (this.addTypePackageToBuildModel()) {
            this.buildModel.addPackage(DeviceKitUtilities.extractPackage(this.mainTarget.getSuperClass()));
        }
        return baType;
    }

    protected IType createDeviceType() throws Exception {
        String mainPackage = this.getMainPackage();
        String mainClassName = this.getMainClassName();
        this.fDeviceModel = new JavaFileModel(mainClassName);
        this.fDeviceModel.setComment(this.getCopyright());
        this.fDeviceModel.setPackage(mainPackage);
        this.fDeviceModel.addImport(this.getServiceFqn());
        IType mainType = this.createClass(this.fDeviceModel, mainPackage, mainClassName, this.getSourceFolderName());
        if (this.getDevice().isAbstract()) {
            mainType.setIdentifiers(65L);
        }
        mainType.setComment(this.getMainClassComment());
        this.fDeviceModel.addImport(this.mainTarget.getSuperClass());
        this.buildModel.addPackage(DeviceKitUtilities.extractPackage(this.mainTarget.getSuperClass()));
        String superClass = DeviceKitUtilities.stripPackage(this.mainTarget.getSuperClass());
        mainType.setSuperClass(superClass);
        String[] interfaces = this.mainTarget.getImplementedInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (interfaces[i].equals(DeviceKitGenerationConstants.CLASS_OSGI_DEVICE)) {
                mainType.addSuperInterface(interfaces[i]);
            } else {
                this.fDeviceModel.addImport(interfaces[i]);
                mainType.addSuperInterface(DeviceKitUtilities.stripPackage(interfaces[i]));
            }
            ++i;
        }
        this.fDeviceModel.addImport(this.getServiceFqn());
        mainType.addSuperInterface(DeviceKitUtilities.stripPackage(this.getServiceClass()));
        return mainType;
    }

    protected boolean doGenerateBundleActivator() {
        return this.bundleType != 0;
    }

    protected void generateBundleActivatorClass() throws Exception {
        if (this.bundleType != 0) {
            IType baType = this.createBundleActivatorType();
            if (this.bundleType != 4) {
                this.codeBAFields(baType);
                this.codeBAMethods(baType);
            }
            this.generateCustomBundleActivatorItems();
        }
    }

    protected void generateMessageClass() throws Exception {
        List elements = this.getMessageClassElements();
        if (!this.hasPids && elements.size() == 0) {
            return;
        }
        IType messageType = this.createMessageType();
        this.codeClassNameField(messageType, this.getMessageFqn());
        int i = 0;
        while (i < elements.size()) {
            TagElement element = (TagElement)elements.get(i);
            this.codeMessageCommonElements(messageType, element, this.isLazyDevice, this.initializeWithMethods());
            ++i;
        }
        if (this.hasPids) {
            this.codeMessagePids(messageType);
        }
    }

    protected void generateOtherFiles() throws Exception {
        switch (this.bundleType) {
            case 0: 
            case 1: {
                break;
            }
            case 4: {
                String dsData = this.getDSDataContents();
                if (dsData == null) break;
                String name = this.getMainClassName();
                String dsName = "OSGI-INF/" + name + ".xml";
                this.otherManifestFiles.put(dsName, dsData);
                break;
            }
            case 2: 
            case 3: {
                String metaData = this.getMetaDataContents();
                if (metaData == null) break;
                this.otherManifestFiles.put("OSGI-INF/metatype/Metadata.xml", metaData);
            }
        }
        String properties = this.getMetaDataProperties();
        if (properties != null) {
            this.otherManifestFiles.put("OSGI-INF/l10n/bundle.properties", properties);
            this.otherManifestFiles.put("OSGI-INF/l10n/bundle_en.properties", properties);
        }
    }

    protected void generateSpecificClass() throws JavaModelException, IOException, Exception {
        IType device = this.createDeviceType();
        this.codeFields(device);
        this.codeConstructors(device);
        this.codeMethods(device);
        this.generateMessageClass();
        this.generateCustomMainItems();
    }

    protected String getBACreateServiceContents() {
        StringBuffer buffer = new StringBuffer(32);
        String type = this.getDevice().getType();
        this.fBundleActivatorModel.addImport(type);
        buffer.append("final ");
        buffer.append(DeviceKitUtilities.stripPackage(type));
        buffer.append(" device = new ");
        buffer.append(DeviceKitUtilities.stripPackage(type));
        buffer.append("();\n");
        if (this.tService != null) {
            buffer.append("device.setTransport(");
            buffer.append("transportService");
            buffer.append(");\n");
        }
        buffer.append("return device;\n");
        return buffer.toString();
    }

    protected String getBAGetInterestServiceNameContents(String service) {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("return ");
        String serv = DeviceKitUtilities.stripPackage(service);
        buffer.append(serv);
        buffer.append(".SERVICE_NAME;");
        return buffer.toString();
    }

    protected String getBASuperClass() {
        switch (this.bundleType) {
            case 2: {
                return DeviceKitGenerationConstants.CLASS_DEVICE_MANAGED_BA;
            }
            case 3: {
                return DeviceKitGenerationConstants.CLASS_DEVICE_MANAGED_FACTORY_BA;
            }
            case 1: {
                return DeviceKitGenerationConstants.CLASS_DEVICE_BUNDLE_ACTIVATOR;
            }
            case 4: {
                return "java.lang.Object";
            }
        }
        return "";
    }

    protected String getBundleActivatorClass() {
        switch (this.bundleType) {
            case 0: {
                return super.getBundleActivatorClass();
            }
            case 4: {
                return String.valueOf(this.getMainClassName()) + "DSBundle";
            }
            case 2: {
                return String.valueOf(this.getMainClassName()) + "Managed";
            }
            case 3: {
                return String.valueOf(this.getMainClassName()) + "Factory";
            }
            case 1: {
                return String.valueOf(this.getMainClassName()) + "Bundle";
            }
        }
        return super.getBundleActivatorClass();
    }

    protected String getBundleActivatorComment() {
        StringBuffer buffer = new StringBuffer(128);
        String desc = this.getMainElement().getDescription();
        if (desc != null) {
            buffer.append(desc);
            if (!desc.trim().endsWith(".")) {
                buffer.append('.');
            }
            buffer.append("\r\n");
        }
        buffer.append(Nls.format(DeviceKitGenerator.getResource("DkDeviceGenerator.ba.class.comment1"), this.getMainClassName()));
        buffer.append("\r\n");
        buffer.append(this.getCommonClassComment());
        return buffer.toString();
    }

    protected String getBundleActivatorFqn() {
        if (this.bundleType == 0 || this.bundleType == 4) {
            return super.getBundleActivatorFqn();
        }
        return String.valueOf(this.getBundleActivatorPackage()) + "." + this.getBundleActivatorClass();
    }

    protected String getBundleActivatorPackage() {
        switch (this.bundleType) {
            case 4: {
                return String.valueOf(this.getMainPackage()) + "." + "dsbundle";
            }
            case 2: {
                return String.valueOf(this.getMainPackage()) + "." + "managed";
            }
            case 3: {
                return String.valueOf(this.getMainPackage()) + "." + "factory";
            }
            case 1: {
                return String.valueOf(this.getMainPackage()) + "." + "bundle";
            }
        }
        return String.valueOf(this.getMainPackage()) + "." + "bundle";
    }

    public int getBundleType() {
        return this.bundleType;
    }

    protected String getCodeCreateAllControlsContents() {
        StringBuffer buffer = new StringBuffer(this.fGetMethods.size() * 16);
        List elements = this.getMainElement().getAllChildrenWithTagCodes(new int[]{1, 19, 2, 3, 4}, false);
        int i = 0;
        while (i < elements.size()) {
            TagElement ci = (TagElement)elements.get(i);
            if (ci instanceof ControlItem) {
                buffer.append("get");
                buffer.append(ci.getId());
                buffer.append("();\n");
            }
            ++i;
        }
        return buffer.toString();
    }

    protected String getCommonClassComment() {
        StringBuffer buffer = new StringBuffer(128);
        List services = this.getServices();
        if (services.size() > 0) {
            buffer.append(" \n");
            buffer.append("<p>The Device Kit properties CONNECTION_KEYS and default values.\n");
            int indentation = 0;
            buffer.append(this.getHtmlHelper().startTable(indentation));
            ++indentation;
            int i = 0;
            while (i < services.size()) {
                String[] dataEntries = new String[]{(String)services.get(i), this.getImplementation(this.tService, (String)services.get(i))};
                buffer.append(this.getHtmlHelper().getTableRow(indentation, dataEntries));
                ++i;
            }
            buffer.append(this.getHtmlHelper().endTable(--indentation));
            buffer.append(" \n");
            String[] xmp = new String[services.size()];
            int i2 = 0;
            while (i2 < services.size()) {
                xmp[i2] = String.valueOf(String.valueOf(services.get(i2))) + '=' + this.getImplementation(this.tService, (String)services.get(i2));
                ++i2;
            }
            buffer.append(this.getHtmlHelper().getExample(0, xmp));
            buffer.append(" \n");
        }
        String importedServices = this.getImportedServiceComment();
        buffer.append(importedServices);
        if (importedServices.length() > 0) {
            buffer.append(" \n");
        }
        String exportedServices = this.getExportedServiceComment();
        buffer.append(exportedServices);
        if (exportedServices.length() > 0) {
            buffer.append(" \n");
        }
        buffer.append(super.getCommonClassComment());
        return buffer.toString();
    }

    protected String getConstructorContents() {
        List parents = this.getParentElements();
        return this.getConstructorContents(parents);
    }

    protected String getConstructorContents(List parents) {
        StringBuffer buffer = new StringBuffer(512);
        if (parents.size() == 0) {
            String serviceName = this.getServiceClass();
            buffer.append("super(");
            buffer.append(serviceName);
            buffer.append(".Capabilities,\t//Define the Capabilities Measurement\n");
            buffer.append(serviceName);
            buffer.append(".Status,\t//Define the Status Measurement\n");
            buffer.append(serviceName);
            buffer.append(".Configuration,\t//Define the Configuration Measurement\n");
            buffer.append(serviceName);
            buffer.append(".Metrics");
            if (this.getMainElement().isMultiplex()) {
                buffer.append(",\t//Define the Metrics Measurement\n");
                buffer.append(serviceName);
                buffer.append(".Channels,\t//Define the Channels Measurement (Multiplex)\n");
                buffer.append(serviceName);
                buffer.append(".ChannelChanged,\t//Define the Channel Changed Measurement (Multiplex)\n");
                buffer.append(serviceName);
                buffer.append(".OpenChannel,\t//Define the Open Channel Measurement (Multiplex)\n");
                buffer.append(serviceName);
                buffer.append(".CloseChannel);\t//Define the Close Channel Measurement (Multiplex)\n");
            } else {
                buffer.append(");\t//Define the Metrics Measurement\n");
            }
        } else {
            buffer.append("super();\n");
        }
        buffer.append("setKey(getDefaultKey());\t//The super class defines the common measurements\n");
        if (!this.isLazyDevice || this.hasPids) {
            buffer.append("initialize();\n");
        }
        return buffer.toString();
    }

    protected String getControlGetterBody(TagElement ci) {
        StringBuffer buffer = new StringBuffer(256);
        String fieldName = CodeUtilities.fieldName(ci.getId());
        if (this.isLazyDevice || this.hasRateControlChild(ci)) {
            buffer.append("if (");
            buffer.append("this.");
            buffer.append(fieldName);
            buffer.append(" == null){\n");
            buffer.append("\tthis.");
            buffer.append(fieldName);
            buffer.append(" =\n");
            NewCodeGenerator gen = new NewCodeGenerator(this.getMainFqn(), this.getMessageFqn(), this.getServiceFqn(), this.isLazyDevice);
            buffer.append(gen.getNewCode(2, ci));
            List newImports = gen.getImports();
            int i = 0;
            while (i < newImports.size()) {
                String importedItem = (String)newImports.get(i);
                this.fDeviceModel.addImport(importedItem);
                String importedPack = DeviceKitUtilities.extractPackage(importedItem);
                this.getManifestModel().addImportPackage(importedPack);
                ++i;
            }
            buffer.append(";\n");
            if (ci instanceof ControlItem) {
                buffer.append("\tput(");
                buffer.append("this.");
                buffer.append(fieldName);
                buffer.append(".getKey(), ");
                buffer.append("this.");
                buffer.append(fieldName);
                buffer.append(");\n");
            }
            buffer.append("}\n");
        }
        buffer.append("return this.");
        buffer.append(fieldName);
        buffer.append(';');
        return buffer.toString();
    }

    public String getCopyrightProperty(Map map) {
        String[] strings = GeneratorTemplates.getCopyrightStrings(map);
        StringBuffer buffer = new StringBuffer(1024);
        int i = 0;
        while (i < strings.length) {
            if (i > 0) {
                buffer.append("\\r\\n");
            }
            buffer.append(strings[i]);
            ++i;
        }
        return buffer.toString();
    }

    protected String getDefaultKeyContents() {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("return ");
        buffer.append(this.getKey(this.getDevice()));
        buffer.append(";\n");
        return buffer.toString();
    }

    protected String getDefaultStyleContents() {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("return ");
        if (this.initializeMeasurements) {
            buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE));
            this.fDeviceModel.addImport(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
            buffer.append(".INITIALIZEMEASUREMENTS");
        } else {
            buffer.append("super.");
            buffer.append("getDefaultStyle");
            buffer.append("()");
        }
        buffer.append(';');
        return buffer.toString();
    }

    protected String getDefaultTransportContents(String transportServiceName) {
        StringBuffer buffer = new StringBuffer(64);
        if (this.getDevice().getTransportServiceChildren().size() > 0) {
            TransportServiceElement te = (TransportServiceElement)this.getDevice().getTransportServiceChildren().get(0);
            if (transportServiceName == null) {
                buffer.append("return null;");
            } else {
                String implementation = te.getAttribute("implementation");
                if (implementation == null) {
                    implementation = transportServiceName;
                } else {
                    int index = implementation.indexOf(46);
                    if (index < 0) {
                        String packageName = DeviceKitUtilities.getPackageFromClassName(implementation, this.getPackageBase());
                        implementation = String.valueOf(packageName) + '.' + implementation;
                    }
                }
                buffer.append("return (");
                buffer.append(DeviceKitUtilities.stripPackage(transportServiceName));
                buffer.append(") loadService(");
                buffer.append(DeviceKitUtilities.stripPackage(transportServiceName));
                buffer.append(".SERVICE_NAME, \"");
                buffer.append(implementation);
                this.buildModel.addAdditionalBundles(DeviceKitUtilities.extractPackage(implementation));
                buffer.append("\");");
            }
        } else {
            TagElement transportElement = this.getDevice().getTransportElement();
            if (transportElement != null) {
                buffer.append("return (");
                buffer.append(DeviceKitUtilities.stripPackage(transportElement.getServiceNameFull()));
                buffer.append(") loadService(");
                buffer.append(DeviceKitUtilities.stripPackage(transportServiceName));
                buffer.append(".SERVICE_NAME, \"");
                buffer.append(transportElement.getType());
                this.buildModel.addAdditionalBundles(DeviceKitUtilities.extractPackage(transportElement.getType()));
                buffer.append("\");");
            } else {
                buffer.append("return null;");
            }
        }
        return buffer.toString();
    }

    protected MainTagElement getDevice() {
        return this.mainTarget;
    }

    protected String getDeviceCategory() {
        return DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
    }

    protected MainTagElement getDeviceElement() {
        if (this.mainTarget != null) {
            return this.mainTarget;
        }
        return this.getDeviceElement(this.getRootElement());
    }

    protected MainTagElement getDeviceElement(TagElement parent) {
        List children = parent.getChildren();
        int i = 0;
        while (i < children.size()) {
            if (8 == ((TagElement)children.get(i)).getTagCode()) {
                return (MainTagElement)children.get(i);
            }
            ++i;
        }
        return null;
    }

    protected String getElementsContents() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("createAllControls();\n");
        buffer.append("return super.elements();");
        return buffer.toString();
    }

    protected String getExportedServiceComment() {
        StringBuffer buffer = new StringBuffer(64);
        List exports = this.getExportedServices();
        if (exports.size() > 0) {
            buffer.append("<p>The list of exported services:\n");
            int i = 0;
            while (i < exports.size()) {
                buffer.append("@see ");
                buffer.append(exports.get(i));
                buffer.append('\n');
                ++i;
            }
        }
        return buffer.toString();
    }

    protected List getExportedServices() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getServiceFqn());
        result.add(this.getServiceClassParent());
        return result;
    }

    private String getExternalKey(String fieldName) {
        String fieldNameUpper = CodeUtilities.validStaticIdentifier(fieldName);
        String externalKeyBase = String.valueOf(fieldNameUpper) + "_EXTERNAL_KEY";
        return externalKeyBase;
    }

    protected String getGetControlCapacityContents() {
        StringBuffer buffer = new StringBuffer();
        int controlCapacity = this.fGetMethods.size();
        int controlCapacityPrime = DeviceKitUtilities.getPrime((controlCapacity << 2) / 3);
        buffer.append("return ");
        buffer.append(controlCapacityPrime);
        buffer.append(';');
        return buffer.toString();
    }

    protected String getGetControlContents() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("ControlService control = super.get(key);\n");
        buffer.append("Method method = null;\n");
        buffer.append("try {\n");
        buffer.append("\tmethod = this.getClass().getMethod(\"get\" + key, new Class[0]);\n");
        buffer.append("\tif (method != null) {\n");
        buffer.append("\t\t\tcontrol = (ControlService)method.invoke(this, new Object[0]);\n");
        buffer.append("\t}\n");
        buffer.append("} catch (final Exception e) {\n");
        buffer.append("\tcontrol = null;\n");
        buffer.append("}\n");
        buffer.append("return control;");
        return buffer.toString();
    }

    private String getGetExternalKey(String fieldName) {
        String fieldNameUpper = CodeUtilities.validStaticIdentifier(fieldName);
        String externalKeyBase = String.valueOf(fieldNameUpper) + "_GET_EXTERNAL_KEY";
        return externalKeyBase;
    }

    protected String getGetInterestMaskContents() {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("return ");
        buffer.append("this.");
        buffer.append("interest");
        buffer.append(";\n");
        return buffer.toString();
    }

    protected String getImportedServiceComment() {
        StringBuffer buffer = new StringBuffer(64);
        List imports = this.getImportedServices();
        if (imports.size() > 0) {
            buffer.append("<p>The list of imported services:\n");
            int i = 0;
            while (i < imports.size()) {
                buffer.append("@see ");
                buffer.append(imports.get(i));
                buffer.append('\n');
                ++i;
            }
        }
        return buffer.toString();
    }

    protected List getImportedServices() {
        return this.getServices();
    }

    protected String getInitializeContents() {
        StringBuffer buffer = new StringBuffer(256);
        if (!this.isLazyDevice) {
            int i = 0;
            while (i < this.fGetMethods.size()) {
                TagElement ci = (TagElement)this.fGetMethods.get(i);
                if (ci instanceof ControlItem) {
                    if (!this.isCodeGetters()) {
                        buffer.append("\tfinal ");
                        String serviceType = ci.getServiceType();
                        this.fDeviceModel.addImport(serviceType);
                        buffer.append(DeviceKitUtilities.stripPackage(serviceType));
                        buffer.append(' ');
                        buffer.append(CodeUtilities.fieldName(ci.getId()));
                        buffer.append(" = ");
                        buffer.append("this.");
                        buffer.append(CodeUtilities.fieldName(ci.getId()));
                        buffer.append(";\t//Force reference to service class\n");
                        buffer.append("put(");
                        buffer.append(CodeUtilities.fieldName(ci.getId()));
                        buffer.append(");\n");
                    } else {
                        buffer.append("put(");
                        buffer.append("this.");
                        buffer.append(CodeUtilities.fieldName(ci.getId()));
                        buffer.append(");\n");
                    }
                    if ("true".equals(ci.getAttribute("listen"))) {
                        buffer.append("this.");
                        buffer.append(CodeUtilities.fieldName(ci.getId()));
                        buffer.append(".addMeasurementListener(this);\n");
                    }
                }
                ++i;
            }
        }
        if (this.hasPids) {
            String mh = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_J1587_PID_MESSAGE_HANDLER);
            this.fDeviceModel.addImport(DeviceKitGenerationConstants.CLASS_J1587_PID_MESSAGE_HANDLER);
            buffer.append(mh);
            buffer.append(" messageHandler = new ");
            buffer.append(mh);
            buffer.append("(this, ");
            this.fDeviceModel.addImport(DeviceKitGenerationConstants.CLASS_MESSAGE_SERVICE);
            buffer.append(this.getMessageClass());
            buffer.append(".getDefaultJ1587Message(), pidLengths);\n");
            buffer.append("registerMessageHandler(");
            buffer.append(this.getMessageClass());
            buffer.append(".getDefaultJ1587Message(), messageHandler);\n");
        }
        return buffer.toString();
    }

    protected String getInterestFilterFieldValue(byte[] mask, byte[] pattern) {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("new InterestMask(");
        if (mask != null && pattern != null) {
            buffer.append(DeviceKitUtilities.convertByteArrayToString(pattern, this.getRootElement().getFormat()));
            buffer.append(", ");
            buffer.append(DeviceKitUtilities.convertByteArrayToString(mask, this.getRootElement().getFormat()));
        }
        buffer.append(')');
        return buffer.toString();
    }

    protected String getMainClassComment() {
        StringBuffer buffer = new StringBuffer(64);
        String desc = this.getMainElement().getDescription();
        if (desc != null) {
            buffer.append(desc);
            if (!desc.trim().endsWith(".")) {
                buffer.append('.');
            }
            buffer.append("\n\n");
        }
        buffer.append(Nls.format(DeviceKitGenerator.getResource("DkDeviceGenerator.device.class.comment1"), new String[]{this.getMainClassName(), this.getServiceClass(), this.getMainTagName()}).trim());
        buffer.append('\n');
        buffer.append(this.getCommonClassComment());
        return buffer.toString();
    }

    public JavaFileModel getMainModel() {
        return this.fDeviceModel;
    }

    protected String[] getManifestCategories() {
        return new String[]{"device"};
    }

    protected String getManifestDescription() {
        TagElement element = null;
        MainTagElement mainElement = this.getMainElement();
        String mainElementDescription = mainElement.getDescription();
        String mainElementId = mainElement.getId();
        String ending = null;
        switch (this.bundleType) {
            case 0: {
                return super.getManifestDescription();
            }
            case 1: {
                List bundles = this.getMainElement().getAllChildrenWithTagCode(66);
                if (bundles.size() > 0) {
                    element = (TagElement)bundles.get(0);
                }
                ending = " Bundle";
                break;
            }
            case 4: {
                List dsbundles = this.getMainElement().getAllChildrenWithTagCode(66);
                if (dsbundles.size() > 0) {
                    element = (TagElement)dsbundles.get(0);
                }
                ending = " DS Bundle";
                break;
            }
            case 2: {
                List managed = this.getMainElement().getAllChildrenWithTagCode(67);
                if (managed.size() > 0) {
                    element = (TagElement)managed.get(0);
                }
                ending = " Managed";
                break;
            }
            case 3: {
                List factory = this.getMainElement().getAllChildrenWithTagCode(68);
                if (factory.size() > 0) {
                    element = (TagElement)factory.get(0);
                }
                ending = " Factory";
                break;
            }
            default: {
                return super.getManifestDescription();
            }
        }
        if (element != null && element.getDescription() != null) {
            return element.getDescription();
        }
        if (mainElementDescription != null) {
            return String.valueOf(mainElementDescription) + ending;
        }
        return String.valueOf(mainElementId) + ending;
    }

    protected List getManifestExportPackages() {
        ArrayList<String> vector = new ArrayList<String>();
        vector.add(this.getMainPackage());
        List elements = this.getMessageClassElements();
        if (elements.size() > 0) {
            vector.add(this.getMessagePackage());
        }
        vector.add(this.getServicePackage());
        return vector;
    }

    protected List getManifestImportPackages() {
        int i;
        List vector = super.getManifestImportPackages();
        String[] imports = null;
        if (this.fDeviceModel != null) {
            imports = this.fDeviceModel.getImports();
            i = 0;
            while (i < imports.length) {
                if (!this.inThisBundle(imports[i])) {
                    vector.add(DeviceKitUtilities.extractPackage(imports[i]));
                }
                ++i;
            }
        }
        if (this.fServiceModel != null) {
            imports = this.fServiceModel.getImports();
            i = 0;
            while (i < imports.length) {
                if (!this.inThisBundle(imports[i])) {
                    vector.add(DeviceKitUtilities.extractPackage(imports[i]));
                }
                ++i;
            }
        }
        if (this.fBundleActivatorModel != null) {
            imports = this.fBundleActivatorModel.getImports();
            i = 0;
            while (i < imports.length) {
                if (!this.inThisBundle(imports[i])) {
                    vector.add(DeviceKitUtilities.extractPackage(imports[i]));
                }
                ++i;
            }
        }
        return vector;
    }

    protected List getMessageClassElements() {
        HashMap<String, TagElement> map = new HashMap<String, TagElement>();
        List all = this.getMainElement().getAllChildren(false, false);
        ArrayList<TagElement> elements = new ArrayList<TagElement>();
        int i = 0;
        while (i < all.size()) {
            String id;
            TagElement element = (TagElement)all.get(i);
            if (element.isMessageClassElement() && (id = element.getId()) != null && id.length() > 0 && !elements.contains(element) && map.get(id) == null) {
                map.put(id, element);
            }
            ++i;
        }
        List idOrder = super.getMessageClassElements();
        int i2 = 0;
        while (i2 < idOrder.size()) {
            String id;
            TagElement element = (TagElement)idOrder.get(i2);
            if (element == map.get(id = element.getId())) {
                elements.add(element);
            }
            ++i2;
        }
        return elements;
    }

    protected String getMessagePidsFieldValue() {
        String type = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_MESSAGE_SERVICE);
        String filterMessage = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_MESSAGE_FILTER);
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("new ");
        buffer.append(type);
        buffer.append(" [] { new ");
        buffer.append(filterMessage);
        buffer.append("(new byte[] { (byte) 0x80 }, ");
        buffer.append("getJ1587PidFilter()) };\n");
        return buffer.toString();
    }

    protected String getMetaDataContents() {
        DeviceFactoryMetaDataBuilder builder = new DeviceFactoryMetaDataBuilder(this, this.bundleType);
        return builder.getMetaDataXmlContents();
    }

    protected String getMetaDataProperties() {
        DeviceFactoryMetaDataBuilder builder = new DeviceFactoryMetaDataBuilder(this, this.bundleType);
        return builder.getMetaDataPropertiesContents();
    }

    protected Map getOsgiProperties(JavaFileModel model) {
        Map table = super.getOsgiProperties(model);
        String dev = this.getMainClassName();
        if (dev.endsWith("Device")) {
            int index = dev.lastIndexOf("Device");
            dev = dev.substring(0, index);
        }
        table.put("org.osgi.framework.Constants.SERVICE_VENDOR", this.quote(this.getVendor()));
        table.put("org.osgi.framework.Constants.SERVICE_RANKING", this.quote("" + this.getDefaultRanking()));
        String pid = this.getServiceClass();
        if (pid != null) {
            model.addImport(this.getServiceFqn());
            table.put("org.osgi.framework.Constants.SERVICE_DESCRIPTION", String.valueOf(pid) + ".SERVICE_DESCRIPTION");
            table.put("org.osgi.framework.Constants.SERVICE_PID", String.valueOf(pid) + ".SERVICE_NAME");
        }
        return table;
    }

    protected List getParentElements() {
        return this.getMainElement().getAllChildrenWithTagCode(156);
    }

    protected String getPidsLengthFieldContents() {
        List pidElements = TagElement.collection.getPids();
        int[] values = new int[255];
        int i = 0;
        while (i < pidElements.size()) {
            int length;
            PidElement element = (PidElement)pidElements.get(i);
            String idString = element.getIdentifier();
            Integer idInt = new Integer(idString);
            int pidId = idInt;
            String lengthString = element.getLength();
            Integer lengthInt = new Integer(lengthString);
            values[pidId] = length = lengthInt.intValue();
            ++i;
        }
        StringBuffer buffer = new StringBuffer(320);
        buffer.append("new int [] { ");
        int i2 = 0;
        while (i2 < values.length) {
            if (i2 > 0) {
                buffer.append(", ");
            }
            buffer.append(values[i2]);
            ++i2;
        }
        buffer.append("};");
        return buffer.toString();
    }

    public String getServiceClassParent() {
        return DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE;
    }

    public String getServiceComponent() {
        if (this.bundleType == 4) {
            return this.getDSFileName();
        }
        return "";
    }

    protected String getServiceFieldComment(TagElement element) {
        StringBuffer buffer = new StringBuffer(128);
        if (element.getDescription() == null) {
            buffer.append(Nls.format(DeviceKitGenerator.getResource("DkDeviceGenerator.service.control.key.comment1"), new Object[]{element.getId(), element.getTagName()}));
            buffer.append("\n \n");
        } else {
            buffer.append(element.getDescription());
            buffer.append("\n \n");
        }
        buffer.append(this.getServiceFieldSpecificComment(element));
        buffer.append(Nls.format(DeviceKitGenerator.getResource("DkDeviceGenerator.service.control.key.comment2"), new Object[]{element.getTagName(), element.getId()}));
        buffer.append(" \n");
        String type = DeviceKitUtilities.capitalizeFirstLetter(element.getTagName());
        String xmp = String.valueOf(type) + ' ' + element.getId() + " = device.get" + type + '(' + this.getServiceClass() + '.' + element.getId() + ");";
        buffer.append(this.getHtmlHelper().getExample(0, xmp));
        return buffer.toString();
    }

    protected String getServiceFieldMeasurementComment(ControlItem element) {
        String wcId;
        String rcId;
        String sigId;
        StringBuffer buffer = new StringBuffer(32);
        List signals = element.getAllChildrenWithTagCode(3);
        List readCommands = element.getAllChildrenWithTagCode(20);
        List writeCommands = element.getAllChildrenWithTagCode(45);
        List units = element.getAllChildrenWithTagCode(4);
        String unitId = null;
        int indentation = 0;
        buffer.append(this.getHtmlHelper().startTable(0, 50));
        buffer.append(this.getHtmlHelper().getTableCaption(++indentation, "Measurement Specifications"));
        if (signals != null && signals.size() > 0) {
            TagElement sig = (TagElement)signals.get(0);
            sigId = sig.getId();
            if (sigId == null) {
                sigId = sig.getAttribute("idref");
            }
        } else {
            sigId = "";
        }
        if (readCommands != null && readCommands.size() > 0) {
            TagElement rc = (TagElement)readCommands.get(0);
            rcId = rc.getId();
            if (rcId == null) {
                rcId = rc.getAttribute("idref");
            }
        } else {
            rcId = "";
        }
        if (writeCommands != null && writeCommands.size() > 0) {
            TagElement wc = (TagElement)writeCommands.get(0);
            wcId = wc.getId();
            if (wcId == null) {
                wcId = wc.getAttribute("idref");
            }
        } else {
            wcId = "";
        }
        if (units != null && units.size() > 0) {
            TagElement u = (TagElement)units.get(0);
            unitId = u.getId();
            if (unitId == null) {
                unitId = u.getAttribute("idref");
            }
        } else {
            unitId = "";
        }
        buffer.append(this.getHtmlHelper().getTableRow(indentation, new String[]{"Signal", "<b>" + this.getHtmlHelper().getLink(0, sigId, sigId, true) + "</b>"}, new int[]{50, 50}));
        buffer.append(this.getHtmlHelper().getTableRow(indentation, new String[]{"Read Command", "<b>" + this.getHtmlHelper().getLink(0, rcId, rcId, true) + "</b>"}));
        buffer.append(this.getHtmlHelper().getTableRow(indentation, new String[]{"Write Command", "<b>" + this.getHtmlHelper().getLink(0, wcId, wcId, true) + "</b>"}));
        buffer.append(this.getHtmlHelper().getTableRow(indentation, new String[]{"Units", "<b>" + unitId + "</b>"}));
        buffer.append(this.getHtmlHelper().endTable(--indentation));
        buffer.append("\n \n");
        return buffer.toString();
    }

    protected String getServiceFieldParameterComment(TagElement element) {
        List messages = element.getMessageChildren();
        if (messages.size() > 0) {
            TagElement message = (TagElement)messages.get(0);
            if (message.getAllChildrenWithTagCode(5).size() > 0) {
                List parameters = message.getAllChildrenWithTagCode(5, true);
                return this.getServiceFieldParameterCommentPart((TagElement)parameters.get(0));
            }
            if (message.getAllChildrenWithTagCode(23).size() > 0) {
                List parameters = message.getAllChildrenWithTagCode(23, true);
                return this.getServiceFIeldParametersCommentPart((ParametersElement)parameters.get(0));
            }
        }
        return "";
    }

    protected String getServiceFieldParameterCommentPart(TagElement pe) {
        UnitsElement ue;
        TagElement tpe = pe;
        int indentation = 0;
        if (tpe.getAttribute("idref") != null) {
            tpe = TagElement.collection.getParameter(tpe.getAttribute("idref"));
        }
        List units = tpe.getAllChildrenWithTagCode(4);
        StringBuffer buffer = new StringBuffer(128);
        String type = tpe.getAttribute("type");
        buffer.append(this.getHtmlHelper().startTable(indentation, 25));
        buffer.append(this.getHtmlHelper().getTableCaption(++indentation, "Parameter Specifications"));
        if (type == null) {
            type = "";
        }
        String id = null;
        if (units != null && units.size() > 0 && (id = (ue = (UnitsElement)units.get(0)).getId()) == null) {
            id = ue.getAttribute("idref");
        }
        if (id == null) {
            id = "";
        }
        String[] data = new String[]{"Type", "<b>" + type + "</b>"};
        buffer.append(this.getHtmlHelper().getTableRow(indentation, data, new int[]{50, 50}));
        data = new String[]{"Unit", "<b>" + id + "</b>"};
        buffer.append(this.getHtmlHelper().getTableRow(indentation, data));
        buffer.append(this.getHtmlHelper().endTable(--indentation));
        buffer.append("\n \n");
        return buffer.toString();
    }

    protected String getServiceFIeldParametersCommentPart(ParametersElement pe) {
        StringBuffer buffer = new StringBuffer(128);
        List parameters = pe.getAllChildrenWithTagCode(5);
        int indentation = 0;
        buffer.append(this.getHtmlHelper().startTable(0, 100));
        buffer.append(this.getHtmlHelper().getTableCaption(++indentation, "Parameters Specifications"));
        String[] columnNames = new String[]{"Parameter", "Type", "Units"};
        int[] percents = new int[]{40, 20, 40};
        buffer.append(this.getHtmlHelper().getTableColumns(indentation, columnNames, percents));
        int i = 0;
        while (i < parameters.size()) {
            UnitsElement ue;
            String type;
            String id = null;
            TagElement pare = (TagElement)parameters.get(i);
            List units = pare.getAllChildrenWithTagCode(4);
            id = pare.getKey();
            if (id == null) {
                id = pare.getAttribute("idref");
            }
            if ((type = pare.getAttribute("type")) == null) {
                type = "";
            }
            String unitsId = null;
            if (units != null && units.size() > 0 && (unitsId = (ue = (UnitsElement)units.get(0)).getId()) == null) {
                unitsId = ue.getAttribute("idref");
            }
            if (unitsId == null) {
                unitsId = "";
            }
            String[] rowItems = new String[]{id, type, unitsId};
            buffer.append(this.getHtmlHelper().getTableRow(indentation, rowItems));
            ++i;
        }
        buffer.append(this.getHtmlHelper().endTable(--indentation));
        buffer.append("\n \n");
        return buffer.toString();
    }

    protected String getServiceFieldSpecificComment(TagElement element) {
        StringBuffer buffer = new StringBuffer(64);
        switch (element.getTagCode()) {
            case 1: 
            case 3: {
                buffer.append(this.getServiceFieldParameterComment(element));
                break;
            }
            case 2: {
                buffer.append(this.getServiceFieldMeasurementComment((ControlItem)element));
            }
        }
        return buffer.toString();
    }

    protected String getServiceFileComment() {
        List s;
        List m;
        StringBuffer buffer = new StringBuffer(128);
        String desc = this.getMainElement().getDescription();
        if (desc != null) {
            buffer.append(desc);
            if (!desc.trim().endsWith(".")) {
                buffer.append('.');
            }
            buffer.append("\n\n ");
        }
        buffer.append(Nls.format(DeviceKitGenerator.getResource("DkDeviceGenerator.service.class.comment1"), this.getMainClassName()));
        List c = this.getDevice().getAllChildrenWithTagCodes(new int[]{1, 19});
        int indentation = 0;
        if (c.size() > 0) {
            buffer.append(" \n \n");
            buffer.append("<p>The following commands are supported:\n");
            buffer.append(" \n");
            buffer.append(this.getHtmlHelper().startTable(indentation, 100));
            ++indentation;
            int i = 0;
            while (i < c.size()) {
                String id = ((TagElement)c.get(i)).getId();
                String description = ((TagElement)c.get(i)).getDescription();
                if (description == null) {
                    description = "";
                }
                String[] dataEntries = new String[]{this.getHtmlHelper().getLink(indentation, id, id, true), description};
                buffer.append(this.getHtmlHelper().getTableRow(indentation, dataEntries, new int[]{40, 60}));
                ++i;
            }
            buffer.append(this.getHtmlHelper().endTable(--indentation));
        }
        if ((m = this.getDevice().getAllChildrenWithTagCode(2)).size() > 0) {
            buffer.append(" \n");
            buffer.append("<p>The following measurements are supported:\n");
            buffer.append(" \n");
            buffer.append(this.getHtmlHelper().startTable(indentation, 100));
            ++indentation;
            int i = 0;
            while (i < m.size()) {
                String id = ((TagElement)m.get(i)).getId();
                String description = ((TagElement)m.get(i)).getDescription();
                if (description == null) {
                    description = "";
                }
                String[] dataEntries = new String[]{this.getHtmlHelper().getLink(indentation, id, id, true), description};
                buffer.append(this.getHtmlHelper().getTableRow(indentation, dataEntries, new int[]{40, 60}));
                ++i;
            }
            buffer.append(this.getHtmlHelper().endTable(--indentation));
        }
        if ((s = this.getDevice().getAllChildrenWithTagCode(3)).size() > 0) {
            buffer.append(" \n");
            buffer.append("<p>The following signals are supported:\n");
            buffer.append(" \n");
            buffer.append(this.getHtmlHelper().startTable(indentation, 100));
            ++indentation;
            int i = 0;
            while (i < s.size()) {
                String id = ((TagElement)s.get(i)).getId();
                String description = ((TagElement)s.get(i)).getDescription();
                if (description == null) {
                    description = "";
                }
                String[] dataEntries = new String[]{this.getHtmlHelper().getLink(indentation, id, id, true), description};
                buffer.append(this.getHtmlHelper().getTableRow(indentation, dataEntries, new int[]{40, 60}));
                ++i;
            }
            buffer.append(this.getHtmlHelper().endTable(--indentation));
        }
        buffer.append(" \n");
        buffer.append(this.getImportedServiceComment());
        buffer.append(" \n");
        buffer.append(this.getExportedServiceComment());
        buffer.append(" \n");
        buffer.append(super.getCommonClassComment());
        return buffer.toString();
    }

    protected String[] getServiceInterfaces() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getServiceClassParent());
        List exportedService = this.getDevice().getAllChildrenWithTagCode(30);
        int i = 0;
        while (i < exportedService.size()) {
            if (((TagElement)exportedService.get(i)).getTextData() != null) {
                result.add(((TagElement)exportedService.get(i)).getTextData());
            }
            ++i;
        }
        String[] serviceInterfaces = new String[result.size()];
        int i2 = 0;
        while (i2 < result.size()) {
            serviceInterfaces[i2] = (String)result.get(i2);
            ++i2;
        }
        return serviceInterfaces;
    }

    protected List getServices() {
        String service;
        ArrayList<String> result = new ArrayList<String>();
        if (this.tService != null && (service = this.tService.getAttribute("service")) != null) {
            if (service.indexOf(46) == -1) {
                String p = DeviceKitUtilities.getPackageFromClassName(service, this.getPackageBase());
                service = String.valueOf(p) + '.' + service;
            }
            result.add(service);
        }
        return result;
    }

    protected String getSetupContents(IType device) {
        MainTagElement element = this.getMainElement();
        String configKey = this.getConfigurationKey(element);
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("super.setup();\n");
        EscPropertiesModel.getModel(this).addComment("Define configuration parameters");
        buffer.append(this.getSetupRateContents(device));
        buffer.append("setNotificationPriority(");
        buffer.append(this.getConfInt(element, "notificationpriority", "getNotificationPriority()"));
        buffer.append(");\n");
        boolean first = true;
        if (configKey != null) {
            EscPropertiesModel.getModel(this).addProperty(String.valueOf(configKey) + '.' + "notificationpriority".toLowerCase(), "-1");
        }
        List parameters = element.getAllChildrenWithTagCode(46);
        int i = 0;
        while (i < parameters.size()) {
            String defaultValue;
            CustomParameterElement parameter = (CustomParameterElement)parameters.get(i);
            ConfigurationField field = new ConfigurationField(parameter);
            field.setQualifiedName("");
            String name = parameter.getAttribute("name");
            String capName = DeviceKitUtilities.capitalizeFirstLetter(name);
            String key = name;
            String defaultValueContents = "get" + capName + "()";
            String contents = NewCodeGenerator.getConfiguration(field, element, key, defaultValueContents);
            buffer.append("set" + capName + '(' + contents + ");\n");
            if (parameter.getAttribute("access") == null || parameter.getAttribute("access").equals("true")) {
                this.codeParameterAccess(field, device, element);
            }
            if ((defaultValue = parameter.getAttribute("defaultvalue")) != null && configKey != null) {
                if (first) {
                    EscPropertiesModel.getModel(this).addComment("Define custom parameters");
                    first = false;
                }
                String fullKey = (String.valueOf(configKey) + '.' + name).toLowerCase();
                EscPropertiesModel.getModel(this).addProperty(fullKey, defaultValue);
            }
            ++i;
        }
        return buffer.toString();
    }

    protected String getSetupRateContents(IType device) {
        long maxRate = -1L;
        long minRate = Long.MAX_VALUE;
        StringBuffer buffer = new StringBuffer(4096);
        int size = this.fRateElements.size();
        long gcd = 0L;
        long lcm = 0L;
        if (size > 0) {
            String srate;
            long rate;
            HashMap<Long, ControlItem[]> rateMap = new HashMap<Long, ControlItem[]>((size << 1) + 1);
            int i = 0;
            while (i < this.fRateElements.size()) {
                rate = -1L;
                ControlItem tagElement = (ControlItem)this.fRateElements.get(i);
                srate = tagElement.getRate();
                if (srate != null && srate.length() > 0) {
                    try {
                        rate = Long.parseLong(srate);
                        Long rateKey = new Long(rate);
                        ControlItem[] rateList = (ControlItem[])rateMap.get(rateKey);
                        if (rateList == null) {
                            rateMap.put(rateKey, new ControlItem[]{tagElement});
                        } else {
                            ControlItem[] newList = new ControlItem[rateList.length + 1];
                            System.arraycopy(rateList, 0, newList, 0, rateList.length);
                            newList[rateList.length] = tagElement;
                            rateMap.put(rateKey, newList);
                        }
                        if (gcd == 0L) {
                            gcd = rate;
                            lcm = rate;
                        } else {
                            gcd = DeviceKitUtilities.gcd(gcd, rate);
                            lcm = DeviceKitUtilities.lcm(lcm, rate);
                        }
                        maxRate = Math.max(maxRate, rate);
                        minRate = Math.min(minRate, rate);
                    }
                    catch (Exception exception) {}
                }
                ++i;
            }
            if (minRate == maxRate) {
                buffer.append("//Rate is ");
                buffer.append(maxRate);
                buffer.append("\r\n");
                buffer.append("//The poll entry delta time is ");
                buffer.append(maxRate / (long)size);
                buffer.append("\r\n");
            } else {
                buffer.append("//Minimum rate is ");
                buffer.append(minRate);
                buffer.append(" Maximum rate is ");
                buffer.append(maxRate);
                buffer.append(" gcd rate is ");
                buffer.append(gcd);
                buffer.append(" lcm rate is ");
                buffer.append(lcm);
                buffer.append("\r\n");
            }
            buffer.append("setProcessingControls(new ");
            buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONTROL_SERVICE));
            this.fDeviceModel.addImport(DeviceKitGenerationConstants.CLASS_CONTROL_SERVICE);
            buffer.append("[] {\t//\r\n");
            if (minRate == maxRate) {
                i = 0;
                while (i < size) {
                    rate = -1L;
                    buffer.append('\t');
                    ControlItem tageElement = (ControlItem)this.fRateElements.get(i);
                    srate = tageElement.getRate();
                    if (srate != null && srate.length() > 0) {
                        try {
                            rate = Long.parseLong(srate);
                            maxRate = Math.max(maxRate, rate);
                        }
                        catch (Exception exception) {}
                    }
                    CodeUtilities.fieldReference(tageElement.getId(), this.isLazyDevice, buffer);
                    if (i != size - 1) {
                        buffer.append(",");
                    }
                    buffer.append("\t//Rate ");
                    buffer.append(rate);
                    buffer.append("\r\n");
                    ++i;
                }
                buffer.append("});\n");
            } else {
                long ccount;
                int number = (int)(lcm / minRate);
                int count = size * number;
                ControlItem[] controls = new ControlItem[count];
                long pollEntry = lcm / (long)count;
                buffer.append("//The poll entry delta time is ");
                buffer.append(pollEntry);
                buffer.append(" count ");
                buffer.append(count);
                buffer.append("\r\n");
                Set rateSet = rateMap.keySet();
                Object[] rateKeys = new Long[rateSet.size()];
                rateKeys = rateSet.toArray(rateKeys);
                Arrays.sort(rateKeys);
                int indexStart = 0;
                int i2 = 0;
                while (i2 < rateKeys.length) {
                    Object rateKey = rateKeys[i2];
                    long rate2 = (Long)rateKey;
                    ccount = lcm / rate2;
                    ControlItem[] rateList = (ControlItem[])rateMap.get(rateKey);
                    int j = 0;
                    while (j < rateList.length) {
                        ControlItem tagElement = rateList[j];
                        block3 : switch ((int)ccount) {
                            case 1: {
                                int k = 0;
                                while (k < count) {
                                    if (controls[k] == null) {
                                        controls[k] = tagElement;
                                        break block3;
                                    }
                                    ++k;
                                }
                                break;
                            }
                            case 2: {
                                int index = indexStart;
                                int delta = size * (int)((long)number / ccount);
                                int k = 0;
                                while ((long)k < ccount) {
                                    if (controls[index] == null) {
                                        controls[index] = tagElement;
                                        index += delta;
                                    }
                                    ++k;
                                }
                                break;
                            }
                            default: {
                                int index = indexStart;
                                int delta = size * (int)((long)number / ccount);
                                int k = 0;
                                while ((long)k < ccount) {
                                    if (controls[index] == null) {
                                        controls[index] = tagElement;
                                        index += delta;
                                    }
                                    ++k;
                                }
                                break block3;
                            }
                        }
                        ++indexStart;
                        ++j;
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < count) {
                    buffer.append('\t');
                    long rate3 = -1L;
                    ControlItem tagElement = controls[i2];
                    if (tagElement == null) {
                        buffer.append("null");
                        if (i2 != count - 1) {
                            buffer.append(",");
                        }
                        buffer.append("\t\t\t//Empty slot\r\n");
                    } else {
                        ccount = 1L;
                        String srate2 = tagElement.getRate();
                        if (srate2 != null && srate2.length() > 0) {
                            try {
                                rate3 = Long.parseLong(srate2);
                                ccount = lcm / rate3;
                            }
                            catch (Exception exception) {}
                        }
                        CodeUtilities.fieldReference(tagElement.getId(), this.isLazyDevice, buffer);
                        if (i2 != count - 1) {
                            buffer.append(",");
                        }
                        long pollTime = pollEntry * (long)i2;
                        long actualRate = lcm / ccount;
                        if (actualRate == rate3) {
                            buffer.append("\t//Poll time ");
                            buffer.append(pollTime);
                            buffer.append(" Rate ");
                            buffer.append(rate3);
                            buffer.append(" Count ");
                            buffer.append(ccount);
                            buffer.append("\r\n");
                        } else {
                            buffer.append("\t//Poll time ");
                            buffer.append(pollTime);
                            buffer.append(" Rate ");
                            buffer.append(rate3);
                            buffer.append(" ActualRate ");
                            buffer.append(actualRate);
                            buffer.append(" Count ");
                            buffer.append(ccount);
                            buffer.append("\r\n");
                        }
                    }
                    ++i2;
                }
                buffer.append("});\n");
            }
            buffer.append("setProcessingTime(");
            buffer.append(lcm);
            buffer.append(");\r\n");
        }
        return buffer.toString();
    }

    private String getStaticIdFieldValue(List vector) {
        StringBuffer buffer = new StringBuffer(16 * vector.size());
        buffer.append("new String [] {\n");
        ArrayList<TagElement> idvector = new ArrayList<TagElement>(vector.size());
        int i = 0;
        while (i < vector.size()) {
            TagElement element = (TagElement)vector.get(i);
            if (element.getId() != null) {
                idvector.add(element);
            }
            ++i;
        }
        Object[] keys = new String[idvector.size()];
        int i2 = 0;
        while (i2 < idvector.size()) {
            TagElement element = (TagElement)idvector.get(i2);
            keys[i2] = element.getId();
            ++i2;
        }
        Arrays.sort(keys);
        String serviceClass = this.getServiceClass();
        int i3 = 0;
        while (i3 < idvector.size()) {
            if (i3 > 0) {
                buffer.append(",\n\t");
            }
            buffer.append(serviceClass);
            buffer.append('.');
            buffer.append((String)keys[i3]);
            ++i3;
        }
        buffer.append("};");
        return buffer.toString();
    }

    public Map getTemplateVariables() {
        Map map = super.getTemplateVariables();
        String name = this.getMainElement().getKey();
        if (name != null) {
            map.put("name", name);
            map.put("class_name", name);
            String className = this.getMainElement().getClassNameFull();
            map.put("class_name_full", className);
            map.put("class_package", DeviceKitUtilities.extractPackage(className));
            String serviceName = this.getMainElement().getServiceNameFull();
            map.put("service_name_full", serviceName);
            map.put("service_package", DeviceKitUtilities.extractPackage(serviceName));
            String factoryName = this.getMainElement().getFactoryNameFull();
            map.put("factory_name_full", factoryName);
            map.put("factory_package", DeviceKitUtilities.extractPackage(factoryName));
            String managedName = this.getMainElement().getManagedNameFull();
            map.put("managed_name_full", managedName);
            map.put("managed_package", DeviceKitUtilities.extractPackage(managedName));
            String description = this.getMainElement().getDescription();
            if (description == null || description.toString().length() == 0) {
                map.put("description", name);
            } else {
                map.put("description", description);
            }
            map.put("percent", "%");
            map.put("copyright_property", this.getCopyrightProperty(map));
        }
        return map;
    }

    protected TagElement getTransportServiceElement() {
        return this.tService;
    }

    protected String getType() {
        return "device";
    }

    protected boolean hasRateControlChild(TagElement element) {
        ControlItem ci;
        return element instanceof ControlItem && (ci = (ControlItem)element).getRate() != null && DeviceKitUtilities.caresAboutRate(ci);
    }

    protected boolean hasRateControlElements() {
        return this.fRateElements.size() > 0;
    }

    protected void initialize() {
        this.setDevice(this.getDeviceElement());
        MainTagElement deviceElement = this.getDevice();
        if (deviceElement != null) {
            this.setTransport(deviceElement.getTransportElement());
            this.setMainTagElement(deviceElement);
            String className = DeviceKitUtilities.getClassNameFromTagElement(deviceElement);
            this.setMainClassName(className);
            this.setPackageBase(deviceElement.getPackageBase());
            this.setMainPackage(DeviceKitUtilities.getPackageFromClassName(className, this.getPackageBase()));
            if (deviceElement.getAttribute("lazy") == null || "false".equals(deviceElement.getAttribute("lazy"))) {
                this.setLazy(false);
            } else {
                this.setLazy(true);
            }
            boolean initMeasurments = deviceElement.hasChildWithTagCode(45);
            this.setInitializeMeasurements(initMeasurments);
            String initWithMethod = deviceElement.getAttribute("createmethod");
            if (initWithMethod != null && initWithMethod.trim().toLowerCase().equals("true")) {
                this.setInitializeWithMethod(true);
            } else {
                this.setInitializeWithMethod(false);
            }
            this.initializeGet();
        }
        super.initialize();
    }

    protected void initializeGet() {
        List elements = this.getMainElement().getAllChildrenWithTagCodes(new int[]{1, 19, 2, 3, 4}, false);
        int i = 0;
        while (i < elements.size()) {
            TagElement element = (TagElement)elements.get(i);
            String id = element.getId();
            if (id != null && id.length() > 0 && (element.getTagCode() == 1 || element.getTagCode() == 19 || element.getTagCode() == 2 || element.getTagCode() == 3 || element.getTagCode() == 4 && !element.isMessageClassElement())) {
                this.fGetMethods.add(element);
            }
            ++i;
        }
    }

    protected boolean initializeWithMethods() {
        return this.initializeWithMethods;
    }

    protected boolean inThisBundle(String string) {
        String packageOnly = DkUtilities.extractPackage(string);
        if (super.inThisBundle(packageOnly)) {
            return true;
        }
        return packageOnly.equals(this.getMessagePackage());
    }

    protected boolean isAbstract() {
        return this.getDevice().isAbstract();
    }

    public boolean isCodeGetters() {
        return this.isLazyDevice || this.isAbstract() || this.isGet();
    }

    protected boolean isGet() {
        return this.getDevice().isGet();
    }

    protected boolean isMultiplex() {
        if (this.getMainElement().isMultiplex()) {
            return true;
        }
        List list = this.getMainElement().getAllChildrenWithTagCodes(new int[]{36, 9, 8, 18, 74, 97});
        int i = 0;
        while (i < list.size()) {
            TagElement element = (TagElement)list.get(i);
            if (element.isMultiplex()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public List save(IProgressMonitor progressMonitor) throws Exception {
        Object device;
        List superResult = super.save(progressMonitor);
        ArrayList<Object> result = new ArrayList<Object>();
        this.fDeviceModel.setSaver(this.getSaver());
        if (this.isLazyDevice) {
            this.fDeviceModel.setSortOrder(3L);
        }
        if ((device = this.fDeviceModel.save(progressMonitor)) != null) {
            result.add(device);
        }
        return DeviceKitUtilities.mergeLists(result, superResult);
    }

    protected void setDevice(MainTagElement element) {
        this.mainTarget = element;
    }

    public void setDeviceModel(JavaFileModel deviceModel) {
        this.fDeviceModel = deviceModel;
    }

    protected void setInitializeMeasurements(boolean im) {
        this.initializeMeasurements = im;
    }

    protected void setInitializeWithMethod(boolean initWithMethod) {
        this.initializeWithMethods = initWithMethod;
    }

    protected void setLazy(boolean lazy) {
        this.isLazyDevice = lazy;
    }

    protected void setTransport(TagElement element) {
        this.tService = element;
    }

    public void updateEscProperties(TagElement element) {
        String configKey = this.getConfigurationKey(element);
        if (configKey != null) {
            EscPropertiesModel.getModel(this).addProperty(String.valueOf(configKey) + '.' + "notificationpriority".toLowerCase(), "-1");
        }
    }
}

