/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.DkDeviceGenerator;
import org.eclipse.soda.devicekit.generator.model.elements.ConcreteElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;

public class DkConcreteGenerator
extends DkDeviceGenerator {
    public DkConcreteGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        this(model, generatedInfo, new HashMap(), 0);
    }

    public DkConcreteGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, Map properties, int bundleType) {
        super(model, generatedInfo, properties, bundleType);
    }

    protected ConcreteElement getConcreteElement() {
        List children = this.getRootElement().getChildren();
        int i = 0;
        while (i < children.size()) {
            if (18 == ((TagElement)children.get(i)).getTagCode()) {
                return (ConcreteElement)children.get(i);
            }
            ++i;
        }
        return null;
    }

    protected List getParentElements() {
        return this.getMainElement().getAllChildrenWithTagCode(158);
    }

    protected void initialize() {
        List concretes = this.getRootElement().getAllChildrenWithTagCode(18);
        ConcreteElement ce = (ConcreteElement)concretes.get(0);
        this.setDevice(ce);
        this.setTransport(ce.getTransportElement());
        this.setMainTagElement(ce);
        String className = DeviceKitUtilities.getClassNameFromTagElement(ce);
        this.setMainClassName(className);
        this.setPackageBase(ce.getPackageBase());
        this.setMainPackage(DeviceKitUtilities.getPackageFromClassName(className, this.getPackageBase()));
        if (ce.getAttribute("lazy") == null || "false".equals(ce.getAttribute("lazy"))) {
            this.setLazy(false);
        } else {
            this.setLazy(true);
        }
        if (ce.hasChildWithTagCode(45)) {
            this.setInitializeMeasurements(true);
        } else {
            this.setInitializeMeasurements(false);
        }
        String initWithMethod = ce.getAttribute("createmethod");
        if (initWithMethod != null && initWithMethod.trim().toLowerCase().equals("true")) {
            this.setInitializeWithMethod(true);
        } else {
            this.setInitializeWithMethod(false);
        }
        this.setupExportedPackages();
        this.initializeGet();
    }
}

