/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.messageanalyzer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.soda.devicekit.generator.messageanalyzer.ControlMessage;
import org.eclipse.soda.devicekit.generator.messageanalyzer.MessageStatus;

class LengthStatus {
    private static final String MESSAGE_LENGTH_HEADER = "Message Length Evaluation";
    private static final String QUESTIONABLE = "Questionable Message Lengths";
    double[] lengths;
    Map offenders;

    public LengthStatus(int maxLength) {
        this.lengths = new double[maxLength];
        this.offenders = new HashMap();
        int i = 0;
        while (i < this.lengths.length) {
            this.lengths[i] = 0.0;
            ++i;
        }
    }

    public void addLengthOffender(double percentage, ControlMessage message) {
        double tpercentage = percentage;
        if (tpercentage < 1.0) {
            tpercentage *= 100.0;
        }
        this.offenders.put(message, new Double(tpercentage));
    }

    public String getHtmlReport() {
        return this.getTxtReport();
    }

    public String getReport(int reportStyle) {
        if (reportStyle == MessageStatus.HTML_STYLE) {
            return this.getHtmlReport();
        }
        return this.getTxtReport();
    }

    public String getTxtReport() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(MESSAGE_LENGTH_HEADER);
        buffer.append('\n');
        int i = 0;
        while (i < this.lengths.length) {
            if (this.lengths[i] > 0.0) {
                buffer.append(String.valueOf(Math.round(this.lengths[i]) * 100L) + "% of messages are " + (i + 1) + " bytes long.\n");
            }
            ++i;
        }
        if (this.offenders.size() > 0) {
            buffer.append(QUESTIONABLE);
            buffer.append('\n');
            Iterator iterator = this.offenders.keySet().iterator();
            while (iterator.hasNext()) {
                ControlMessage cm = (ControlMessage)iterator.next();
                Double percentage = (Double)this.offenders.get(cm);
                buffer.append('\t');
                buffer.append(cm.getControlType());
                buffer.append(' ');
                buffer.append(cm.getControlId());
                buffer.append(" message length = ");
                buffer.append(cm.getByteLength());
                buffer.append(" (");
                buffer.append(percentage.intValue());
                buffer.append("% of all message lengths).\n");
            }
        }
        return buffer.toString();
    }

    public void setLengthPercentage(int length, double percentage) {
        double tpercentage = percentage;
        if (tpercentage < 1.0) {
            tpercentage *= 100.0;
        }
        this.lengths[length] = tpercentage;
    }
}

